package com.gtis.archive.service;

import com.gtis.archive.entity.Material;
import com.gtis.archive.entity.MaterialArchive;
import com.gtis.common.Page;

import java.util.List;
import java.util.Map;

/**
 * Created by zhayuwen on 2015/12/9.
 */
public interface MaterialService {
    /**
     * 获取收件单信息
     * @params conditions查询的条件
     * @params start 开始页
     * @params limit 分页的大小
     * @return
     */
    Page<Material> searchMaterial(Map conditions, int start, int limit);

    /**
     * 获取管理的收件单的档案信息
     * @params start 开始页
     * @params limit 分页的大小
     * @param id 交接单材料的主键
     * @return
     */
    Page<MaterialArchive> getMaterialArchiveByMaterialId(Map conditions, String id, int start, int limit);

    /**
     * 退回交接单
     * @param mId
     * @param info
     * @param thr
     * @param jjdhs
     * @return
     */
    Map refuseMateria(String mId, String info, String thr, String jjdhs);

    /**
     * 存储批次的交接单内的档案信息
     * @param mId
     * @patams rid
     * @return
     */
    Map receviceMateria(String mId, String rid, String userid);

    /**
     * 不动产交接单归档调用的归档接口传输的数据
     * @param bdcjjd
     * @param bdcjjdXx
     * @return
     */
    Map materilIn(String bdcjjd, String bdcjjdXx);

    /**
     * 获取材料归档的类型
     * @param id
     * @return
     */
    Map getMaterilType(String id);
}
