package com.gtis.archive.service;

import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Position;
import com.gtis.common.Page;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by wxy on 2015/12/13.
 */
public interface BindService {

    /**
     * 保存卷内目录信息
     * @param position （卷内目录）
     * @return
     */
    Position savePosition(Position position);

    /**
     * 获取卷内目录信息
     * @param id
     * @return
     */
    Position getSimplePosition(String id);

    /**
     * 查询架号，排号，盒号
     * @params jb 0为架号，1为排号、盒号
     * @params parentid 父节点号
     * @params start 开始页
     * @params limit 分页的大小
     * @return
     */ 
    Page<Position> getEntityPage(Integer jb,String parentid, int limit, int start);

    /**
     * 查询条件
     * @params jb 0为架号，1为排号、盒号
     * @params parentid 父节点号
     * @params criterions 条件
     * @return
     */
    List<Criterion> createCriterions(ArrayList<Criterion> criterions, Integer jb,String parentid);

    /**
     * 查询架号，排号，盒号
     * @params criterions 查询条件
     * @params orders 排序方式
     * @params start 开始页
     * @params limit 分页的大小
     * @return
     */
    Page<Position> searchEntity(List<Criterion> criterions, List<Order> orders, int limit, int start);

    /**
     * 获取最大值
     * @return
     */
    int getMaxOrderNum();

    /**
     * 获取最大架号
     * @return
     */
    int getMaxJh();

    /**
     * 获取最大排号
     * @param id（架号id）
     * @return
     */
    int getMaxPh(String id);

    /**
     * 获取最大盒号（盒号全库流水递增）
     * @return
     */
    int getMaxHh();

    /**
     * 查询架号，排号，盒号个数
     * @params clazz 模型
     * @params criterions 条件
     */
    int jhcount(Class clazz, String jhid, Integer jb);

    /**
     * 获取最近一条未上架的电子档案号
     * @param flh 分类号
     * @return
     */
    Archive getArchiveDzdah(String flh);
}
