package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * 房产档案备考表的上一手和下一手信息
 * Created by zhayuwen on 2015/12/15.
 */
@Entity
@Table(name = "t_note_info")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class NoteInfo {

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 受理号
     */
    private String slh;

    /**
     * 接件单编号
     */
    @Column
    private String jjdbh;

    /**
     * 电子档案号
     */
    @Column
    private String dzdah;

    /**
     * 户名，申请人
     */
    @Column
    private String hm;

    /**
     * 产权证号
     */
    @Column
    private String cqzh;

    /**
     * 登记日期
     */
    @Column
    private Date djrq;

    /**
     * 上一手、下一手类型
     * 1：下一手
     * 0：上一手
     */
    private Integer type ;

    @ManyToOne
    @JoinColumn(name = "noteId")
    private Note note;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSlh() {
        return slh;
    }

    public void setSlh(String slh) {
        this.slh = slh;
    }

    public String getJjdbh() {
        return jjdbh;
    }

    public void setJjdbh(String jjdbh) {
        this.jjdbh = jjdbh;
    }

    public String getDzdah() {
        return dzdah;
    }

    public void setDzdah(String dzdah) {
        this.dzdah = dzdah;
    }

    public String getHm() {
        return hm;
    }

    public void setHm(String hm) {
        this.hm = hm;
    }

    public String getCqzh() {
        return cqzh;
    }

    public void setCqzh(String cqzh) {
        this.cqzh = cqzh;
    }

    public Date getDjrq() {
        return djrq;
    }

    public void setDjrq(Date djrq) {
        this.djrq = djrq;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Note getNote() {
        return note;
    }

    public void setNote(Note note) {
        this.note = note;
    }
}
