package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * 备考表
 * <p/>
 * Generated 2010-08-13 13:16:56 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_note")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Note {
    public static final String MODEL_NAME = Note.class.getSimpleName();
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 张数
     */
    @Column
    private Integer zs;

    /**
     * 页数
     */
    @Column
    private Integer ys;

    /**
     * 情况说明
     */
    @Column(length = 1000)
    private String qksm;

    /**
     * 立卷人
     */
    @Column(length = 100)
    private String ljr;

    /**
     * 立卷日期
     */
    private Date ljrq;

    /**
     * 检查人
     */
    @Column(length = 100)
    private String jcr;

    /**
     * 检查日期
     */
    private Date jcrq;

    /**
     * 备考备注
     */
    @Column(length = 1000)
    private String bz;

    /**
     * 档案序号
     */
    @Column(length = 32, nullable = false)
    private String archiveId;

    @OneToMany(fetch = FetchType.EAGER, mappedBy = "note", cascade = CascadeType.ALL)
    Set<NoteInfo> noteInfoSet = new HashSet<NoteInfo>();

    @Transient
    private Archive archive;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getZs() {
        return zs;
    }

    public void setZs(Integer zs) {
        this.zs = zs;
    }

    public Integer getYs() {
        return ys;
    }

    public void setYs(Integer ys) {
        this.ys = ys;
    }

    public String getQksm() {
        return qksm;
    }

    public void setQksm(String qksm) {
        this.qksm = qksm;
    }

    public String getLjr() {
        return ljr;
    }

    public void setLjr(String ljr) {
        this.ljr = ljr;
    }

    public Date getLjrq() {
        return ljrq;
    }

    public void setLjrq(Date ljrq) {
        this.ljrq = ljrq;
    }

    public String getJcr() {
        return jcr;
    }

    public void setJcr(String jcr) {
        this.jcr = jcr;
    }

    public Date getJcrq() {
        return jcrq;
    }

    public void setJcrq(Date jcrq) {
        this.jcrq = jcrq;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public Archive getArchive() {
        return archive;
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public Set<NoteInfo> getNoteInfoSet() {
        return noteInfoSet;
    }

    public void setNoteInfoSet(Set<NoteInfo> noteInfoSet) {
        this.noteInfoSet = noteInfoSet;
    }
}