package com.gtis.archive.core.generater;

import com.gtis.archive.core.Model;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-9
 */
public class ModelCodeGenerater {
    public static final ModelCodeGenerater JAVA = new ModelCodeGenerater("tpl/javaGenerate.ftl");
    public static final ModelCodeGenerater GROOVY = new ModelCodeGenerater("tpl/groovyGenerate.ftl");

    private static Configuration cfg;

    protected final Logger logger = LoggerFactory.getLogger(getClass());

    private Template template;

    static {
        cfg = new Configuration();
        cfg.setDateFormat("yyyy-MM-dd");
        cfg.setTimeFormat("HH:mm:ss");
        cfg.setNumberFormat("0.######");
    }

    public ModelCodeGenerater(String templateLocation) {
        try {
            template = new Template(null, new InputStreamReader(getClass().getResource(templateLocation).openStream()), cfg);
        } catch (IOException e) {
            logger.error("load modelCodeGenerater template error", e);
        }
    }

    public String generate(Model model) {
        StringWriter result = new StringWriter();
        generate(model, result);
        return result.toString();
    }

    public void generate(Model model, Writer write) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("model", model);
        map.put("now", new Date());
        try {
            template.process(map, write);
        } catch (Exception e) {
            logger.error("generate model:[{}] error:[{}]", model, e);
        }
    }
}
