package com.gtis.archive.web;

import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.VRService;
import com.gtis.archive.service.sv.SqlServerService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * .VrAction
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2015/6/26 13:15
 */
public class VrAction implements Action {

    @Autowired
    private VRService vrService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private SqlServerService sqlServerService;

    @Autowired
    private OriginalService originalService;

    private String roomId;

    private String modelName;

    private String mlh;

    private String nd;

    private String ajhs;

    private String id;

    private Page<Archive> archives;

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }

    public List getRooms() {
        return vrService.getRoomsOnly();
    }

    public Map getRoom() {
        return vrService.getRoomByIdFromDb(roomId);
    }

    public Page<Archive> getArchives() {
        return archives;
    }

    public List getRoomCabinets() {
        try {
            return (List) vrService.getRoomById(roomId).get(VRService.Tag.cabinets.name());
        } catch (Exception e) {
            return new ArrayList();
        }
    }

    /**
     * get room details
     */
    public void roomDetail() {
        Struts2Utils.renderJson(getRoom());
    }

    public String boxes() {
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(Restrictions.eq("mlh", mlh));
        criterions.add(Restrictions.eq("nd", nd));
        List<String> sqls = new ArrayList<String>();
        for (String ajh : ajhs.split(",")) {
            sqls.add(" ajh=" + ajh );
        }
        criterions.add(Restrictions.sqlRestriction(" ( "+StringUtils.join(sqls," or ")+" ) "));
//        criterions.add(Restrictions.in("ajh", strArr2IntArr(ajhs.split(","))));
        List<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("dh"));
        this.archives = archiveService.searchArchive(modelName, criterions, orders, 0, -1);
        for (Archive archive :this.archives.getItems()){
            archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
        }
        return "boxes";
    }

    /**
     * open cbi
     */
    public void openCabinet() {
        Map result = new HashMap();
        result.put("success", true);
        try {
            result = sqlServerService.insertOpenCmd(BeanUtils.getProperty(archiveService.getArchive(modelName, id), "szjgwz"), "Open", SessionUtil.getCurrentUser().getUsername());
        } catch (NullPointerException ex) {
            result.put("success", false);
            result.put("msg", "该档案未设置机柜位置！");
        } catch (Exception ex) {
            result.put("success", false);
            result.put("msg", ex.getLocalizedMessage());
        }
        Struts2Utils.renderJson(result);
    }

    /**
     * open room
     *
     * @return
     */
    public String room() {
        return "room";
    }

    public String exh() {
        return "exh";
    }

    public void zipArchiveOg() {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + new Date().toString() + ".zip");
        try {
            ZipOutputStream zos = new ZipOutputStream(response.getOutputStream());
            Object[] ids = originalService.getIds(id);
            if (ids != null) {
                for (Object id : ids) {
                    File file = originalService.getOriginalFile((String) id, "download");
                    zos.putNextEntry(new ZipEntry(file.getName()));
                    zos.write(FileUtils.readFileToByteArray(file));
                }
            }
            zos.flush();
            zos.close();
        } catch (IOException e) {
            try {
                response.sendError(500, e.getLocalizedMessage());
            } catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return modelName;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public void setAjhs(String ajhs) {
        this.ajhs = ajhs;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    private Integer[] strArr2IntArr(String[] value) {
        Integer[] r = new Integer[value.length];
        for (int i = 0; i < value.length; i++) {
            r[i] = Integer.valueOf(value[i]);
        }
        return r;
    }
}
