package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.EntityNotFoundException;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.service.sv.SqlServerService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import freemarker.template.TemplateException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-23
 */
public class ArchiveAction extends BaseModelAction<Archive> {
    private static  final Object Lock=0x001;

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;
    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    @Autowired
    private SysUserService userService;

    @Autowired
    private SqlServerService sqlServerService;

    /**
     * tree id
     */
    private String treeId;
    /**
     * archive view type,wgd(未归档) ygd(已归档)
     */
    private String type;
    /**
     * 所有定义的操作项
     */
    private List<Item> operations;
    private Map<String, String> topMenu;
    /**
     * 自动组盒用的目录号
     */
    private String mlh;
    /**
     * 自动组盒用的起始案卷号
     */
    private Integer ajh;

    /**
     * 自动组合截止案卷号
     */
    private Integer endAjh;
    /**
     * 自动组盒用装盒份数
     */
    private Integer boxSize;
    /**
     * 档案中卷内显示的字段
     */
    private Map docShowFields;
    private Map docFields;

    /**
     * 链接字段
     */
    private String linkField;

    private String docLinkField;

    private String wgdState ="false" ;

    /**
     * excel导入档案
     */
    private File upload ;

    private String uploadFileName; //文件名称

    /**
     * 机柜所在位置
     */
    private String jgszwz;

    /**
     * 操作机柜命令
     */
    private String cmd;

    /**
     * 分类号检索
     */
    private String flhjs;

    /**
     * 档号
     */
    private String dh;

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Document.toArchiveModelName(modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public void setEndAjh(Integer endAjh) {
        this.endAjh = endAjh;
    }

    public void setBoxSize(Integer boxSize) {
        this.boxSize = boxSize;
    }

    public Integer getBoxSize() {
        return boxSize;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public List<Item> getOperations() {
        return operations;
    }

    public String getWgdState() {
        return wgdState;
    }

    public void setWgdState(String wgdState) {
        this.wgdState = wgdState;
    }

    public File getUpload() {
        return upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadFileName() {
        return uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getFlhjs() {
        return flhjs;
    }

    public void setFlhjs(String flhjs) {
        this.flhjs = flhjs;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public Map<String, String> getQueryParam() {
        if(EnvHolder.isEnable(Switch.SJWS)){
            try{
                return JSON.parseObject(getEntityTemplate("queryParam"), LinkedHashMap.class);
            }catch (Exception ex){
                return new HashMap<String, String>();
            }

        }else{
            return new HashMap<String, String>();
        }

    }

    public Map<String, String> getReceivedParam() {
        if(EnvHolder.isEnable(Switch.SJWS)) {
            try {
                return JSON.parseObject(getEntityTemplate("receivedParam"), LinkedHashMap.class);
            }catch (Exception ex){
                return new HashMap<String, String>();
            }

        }else{
            return new HashMap<String, String>();
        }
    }

    public String getJgszwz() {
        return jgszwz;
    }

    public void setJgszwz(String jgszwz) {
        this.jgszwz = jgszwz;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getTddjPath(){
        return EnvHolder.getAppEnv().get(Switch.TDDJPATH);
    }

    public static Object getLock() {
        return Lock;
    }

    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if (securityService.isPermitted(treeId, item.getName()))
                perm.put(item.getName(), true);
        }
        return JSON.toJSONString(perm);
    }

    public String getTreeJson() throws JSONException {
        return JSON.toJSONString(rewrite(treeService.getTree(treeId)));
    }

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if(tree==null){
            List<Map<String, Object>> listTree = treeService.getAjhTree(null,Constants.MODEL_ROOT);
            for(Map item:listTree){
                logger.debug(item.toString());
                if(item.get("name").equals(Constants.GENERIC)){
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    public Map<String, String> getTopMenu() {
        if (topMenu == null) {
            topMenu = new LinkedHashMap<String, String>();
            for (Item item : dictService.getItems("archiveMenu")) {
                if ("true".equalsIgnoreCase(item.getValue())) {
                    topMenu.put(item.getName(), item.getRemark());
                }
            }
        }

        if(EnvHolder.isEnable(Switch.IMPORTEXCEL)){
            List<String> menuList = new ArrayList<String>();
            for(Item item : dictService.getItems("importMenu")){
                menuList.add(item.getName());
            }
            if (!menuList.contains(modelName)) {
                topMenu.remove("importExcel");
            }
        }else{
            topMenu.remove("importExcel");
        }
        return topMenu;
    }

    @Override
    public String execute() {
        operations = dictService.getItems(Permission.OPERATION_DICT);
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                    throw new NoPermissionException(modelName);
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Archive archive = archiveService.getArchive(modelName, id);
            if (archive != null) {
                type = archive.getState() == Archive.STATE_YGD ? "ygd" : "wgd";
            }
        }

        if(EnvHolder.isEnable(Switch.WGDYW)){
            List<Item> dictList = dictService.getItems("wgdyw") ;
            for (Item item : dictList) {
                if(item.getName().equalsIgnoreCase(modelName)){
                    setWgdState("true");
                    break;
                }
            }
        }
        return Action.SUCCESS;
    }

    public String gd() {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Archive archive = archiveService.getArchive(modelName, id);
            AjhRange ajhRange = null;
            if (archive.getDh() == null && !EnvHolder.isEnable(Switch.NOT_NEED_AJH)&&!EnvHolder.isEnable(Switch.LIAN_YUNGANG)) {  //连云港档案系统归档时，目录号、分类号及案卷号不变
                try {
                    if(PropertyUtils.isReadable(archive,"jnmllx")){
                        ajhRange = ajhRangeService.getAvailableAjhRange(modelName,archive);
                    }else{
                        if(!EnvHolder.isEnable(Switch.JIN_TAN)){
                            ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                        }else{
                            if("Tddj".equalsIgnoreCase(modelName) && getDwdm().length()==6 && archive.getNd()!=null){
                                try{
                                    ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName,archive.getNd());
                                }catch (Exception ex){
                                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                                }
                            }else{
                                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                            }
                        }
                    }
                } catch (EntityNotFoundException e) {
                    Struts2Utils.renderText(e.getMessage());
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }

                if(!EnvHolder.isEnable(Switch.NOT_CHECK_AJH)) {       //notCheckAjh.enable=false 设置为此情况，所有业务都可以在添加之后更新业务
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                }else if(EnvHolder.isEnable(Switch.NOT_CHECK_AJH)) {  //notCheckAjh.enable=true 设置为此情况,当字典当中配置这个业务时就给这个业务更新案卷号
                    List<Item> dictList = dictService.getItems("increaseAjh") ;
                    boolean flag = false;
                    for (Item item : dictList) {
                        if(item.getName().equalsIgnoreCase(modelName)){
                            archive.setMlh(ajhRange.getMlh());
                            archive.setAjh(ajhRange.getCurrentValue());
                            flag = true;
                            break;
                        }

                        if(!flag){
                            archive.setMlh(ajhRange.getMlh());
                            archive.setAjh(ajhRange.getNextValue());
                        }
                    }
                }
            }

            archive.setState(Archive.STATE_YGD);
            archive.setGdsj(new Date());
            archiveService.saveArchive(archive);

            try{
                List<Document> documents = archiveService.getArchiveDocuments(modelName+"_jn",archive.getId());
                for(Document document : documents){
                    document.setMlh(archive.getMlh());
                    document.setAjh(archive.getAjh());
                    archiveService.saveDocument(document);
                }
            }catch (Exception ex){
                //不设置卷内的情况下

            }
            if (ajhRange != null) {
                ajhRange.setCurrentValue(archive.getAjh());
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return null;
    }

    public String cxgd() {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setState(Archive.STATE_WGD);
            archive.setGdsj(null);
            if (EnvHolder.isEnable(Switch.ALLOW_NULL_DH)) {
                archive.setMlh(null);
                archive.setAjh(null);
                archive.setDh(null);
            }
            archiveService.saveArchive(archive);
        }
        return null;
    }

    public String fastGd() throws Exception {
        synchronized(Lock){
            String id = getId();
            if (StringUtils.isNotBlank(id)) {
                Archive archive = archiveService.getArchive(modelName, id);
                archive.setState(Archive.STATE_YGD);
                archive.setGdsj(new Date());
                AjhRange ajhRange = null;
                if (archive.getDh() == null) {
//                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    if(!EnvHolder.isEnable(Switch.JIN_TAN)){
                        ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    }else{
                        if("Tddj".equalsIgnoreCase(modelName) && getDwdm().length()==6 && archive.getNd()!=null){
                            try {
                                ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName, archive.getNd());
                            }catch (Exception ex){
                                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                            }
                        }else{
                            ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                        }
                    }
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                }

                archiveService.saveArchive(archive);
                if (ajhRange != null) {
                    ajhRange.setCurrentValue(archive.getAjh());
                    ajhRangeService.saveAjhRange(ajhRange);
                }
            }
        }
        return renderModelTemplate("fastGd");
    }

    public String move() {
        if (StringUtils.isBlank(treeId)) {
            treeId = null;
        }
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setResourceId(treeId);
            archiveService.saveArchive(archive);
        }
        return null;
    }

    public String order() {
        AjhRange ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
        for (Archive archive : getEntities()) {
            if (!ajhRange.hasExhausted()) {
                ajhRangeService.saveAjhRange(ajhRange);
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
            }
            archive.setAjh(ajhRange.getNextValue());
            archive.setDh(null);
            archiveService.saveArchive(archive);
        }
        return null;
    }

    @Override
    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
        Page<Archive> page=archiveService.searchArchive(modelName, criterions, orders, start, 20);
        for(Archive archive:page.getItems()){
            archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
        }
        return page;
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (ajh != null) {
            criterions.add(Restrictions.eq("mlh", mlh));
            criterions.add(Restrictions.gt("ajh", ajh-1));
            if(endAjh!=null)
                criterions.add(Restrictions.lt("ajh",endAjh+1));
            sort = "ajh";
        } else {
            if(type==null || !type.equals("all"))
                criterions.add(Restrictions.eq("state", "ygd".equals(type) ? Archive.STATE_YGD : Archive.STATE_WGD));
            if (StringUtils.isNotBlank(treeId)) {
                if("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))){
                    String[] treeIds=treeId.split(",");
                    if(treeIds.length==1){
                        if (resourceService.getResource(treeId).getName().equals(modelName)) {
                            criterions.add(Restrictions.or(Restrictions.eq("resourceId", treeId), Restrictions.isNull("resourceId")));
                        } else {
                            criterions.add(Restrictions.eq("resourceId", treeId));
                        }
                    }else {
                        if(treeIds.length>2){
                            Criterion temp=Restrictions.or(Restrictions.eq("resourceId",treeIds[0]),Restrictions.eq("resourceId",treeIds[1]));
                            for(int i=2;i<treeIds.length;i++){
                                temp=Restrictions.or(temp,Restrictions.eq("resourceId", treeIds[i]));
                            }
                            criterions.add(temp);
                        } else {
                            criterions.add(Restrictions.or(Restrictions.eq("resourceId",treeIds[0]),Restrictions.eq("resourceId",treeIds[1])));
                        }
                    }

                }else{
                    if (resourceService.getResource(treeId).getName().equals(modelName)) {
                        criterions.add(Restrictions.or(Restrictions.eq("resourceId", treeId), Restrictions.isNull("resourceId")));
                    } else {
                        criterions.add(Restrictions.eq("resourceId", treeId));
                    }
                }
            } else
                criterions.add(Restrictions.isNull("resourceId"));
        }
        return super.createCriterions(criterions);
    }

    /**
     * 分类号类型检索
     * @return
     */
    public String searchFlh(){
        String flhtj =archiveService.flhjs(flhjs,modelName);
        renderJson(flhtj);
        return null;
    }

    @SuppressWarnings("unchecked")
    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                rewrite((List<Map<String, Object>>) map.get("children"));
                String id = (String) map.get("id");
                Map<String, Boolean> perm = new HashMap<String, Boolean>();
                for (Item item : operations) {
                    if (securityService.isPermitted(id, item.getName()))
                        perm.put(item.getName(), true);
                }
                map.put("perm", perm);
            }
        }
        return tree;
    }

    /**
     * 获得档案中案卷显示的字段
     * @return
     */
    public Map getDocShowFields() {
        if(docShowFields==null)
        {
            try{
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"),LinkedHashMap.class);
            }catch(ModelNotFoundException ex){
            }catch(TemplateNotFoundException ex){
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"),LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     * @return
     */
    public Map getDocFields(){
        if(docFields==null)
        {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            }catch(ModelNotFoundException ex){
            }
        }
        return docFields;
    }

    public String getLinkField(){
        if(linkField==null){
            try{
                linkField=archiveService.getArchiveModel(modelName).getTemplate("linkField");
            }catch (Exception ex){
                linkField="tm";
            }
        }
        return linkField;
    }


    public  String getDocLinkField(){
        if(docLinkField==null){
            try{
                docLinkField=archiveService.getDocumentModel(modelName).getTemplate("linkField");
            }catch (ModelNotFoundException ex){
            }catch (TemplateNotFoundException ex){
                docLinkField="tm";
            }
        }
        return docLinkField;
    }


    /**
     * 快速补件
     * @return
     * @throws Exception
     */
    public String fastAddOG() throws Exception {
        //
        return renderModelTemplate("fastAddOG");
    }

    /**
     * 获取是否存在卷内案卷模型
     * @return
     */
    public boolean getIsShowArchiveInfo(){
        try{
            if(modelService.getModel(modelName.concat("_ai"))!=null){
                return true;
            }
        } catch (ModelNotFoundException ex){
            return false;
        }
        return false;
    }

    /**
     * 获取案卷是否存在卷内
     * @return
     */
    public boolean getIsShowArchiveDoc(){
        try{
            if(modelService.getModel(modelName.concat("_jn")) != null){
                return true;
            }

        }catch (ModelNotFoundException ex){
            return false;
        }
        return false;
    }

    /**
     * 打印档案相关案卷信息
     * @return
     * @throws IOException
     * @throws TemplateException
     */
    public String printArcDocs() throws IOException, TemplateException {
        try{
            return renderTemplate(getEntityModel().getTemplate("printArcDoc"));            
        } catch (TemplateNotFoundException ex){
            logger.error(ex.getMessage());
        }
        return null;
    }


    /**
     * 检索数据后进行统一归档
     * @return
     */
    public String gdAfterSearch(){
        List<Archive> list=getEntityPage().getItems();
        for(Archive archive:list){
                AjhRange ajhRange = null;
                if (archive.getDh() == null) {
                    try {
                        ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    } catch (EntityNotFoundException e) {
                        Struts2Utils.renderText(e.getMessage());
                    }
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                }
                archive.setState(Archive.STATE_YGD);
                archive.setGdsj(new Date());
                archiveService.saveArchive(archive);
                if (ajhRange != null) {
                    ajhRange.setCurrentValue(archive.getAjh());
                    ajhRangeService.saveAjhRange(ajhRange);
                }
        }
        return null;
    }


    @Override
    public String remove() throws Exception {
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            for (String id : ids) {
                Archive archive = archiveService.getArchive(modelName, id);
                RecordAjhRange recordAjhRange = new RecordAjhRange();
                recordAjhRange.setAjh(archive.getAjh());
                recordAjhRange.setMlh(archive.getMlh());
                recordAjhRange.setDwdm(archive.getDwdm());
                recordAjhRange.setModelName(archive.getModelName());
                recordAjhRange.setBgqx(archive.getBgqx());
                recordAjhRangeService.saveRecordAjh(recordAjhRange);
            }
        }
        super.remove();
        return null;
    }

    private List docEntities;

    /**
     * 获取档案相关卷内值
     * @return
     */
    public List getDocEntities(){
        if(docEntities!=null) return docEntities;
        docEntities = new ArrayList();
        if(ids.length>0){
            for(String id:ids){
                docEntities.addAll(archiveService.getArchiveDocuments(modelName,id));
            }
        }
        return docEntities;
    }

    public void setIdString(String idString){
        if(StringUtils.isNotBlank(idString))
            ids = idString.split(",");
    }

    /**
     * 过滤条件查询ｉｄ
     * @return
     */
    public String searchIds() {
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        List items = entityService.search(modelName, criterions, orders, start, limit).getItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); i++) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), "id") + ",");
            } catch (Exception e) {
                logger.error(e.toString());
            }
        }
        ids = sb.toString().split(",");
        return cacheIds();
    }

    /**
     * excel导入档案
     */
    public void importExcel() {
        String realpath = ServletActionContext.getServletContext().getRealPath("/WEB-INF");
        String msg = "";
        if (upload != null) {
            File savefile = new File(new File(realpath), uploadFileName);
            try {
                FileUtils.copyFile(upload, savefile);
                InputStream is = new FileInputStream(realpath + File.separator + uploadFileName);

                Workbook book = WorkbookFactory.create(is);
                List list = new ArrayList();
                // 循环工作表Sheet
                for (int numSheet = 0; numSheet < book.getNumberOfSheets(); numSheet++) {
                    Sheet sheet = book.getSheetAt(numSheet);
                    if (sheet == null) {
                        continue;
                    }

                    Map filedMap = new HashMap();

                    /**
                     * 存储所有属性信息，应用于和excel的表头进行比较
                     */
                    //获取第一行的头信息
                    Row row = sheet.getRow(0);
                    for (int titleNum = 0; titleNum < row.getLastCellNum(); titleNum++) {
                        for (Field field : modelService.getModel(modelName).getInheritfieldsMap().values()) {
                            if (row.getCell(titleNum) != null && (row.getCell(titleNum).toString().replaceAll(" ", "")).equals(field.getTitle())) {
                                filedMap.put(titleNum, field.getName());
                            }
                        }
                    }

                    /**
                     * 获取数据
                     */
                    for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); rowNum++) {
                        Object o = entityService.newInstance(modelName);
                        Row rows = sheet.getRow(rowNum);
                        if (rows == null) {
                            continue;
                        }

                        /**
                         * 循环取出所有的单元格的值并且判断类型赋值
                         */
                        for (int cellNum = 0; cellNum <= rows.getLastCellNum(); cellNum++) {
                            if (filedMap.get(cellNum) != null && rows.getCell(cellNum) != null) {
                                if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == String.class) {
                                    if (rows.getCell(cellNum) == null || "".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), null);
                                    } else {
                                        if ("nd".equals(filedMap.get(cellNum).toString())) {
                                            PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).toString().substring(0, rows.getCell(cellNum).toString().lastIndexOf(".")));
                                        } else {
                                            PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).toString());
                                        }
                                    }
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Boolean.class) {
                                    PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).getBooleanCellValue());
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Integer.class) {
                                    if (rows.getCell(cellNum) == null || "".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), 0);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), Integer.valueOf(Math.round(Float.valueOf(rows.getCell(cellNum).toString()))));
                                    }
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Float.class) {
                                    if (rows.getCell(cellNum) == null || "".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), 0);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), Float.valueOf(rows.getCell(cellNum).toString()));
                                    }
                                } else if (rows.getCell(cellNum) == null || PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Double.class) {
                                    if ("".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), 0);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), Double.valueOf(rows.getCell(cellNum).toString()));
                                    }
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Date.class) {
                                    PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).getDateCellValue());
                                }
                            }
                        }
                        PropertyUtils.setProperty(o, "id", UUIDHexGenerator.generate());

                        //对象档号值都为空的不存储
                        if (PropertyUtils.getProperty(o, "dh") != null && PropertyUtils.getProperty(o, "dh") != "") {
                            list.add(o);
                        }
                    }
                }

                for (Object ob : list) {
                    entityService.save(ob);
                }
                msg = "导入成功";
            } catch (IOException e) {
                e.printStackTrace();
                msg = "导入失败";
            } catch (InvocationTargetException e) {
                e.printStackTrace();
                msg = "导入失败";
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
                msg = "导入失败";
            } catch (IllegalAccessException e) {
                e.printStackTrace();
                msg = "导入失败";
            } catch (Exception e) {
                e.printStackTrace();
                msg = "导入失败";
            } finally {
                if (savefile.exists()) {
                    savefile.delete();
                }
            }
        }

        renderJson(msg);
    }

    /**
     * 档案开启机柜
     */
    public void openBox(){
        Map result = null;
        try {
            result = sqlServerService.insertOpenCmd(jgszwz,cmd,SessionUtil.getCurrentUser().getUsername());
        }catch (Exception ex){
            logger.error("open box with error:" + ex.toString());
        }

        renderJson(result);
    }

    private String getDwdm(){
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if(dwdm==null){
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
        }
        return dwdm;
    }


    /**
     * 根据档号获取档案信息
     */
    public void boxDetail(){
        Archive archive = archiveService.getArchiveByDh(dh);
        Map archiveMap =new HashMap();
        archiveMap.put("modelName",archive.getModelName());
        archiveMap.put("mlh",archive.getMlh());
//        archiveMap.put("ajh",archive.getAjh());
        archiveMap.put("nd",archive.getNd());
        String room = archive.getRoomId();
        String carbinet = archive.getCabinetSno();
        Integer side = archive.getSideId();
        Integer cell = archive.getCellId();
        Integer box = archive.getBoxId();

        String ajhs = archiveService.getAjhs(room,carbinet,side,cell,box);
        archiveMap.put("ajhs",ajhs);
        renderJson(archiveMap);
    }
}
