package com.gtis.archive.service.impl;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.VRService;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.io.Resource;
import com.gtis.support.hibernate.HibernateDao;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2015/6/29 13:45
 */
public class VRServiceImpl extends HibernateDao implements VRService {

    private static final Logger logger = LoggerFactory.getLogger(VRServiceImpl.class);

    private Resource location;

    /**
     * get vr config
     *
     * @return
     */
    @Override
    public Map getConfig() {
        try {
            return JSON.parseObject(IOUtils.toByteArray(location.getURI()), Map.class);
        } catch (Exception e) {
            logger.error("read vr config.cfg error [{}]", e.getLocalizedMessage());
            throw new VRException(e.getLocalizedMessage());
        }
    }

    /**
     * get vr rooms
     *
     * @return
     */
    @Override
    public List getRooms() {
        return (List) getConfig().get(Tag.rooms.name());
    }

    /**
     * get rooms only
     *
     * @return
     */
    @Override
    public List getRoomsOnly() {
        List<Map> rooms = getRooms();
        for (Map room : rooms) {
            if (room.containsKey(Tag.cabinets.name())) room.remove(room.get(Tag.cabinets.name()));
        }
        return rooms;
    }

    /**
     * 根据id查找房间
     * @param roomId
     * @return room
     */
    @Override
    public Map getRoomById(String roomId) {
        List<Map> rooms = getRooms();
        for (Map room : rooms) {
            if (room.get(Tag.id.name()).equals(roomId)) return room;
        }
        throw new RuntimeException(" room " + roomId + " not found");
    }

    /**
     * 将list按照groupKey分组成Map<String,List>
     *
     * @param list
     * @param groupKey
     * @return 分组结果
     */
    private Map listConvertMap(List list, String groupKey) {
        assert list != null;
        assert groupKey != null;
        Map<String, List<Map>> map = new HashMap<String, List<Map>>();
        if (list.size() > 0) {
            for (Object obj : list) {
                Map item = new HashMap();
                if (obj instanceof Archive) {
                    copyBean(item,obj);
                } else if (obj instanceof Map) {
                    item = (Map) obj;
                }
                if (item.isEmpty()) continue;
                if (!item.containsKey(groupKey)) continue;
                String key = MapUtils.getString(item, groupKey);
                if (map.containsKey(key)) {
                    List list1 = map.get(key);
                    list1.add(item);
                    map.put(key, list1);
                } else {
                    List list2 = new ArrayList();
                    list2.add(item);
                    map.put(key, list2);
                }
            }
            return map;
        }
        return null;


    }

    /**
     * 转换对象类型
     * @param dest
     * @param src
     */
    private void copyBean(Map dest,Object src){
        assert src!=null;
        BeanWrapper beanWrapper = new BeanWrapperImpl(src);
        PropertyDescriptor[] descriptor = beanWrapper.getPropertyDescriptors();
        for (int i = 0; i < descriptor.length; i++) {
            dest.put(descriptor[i].getName(), beanWrapper.getPropertyValue(descriptor[i].getName()));
        }
    }

    /**
     * 获取柜子信息
     * @param roomId
     * @return
     */
    private List getCabinetByRoom(String roomId) {
        List<Map> result = new ArrayList<Map>();
        List<Map> rooms = getRooms();
        Map targetRoom = null;
        for (Map room : rooms) {
            if (room.get(Tag.id.name()).equals(roomId))
                targetRoom = room;
        }
        if (targetRoom != null) {
            List<Map> cabinets = (List<Map>) targetRoom.get("cabinets");
            for (Map cabinet : cabinets) {
                Map tmp = new HashMap();
                tmp.put("sno", MapUtils.getString(cabinet, "sno"));
                tmp.put("type", MapUtils.getString(cabinet, "type"));
                tmp.put("title", MapUtils.getString(cabinet, "title"));
                result.add(tmp);
            }
        }
        return result;
    }

    /***
     * 从数据库查数据
     * @param roomId
     * @return
     */
    @Override
    public Map getRoomByIdFromDb(String roomId) {
        String hql ="FROM Archive WHERE roomId=:roomId";
        List<Object> list = new ArrayList<Object>();
        Map map = new HashMap();
        map.put("roomId",roomId);
        try {
            list = find(hql, map);
        } catch (Exception e) {
            logger.error("查询数据失败："+e.toString());
        }
        Map room=new HashMap();                    //存放最终的room
        List<Map> cabinetList=new ArrayList<Map>();//存放room里的cabinets集合

        List<Map> cabinets=getCabinetByRoom(roomId);
        List<Map> rooms = getRoomsOnly();
        for (Map r : rooms) {
            if (roomId.equals(MapUtils.getString(r, "id"))) {
                room.put("id", roomId);
                room.put("title", MapUtils.getString(r, "title"));
                room.put("desc", MapUtils.getString(r, "desc"));
            }
        }
        logger.info(JSON.toJSONString(room));

        Map cabinetGroup = listConvertMap(list,"cabinetSno");
        for (Map cItem : cabinets) {
            Map cabinet=new HashMap();
           Object content= cabinetGroup.get(cItem.get("sno"));
            if(content!=null){
                List<Map> contentList = (List<Map>) content;
                Map sideMap = listConvertMap(contentList,"sideId");
                List leftSides=new ArrayList();//  存放组织好的sides
                List rightSides=new ArrayList();//  存放组织好的sides
                for (Object k : sideMap.keySet()) {
                    List<Map> cells = (List<Map>) sideMap.get(k);
                    Map cellGroup = listConvertMap(cells,"cellId");
                    for (Object m : cellGroup.keySet()) {
                        if("0".equals(k)) leftSides.add(getCell(m,cellGroup.get(m)));
                        else rightSides.add(getCell(m,cellGroup.get(m)));
                    }
                }
                List sides=new ArrayList();
                sides.add(leftSides);
                sides.add(rightSides);

                cabinet.put("sides",sides);
                cabinet.put("sno",cItem.get("sno"));
                cabinet.put("type",cItem.get("type"));
                cabinet.put("title",cItem.get("title"));
                cabinetList.add(cabinet);
            }
        }
        room.put("cabinets",cabinetList);
        return room;

    }

    /**
     * 获取档案详细信息
     * @param cellId
     * @param value
     * @return
     */
    private Map getCell(Object cellId,Object value){
        Map result=new HashMap();
        //TODO:组织档案
        List<Map> cellList = (List<Map>)value;
        Collections.sort(cellList, new Comparator<Map>() {
             @Override
             public int compare(Map o1, Map o2) {
                        return Integer.valueOf(MapUtils.getString(o1,"ajh"))-Integer.valueOf(MapUtils.getString(o2,"ajh"));
             }
        });


        Map boxMap = listConvertMap(cellList,"boxId");
        List<Map> boxes=new ArrayList<Map>();
        for (Object bk : boxMap.keySet()) {
            Map tempBox= new HashMap();
            List ajhList = new ArrayList();
            List<Map> archives= (List<Map>) boxMap.get(bk);
            for(int i=0;i<archives.size();i++) {
                ajhList.add(archives.get(i).get("ajh"));
            }
            try {
                Collections.sort(ajhList);
            } catch (Exception e) {
                logger.error("检查案卷号为空的情况"+e.toString());
            }
            tempBox.put("ajhs",ajhList);
            tempBox.put("flh",archives.get(0).get("flh"));
            tempBox.put("id",bk);
            tempBox.put("mlh",archives.get(0).get("mlh"));
            tempBox.put("qzh",archives.get(0).get("qzh"));
            tempBox.put("nd",archives.get(0).get("nd"));

            boxes.add(tempBox);
        }
        Collections.sort(boxes, new Comparator<Map>() {
            @Override
            public int compare(Map o1, Map o2) {
                return Integer.valueOf(MapUtils.getString(o1,"id"))-Integer.valueOf(MapUtils.getString(o2,"id"));
            }
        });

        List boxfirst = (List)boxes.get(0).get("ajhs");
        List boxlast = (List)boxes.get(boxes.size()-1).get("ajhs");

        result.put("id",cellId);
        result.put("modelName",cellList.get(0).get("modelName"));
        result.put("ajhRange",boxfirst.get(0)+"~"+boxlast.get(boxlast.size()-1));
        result.put("firstYear",boxes.get(0).get("nd"));
        result.put("lastYear",boxes.get(boxes.size()-1).get("nd"));
        result.put("boxes",boxes);
        return result;
    }
    public void setLocation(Resource location) {
        this.location = location;
    }
}
