package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.entity.LoanCart;
import com.gtis.archive.service.LoanService;
import com.gtis.common.Page;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 12-9-3 上午11:01
 */
@Service
public class LoanServiceImpl implements LoanService<LoanCart> {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private EntityService entityService;

    /**
     * 添加到借阅车
     *
     * @param entity
     */
    public void addToCart(LoanCart entity) {
        entityService.save(entity);
    }

    /**
     * 移出借阅车
     *
     * @param entity
     */
    public void removeFromCart(LoanCart entity) {
        entityService.remove(LoanCart.class, new String[]{entity.getId()});
    }

    /**
     * 删除借阅车中记录
     *
     * @param ids
     */
    public void removeFromeCart(String[] ids) {
        entityService.remove(LoanCart.class, ids);
    }

    /**
     * 借阅
     *
     * @param entities
     * @deprecated
     */
    public void doLoan(Loan[] entities) {
        throw new RuntimeException("弃用该方法，用另一个同名方法");
    }

    /**
     * 借阅
     *
     * @param loanCarts
     * @param loan
     */
    public void doLoan(List<LoanCart> loanCarts, Loan loan) {
        List<Loan> loans = new ArrayList<Loan>();
        for (LoanCart loanCart : loanCarts) {
            try {
                Loan loan1 = loan.clone();
                loan1.setArchiveId(loanCart.getArchiveId());
                loan1.setState(0);
                loans.add(loan1);
                removeFromCart(loanCart);
            } catch (CloneNotSupportedException e) {
                logger.error("借阅数据拷贝异常", e.getLocalizedMessage());
            }
        }
        if (loans.size() != loanCarts.size()) return;
        for (Loan loan1 : loans) {
            entityService.save(loan1);
        }
    }


    /**
     * 获取借阅车内所有内容
     *
     * @param start
     * @param limit
     * @param criterions
     * @return
     */
    public Page<LoanCart> getPages(int start, int limit, List<? extends Criterion> criterions) {
        return entityService.search(LoanCart.class.getSimpleName(), criterions, null, start, limit);
    }

    /**
     * 获取所有记录条数
     *
     * @return
     */
    public int count(List<? extends Criterion> criterions) {
        return entityService.getCount(LoanCart.class, criterions);
    }

    @Override
    public Loan findLoanById(String id) {
        return entityService.load(Loan.class, id);
    }

    /**
     * 根据用户ID获取借阅数
     * @param userID
     * @return
     */
    @Override
    public int loanCount(String userID){
        Criterion criterion = Restrictions.eq("userId", userID);
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(criterion);
        return entityService.getCount(LoanCart.class, criterions);
    }

    public int getLoanCartCount(String userID, String id) {
        List<Criterion> criterions = new ArrayList<Criterion>();
        Criterion criterion = Restrictions.eq("userId", userID);
        criterions.add(criterion);
        criterion = Restrictions.eq("archiveId", id);
        criterions.add(criterion);

        return entityService.getCount(LoanCart.class, criterions);
    }

    public LoanCart getLoanCart(String id){
        Criterion criterion = Restrictions.eq("id", id);
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(criterion);
        Page<LoanCart> loanCartPage = entityService.search(LoanCart.class, criterions, null, 0, 20);
        List<LoanCart> loanCartList = loanCartPage.getItems();
        if(loanCartList != null && loanCartList.size() > 0){
            return loanCartList.get(0);
        }

        return  null;
    }

    /**
     * 根据用户ID获取借阅车内需借阅的档案
     * @param userID 用户ID
     * @param start 起始页
     * @param limit 每页的数量
     * @return
     */
    @Override
    public Page<LoanCart> getLoanCart(String userID, int start, int limit){
        Criterion criterion = Restrictions.eq("userId", userID);
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(criterion);
        return entityService.search(LoanCart.class, criterions, null, start, limit);
    }
}
