package com.gtis.archive.service.impl;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-17
 */
@Service
public class ExtTreeServiceImpl implements ExtTreeService {
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private AjhRangeService ajhRangeService;

    public List<Map<String, Object>> getTree(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Resource> ress = resourceService.getChildrenResource(resourceId);
        for (Resource res : ress) {
            Map<String, Object> map = new HashMap<String, Object>();
            List children = getTree(res.getId());
            if (securityService.isPermitted(res.getId(), "view") || children.size() > 0) {
                map.put("id", res.getId());
                map.put("name", res.getName());
                map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
                map.put("content", res.getContent());
                if("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))){
                    map.put("checked",false);
                }
                if (children.size() > 0) {
                    map.put("children", children);
                    map.put("expanded", true);
                    map.put("iconCls", "node");
                } else {
                    map.put("leaf", true);
                    map.put("iconCls", "node left");
                }
                list.add(map);
            }
        }
        return list;
    }

    public List<Map<String, Object>> getAjhTree(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Resource> ress = resourceService.getChildrenResource(resourceId);
        for (Resource res : ress) {
            Map<String, Object> map = new HashMap<String, Object>();
            List children = getAjhTree(res.getId());
            List childrenAjh = getAjhTreeBySesourceId(res.getId());
            if (securityService.isPermitted(res.getId(), "view") || (children.size() > 0 || childrenAjh.size() > 0)) {
                map.put("id", res.getId());
                map.put("name", res.getName());
                map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
                map.put("content", res.getContent());
                if("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))){
                    map.put("checked",false);
                }
                if (children.size() > 0 || childrenAjh.size() > 0) {
                    if(children.size() > 0) {
                        map.put("children", children);
                        map.put("expanded", true);
                        map.put("iconCls", "node");
                    }

                    if(childrenAjh.size() > 0){
                        map.put("children", childrenAjh);
                        map.put("expanded", true);
                        map.put("iconCls", "node");
                    }
                } else {
                    map.put("leaf", true);
                    map.put("iconCls", "node left");
                }
                list.add(map);
            }
        }
        return list;
    }

    public List<Map<String, Object>> getAjhTreeBySesourceId(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<AjhRange> ress = ajhRangeService.getAjhRangeByModelName(resourceService.getResourceName(resourceId));
        for (AjhRange res : ress) {
            Map<String, Object> map = new HashMap<String, Object>();
            if (securityService.isPermitted(res.getId(), "view")) {
                map.put("id", res.getId());
                map.put("name", res.getMlh());
                map.put("text", res.getMlh() == null ? res.getMlh() : res.getMlh());
                map.put("content", res.getMlh());
                if ("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                    map.put("checked", false);
                }

                map.put("leaf", true);
                map.put("iconCls", "node left");

                list.add(map);
            }
        }
        return list;
    }

    public List<Map<String, Object>> getALLTree(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Resource> ress = resourceService.getChildrenResource(resourceId);
        for (Resource res : ress) {
//            if(res.getName().equals(Constants.GENERIC)) continue;
            Map<String, Object> map = new HashMap<String, Object>();
            List children = getTree(res.getId());
                map.put("id", res.getId());
                map.put("name", res.getName());
                map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
                map.put("content", res.getContent());
                if("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))){
                    map.put("checked",false);
                }
                if (children.size() > 0) {
                    map.put("children", children);
                    map.put("expanded", true);
                    map.put("iconCls", "node");
                } else {
                    map.put("leaf", true);
                    map.put("iconCls", "node left");
                }
                list.add(map);
        }
        return list;
    }

    public List<Map<String, Object>> getTree(String resourceId, String... name) {
         return getTree(resourceService.getResource(resourceId, name).getId());
    }

    public List<Map<String, Object>> getAjhTree(String resourceId, String... name) {
        return getAjhTree(resourceService.getResource(resourceId, name).getId());
    }

    public List<Map<String, Object>> getAllTree(String resourceId, String... name) {
        return getALLTree(resourceService.getResource(resourceId, name).getId());
    }

    public List<Map<String, Object>> getTree2(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Resource> ress = resourceService.getChildrenResource(resourceId);
        for (Resource res : ress) {
//            if(res.getName().equals(Constants.GENERIC)) continue;
            Map<String, Object> map = new HashMap<String, Object>();
            List children = getTree2(res.getId());
            if (securityService.isPermitted(res.getId(), "view") || children.size() > 0) {
                map.put("id", res.getId());
                map.put("name", res.getName());
                map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
                map.put("content", res.getContent());
                if (children.size() > 0) {
                    map.put("children", children);
                    map.put("expanded", true);
                    map.put("iconCls", "node");
                } else {
                    map.put("leaf", true);
                    map.put("iconCls", "node left");
                }
                list.add(map);
            }
        }
        return list;
    }


}
