package com.gtis.archive.service;

import com.gtis.archive.entity.Loan;
import com.gtis.common.Page;
import org.hibernate.criterion.Criterion;

import java.util.List;

/**
 * .借阅管理
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 12-9-3 上午10:58
 */
public interface LoanService<T> {

    /**
     * 添加到借阅车
     *
     * @param entity
     */
    public void addToCart(T entity);

    /**
     * 移出借阅车
     *
     * @param entity
     */
    public void removeFromCart(T entity);

    /**
     * 删除借阅车中记录
     *
     * @param ids
     */
    public void removeFromeCart(String[] ids);

    /**
     * 借阅
     *
     * @param entities
     * @deprecated
     */
    public void doLoan(Loan[] entities);

    /**
     * 借阅
     *
     * @param loanCarts
     * @param loan
     */
    public void doLoan(List<T> loanCarts, Loan loan);

    /**
     * 获取借阅车内所有内容
     *
     * @param start
     * @param limit
     * @param criterions
     * @return
     */
    public Page<T> getPages(int start, int limit, List<? extends Criterion> criterions);


    /**
     * 获取所有记录条数
     *
     * @return
     */
    public int count(List<? extends Criterion> criterions);

    /**
     * 通过id查询借阅记录
     * @param id
     * @return
     */
    public Loan findLoanById(String id);

    /**
     * 根据用户ID获取借阅车内借阅的数量
     * @param userID
     * @return
     */
    int loanCount(String userID);

    /**
     * 根据用户ID、档案ID，获取该用户借阅该档案的数据
     * @param userID
     * @param id
     * @return
     */
    int getLoanCartCount(String userID, String id);

    /**
     * 获取借阅车
     * @param id id
     * @return
     */
    T getLoanCart(String id);

    /**
     * 根据用户ID获取借阅车内需借阅的档案
     * @param userID 用户ID
     * @param start 起始页
     * @param limit 每页的数量
     * @return
     */
    Page<T> getLoanCart(String userID, int start, int limit);
}
