 <@layout.main import="jquery,ext">
<style type="text/css">
    #gd-form,#gd-form *, #gd-form input {
        font-size: 16px;
    }
    #archive-info {
        font-size: 16px;
        padding: 20px 40px;
    }
    #archive-info li{
        padding: 5px;
    }
    .checkBtn{
        padding: 1px 4px 1px 4px;
    }
    #original-container{
        padding: 0px 4px 10px 4px;
    }
    #original-container ul{
        list-style: none;
        clear: left;
        float:left;
        border-bottom: 2px;
        margin: 2px 10px 2px 0px;
    }
    #original-container ul li{
        float: left;
    }
    #original-container ul li input{
        font-size: 14px;
        padding: 1px 3px 1px 3px;
    }
    #original_list{
        padding: 4px 2px 4px 2px;
    }

</style>
<div class="a-box">
    <div class="a-box-frame">
        <div class="a-box-inner">
            <div class="a-box-inner-frame" style="min-height:500px;_height:500px;padding-top:10px;">
                <form method="post" style="padding:20px;" id="gd-form">
                    <input type="hidden" name="condition" value="name,dh;cd,like;value,"/>
                    请输入档号：<input type="text" name="keyword" size="30" value="${Parameters.keyword!}"/>
                    <input type="submit" value="检 索" class="checkBtn" onclick="return searchArchive(this.form);"/>

                    <div id="archive-info" class="info-card">
                        <#if entities?? && entities?size gt 0>
                            <#assign archive=entities[0]/>
                            <input type="hidden" name="id" value="${archive.id!}"/>
                            <ul>
                                <li><span><@a.title name="tm"/></span>${archive.tm!}</li>
                                <li><span><@a.title name="ajh"/></span>${archive.ajh!}</li>
                                <li><span><@a.title name="mlh"/></span>${archive.mlh!}</li>
                                <li><span><@a.title name="js"/></span>${archive.js!}</li>
                                <li><span><@a.title name="ys"/></span>${archive.ys!}</li>
                                <li><span><@a.title name="bgqx"/></span>${archive.bgqx!}</li>
                                <li><span><@a.title name="mj"/></span>${archive.mj!}</li>
                                <li><span><@a.title name="nd"/></span>${archive.nd!}</li>
                                <li><span><@a.title name="bz"/></span>${archive.bz!}</li>
                            </ul>
                            <!--案卷原文列表-->
                            <hr style="background-color: #9fc9f5;"/>
                            <div id="original-container">
                                <div id="original_list"/>
                            </div>

                            <#else>
                                <#if Parameters.keyword??>
                                    <div style="padding: 10px;color: red;">未找到满足条件的档案</div>
                                </#if>
                        </#if>
                        
                    </div>
                </form>
                
            </div>
        </div>
    </div>
</div>
 <script type="text/javascript" src="js/UploadDialog.js"></script>
 <script type="text/javascript" src="js/ext/SearchField.js"></script>
 <script type="text/javascript">

     var _aId = '${(archive.id)!''}';
     var jsessionId = '${sessionId}';
     var modelName = '${modelName}';
     var jnModelName = '${modelName}_jn';

     var ogDataStore = new Ext.data.JsonStore({
         url:'og!list.action?ownerId='+_aId,
         autoLoad:true,
         totalProperty:'totalCount',
         root:'items',
         fields:[
            'id','name','filesize','updateTime'
         ]
     });

     var ogCbSm = new Ext.grid.CheckboxSelectionModel();

     var formateSize = function(s,p,r){
         return Ext.util.Formate.fileSize(s);
     }

     var ogGridPanel = new Ext.grid.GridPanel({
         cls:'og',
         border:true,
         ds:ogDataStore,
         height:250,
         sm:ogCbSm,
         loadMask:true,
         stripeRows:true,
         region:'center',
         renderTo:'original_list',
         bbar:new Ext.PagingToolbar({
             pageSize:20,
             store:ogDataStore,
             displayInfo:true,
             displayMsg:'{0}-{1}共{2}条',
             emptyMsg:"尚未检测到原文数据"
         }),
         cm:new Ext.grid.ColumnModel([
             ogCbSm,
             {header:"名称",width:400,sortable:true,dataIndex:'name'},
             {header:"大小",width:120,sortable:true,dataIndex:'fileSize',render:formateSize},
             {header:"上传时间",width:200,sortable:true,dataIndex:'updateTime'}
         ]),
         tbar:[
             {
                 text:"上传",
                 iconCls:'upload',
                 handler:function(){
                     var upUrl = function(url){return getUrlWidthSessionId(url+'?modelName='+modelName)};
                     var upLoadDialog = new UploadDialog({
                         getUrl:upUrl,
                         maxSize:5368709120,
                         typeDescription:"所有文件",
                         autoClose:this.autoClose||true,
                         fileTypes:'*.*'
                     });
                     upLoadDialog.on('close',function(){
                         ogDataStore.reload();
                     });
                     upLoadDialog.show(_aId);
                 }
             },
             {
                 text:"删除",
                 iconCls:'delete',
                 handler:function(){
                     if(ogCbSm.getSelections().length==0)
                     {
                         alert('未选择原文！');
                         return;
                     }
                     if(!confirm('确定删除选中原文？')) return;
                     var s = [];
                     Ext.each(ogCbSm.getSelections(),function(e){
                        s.push(e.data.id);
                     });
                     Ext.Ajax.request({
                         url:'og!remove.action',
                         params:{id:s},
                         success:function(m){
                             ogDataStore.reload();
                         }
                     });

                 }
             }
         ],
         listeners:{
             render:function(g){
                 var store = g.getStore();
                 var view = g.getView();
                 g.tip = new Archive.OgTip({
                     dismissDelay:0,
                     target:view.mainBody,
                     delegate:'.x-grid3-row',
                     autoWidth:!Ext.isIE6,
                     renderTo:document.body,
                     listeners:{
                         beforeShow:function(tip){
                             var rowIndex = view.findRowIndex(tip.triggerElement);
                             tip.body.update('<img src="og!thumb.action?modelName='+modelName+'&id='+store.getAt(rowIndex).id+'"/>');

                         }
                     }
                 })
             },
             rowdblclick:function(g,index,e){
                 var id = ogDataStore.getAt(index).id;
                 showPreview([id]);
             }
         }

     });

     function showPreview(nids) {
         if (!Ext.isDefined(window.hasEPreOcx)) {
             try {
                 new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
                 window.hasEPreOcx = true;
             } catch (e) {
                 window.hasEPreOcx = false;
             }
         }
         if (window.hasEPreOcx) {
             var base = location.href.substring(0, location.href.lastIndexOf('/'));
             var link = getJsessionidUrl(base + '/og!preview.action?idsKey=');
             link = link.substr(link.indexOf('//') + 2);
             Ext.Ajax.request({
                 url:'archive!cacheIds.action',
                 params:{id:nids},
                 success:function (r) {
                     var json = Ext.decode(r.responseText);
                     location.href = 'epre://'+link + json['idsKey'];
                 }
             });
         } else {
             window.open('og!get.action?preview=true&id=' + nids[0]);
         }
     }

     function getUrlWidthSessionId(url)
     {
         var index = url.indexOf('?');
         var _jpart = ';jsessionid='+jsessionId;
         if (index > -1)
             return url.substring(0,index)+_jpart+url.substring(index);
         else
             return url+_jpart;
     }


 </script>
</@layout.main>