var Archive = function(config) {
    Ext.apply(this, config);
    this.init();
};

Archive.prototype = {
    viewDocument:function(id, link) {
        var ct = $('#d' + id).parent().parent();
        if (ct.is(":hidden")) {
            ct.show();
            this.reloadDocuments(id);
        } else {
            if (link)
                ct.hide();
        }
        if (link)
            $(link).toggleClass('jn-open');
        return false;
    },
    reloadDocuments:function(id) {
        Ext.Ajax.request({
            url: 'archive!docList.action',
            params:{id:id,modelName:this.modelName},
            success: function(r) {
                var docs = Ext.decode(r.responseText);
                this.docTpl.overwrite('d' + id, {docs:docs,archiveId:id});
            }
        });
    },
    addSearchItem:function() {
        var item = $('#search-item-box').append($('#searchTpl').val()).children(":last");
        item.hover(
                function () {
                    $(this).addClass("hover");
                },
                function () {
                    $(this).removeClass("hover");
                });
    },
    showAdvancedSearch:function() {
        if ($("#search-item-box .search-item").length == 0) {
            this.addSearchItem();
        }
        $('#search-item').toggle();
    },
    advancedSearch:function() {
        var condition = Ext.lib.Ajax.serializeForm('search-item-box');
        this.store.setBaseParam('query', '');
        this.store.load({params:{condition:condition}});
    },
    hideAdvancedSearch:function() {
        $('#search-item').hide();
        this.store.load();
    }
};