<@layout.html title="档案管理" import="ext,jquery,base,main">
<style type="text/css">
    .archive {
        background: url(/archive/img/archive.png) no-repeat 0 0 !important;
    }

    .document {
        background: url(/archive/img/document.png) no-repeat 0 0 !important;
    }

    .add {
         background: url(/archive/img/add.gif) no-repeat 0 0 !important;
     }

    .tree {
        background: url(/archive/img/tree.png) no-repeat 0 0 !important;
    }

    .delete {
        background: url(/archive/img/delete.gif) no-repeat 0 0 !important;
    }

    .edit {
        background: url(/archive/img/admin/edit.gif) no-repeat 0 0 !important;
    }

    .gd {
        background: url(/archive/img/gd.png) no-repeat 0 0 !important;
    }

    .packageArchive {
        background: url(/archive/img/box.png) no-repeat 0 0 !important;
    }

    .reset {
        background: url(/archive/img/reset.gif) no-repeat 0 0 !important;
    }

    .preview {
        background: url(/archive/img/preview.gif) no-repeat 0 0 !important;
    }
</style>
<script type="text/javascript" src="js/UploadDialog.js"></script>
<script type="text/javascript" src="js/ext/SearchField.js"></script>
<script type="text/javascript" src="js/ext/ux/ComboPageSize.js"></script>
<script type="text/javascript">
var modelName, jnModelName, title;
var store, docStore;
var columns = [];
var docColumns = [];
var archiveGrid, documnetGrid, ogGrid;
var win;
var perm = ${permJson!'{}'};
var treeId;
var _jsessionid = '${sessionId}';
var ogDs, linkWin;

/**
 *  arc/doc
 */
var iframeType, _curAId, archiveId, archiveSaveType;
var ogSm = new Ext.grid.CheckboxSelectionModel();
var docOgSm = new Ext.grid.CheckboxSelectionModel();


//案卷目录面板
var archiveVessel = new Ext.Panel({
    title:'档案数据',
    iconCls:'archive',
    region:'center',
    listeners:{
        resize:function(a,b,c){
            if(archiveGrid!=null){
                archiveGrid.setWidth(archiveVessel.getWidth());
                archiveGrid.setHeight(archiveVessel.getHeight()-30);
            }
            if(documnetGrid!=null){
                documnetGrid.setWidth(documentVessel.getWidth());
                documnetGrid.setHeight(documentVessel.getHeight()-30);
            }
        }
    }
});


//卷内目录面板
var documentVessel = new Ext.Panel({
    title:'卷内目录',
    iconCls:'document',
    region:'south',
    split:true,
    collapsible:true,
    height:200,
    listeners:{
        collapse:function (a) {
            if (archiveGrid != null) {
                archiveGrid.setHeight(archiveVessel.getHeight() - 30);
            }
        }
    }
});

var innerPanel = new Ext.Panel({
    region:'center',
    margins:'5 0 0 0',
    layout:'border',
    items:[archiveVessel, documentVessel]
});

//案卷分类面板
var treeVessel = new Ext.tree.TreePanel({
    title:'档案类别',
    iconCls:'tree',
    region:'west',
    margins:'5 0 0 5',
    width:150,
    split:true,
    collapsible:true,
    autoScroll:true,
    loader:new Ext.tree.TreeLoader(),
    root:{
        id:'rootNode',
        text:'根分类',
        iconCls:'root'
    },
    rootVisible:false,
    listeners:{
        render:function (tree) {
            tree.getRootNode().expand(false, false);
        },
        beforeload:function (node) {
            this.loader.dataUrl = 'main!node.action?type=model&id=' + (node.id == 'rootNode' ? '' : node.id);
        },
        click:function (node) {
            //刷新档案数据操作
            var tempNode = node;
            title = node.attributes['title'];
            treeId = node.id;
            if (tempNode.parentNode.parentNode != null) {
                while (tempNode.parentNode.parentNode.id != 'rootNode') {
                    tempNode = tempNode.parentNode;
                }
                modelName = tempNode.attributes['name'];
                jnModelName = modelName + "_jn";
            } else {
                modelName = null;
            }
            Ext.Ajax.request({
                url:'main!getPermJson.action?treeId=' + treeId,
                success:function (rp) {
                    perm = Ext.decode(rp.responseText);

                }
            });

            if (modelName != null) {
                Ext.Ajax.request({
                    url:'main!getShowFields.action?modelName=' + modelName,
                    success:function (rp) {
                        var showFields = Ext.decode(rp.responseText);
                        updateArchive(node.id, getFields(showFields.result, "archive"));
                    }
                });
            } else {
                if (archiveGrid != null) {
                    archiveVessel.remove(archiveGrid);
                    archiveGrid = null;
                }
                if (documnetGrid != null) {
                    documentVessel.remove(documnetGrid);
                    documnetGrid = null;
                }
            }
        },
        collapse:function (a) {
            if (archiveGrid != null) {
                archiveGrid.setWidth(archiveVessel.getWidth());
            }
            if (documnetGrid != null) {
                documnetGrid.setWidth(documentVessel.getWidth());
            }
        }
    }
});


//原文列表面板
var originalVessel = new Ext.Panel({
    title:'原文管理',
    region:'east',
    margins:'5 0 0 0',
    split:true,
    width:300,
    collapsible:true,
    listeners:{
        collapse:function (a) {
            if (archiveGrid != null) {
                archiveGrid.setWidth(archiveVessel.getWidth());
            }
            if (documnetGrid != null) {
                documnetGrid.setWidth(documentVessel.getWidth());
            }
        },
        resize:function (a) {
            if (ogGrid!=null)
            {
                ogGrid.setWidth(originalVessel.getWidth());
            }
        }

    }
});


new Ext.Viewport({
    layout:'border',
    title:'档案管理',
    items:[originalVessel, treeVessel, innerPanel],
    renderTo:Ext.getBody()
});


function getJsessionidUrl(url) {
    var index = url.indexOf('?');
    if (index > -1) {
        return url.substring(0, index) + ';jsessionid=' + _jsessionid + url.substr(index);
    } else {
        return url + ';jsessionid=' + _jsessionid;
    }
}

/**
 * 更新档案数据
 * @param treeId 资源id
 */
function updateArchive(treeId, fields) {
    if (archiveGrid != null) {
        archiveVessel.remove(archiveGrid);
        archiveGrid = null;
    }
    if (documnetGrid != null) {
        documentVessel.remove(documnetGrid);
        documnetGrid = null;
    }
    store = new Ext.data.JsonStore({
        url:'archive!list.action',
        root:'items',
        totalProperty:'totalCount',
        fields:fields,
        baseParams:{modelName:modelName, limit:20, treeId:treeId, type:"all"}
    });

    store.load({callback:function (a, b, c) {
        if (c) {
            addGridView();
        }
    }});
}

/**
 * 更新卷内数据
 */
function updateDocument(archiveId, fields) {
    var jnModelName = modelName + "_jn";
    if (documnetGrid != null) {
        documentVessel.remove(documnetGrid);
        documnetGrid = null;
    }
    docStore = new Ext.data.JsonStore({
        url:'doc!list.action',
        root:'items',
        totalProperty:'totalCount',
        fields:fields,
        baseParams:{modelName:jnModelName, limit:20, archiveId:archiveId}
    });
    docStore.load({callback:function (a, b, c) {
        if (c) {
            resetDocument();
        }
    }});

}


/**
 * 将gridView嵌入到档案列表容器中
 */
function addGridView() {
    var column = new Ext.grid.ColumnModel(columns
    );
    var pageBar = new Ext.PagingToolbar({
        plugins:new Ext.ux.ComboPageSize({ addToItem:false, prefixText:'每页', postfixText:'条'}),
        pageSize:20,
        store:store,
        displayInfo:true,
        displayMsg:'{0} - {1} 共 {2} 条',
        emptyMsg:"没有记录返回"
    });
    archiveGrid = new Ext.grid.GridPanel({
        title:title,
        iconCls:'preview',
        ds:store,
        autoScroll:true,
        height:archiveVessel.getHeight() - 30,
        sm:ogSm,
        bbar:pageBar,
        viewConfig:{
            forceFit:true
        },
        cm:column,
        tbar:[
            {
                text:'添加',
                iconCls:'add',
                handler:function () {
                    showArchive();
                }
            },
            {
                text:'编辑',
                iconCls:'edit',
                handler:function () {
                    editArchive();
                }
            },
            {
                text:'删除',
                iconCls:'delete',
                handler:function () {
                    delArchive();
                }
            },
            {
                text:'归档',
                iconCls:'gd',
                handler:function () {
                    gdArchive();
                }
            },
            {
                text:'撤销归档',
                iconCls:'reset',
                handler:function () {
                    cxgdArchive();
                }
            },
            {
                text:'自动组盒',
                iconCls:'packageArchive',
                handler:function () {
                    packageArchive();
                }
            },
            '->',
            new Ext.ux.form.SearchField({
                id:'searchBox2',
                style:{'margin':'0,0,0,200px'},
                store:store,
                width:150
            })
        ],
        listeners:{
            rowdblclick:function (g, index, e) {
                var archiveId = store.getAt(index).id;
                editArchive(archiveId);
            },
            rowclick:function (g, index, e) {
                var ids = getSelectIds();
                if (ids.length != 1) {
                    if (documnetGrid != null) {
                        documentVessel.remove(documnetGrid);
                        originalVessel.removeAll();
                        documnetGrid=null;
                    }
                    return;
                } else {
                    archiveId = ids;
                    Ext.Ajax.request({
                        url:'main!getDocShowFields.action?modelName=' + modelName,
                        success:function (rp) {
                            var showFields = Ext.decode(rp.responseText);
                            updateDocument(ids, getFields(showFields.result, "document"));
                        }
                    });
                    showOriginal(null,ids);
                }
            }
        }
    });
    archiveVessel.add(archiveGrid);
    archiveVessel.doLayout();
}


function resetDocument() {
    var column = new Ext.grid.ColumnModel(docColumns);
    var pageBar = new Ext.PagingToolbar({
        plugins:new Ext.ux.ComboPageSize({ addToItem:false, prefixText:'每页', postfixText:'条'}),
        pageSize:20,
        store:docStore,
        displayInfo:true,
        displayMsg:'{0} - {1} 共 {2} 条',
        emptyMsg:"没有记录返回"
    });

    documnetGrid = new Ext.grid.GridPanel({
        ds:docStore,
        height:documentVessel.getHeight() - 30,
        sm:docOgSm,
        bbar:pageBar,
        viewConfig:{
            forceFit:true
        },
        cm:column,
        tbar:[
            {
                text:'添加',
                iconCls:'add',
                handler:function () {
                    showDocument();
                }
            },
            {
                text:'修改',
                iconCls:'edit',
                handler:function () {
                    editDocument();
                }
            },
            {
                text:'删除',
                iconCls:'delete',
                handler:function () {
                    delDocument();
                }
            }
        ],
        listeners:{
            rowdblclick:function (g, index, e) {
                showDocument(docStore.getAt(index).data.id);
            },
            rowclick:function (g, index, e) {
                var ids=getDocumentIds();
                if(ids.length!=1){
                    originalVessel.removeAll();
                }else{
                    showOriginal(null,ids);
                }
            }
        }
    });
    documentVessel.add(documnetGrid);
    documentVessel.doLayout();
}


/**
 * 获取档案展示的字段
 * @param result
 * @return {Array}
 */
function getFields(result, type) {
    var fields = [];
    fields.push("id");
    if (result != null) {
        for (var i = 0; i < result.length; i++) {
            fields.push(result[i].fieldName);
        }
        getColumn(result, type);
    }
    return fields;
}

/**
 * 获取档案类表的columns
 * @param result
 * @return {Array}
 */
function getColumn(result, type) {
    if (result != null) {
        if (type == "archive") {
            if (columns != null) {
                columns = [];
            }
            columns.push(ogSm);
            for (var i = 0; i < result.length; i++) {
                var column;
                if (result[i].fieldName == "state") {
                    column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName, renderer:stateFormat};
                } else if (result[i].date != null) {
                    column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName, renderer:dateFormate};
                } else {
                    column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName};
                }
                columns.push(column);
            }
        } else {
            if (docColumns != null) {
                docColumns = [];
            }
            docColumns.push(docOgSm);
            for (var i = 0; i < result.length; i++) {
                var column;
                if (result[i].fieldName == "state") {
                    column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName, renderer:stateFormat};
                } else if (result[i].date != null) {
                    column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName, renderer:dateFormate};
                } else if (result[i].fieldName == "archiveId") {
                    column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName, renderer:archvieFormate};
                } else {
                    column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName};
                }
                docColumns.push(column);
            }
        }

    }
}

var dateFormate = function (date, o, p) {
    if (date == "") {
        return "----";
    } else {
        if (typeof  date == "string") {
            var d = new Date(Date.parse(date.replace(/-/g, "/")));
        } else {
            var d = new Date(date);
        }
        return Ext.util.Format.date(d.toString(), "Y年m月d日");
    }
};

var stateFormat = function (v, o, p) {
    if (v == 1) return "<img src=\"/archive/img/ygd.png\" alt=\"已归档\" title=\"已归档\" class='img' />";
    else return "<img src=\"/archive/img/wgd.png\" alt=\"未归档\" title=\"未归档\" class='img' />";
}

var archvieFormate = function (v, o, p) {
    if (v != null && v != "") return "<img src=\"/archive/img/ygd.png\" alt=\"已立卷\" title=\"已立卷\" class='img' />";
    else return "<img src=\"/archive/img/wgd.png\" alt=\"未立卷\" title=\"未立卷\" class='img' />";

}


/**
 * 弹出窗口缩放
 * @param w
 * @param h
 */
function onResize(w, h) {
    if (iframeType == 'doc') {
        docWin.setWidth(w + 40);
        docWin.setHeight(h + 90);
        docWin.center();
    } else {
        win.setWidth(w + 40);
        win.setHeight(h + 90);
        win.center();
    }
}


/**
 * 显示档案
 * @param id
 */
function showArchive(id) {
    win = new Ext.Window({
        title:id ? '编辑档案' : '添加档案',
        closable:true,
        modal:true,
        width:400,
        height:320,
        border:false,
        resizable:false,
        buttons:[
            <#if ctx.hasEnv('jurong.enable')>
                {
                    text:'添加卷内',
                    hidden:(!id),
                    handler:function () {
                        showDocument(id);
                    }
                },
                <#if isShowArchiveInfo>
                    {
                        text:'卷内信息',
                        hidden:(!id),
                        handler:function () {
                            showArchiveInfo(id);
                        }
                    },
                </#if>
            </#if>
            {
                text:'续添档案',
                hidden:!perm.edit,
                handler:function () {
                    archiveSaveType = 'SaveAndAdd';
                    $('#archiveFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'保存',
                hidden:!perm.edit,
                handler:function () {
                    archiveSaveType = 'onlySave';
                    $('#archiveFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="archive-entity.action?modelName=' + modelName + '&treeId=' + treeId + (id ? '&id=' + id : '') + '" id="archiveFrame"></iframe>'
    });
    win.show();
    iframeType = "arc";
    _curAId = id;
    return false;
}

/**
 * 编辑档案
 * @param id
 */
function editArchive(id) {
    if (id) {
        showArchive(id);
    } else {
        var ids = getSelectIds();
        if (ids.length > 1 || ids.length == 0) {
            alert('请选择一个档案!');
        } else {
            showArchive(ids.pop());
        }
    }
}
/**
 * 删除档案
 * @param id
 */
function delArchive(id) {
    if (id) {
        showArchive(id);
    }
    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个项目!');
    }
    else if (confirm('确定要删除吗？')) {
        Ext.Ajax.request({
            url:'archive!remove.action?modelName=' + modelName,
            params:{id:getSelectIds()},
            success:function (r) {
                documentVessel.removeAll();
                originalVessel.removeAll();
                store.reload();
            }
        });
    }
}

function onArchiveComplete(result, msg) {
    win.close();
    if (result) {
            store.reload();
            if (archiveSaveType == 'onlySave'){
                showArchive(msg);
            }else{
                showArchive(null);
            }
    }
    else {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　', function () {
            if (archiveSaveType == 'onlySave') showArchive(msg);
            else showArchive(null);
        });
    }

}

/**
 * 档案归档操作
 */
function gdArchive() {
    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个项目!');
        return;
    }
    if (confirm('确定要归档吗？')) {
        Ext.Ajax.request({
            url:'archive!gd.action?modelName=' + modelName,
            params:{id:ids},
            success:function (r) {
                if (r.responseText) {
                    alert(r.responseText);
                }
                store.reload();
            }
        });
    }
}

/**
 * 撤销归档
 */
function cxgdArchive() {
    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个项目!');
        return;
    }
    if (confirm('确定要撤销归档吗？')) {
        Ext.Ajax.request({
            url:'archive!cxgd.action?modelName=' + modelName,
            params:{id:ids},
            success:function (r) {
                if (r.responseText) {
                    alert(r.responseText);
                }
                store.reload();
            }
        });
    }
}

/**
 * 自动组盒
 */
function packageArchive() {
    var fp = new Ext.FormPanel({
        labelWidth:90,
        frame:true,
        border:false,
        bodyStyle:'padding:5px',
        items:[
            {
                fieldLabel:'目录号',
                xtype:"textfield",
                allowBlank:false,
                name:'mlh'
            },
            {
                fieldLabel:'起始案卷号',
                xtype:"numberfield",
                allowBlank:false,
                name:'ajh'
            },
            {
                fieldLabel:'截止案卷号',
                xtype:'numberfield',
                allowBlank:true,
                name:'endAjh'
            },
            {
                fieldLabel:'装盒份数',
                xtype:"numberfield",
                value:10,
                allowBlank:false,
                name:'boxSize'
            },
            {
                xtype:'radiogroup',
                fieldLabel:'排序',
                items:[
                    {boxLabel:'升序', name:'dir', inputValue:'ASC', checked:true},
                    {boxLabel:'降序', name:'dir', inputValue:'DESC'}
                ]
            }
        ],
        buttons:[
            {
                text:'打印目录',
                handler:function () {
                    if (fp.getForm().isValid()) {
                        var param = fp.getForm().getValues();
                        if (param.endAjh != "") {
                            var start = parseInt(param.ajh);
                            var end = parseInt(param.endAjh);
                            if (start >= end)
                                return Ext.MessageBox.alert("提示", "请确保截止案卷号要大于起始案卷号");
                        }
                        param.limit = -1;
                        var base = location.href.substring(0, location.href.lastIndexOf('/'));
                        var printUrl = getJsessionidUrl(base + '/archive!fr3.action?modelName=' + modelName);
                        var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName + '&' + Ext.urlEncode(param));
//                        prompt('', dataUrl);
                        location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
                    }
                }
            },
            {
                text:'打印封皮',
                handler:function () {
                    if (fp.getForm().isValid()) {
                        var param = fp.getForm().getValues();
                        if (param.endAjh != "") {
                            var start = parseInt(param.ajh);
                            var end = parseInt(param.endAjh);
                            if (start >= end)
                                return Ext.MessageBox.alert("提示", "请确保截止案卷号要大于起始案卷号");
                        }
                        param.limit = -1;
                        var base = location.href.substring(0, location.href.lastIndexOf('/'));
                        var printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=cover&modelName=' + modelName);
                        var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName + '&' + Ext.urlEncode(param));
                        location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
                    }
                }
            },
            {
                text:'关闭',
                handler:function () {
                    pWin.close();
                }
            }
        ]
    });
    var pWin = new Ext.Window({
        title:'自动组盒',
        closable:true,
        modal:true,
        width:280,
        layout:'auto',
        border:false,
        resizable:false,
        items:fp
    });
    pWin.show();
}
function delDocument() {
    var ids = getDocumentIds();
    if (ids.length == 0) {
        alert('请至少选择一个卷内!');
    } else {
        if (confirm('确定要删除吗？')) {
            Ext.Ajax.request({
                url: 'doc!remove.action?modelName='+jnModelName,
                params:{id:ids},
                success: function(r) {
                    docStore.reload();
                }
            });
        }
    }
}


function showOriginal(archiveId, id) {
    var isArchive = !archiveId;
    ogDs = new Ext.data.JsonStore({
        url:'og!list.action?ownerId=' + id,
        autoLoad:true,
        totalProperty:'totalCount',
        root:'items',
        fields:[
            'id', 'name', 'fileSize', 'updateTime'
        ]
    });
    var ogSm = new Ext.grid.CheckboxSelectionModel();
    var formatSize = function (size, p, record) {
        return Ext.util.Format.fileSize(size);
    };
    ogGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds:ogDs,
        width:originalVessel.getWidth(),
        height:originalVessel.getHeight() - 50,
        sm:ogSm,
        loadMask:true,
        autoScroll:true,
        stripeRows:true,
        region:'center',
        bbar:new Ext.PagingToolbar({
            pageSize:20, //每页显示几条数据
            store:ogDs,
            displayInfo:true,
            displayMsg:'{0} - {1} 共 {2} 条',
            emptyMsg:"没有记录返回" }),
        cm:new Ext.grid.ColumnModel([
            //new Ext.grid.RowNumberer(),//显示行号
            ogSm,
            {header:"名称", width:150, sortable:true, dataIndex:'name'},
            {header:"大小", width:100, sortable:true, dataIndex:'fileSize', renderer:formatSize},
            {header:"上传时间", width:150, sortable:true, dataIndex:'updateTime'}
        ]),
        tbar:[
            {
                text:'查看',
                iconCls:'preview',
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    }
                    var nids = [];
                    for (var i = 0; i < ogSm.getSelections().length; i++) {
                        nids.push(ogSm.getSelections()[i].data.id);
                    }
                    showPreview(nids);
                }
            },
            {
                text:'上传',
                iconCls:'upload',
                hidden:!perm.edit,
                handler:function () {
                    var getUrl = function (url) {
                        return getJsessionidUrl(url + '?modelName=' + (isArchive ? modelName : jnModelName));
                    };
                    var uploadDialog = new UploadDialog({
                        getUrl:getUrl,
                        maxSize:5368709120,
                        typeDescription:'所有文件',
                        autoClose:this.autoClose || true,
                        fileTypes:'*.*'
                    });
                    uploadDialog.on('close', function () {
                        ogDs.reload();
//                        ogGrid.getStore().loa;
                    });
                    uploadDialog.show(id);
                }
            },
            {
                text:'关联',
                iconCls:'reset',
                hidden:!perm.edit,
                handler:function () {
                    if (linkWin != null) {
                        linkWin.show();
                    }
                    else
                        showLinkWin(id);
                }
            },
            {
                text:'打印',
                iconCls:'print',
                hidden:!perm.print,
                handler:function () {
                    var ssl = ogSm.getSelections().length;
                    if (ssl == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    } else if (ssl > 1) {
                        Ext.MessageBox.alert('提示', '　　只能选择一个原文!　　');
                        return;
                    }
                    showPrint(ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:'下载',
                iconCls:'download',
                hidden:!perm.download,
                handler:function () {
                    var ssl = ogSm.getSelections().length;
                    if (ssl == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    } else if (ssl > 1) {
                        Ext.MessageBox.alert('提示', '　　只能选择一个原文!　　');
                        return;
                    }
                    window.open('og!get.action?preview=false&id=' + ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:'权限',
                iconCls:'edit',
            hidden:<#if ctx.hasEnv('originalPermission.enable')>!perm.edit<#else>true</#if>,
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　没有原文被选择!　');
                        return;
                    }
                    setPermission(ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:'删除',
                iconCls:'delete',
                hidden:!perm.edit,
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        alert('　　没有原文被选择!　　');
                        return;
                    }
                    if (!confirm('确定要删除吗？'))
                        return;
                    var p = [];
                    Ext.each(ogSm.getSelections(), function (s) {
                        p.push(s.data.id);
                    });
                    Ext.Ajax.request({
                        url:'og!remove.action',
                        params:{id:p},
                        success:function (r) {
                            ogDs.reload();
                        }
                    });
                }
            },
                '->',
            new Ext.ux.form.SearchField({
                id:'searchBox1',
                style:{'margin':'0,0,0,150px'},
                store:ogDs,
                width:150
            })
        ],
        listeners:{
            rowdblclick:function (g, index, e) {
                if (perm.download) {
                    var id = ogDs.getAt(index).id;
                    showPreview([id]);
                }
            },
            render:function (g) {
                var store = g.getStore();
                var view = g.getView();
                g.tip = new Archive.OgTip({
                    dismissDelay:0,
                    target:view.mainBody,
                    delegate:'.x-grid3-row',
                    autoWidth:!Ext.isIE6,
                    renderTo:document.body,
                    listeners:{
                        beforeshow:function (tip) {
                            var rowIndex = view.findRowIndex(tip.triggerElement);
                            tip.body.update('<img src="' + 'og!thumb.action?modelName=' + modelName + '&id=' + store.getAt(rowIndex).id + '"/>');
                        }
                    }
                });
            }
        }
    });
    originalVessel.removeAll();
    originalVessel.add(ogGrid);
    originalVessel.doLayout();
    return false;
}
var docWin;
function showDocument(id) {
    docWin = new Ext.Window({
        title:id ? '编辑卷内' : '添加卷内',
        closable:true,
        modal:true,
        width:400,
        height:320,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'保存',
                handler:function () {
                    window.archiveId = archiveId;
                    $('#documentFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    docWin.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="doc-entity.action?modelName=' + jnModelName + (id ? '&id=' + id : '') + (archiveId ? '&archiveId=' + archiveId : '') + '" id="documentFrame"></iframe>'
    });
    docWin.show();
    iframeType = "doc";
    return false;
}

function editDocument() {
    var ids = getDocumentIds();
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个卷内!');
    }
    else {
        showDocument(ids.pop());
    }
}

function onDocumentComplete(result, msg) {
    docWin.close();
    if (result) {
        docStore.reload();
    } else {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    }
}


function getSelectIds() {
    var nids = [];
    for (var i = 0; i < ogSm.getSelections().length; i++) {
        nids.push(ogSm.getSelections()[i].data.id);
    }
    return nids;
}

function getDocumentIds() {
    var nids = [];
    for (var i = 0; i < docOgSm.getSelections().length; i++) {
        nids.push(docOgSm.getSelections()[i].data.id);
    }
    return nids;
}

function showPreview(nids) {
    if (!Ext.isDefined(window.hasEPreOcx)) {
        try {
            new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
            window.hasEPreOcx = true;
        } catch (e) {
            window.hasEPreOcx = false;
        }
    }
    if (window.hasEPreOcx) {
        var base = location.href.substring(0, location.href.lastIndexOf('/'));
        var link = getJsessionidUrl(base + '/og!preview.action?idsKey=');
        link = link.substr(link.indexOf('//') + 2);
        Ext.Ajax.request({
            url:'archive!cacheIds.action',
            params:{id:nids},
            success:function (r) {
                var json = Ext.decode(r.responseText);
                location.href = 'epre://' + link + json['idsKey'];
            }
        });
    } else {
        window.open('og!get.action?preview=true&id=' + nids[0]);
    }
}

function showPrint(id) {
    var width = 0, height = 0, srcWidth, srcHeight;
    var win = new Ext.Window({
        cls:'og',
        title:'打印原文',
        closable:true,
        modal:true,
        width:Ext.lib.Dom.getViewWidth() * .9,
        height:Ext.lib.Dom.getViewHeight() * .9,
        border:false,
        resizable:false,
        tbar:[
            {
                text:'打印',
                iconCls:'print',
                handler:function () {
                    var print = Ext.getDom('printFrame').contentWindow.webPrint;
                    var link = location.href;
                    print.ContentURL = getJsessionidUrl(link.substring(0, link.lastIndexOf('/')) + '/og!print.action?id=' + id + (width > 0 ? '&width=' + width : '') + (height ? '&height=' + height : ''));
                    print.marginBottom = print.marginLeft = print.marginRight = print.marginTop = 0;
                    print.Preview();
                }
            },
            {
                text:'放大',
                iconCls:'zoom-out',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 1.2;
                    img.height = height = height * 1.2;
                }
            },
            {
                text:'缩小',
                iconCls:'zoom-in',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 0.8;
                    img.height = height = height * 0.8;
                }
            },
            {
                text:'默认大小',
                iconCls:'reset',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    img.width = width = srcWidth;
                    img.height = height = srcHeight;
                }
            }
        ],
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="auto" frameborder="0" style="width:100%;height:100%;" src="og!print.action?id=' + id + '" id="printFrame"></iframe>'
    });
    win.show();
    return false;
}
function showLinkWin(id) {
    var tree = new Ext.tree.TreePanel({
        autoScroll:true,
        loader:new Ext.tree.TreeLoader(),
        root:new Ext.tree.AsyncTreeNode({
            id:"root",
            text:'/',
            iconCls:'root'
        }),
        listeners:{
            render:function (tree) {
                tree.getRootNode().expand(false, false);
            },
            beforeload:function (node) {
                this.loader.dataUrl = 'og!link.action?id=' + encodeURIComponent(node.id)
            }
        }
    });
    tree.on('checkchange', function (node, flag) {
        node.cascade(function (node) {
            node.attributes.checked = flag;
            node.ui.checkbox.checked = flag;
            return true;
        });
    });
    linkWin = new Ext.Window({
        title:'文件关联目录树',
        closable:true,
        modal:true,
        width:600,
        height:450,
        layout:'fit',
        border:false,
        resizable:false,
        closeAction:'hide',
        items:tree,
        buttons:[
            {
                text:'关联',
                handler:function () {
                    var ids = [];
                    var nodes = tree.getChecked();
                    for (var i = 0; i < nodes.length; i++) {
                        ids.push(nodes[i].id);
                    }
                    Ext.Ajax.request({
                        url:'og!saveLink.action?ownerId=' + id,
                        params:{id:ids},
                        success:function (r) {
                            Ext.MessageBox.alert("提示", "关联成功");
                            linkWin.hide();
                            for (var i = 0; i < nodes.length; i++) {
                                nodes[i].getUI().toggleCheck(false);
                                nodes[i].attributes.checked = false;
                            }
                            ogDs.load();
                        }
                    });
                }
            },
            {
                text:'关闭',
                handler:function () {
                    linkWin.hide();
                    ogDs.load();
                }
            }
        ]
    });
    linkWin.show();
}

function setPermission(id) {
    var pDs = new Ext.data.JsonStore({
        url:'og!listPermission.action?id=' + id,
        autoLoad:true,
        root:'items',
        fields:['id', 'userId', 'userName', 'operation', 'expireTime']
    });
    var pSm = new Ext.grid.CheckboxSelectionModel();
    var pGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds:pDs,
        height:250,
        sm:pSm,
        loadMask:true,
        stripeRows:true,
        region:'center',
        cm:new Ext.grid.ColumnModel([
            pSm,
            {header:"用户", width:100, sortable:true, dataIndex:'userName'},
            {header:"权限", width:200, sortable:true, dataIndex:'operation', renderer:function (v) {
                return v == 'download' ? '下载' : '查看';
            }},
            {header:"到期时间", width:200, sortable:true, dataIndex:'expireTime'}
        ]),
        tbar:[
            {
                iconCls:'add',
                text:'添加',
                handler:function () {
                    var fp = new Ext.FormPanel({
                        labelWidth:80,
                        url:'og!addPermission.action?op.originalId=' + id,
                        frame:true,
                        border:false,
                        bodyStyle:'padding:5px',
                        defaultType:'textfield',
                        items:[
                            {
                                xtype:'combo',
                                fieldLabel:'用户',
                                hiddenName:'op.userId',
                                store:new Ext.data.JsonStore({
                                    url:'og!listUsers.action',
                                    fields:['userId', 'userName']
                                }),
                                minChars:1,
                                valueField:'userId',
                                displayField:'userName',
                                mode:'remote',
                                typeAhead:false,
                                triggerAction:'all',
                                loadingText:'获取中...',
                                anchor:'100%',
                                listeners:{
                                    'select':function (cb, record) {
                                        fp.form.findField('op.userName').setValue(record.data['userName']);
                                    }
                                }
                            },
                            {
                                xtype:'combo',
                                fieldLabel:'权限',
                                hiddenName:'op.operation',
                                store:new Ext.data.ArrayStore({
                                    fields:['name', 'value'],
                                    data:[
                                        ["查看", 'view'],
                                        ['下载', 'download']
                                    ]
                                }),
                                value:'download',
                                valueField:'value',
                                displayField:'name',
                                typeAhead:true,
                                mode:'local',
                                triggerAction:'all',
                                anchor:'100%'
                            },
                            {
                                fieldLabel:'到期时间',
                                xtype:'datefield',
                                name:'op.expireTime',
                                anchor:'100%',
                                format:'Y-m-d'
                            },
                            {
                                xtype:'hidden',
                                name:'op.userName'
                            }
                        ],
                        buttons:[
                            {
                                text:'保存',
                                handler:function () {
                                    if (fp.getForm().isValid()) {
                                        fp.getForm().submit({
                                            waitMsg:'正在保存...',
                                            success:function () {
                                                addWin.close();
                                                pDs.reload();
                                            },
                                            failure:function (fp, action) {
                                                Ext.MessageBox.alert('失败', '保存失败');
                                            },
                                            scope:this
                                        });
                                    }
                                },
                                scope:this
                            },
                            {
                                text:'关闭',
                                handler:function () {
                                    addWin.close();
                                }
                            }
                        ]
                    });
                    var addWin = new Ext.Window({
                        title:'原文权限',
                        closable:true,
                        modal:true,
                        width:300,
                        height:200,
                        layout:'fit',
                        border:false,
                        resizable:false,
                        items:fp
                    });
                    addWin.show();
                }
            },
            {
                iconCls:'delete',
                text:'删除',
                handler:function () {
                    if (pSm.getSelections().length == 0) {
                        alert('　　没有权限被选择!　　');
                        return;
                    }
                    if (!confirm('确定要删除吗？'))
                        return;
                    var p = [];
                    Ext.each(pSm.getSelections(), function (s) {
                        p.push(s.data.id);
                    });
                    Ext.Ajax.request({
                        url:'og!removePermission.action',
                        params:{id:p},
                        success:function (r) {
                            pDs.reload();
                        }
                    });
                }
            }
        ]
    });
    var pWin = new Ext.Window({
        title:'原文权限',
        closable:true,
        modal:true,
        width:600,
        height:400,
        layout:'fit',
        border:false,
        resizable:false,
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    pWin.close();
                }
            }
        ],
        items:pGrid
    });
    pWin.show();
}
</script>
</@layout.html>