<#-- @ftlvariable name="modelName" type="java.lang.String" -->
<#-- @ftlvariable name="topMenu" type="java.util.Map<java.lang.String, java.lang.String>" -->
<#-- @ftlvariable name="treeId" type="java.lang.String" -->
<#-- @ftlvariable name="fields" type="java.util.Map<java.lang.String, com.gtis.archive.core.Field>" -->
<#-- @ftlvariable name="showFields" type="java.util.LinkedHashMap" -->
<@layout.main import="jquery,ext">
<table>
    <tr>
        <td class="archiveLeftPanel">
            <div class="a-box">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="min-height:500px;_height:500px;padding-top:10px;">
                            <dl class="a-side">
                                <dt>全文检索</dt>
                                <dd>
                                    <form action="${ctx.env['solr.url']}" method="get" target="_blank">
                                        <input type="hidden" name="bid" value="archive"/>
                                        <table id="search-box" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td class="input">
                                                    <input type="text" name="keyword" class="text"
                                                           style="width:120px;"/>
                                                    <input type="submit" class="sub" value=""/>
                                                    <input type="hidden" name="cid" value="a_${modelName}"/>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                </dd>
                            </dl>
                            <dl class="a-side" id="treeBox-ct">
                                <dt>分类</dt>
                                <dd>
                                    <div id="treeBox" style="margin: 5px 0px"></div>
                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </td>
        <td class="archiveRightPanel">
            <div class="a-box">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="padding-top:10px;">
                            <div>
                                <div id="wdythDiv" class="a-tab" style="display: none;font-size: 13px;">
                                    <a name="wgd" href="#" class="btn active" id="wgdItem">未归档</a>
                                    <a name="xgd" href="#" class="btn">需归档</a>
                                    <a name="bgd" href="#" class="btn">不归档</a>
                                    <a name="pgd" href="#" class="btn">预归档</a>
                                    <a name="ygd" href="#" class="btn">已归档</a>
                                </div>
                                <a id='advSearch' href="#" onclick="return showAdvancedSearch();"
                                   style="display:block;float:right;margin:4px 10px 0 5px;line-height: 20px;visibility:hidden;">高级检索</a>

                                <div id="searchBox" style="margin: 4px"></div>
                            </div>
                            <div class="a-opt clearfix" id="opt-box">
                                <div id="editDiv">
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return showEntity();"-->
                                       <#--id="addArchive">添加</a>-->

                                <#--<#if ctx.hasEnv('jiangyin.enable')>-->
                                <#--<#if ctx.isAdmin()>-->
                                <#--<a class="a-btn a-ctl" href="#" onclick="return editEntity();"id="editArchive">修改</a>-->
                                <#--<a class="a-btn a-ctl" href="#" onclick="return delEntity();" id="delArchive">删除</a>-->
                                <#--</#if>-->
                                <#--<#else>-->
                                <#--<a class="a-btn a-ctl" href="#" onclick="return editEntity();"id="editArchive">修改</a>-->
                                <#--<a class="a-btn a-ctl" href="#" onclick="return delEntity();" id="delArchive">删除</a>-->
                                <#--</#if>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return editEntity();"id="editArchive">修改</a>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return delEntity();" id="delArchive">删除</a>-->

                                    <a class="a-btn a-ctl" href="#" onclick="return printArchive();" id="printArchive">打印</a>
                                    <a class="a-btn a-ctl" href="#" onclick="return printCover();"
                                       id="printArchiveCover">打印封皮</a>
                                    <a class="a-btn a-ctl" href="#" onclick="return exportExcel();"
                                       id="exportExcel">导出</a>
                                </div>
                                <div id="gdDiv" style="display: none">
                                    <a class="a-btn a-ctl" href="#" onclick="return showOriginal()" id="showOriginal1">原文管理</a>
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return changeEntityStatus('xgd');" id="xgdBtn">需归档</a>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return changeEntityStatus('bgd');" id="bgdBtn">不归档</a>-->
                                <#--<a class="a-btn a-ctl" href="#" onclick="return changeEntityStatus('pgd');">预归档</a>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return changeEntityStatus('ygd');" id="ygdBtn">已归档</a>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="changeEntityStatusAll('ygd');" id="ytgdBtn">一体归档</a>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="changeEntityStatusAll('pgd');" id="ytygdBtn">一体预归档</a>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="removeYgd();" id="cxygdBtn">撤销预归档</a>-->
                                    <a class="a-btn a-ctl" href="#" onclick="showLoan2();" id="jydj">借阅登记</a>
                                    <a class="a-btn a-ctl" href="#" onclick="loanCar2();" id="jyc">添加到借阅车</a>
                                </div>
                                <div id="cxGdDiv" style="display: none">
                                    <#if ctx.hasEnv('jiangyin.enable')>
                                        <#if ctx.isAdmin()>
                                            <#--<a class="a-btn a-ctl" href="#" onclick="return editEntity();">修改</a>-->
                                            <#--<a class="a-btn a-ctl" href="#" onclick="return delEntity();">删除</a>-->
                                        </#if>
                                    <#else>
                                        <#--<a class="a-btn a-ctl" href="#" onclick="return editEntity();">修改</a>-->
                                        <#--<a class="a-btn a-ctl" href="#" onclick="return delEntity();">删除</a>-->
                                    </#if>

                                    <a class="a-btn a-ctl" href="#" onclick="return showOriginal()" id="showOriginal2">原文管理</a>
                                    <#if ctx.hasEnv('jiangyin.enable')>
                                        <#if ctx.isAdmin()>
                                            <#--<a class="a-btn a-ctl" href="#" onclick="return cxgd();">撤销归档</a>-->
                                        </#if>
                                    <#else>
                                        <#--<a class="a-btn a-ctl" href="#" onclick="return cxgd();">撤销归档</a>-->
                                    </#if>

                                    <a class="a-btn a-ctl" href="#" onclick="return printYGD();">打印</a>
                                    <a class="a-btn a-ctl" href="#" id="loanNote" onclick="showLoan();" >借阅登记</a>
                                    <a class="a-btn a-ctl" href="#" id="loanCart" onclick="loanCar();" >添加到借阅车</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="a-box" id="search-item" style="display:none;">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame clearfix"
                             style="margin-top:10px;padding:5px 0 5px 5px;position:relative;">
                            <span class="search-item-close" onclick="hideAdvancedSearch();"></span>

                            <div style="float:right;padding:3px 25px 8px 0;">
                                <a class="a-btn" href="#" onclick="return addSearchItem();">增加过滤</a>
                                <a class="a-btn" href="#" onclick="return advancedSearch();">检 索</a>
                            </div>
                            <form class="clearfix" id="search-item-box"
                                  onkeydown="if(event.keyCode==13){event.keyCode=0;return false;}"></form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="a-box" style="margin-top:10px;">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="min-height:422px;_height:422px;">
                            <div id="entityCt"></div>
                            <div id="pagingToolbar"></div>
                        </div>
                    </div>
                </div>
            </div>
        </td>
    </tr>
</table>
<div id="advancedSearchTpl"></div>

<style type="text/css">

    a {
        overflow: auto;
    }

    span {
        overflow: auto;
    }

</style>

<script type="text/javascript" src="js/ext/SearchField.js"></script>
<script type="text/javascript" src="js/ext/ux/ComboPageSize.js"></script>
<script type="text/javascript" src="js/UploadDialog.js"></script>
<script type="text/javascript">

var win, store, dataView, pageToolBar, searchField, treeId = '${treeId}', modelName = '${modelName}', id;
var changeType, preFields;
var json =${treeJson!'[]'};
var _jsessionid = '${sessionId}';
var $allStatusItemList = $('#wdythDiv a');
var isWdyth;
var tree;
var genericId;
document.onreadystatechange = test


Ext.util.Format.style = function (v) {
    debugger;
    if (v == null || v.toString() == "") {
        return null;
    } else if (v == false) {
        return "<img src=\"/archive/img/wuog.png\" alt=\"未上传原文\"  title=\"未上传原文\" class='img' />";
    }
    return null;
}

function test() {
    Ext.onReady(function () {
        if (tree != null) {
            debugger;
            var nodes = tree.root.childNodes;
            var wdyth;
            var node;
            for (var i = 0; i < nodes.length; i++) {
                if (nodes[i].attributes["name"] == "文档一体化") {
                    wdyth = nodes[i].childNodes;
                    break;
                }
            }
            if (wdyth != null) {
                for (var j = 0; j < wdyth.length; j++) {
                    if (wdyth[j].attributes["name"].toLowerCase() == modelName.toString()) {
                        node = wdyth[j];
                    }
                }
            }
            if (node != null) {
                if (node.id == 'rootNode') {
                    treeId = '${treeId}';
                } else {
                    treeId = node.id;
                }
                if (node.childNodes.length > 0) return;
                modelName = node.attributes.name;
                if (node.attributes.content == 'wdyth' && modelName != "ygd" && modelName != "pgd") {
                    $("#wdythDiv").css('display', 'block');
                    $("#gdDiv").css('display', 'block');
                    $("#ygdBtn").hide();
                    $("#ytgdBtn").hide();
                    $("#ytygdBtn").hide();
                    $("#cxygdBtn").hide();
                    $("#xgdBtn").show();
                    $("#bgdBtn").show();
                    $("#jydj").hide();
                    $("#jyc").hide();
                    isWdyth = true;
                } else {
                    $("#wdythDiv").css('display', 'none');
                    $("#gdDiv").css('display', 'none');
                    isWdyth = false;
                }
                if (modelName == "ygd" || modelName == "pgd") {
                    $("#editDiv").css('display', 'none');
                    $("#cxGdDiv").css('display', 'block');
                } else {
                    $("#editDiv").css('display', 'block');
                    $("#cxGdDiv").css('display', 'none');
                }
                getTplByModel(modelName, 'list');
                node.select();
            }
        }
    });
}


function loanCar2(){
    var loanIds=getSelectIds();
    if(loanIds.length==0){
        alert("请选择要借阅的档案");
        return;
    }
    Ext.Ajax.request({
        url:'borrow!addLoanCar.action',
        params:{idString:loanIds, archiveType:modelName},
        success:function (rp) {
            var message=rp.responseText;
            if(message=="success"){
                alert("添加成功");
            }else{
                alert("添加失败");
            }
        }
    });
}

function showLoan2(){
    var ids=getSelectIds();
    if (ids.length == 0) {
        alert('请选择项目!');
        return;
    }
    win = new Ext.Window({
        title: '借阅登记',
        closable:true,
        modal:true,
        width:400,
        height:240,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'立即归还',
            hidden:<#if ctx.hasEnv('jiangyin.enable')>false<#else >true</#if>,
                handler:function(){
                    $('#loanFrame')[0].contentWindow.backNow();
                    $('#loanFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'借阅',
                handler:function () {
                    $('#loanFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="loan-entity.action?modelName=Loan&type='+modelName+"&"+ Ext.urlEncode({archiveId:ids}) + '" id="loanFrame"></iframe>'
    });
    win.show();
}

function loanCar(){
    debugger;
    var loanIds=getSelectIds();
    if(loanIds.length!=1){
        alert("请选择一个要借阅的档案");
        return;
    }
    var ml = store.data.items[position(loanIds[0], store.data.keys)].data.modelName.toLowerCase();
    Ext.Ajax.request({
        url:'borrow!addLoanCar.action',
        params:{idString:loanIds, archiveType:ml},
        success:function (rp) {
            var message=rp.responseText;
            if(message=="success"){
                alert("添加成功");
            }else{
                alert("添加失败");
            }
        }
    });
}

function showLoan(){
    var ids=getSelectIds();
    if (ids.length != 1) {
        alert('请选择一个项目!');
        return;
    }
    var ml = store.data.items[position(ids[0], store.data.keys)].data.modelName.toLowerCase();
    win = new Ext.Window({
        title: '借阅登记',
        closable:true,
        modal:true,
        width:400,
        height:240,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'立即归还',
            hidden:<#if ctx.hasEnv('jiangyin.enable')>false<#else >true</#if>,
                handler:function(){
                    $('#loanFrame')[0].contentWindow.backNow();
                    $('#loanFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'借阅',
                handler:function () {
                    $('#loanFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="loan-entity.action?modelName=Loan&type='+ml+"&"+ Ext.urlEncode({archiveId:ids}) + '" id="loanFrame"></iframe>'
    });
    win.show();
}

function onComplete(result, msg) {
    win.close();
    if (!result) {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    } else {
        Ext.MessageBox.alert('成功', '　　' + msg + '　　');
    }
}

function getJsessionidUrl(url) {
    var index = url.indexOf('?');
    if (index > -1) {
        return url.substring(0, index) + ';jsessionid=' + _jsessionid + url.substr(index);
    } else {
        return url + ';jsessionid=' + _jsessionid;
    }
}

function addSearchItem() {
    var item = $('#search-item-box').append($('#searchTpl').val()).children(":last");
    item.hover(
            function () {
                $(this).addClass("hover");
            },
            function () {
                $(this).removeClass("hover");
            });
}

function showAdvancedSearch() {
    if ($("#search-item-box .search-item").length == 0) {
        addSearchItem();
    }
    $('#search-item').toggle();
}

function advancedSearch() {
    var condition = Ext.lib.Ajax.serializeForm('search-item-box');
    store.setBaseParam('condition', condition.replace(/=/g, ',').replace(/&/g, ';'));
    store.load();
}

function hideAdvancedSearch() {
    $('#search-item').hide();
    store.setBaseParam('condition', '');
    store.load();
}


function getListIds() {
    var ids = [];
    var ct = "#entityCt";
    $(ct + ' .chk-archive').each(function () {
        if (this.value)
            ids.push(this.value);
    });
    return ids;
}

/**
 ##########################################################
 */

function changeEntityStatus(status) {
    var ids = getSelectIds();
    Ext.Ajax.request({
        url:'check!modify.action',
        params:{id:ids, modelName:modelName, status:status},
        success:function (resp) {
            store.reload();
        }
    });

}


function changeEntityStatusAll(type) {
    Ext.Ajax.request({
        url:'check!years.action',
        success:function (resp) {
            var years = Ext.decode(resp.responseText);
            choseYear(years,type);
        }
    });
}

function removeYgd(){
    debugger;
    var ids = getSelectIds();
    Ext.Ajax.request({
        url:'check!cxyGd.action',
        params:{id:ids, modelName:modelName, status:"xgd"},
        success:function (resp) {
            store.reload();
        }
    });
}


function choseYear(years,type) {
    var combo = new Ext.form.ComboBox({
        store:years,
        emptyText:"请选择年份:",
        model:'local'
    });
    var yearsSelectPanel = new Ext.Panel({
        labelWidth:90,
        frame:true,
        border:false,
        bodyStyle:'padding:5px',
        html:'',
        items:combo,
        buttons:[
            {
                text:'确定',
                handler:function () {
                    var selectYear = combo.getValue();
                    if (selectYear == "") return;
                    Ext.Ajax.request({
                        url:'check!modifyAll.action',
                        params:{nd:selectYear,status:type},
                        success:function (resp) {
                            store.reload();
                            yWin.close();
                        }
                    });

                }
            },
            {
                text:'关闭',
                handler:function () {
                    yWin.close();
                }
            }
        ]
    });


    var yWin = new Ext.Window({
        title:'一体化归档',
        closable:false,
        modal:true,
        width:200,
        layout:'auto',
        border:false,
        resizable:false,
        items:yearsSelectPanel
    });
    yWin.show();
}

function showTipDelay(o, id) {
    o.tipTimer = setTimeout(function () {
        showTip(o, id)
    }, 500);
}

function hideTip(o) {
    if (o.tipTimer) {
        clearTimeout(o.tipTimer);
    }
}

var archiveTip;

function showTip(a, id) {
    var tempModelName;
    if (archiveTip) {
        archiveTip.hide();
    } else {
        archiveTip = new Archive.ToolTip({
            width:250,
            target:a,
            html:'loading'
        });
    }
    if (modelName == "ygd" || modelName == "pgd") {
        tempModelName = store.data.items[position(id, store.data.keys)].data.modelName.toLowerCase();
    } else {
        tempModelName = modelName;
    }
    Ext.Ajax.request({
        url:'generic-entity!preview.action',
        params:{id:id, modelName:tempModelName},
        success:function (rp) {
            var html = ['<div class="info-card"><ul>'];
            html.push(rp.responseText);
            html.push('</ul></div>');
            archiveTip.setHtml(html.join(''));
        }
    });
    archiveTip.showBy(a);
    return false;
}

function showEntity(id) {
    debugger;
    var tempModelName;
    var tempTreeId;
    if ((modelName == "ygd" && id != null)||(modelName == "pgd" && id != null)) {
        tempModelName = store.data.items[position(id, store.data.keys)].data.modelName.toLowerCase();
    } else {
        tempModelName = modelName;
    }
    if (tree != null) {
        if ((modelName == "ygd" && id != null) || (modelName == "pgd" && id != null)) {
            tempTreeId = getTreeId(tree, tempModelName);
        } else {
            tempTreeId = treeId;
        }
    } else {
        tempTreeId = treeId;
    }
    win = new Ext.Window({
        title:id ? '编辑' : '添加',
        closable:true,
        modal:true,
        width:400,
        height:300,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'续添',
                hidden:(id != null && modelName != "ygd" && modelName!="pgd") ? false : true,
                handler:function () {
                    win.close();
                    showEntity();
                }
            },
            {
                text:'打印暨办单',
                hidden:showGBD(id),
                handler:function () {
                    printGBD(id);
                }
            },
            {
                text:'打印',
                hidden:id ? false : true,
                handler:function () {
                    printEntity(id);
                }

            },
            {
                text:'原文管理',
                hidden:showOriginalBtn(id),
                handler:function () {
                    showOriginal(id);
                }

            },
            {
                text:'保存',
                handler:function () {
                    $('#archiveFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="generic-entity.action?modelName=' + tempModelName + '&treeId=' + tempTreeId + (id ? '&id=' + id : '') + '" id="archiveFrame"></iframe>'
    });
    win.show();
}

/**
 * 打印单条记录
 * @param id
 */
function printEntity(id) {
    debugger;
    var tempModelName;
    if (modelName == "ygd"||modelName=="pgd") {
        tempModelName = store.data.items[position(id, store.data.keys)].data.modelName.toLowerCase();
    } else {
        tempModelName = modelName;
    }
    var base = location.href.substring(0, location.href.lastIndexOf('/'));
    var dataUrl = getJsessionidUrl(base + '/check!print.action?modelName=' + tempModelName) + '&id=' + id;
    var printUrl;
    var printType= window.localStorage.printType;
    var localPath=window.localStorage.localPath;
    if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
    if(printType==null||printType=="Local"){

        if(fileExist(localPath+tempModelName+"-info.fr3")){
            printUrl = localPath+tempModelName+"-info.fr3";
        }else{
            return alert("请检查本地模版"+tempModelName+"-info.fr3是否存在");
        }
    }else{
        printUrl = getJsessionidUrl(base + '/check!fr3.action?modelName=' + tempModelName + '&printType=info');
    }
//    var printUrl = getJsessionidUrl(base + '/generic!fr3.action?modelName=' + tempModelName + '&printType=info');
//    Ext.Ajax.request({
//        url:'generic!cacheIds.action',
//        params:{modelName:modelName,ids:id},
//        success:function (r) {
//            debugger;
//            var key = Ext.decode(r.responseText);
    location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
//        }
//    });

}

function editEntity(id) {
    if (id) {
        showEntity(id);
    } else {
        var ids = getSelectIds();
        if (ids.length > 1 || ids.length == 0) {
            alert('请选择某一项!');
        }
        else {
            showEntity(ids.pop());
        }
    }
}

function delEntity(id) {
    var ids;
    var tempModelName;
    if (id) {
        ids = id;
    } else {
        ids = getSelectIds();
    }
    if (modelName == "ygd"||modelName=="pgd") {
        if (ids.length != 1) {
            return alert("请选择一个项目！")
        }
        tempModelName = store.data.items[position(ids, store.data.keys)].data.modelName.toLowerCase();
    } else {
        tempModelName = modelName;
    }
    if (ids.length == 0) alert('请先选择项目！');
    else if (confirm('确定要删除选中项？')) {
        Ext.Ajax.request({
            url:'check!remove.action',
            params:{modelName:tempModelName, id:ids},
            success:function (r) {
                store.reload();
            }
        });
    }

}

function onGenericComplete(result, msg) {
    win.close();
    if (store) {
//        Ext.MessageBox.alert('成功', '　　' + msg.split(";")[0] + '　　');
        store.reload();
        reloadGeneric(msg.split(";")[1]);
    } else {
        showError("保存失败", msg);
    }

}

function reloadGeneric(id) {
    editEntity(id);
}

function getSelectIds(itemId, id) {
    if (id)
        return [id];
    var ids = [];
    var ct = itemId ? '#d' + itemId : "#entityCt";
    $(ct + ' [type="checkbox"]').each(function () {
        if ($(this).attr("checked")) {
            if (this.value != "on")
                ids.push(this.value);
        }
    });
    return ids;
}

var _order = 'ASC';

function sortByField(field) {
    store.singleSort(field, _order);
    _order = _order == 'ASC' ? 'DESC' : 'ASC';
    return false;
}

function getDataViewXTpl(context) {
    try {
        var el = document.createElement('div');
        el.innerHTML = context;
        var xTpl = Ext.XTemplate.from(el.children[0]);
        var fields = el.children[1].value.split(',');
        renderModelList(xTpl, fields);
        showAdvSearchContext(el.children[2]);
    } catch (err) {
        showError("模板有误", err);
    }
}

function showAdvSearchContext(e) {
    clearDivHolder('advancedSearchTpl');
    clearDivHolder('search-item-box');
    document.getElementById('advancedSearchTpl').appendChild(e);
    document.getElementById('advSearch').style.visibility = 'visible';
}

/**
 *
 * @param modelName
 * @param opera
 */
function getTplByModel(modelName, tplName) {
    if (modelName == null || tplName == null) return;
    if (modelName == 'Object') {
        alert('请先选择左侧某一分类');
        return;
    }
    Ext.Ajax.request({
        url:'check!tpl.action',
        params:{'modelName':modelName, 'tplName':tplName},
        success:function (res, opt) {
            parseTpl(opt.params.modelName, opt.params.tplName, res.responseText);
        },
        failure:function (res, opt) {
            showError(res);
        }
    });

}

/**
 *
 * @param modelName
 * @param tplName
 * @param content
 */
function parseTpl(modelName, tplName, content) {
    if (content == null || content.length == 0) {
        showError('模板异常', '模型【' + modelName + '】未定义或模板未定义,请查看后台日志记录');
        return;
    }
    switch (tplName) {
        case 'list':
            //
            getDataViewXTpl(content);
            break;
        case 'edit':
            //
            break;
    }

}

/**
 *
 * @param title
 * @param msg
 */
function showError(title, msg) {
    Ext.Msg.alert(title == null ? '异常' : title, msg);
}

function renderModelList(xtpl, fields) {
    debugger;
    if (modelName == "ygd" || modelName == "pgd")
        fields.push("modelName");
    if (modelName == "ythsw" || modelName == "ythfw" || modelName == "ythnw")
        fields.push("hasOriginal");
    store = new Ext.data.JsonStore({
        url:'check!list.action',
        root:'items',
        totalProperty:'totalCount',
        fields:fields,
        autoLoad:true,
        baseParams:isWdyth ? {'status':'wgd'} : "",
        listeners:{
            beforeload:function (r, s, p) {
                store.baseParams = store.baseParams || {};
                store.baseParams['limit'] = ${limit};
                store.baseParams['treeId'] = treeId;
                store.baseParams['modelName'] = modelName;
                store.baseParams['itemId']='${itemId}';
            },
            load:function (s, r, o) {
                debugger;
//                store.singleSort('id','asc');
                if (preFields != fields) {
//                    if(modelName == "ygd"){
//                        store.sort("sbjh","ASC");
//                        store.sort("flh","ASC");
//                        store.sort("qzh","ASC");
//                        store.sort("nd","ASC");
//                        store.sort("bgqx","ASC");
//                    }
                    changeType = true;
                    preFields = fields;
                } else {
                    changeType = false;
                }
                updateContent(xtpl);
            }
        }
    });
}

/**
 * 根据获取到对应model的模板更新显示内容
 * @param xtpl
 */
function updateContent(xtpl) {

    if (changeType) {

        dataView = new Ext.DataView({
            store:store,
            tpl:xtpl,
            autoDestroy:true,
            autoHeight:true,
            overClass:'x-view-over',
            itemSelector:'tr.a-item',
            emptyText:'',
            applyTo:'entityCt'
        });

        clearDivHolder('pagingToolbar');
        pageToolBar = new Ext.PagingToolbar({
            plugins:new Ext.ux.ComboPageSize({ addToItem:false, prefixText:'每页', postfixText:'条'}),
            renderTo:'pagingToolbar',
            autoDestroy:true,
            pageSize: ${limit},
            store:store,
            displayInfo:true,
            displayMsg:'{0} - {1} 共 {2} 条',
            emptyMsg:"没有记录返回"
        });

        clearDivHolder('searchBox');
        searchField = new Ext.ux.form.SearchField({
            store:store,
            width:150,
            renderTo:'searchBox'
        });

        hideAdvancedSearch();
    }

}

function clearDivHolder(id) {
    var el = document.getElementById(id);
    var nodes = el.childNodes;
    for (var i = nodes.length - 1; i >= 0; i--) {
        el.removeChild(nodes[i]);
    }
}

function onResize(w, h) {
    if (win != null) {
        win.setWidth(w + 40);
        win.setHeight(h + 90);
        win.center();
    }
}


function showGBD(id) {
    if (id != null && (modelName.toLowerCase() == "ythsw")) {
        return false;
    } else if (id != null && (modelName == "ygd"||modelName=="pgd")) {
        if (store.data.items[position(id, store.data.keys)].data.modelName.toLowerCase() == "ythsw")
            return false;
    }
    return true;
}

function showOriginalBtn(id) {
    if (id != null && (modelName.toLowerCase() == "ythsw" || modelName.toLowerCase() == "ythfw"
            || modelName.toLowerCase() == "ythnw" || modelName.toLowerCase() == "wsda"||modelName.toLowerCase() == "ygd"||modelName=="pgd")) {
        return false;
    }
    return true;
}

function printGBD(id) {
    var tempModelName;
    if (modelName == "ygd"||modelName=="pgd") {
        tempModelName = store.data.items[position(id, store.data.keys)].data.modelName.toLowerCase();
    } else {
        tempModelName = modelName;
    }
    var ids = [];
    ids.push(id);
    var base = location.href.substring(0, location.href.lastIndexOf('/'));
    var dataUrl = getJsessionidUrl(base + '/check!print.action?modelName=' + tempModelName) + '&id=' + ids;
    var printUrl;
    var printType= window.localStorage.printType;
    var localPath=window.localStorage.localPath;
    if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
    if(printType==null||printType=="Local"){

        if(fileExist(localPath+tempModelName+"-jbd.fr3")){
            printUrl = localPath+tempModelName+"-jbd.fr3";
        }else{
            return alert("请检查本地模版"+tempModelName+"-jbd.fr3是否存在");
        }
    }else{
        printUrl = getJsessionidUrl(base + '/check!fr3.action?modelName=' + tempModelName + '&printType=jbd');
    }
//    var printUrl = getJsessionidUrl(base + '/generic!fr3.action?modelName=' + tempModelName + '&printType=jbd');
    location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
}

/**
 * 验证本地文件是否存在
 */
function fileExist(filePath){
    var fso =new ActiveXObject("Scripting.FileSystemObject");
    if (fso.FileExists(filePath))
        return true;
    return false;
}


function cxgd() {
    var ids = getSelectIds();
    if (ids.length != 1)
        return alert("请选择一个项目");
    var modelName = store.data.items[position(ids, store.data.keys)].data.modelName.toLowerCase();
    Ext.Ajax.request({
        url:'check!modify.action',
        params:{id:ids, modelName:modelName, status:"wgd"},
        success:function (resp) {
            store.reload();
        }
    });

}

function position(value, array) {
    for (var i in array) {
        if (array[i] == value) {
            return i;
            break;
        }
    }
}

//get treeId by name
function getTreeId(tree, name) {
    var nodes = tree.root.childNodes;
    var wdyth;
    for (var i = 0; i < nodes.length; i++) {
        if (nodes[i].attributes["name"] == "文档一体化") {
            wdyth = nodes[i].childNodes;
            break;
        }
    }
    if (wdyth != null) {
        for (var j = 0; j < wdyth.length; j++) {
            if (wdyth[j].attributes["name"].toLowerCase() == name) {
                return wdyth[j].id;
            }
        }
    }
    return null;
}


var ogDs, linkWin;
/**
 * 原文管理
 */
function showOriginal(archiveId) {
    var id;
    if (archiveId == null) {
        var ids = getSelectIds();
        if (ids.length != 1)
            return alert("请选择一个档案!");
        id = ids[0];
    } else {
        id = archiveId;
    }
    ogDs = new Ext.data.JsonStore({
        url:'og!list.action?ownerId=' + id,
        autoLoad:true,
        totalProperty:'totalCount',
        root:'items',
        fields:[
            'id', 'name', 'fileSize', 'updateTime'
        ]
    });
    var ogSm = new Ext.grid.CheckboxSelectionModel();
    var formatSize = function (size, p, record) {
        return Ext.util.Format.fileSize(size);
    };
    var ogGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds:ogDs,
        height:250,
        sm:ogSm,
        loadMask:true,
        stripeRows:true,
        region:'center',
        bbar:new Ext.PagingToolbar({
            pageSize:20, //每页显示几条数据
            store:ogDs,
            displayInfo:true,
            displayMsg:'{0} - {1} 共 {2} 条',
            emptyMsg:"没有记录返回" }),
        cm:new Ext.grid.ColumnModel([
            //new Ext.grid.RowNumberer(),//显示行号
            ogSm,
            {header:"名称", width:400, sortable:true, dataIndex:'name'},
            {header:"大小", width:100, sortable:true, dataIndex:'fileSize', renderer:formatSize},
            {header:"上传时间", width:150, sortable:true, dataIndex:'updateTime'}
        ]),
        tbar:[
            {
                text:'查看',
                iconCls:'preview',
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    }
                    var nids = [];
                    for (var i = 0; i < ogSm.getSelections().length; i++) {
                        nids.push(ogSm.getSelections()[i].data.id);
                    }
                    showPreview(nids);
                }
            },
            {
                text:'上传',
                iconCls:'upload',
                hidden:true,
                handler:function () {
                    var getUrl = function (url) {
                        return getJsessionidUrl(url + '?modelName=' + modelName);
                    };
                    var uploadDialog = new UploadDialog({
                        getUrl:getUrl,
                        maxSize:5368709120,
                        typeDescription:'所有文件',
                        autoClose:this.autoClose || true,
                        fileTypes:'*.*'
                    });
                    uploadDialog.on('close', function () {
                        ogDs.reload();
                    });
                    uploadDialog.show(id);
                }
            },
            {
                text:'关联',
                iconCls:'reset',
                hidden:true,
                handler:function () {
                    if (linkWin != null) {
                        linkWin.show();
                    }
                    else
                        showLinkWin(id);
                }
            },
            {
                text:'打印',
                iconCls:'print',
                hidden:false,
                handler:function () {
                    var ssl = ogSm.getSelections().length;
                    if (ssl == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    } else if (ssl > 1) {
                        Ext.MessageBox.alert('提示', '　　只能选择一个原文!　　');
                        return;
                    }
                    showPrint(ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:'下载',
                iconCls:'download',
                hidden:true,
                handler:function () {
                    var ssl = ogSm.getSelections().length;
                    if (ssl == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    } else if (ssl > 1) {
                        Ext.MessageBox.alert('提示', '　　只能选择一个原文!　　');
                        return;
                    }
                    window.open('og!get.action?preview=false&id=' + ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:'删除',
                iconCls:'delete',
                hidden:true,
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        alert('　　没有原文被选择!　　');
                        return;
                    }
                    if (!confirm('确定要删除吗？'))
                        return;
                    var p = [];
                    Ext.each(ogSm.getSelections(), function (s) {
                        p.push(s.data.id);
                    });
                    Ext.Ajax.request({
                        url:'og!remove.action',
                        params:{id:p},
                        success:function (r) {
                            ogDs.reload();
                        }
                    });
                }
            },
            '->',
            new Ext.ux.form.SearchField({
                id:'searchBox1',
                style:{'margin':'0,0,0,150px'},
                store:ogDs,
                width:150,
                renderTo:'searchBox'
            })
        ],
        listeners:{
            rowdblclick:function (g, index, e) {
                var id = ogDs.getAt(index).id;
                showPreview([id]);
            },
            render:function (g) {
                var store = g.getStore();
                var view = g.getView();
                g.tip = new Archive.OgTip({
                    dismissDelay:0,
                    target:view.mainBody,
                    delegate:'.x-grid3-row',
                    autoWidth:!Ext.isIE6,
                    renderTo:document.body,
                    listeners:{
                        beforeshow:function (tip) {
                            var rowIndex = view.findRowIndex(tip.triggerElement);
                            tip.body.update('<img src="' + 'og!thumb.action?modelName=' + modelName + '&id=' + store.getAt(rowIndex).id + '"/>');
                        }
                    }
                });
            }
        }
    });
    var ogWin = new Ext.Window({
        title:'原文',
        closable:true,
        modal:true,
        width:700,
        height:500,
        layout:'fit',
        border:false,
        resizable:false,
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    ogWin.close();
                }
            }
        ],
        items:ogGrid
    });
    ogWin.show();
    return false;
}


function showPreview(nids) {
    if (!Ext.isDefined(window.hasEPreOcx)) {
        try {
            new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
            window.hasEPreOcx = true;
        } catch (e) {
            window.hasEPreOcx = false;
        }
    }
    if (window.hasEPreOcx) {
        var base = location.href.substring(0, location.href.lastIndexOf('/'));
        var link = getJsessionidUrl(base + '/og!preview.action?idsKey=');
        link = link.substr(link.indexOf('//') + 2);
        Ext.Ajax.request({
            url:'archive!cacheIds.action',
            params:{id:nids},
            success:function (r) {
                var json = Ext.decode(r.responseText);
                location.href = 'epre://' + link + json['idsKey'];
            }
        });
    } else {
        window.open('og!get.action?preview=true&id=' + nids[0]);
    }
}


function showPrint(id) {
    var width = 0, height = 0, srcWidth, srcHeight;
    var win = new Ext.Window({
        cls:'og',
        title:'打印原文',
        closable:true,
        modal:true,
        width:Ext.lib.Dom.getViewWidth() * .9,
        height:Ext.lib.Dom.getViewHeight() * .9,
        border:false,
        resizable:false,
        tbar:[
            {
                text:'打印',
                iconCls:'print',
                handler:function () {
                    var print = Ext.getDom('printFrame').contentWindow.webPrint;
                    var link = location.href;
                    print.ContentURL = getJsessionidUrl(link.substring(0, link.lastIndexOf('/')) + '/og!print.action?id=' + id + (width > 0 ? '&width=' + width : '') + (height ? '&height=' + height : ''));
                    print.marginBottom = print.marginLeft = print.marginRight = print.marginTop = 0;
                    print.Preview();
                }
            },
            {
                text:'放大',
                iconCls:'zoom-out',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 1.2;
                    img.height = height = height * 1.2;
                }
            },
            {
                text:'缩小',
                iconCls:'zoom-in',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 0.8;
                    img.height = height = height * 0.8;
                }
            },
            {
                text:'默认大小',
                iconCls:'reset',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    img.width = width = srcWidth;
                    img.height = height = srcHeight;
                }
            }
        ],
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="auto" frameborder="0" style="width:100%;height:100%;" src="og!print.action?id=' + id + '" id="printFrame"></iframe>'
    });
    win.show();
    return false;
}


function showLinkWin(id) {
    var tree = new Ext.tree.TreePanel({
        autoScroll:true,
        loader:new Ext.tree.TreeLoader(),
        root:new Ext.tree.AsyncTreeNode({
            id:"root",
            text:'/',
            iconCls:'root'
        }),
        listeners:{
            render:function (tree) {
                tree.getRootNode().expand(false, false);
            },
            beforeload:function (node) {
                this.loader.dataUrl = 'og!link.action?id=' + encodeURIComponent(node.id)
            }
        }
    });
    tree.on('checkchange', function (node, flag) {
        node.cascade(function (node) {
            node.attributes.checked = flag;
            node.ui.checkbox.checked = flag;
            return true;
        });
    });
    linkWin = new Ext.Window({
        title:'文件关联目录树',
        closable:true,
        modal:true,
        width:600,
        height:450,
        layout:'fit',
        border:false,
        resizable:false,
        closeAction:'hide',
        items:tree,
        buttons:[
            {
                text:'关联',
                handler:function () {
                    var ids = [];
                    var nodes = tree.getChecked();
                    for (var i = 0; i < nodes.length; i++) {
                        ids.push(nodes[i].id);
                    }
                    Ext.Ajax.request({
                        url:'og!saveLink.action?ownerId=' + id,
                        params:{id:ids},
                        success:function (r) {
                            Ext.MessageBox.alert("提示", "关联成功");
                            linkWin.hide();
                            for (var i = 0; i < nodes.length; i++) {
                                nodes[i].getUI().toggleCheck(false);
                                nodes[i].attributes.checked = false;
                            }
                            ogDs.load();
                        }
                    });
                }
            },
            {
                text:'关闭',
                handler:function () {
                    linkWin.hide();
                    ogDs.load();
                }
            }
        ]
    });
    linkWin.show();
}

function setPermission(id) {
    var pDs = new Ext.data.JsonStore({
        url:'og!listPermission.action?id=' + id,
        autoLoad:true,
        root:'items',
        fields:['id', 'userId', 'userName', 'operation', 'expireTime']
    });
    var pSm = new Ext.grid.CheckboxSelectionModel();
    var pGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds:pDs,
        height:250,
        sm:pSm,
        loadMask:true,
        stripeRows:true,
        region:'center',
        cm:new Ext.grid.ColumnModel([
            pSm,
            {header:"用户", width:100, sortable:true, dataIndex:'userName'},
            {header:"权限", width:200, sortable:true, dataIndex:'operation', renderer:function (v) {
                return v == 'download' ? '下载' : '查看';
            }},
            {header:"到期时间", width:200, sortable:true, dataIndex:'expireTime'}
        ]),
        tbar:[
            {
                iconCls:'add',
                text:'添加',
                handler:function () {
                    var fp = new Ext.FormPanel({
                        labelWidth:80,
                        url:'og!addPermission.action?op.originalId=' + id,
                        frame:true,
                        border:false,
                        bodyStyle:'padding:5px',
                        defaultType:'textfield',
                        items:[
                            {
                                xtype:'combo',
                                fieldLabel:'用户',
                                hiddenName:'op.userId',
                                store:new Ext.data.JsonStore({
                                    url:'og!listUsers.action',
                                    fields:['userId', 'userName']
                                }),
                                minChars:1,
                                valueField:'userId',
                                displayField:'userName',
                                mode:'remote',
                                typeAhead:false,
                                triggerAction:'all',
                                loadingText:'获取中...',
                                anchor:'100%',
                                listeners:{
                                    'select':function (cb, record) {
                                        fp.form.findField('op.userName').setValue(record.data['userName']);
                                    }
                                }
                            },
                            {
                                xtype:'combo',
                                fieldLabel:'权限',
                                hiddenName:'op.operation',
                                store:new Ext.data.ArrayStore({
                                    fields:['name', 'value'],
                                    data:[
                                        ["查看", 'view'],
                                        ['下载', 'download']
                                    ]
                                }),
                                value:'download',
                                valueField:'value',
                                displayField:'name',
                                typeAhead:true,
                                mode:'local',
                                triggerAction:'all',
                                anchor:'100%'
                            },
                            {
                                fieldLabel:'到期时间',
                                xtype:'datefield',
                                name:'op.expireTime',
                                anchor:'100%',
                                format:'Y-m-d'
                            },
                            {
                                xtype:'hidden',
                                name:'op.userName'
                            }
                        ],
                        buttons:[
                            {
                                text:'保存',
                                handler:function () {
                                    if (fp.getForm().isValid()) {
                                        fp.getForm().submit({
                                            waitMsg:'正在保存...',
                                            success:function () {
                                                addWin.close();
                                                pDs.reload();
                                            },
                                            failure:function (fp, action) {
                                                Ext.MessageBox.alert('失败', '保存失败');
                                            },
                                            scope:this
                                        });
                                    }
                                },
                                scope:this
                            },
                            {
                                text:'关闭',
                                handler:function () {
                                    addWin.close();
                                }
                            }
                        ]
                    });
                    var addWin = new Ext.Window({
                        title:'原文权限',
                        closable:true,
                        modal:true,
                        width:300,
                        height:200,
                        layout:'fit',
                        border:false,
                        resizable:false,
                        items:fp
                    });
                    addWin.show();
                }
            },
            {
                iconCls:'delete',
                text:'删除',
                handler:function () {
                    if (pSm.getSelections().length == 0) {
                        alert('　　没有权限被选择!　　');
                        return;
                    }
                    if (!confirm('确定要删除吗？'))
                        return;
                    var p = [];
                    Ext.each(pSm.getSelections(), function (s) {
                        p.push(s.data.id);
                    });
                    Ext.Ajax.request({
                        url:'og!removePermission.action',
                        params:{id:p},
                        success:function (r) {
                            pDs.reload();
                        }
                    });
                }
            }
        ]
    });
    var pWin = new Ext.Window({
        title:'原文权限',
        closable:true,
        modal:true,
        width:600,
        height:400,
        layout:'fit',
        border:false,
        resizable:false,
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    pWin.close();
                }
            }
        ],
        items:pGrid
    });
    pWin.show();
}


/**
 * 已归档的打印，只支持单条打印
 * @return {*}
 */
function printYGD() {
    debugger;
    var ids = getSelectIds();
    if (ids.length != 1) return alert("请选择一个档案");
    var id = ids[0];
    printEntity(id);
}


function printArchive() {
    debugger;
    Ext.MessageBox.show({
        title:'打印选择',
        msg:'案卷列表打印选择,选择是打印当前页,否所有案卷',
        buttons:Ext.MessageBox.YESNOCANCEL,
        fn:function (btn) {
            var param = Ext.apply({}, store.lastOptions.params || store.baseParams);
            if (btn == 'no') {
                Ext.apply(param, {limit:-1});
            } else if (btn == 'cancel') {
                return;
            }
            var base = location.href.substring(0, location.href.lastIndexOf('/'));
            var dataUrl;
            if (param.status == null) {
                dataUrl = getJsessionidUrl(base + '/check!print.action?modelName=' + modelName + '&limit=' + param.limit + '&start=' + (param.start == null ? 0 : param.start)) + '&idsKey=';
            } else {
                dataUrl = getJsessionidUrl(base + '/check!print.action?modelName=' + modelName + '&limit=' + param.limit + '&start=' + (param.start == null ? 0 : param.start) + '&status=' + param.status) + '&idsKey=';
            }
            var printUrl;
            var printType= window.localStorage.printType;
            var localPath=window.localStorage.localPath;
            if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
            if(printType==null||printType=="Local"){

                if(fileExist(localPath+modelName+".fr3")){
                    printUrl =localPath+modelName+".fr3";
                }else{
                    return alert("请检查本地模版"+modelName+".fr3是否存在");
                }
            }else{
                printUrl = getJsessionidUrl(base + '/check!fr3.action?modelName=' + modelName);
            }

//            var printUrl = getJsessionidUrl(base + '/generic!fr3.action?modelName=' + modelName);
//        Ext.Ajax.request({
//            url:'generic!cacheIds.action',
//            params:{condition:param.condition,limit:param.limit,modelName:modelName,treeId:param.treeId},
//            success:function (r) {
//                var key = Ext.decode(r.responseText);
//                location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl+key['idsKey'];
//            }
//        });

            debugger;
            if (param.limit == -1) {
                Ext.Ajax.request({
                    url:'check!searchIds.action',
                    params:{status:param.status,condition:param.condition, limit:param.limit, start:(param.start==null?0:param.start), modelName:modelName, treeId:param.treeId, type:param.type},
                    success:function (r) {
                        var key = Ext.decode(r.responseText);
                        location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl + key['idsKey'];
                    }
                });
            } else {
                Ext.Ajax.request({
                    url:'check!cacheIds.action',
                    params:{modelName:modelName, treeId:param.treeId, type:param.type, id:getListIds()},
                    success:function (r) {
                        debugger;
                        var key = Ext.decode(r.responseText);
                        location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl + key['idsKey'];
                    }
                });
            }


        },
        icon:Ext.MessageBox.QUESTION
    });
//           alert(modelName);
}


function printCover() {
    var ids = getSelectIds();
    if (ids.length < 1)
        return alert("至少选择一个项目!");

    var base = location.href.substring(0, location.href.lastIndexOf('/'));
//    var printUrl = getJsessionidUrl(base + '/generic!fr3.action?printType=cover&modelName=' + modelName);
    var dataUrl = getJsessionidUrl(base + '/check!print.action?modelName=' + modelName) + '&idsKey=';
    var printUrl;
    var printType= window.localStorage.printType;
    var localPath=window.localStorage.localPath;
    if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
    if(printType==null||printType=="Local"){

        if(fileExist(localPath+modelName+"-cover.fr3")){
            printUrl =localPath+modelName+"-cover.fr3";
        }else{
            return alert("请检查本地模版"+modelName+"-cover.fr3是否存在");
        }
    }else{
        printUrl = getJsessionidUrl(base + '/check!fr3.action?printType=cover&modelName=' + modelName);
    }
    Ext.Ajax.request({
        url:'check!cacheIds.action',
        params:{id:ids},
        success:function (r) {
            var key = Ext.decode(r.responseText);
            location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl + key['idsKey'];
        }
    });
}


function exportExcel() {
    Ext.MessageBox.show({
        title:'导出excel',
        msg:'excel导出,选择是导出当前页,否导出所有案卷',
        buttons:Ext.MessageBox.YESNOCANCEL,
        fn:function (btn) {
            var param = Ext.apply({}, store.lastOptions.params || store.baseParams);
            if (btn == 'no') {
                Ext.apply(param, {limit:-1});
            } else if (btn == 'cancel') {
                return;
            }
            location.href = 'check!export.action?' + Ext.urlEncode(param);
        },
        icon:Ext.MessageBox.QUESTION
    });
}


$(function () {
    if (json.length) {
        tree = new Ext.tree.TreePanel({
            animate:true,
            autoScroll:true,
            containerScroll:true,
            useArrows:true,
            width:160,
            renderTo:'treeBox',
            root:new Ext.tree.AsyncTreeNode({
                id:'rootNode',
                text:'未分类',
                iconCls:'root',
                children:json
            }),
            listeners:{
                click:function (n) {
                    debugger;
                    if (n.id == 'rootNode') {
                        treeId = '${treeId}';
                    } else {
                        treeId = n.id;
                    }
                    if (n.childNodes.length > 0) return;
                    modelName = n.attributes.name;
                    if (n.attributes.content == 'wdyth' && modelName != "ygd" && modelName != "pgd") {
                        $("#wdythDiv").css('display', 'block');
                        $("#gdDiv").css('display', 'block');
                        $("#ygdBtn").hide();
                        $("#ytgdBtn").hide();
                        $("#ytygdBtn").hide();
                        $("#cxygdBtn").hide();
                        $("#xgdBtn").show();
                        $("#bgdBtn").show();
                        $("#jydj").hide();
                        $("#jyc").hide();
                        $allStatusItemList.removeClass('active');
                        $("#wgdItem").addClass('active');
                        isWdyth = true;
                    } else {
                        $("#wdythDiv").css('display', 'none');
                        $("#gdDiv").css('display', 'none');
                        isWdyth = false;
                    }
                    if (modelName == "ygd" || modelName == "pgd") {
                        $("#editDiv").css('display', 'none');
                        $("#cxGdDiv").css('display', 'block');
                    } else {
                        $("#editDiv").css('display', 'block');
                        $("#cxGdDiv").css('display', 'none');
                    }
                    if(modelName=="pgd"){
                        $("#loanNote").hide();
                        $("#loanCart").hide();
                    }else if(modelName=="ygd"){
                        $("#loanNote").show();
                        $("#loanCart").show();
                    }
                    getTplByModel(modelName, 'list');
                }
            }
        });
        tree.getRootNode().expand(false, false);
        tree.getRootNode().select();
    } else {
        $('#treeBox-ct').hide();
    }

    $allStatusItemList.click(function (e) {
        $el = $(this);
        var item= $el.attr('name');
        if (store) {
            store.setBaseParam("status", $el.attr('name'));
            store.load();
        }
        $allStatusItemList.removeClass('active');
        $el.addClass('active');
        if(item=="wgd"){
            $("#ygdBtn").hide();
            $("#ytgdBtn").hide();
            $("#ytygdBtn").hide();
            $("#cxygdBtn").hide();
            $("#xgdBtn").show();
            $("#bgdBtn").show();
            $("#jydj").hide();
            $("#jyc").hide();
        }else if(item=="xgd"){
            $("#ygdBtn").hide();
            $("#ytgdBtn").hide();
            $("#ytygdBtn").show();
            $("#cxygdBtn").hide();
            $("#xgdBtn").hide();
            $("#bgdBtn").hide();
            $("#jydj").hide();
            $("#jyc").hide();
        }else if(item=="bgd"){
            $("#ygdBtn").hide();
            $("#ytgdBtn").hide();
            $("#ytygdBtn").hide();
            $("#cxygdBtn").hide();
            $("#xgdBtn").hide();
            $("#bgdBtn").hide();
            $("#jydj").hide();
            $("#jyc").hide();
        }else if(item=="pgd"){
            $("#ygdBtn").hide();
            $("#ytgdBtn").show();
            $("#ytygdBtn").hide();
            $("#cxygdBtn").show();
            $("#xgdBtn").hide();
            $("#bgdBtn").hide();
            $("#jydj").hide();
            $("#jyc").hide();
        }else if(item == "ygd"){
            $("#ygdBtn").hide();
            $("#ytgdBtn").hide();
            $("#ytygdBtn").hide();
            $("#cxygdBtn").hide();
            $("#xgdBtn").hide();
            $("#bgdBtn").hide();
            $("#jydj").show();
            $("#jyc").show();
        }

    });

});
</script>
</@layout.main>
