package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;<#if !model.parentName??>
import org.hibernate.annotations.GenericGenerator;</#if>

import javax.persistence.*;
import java.util.Date;

/**
 * <p>
 * ${model.title!}<#if model.remarker??>
 * ${model.remarker!}</#if>
 * Generated ${now?datetime} by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t<#if model.parentName??>_${model.parentName?lower_case}</#if>_${model.name?lower_case}")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ${model.name?cap_first}<#if model.parentName??> extends ${model.parentName?cap_first}</#if> {
    public static final String MODEL_NAME = ${model.name?cap_first}.class.getSimpleName();
    public static final String ENTITY_NAME = "${model.title!}";
<#if model.fields??>
    <#list model.fields as field>
    public static final String FIELD_${field.name?upper_case} = "${field.title}";
    </#list>
</#if>

<#if !model.parentName??>
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    private String modelName = getClass().getSimpleName();
</#if>
<#if model.fields??>
    <#list model.fields as field>
        <#if field.type??>
            <#if field.type=='TEXT'>
                <#assign type='String'/>
                <#elseif field.type=='NUMBER' && field.length <= 10 >
                    <#if field.nullable!true><#assign type='Integer'/><#else><#assign type='int'/></#if>
                <#elseif field.type=='NUMBER' && field.length gt 10 >
                    <#if field.nullable!true><#assign type='Long'/><#else><#assign type='long'/></#if>
                <#elseif field.type=='FLOAT'>
                    <#if field.nullable!true><#assign type='Double'/><#else><#assign type='double'/></#if>
                <#elseif field.type=='DATE' || field.type=='DATETIME'>
                    <#assign type='Date'/>
                <#elseif field.type=='BOOLEAN'>
                    <#if field.nullable!true><#assign type='Boolean'/><#else><#assign type='boolean'/></#if>
                <#else>
                    <#assign type='String'/>
            </#if>

    /**
    * ${field.title} ${field.remarker!}
    */<#if field.length?? && type=='String' || field.nullable?? && !field.nullable>
    @Column<#if field.length?? || field.nullable??>(<#if field.length?? && type=='String'>length = ${field.length?c}</#if><#if field.length?? && type=='String' && field.nullable?? && !field.nullable>, </#if><#if field.nullable?? && !field.nullable>nullable = ${field.nullable?string}</#if>)</#if></#if>
    private ${type} ${field.name};
        </#if>
    </#list>

    <#if !model.parentName??>
    public String getId() {
    return id;
    }

    public void setId(String id) {
    this.id = id;
    }

    public void setModelName(String modelName) {
        if (StringUtils.isNotEmpty(modelName))
            this.modelName = modelName;
    }

    public String getModelName(){
        return this.modelName;
    }
    </#if>
    <#list model.fields as field>
        <#if field.type??>
            <#if field.type=='TEXT'>
                <#assign type='String'/>
                <#elseif field.type=='NUMBER' && field.length <= 10 >
                    <#if field.nullable!true><#assign type='Integer'/><#else><#assign type='int'/></#if>
                <#elseif field.type=='NUMBER' && field.length gt 10 >
                    <#if field.nullable!true><#assign type='Long'/><#else><#assign type='long'/></#if>
                <#elseif field.type=='DATE' || field.type=='DATETIME'>
                    <#assign type='Date'/>
                <#elseif field.type=='BOOLEAN'>
                    <#if field.nullable!true><#assign type='Boolean'/><#else><#assign type='boolean'/></#if>
                <#else>
                    <#assign type='String'/>
            </#if>
    public ${type} <#if field.type=='BOOLEAN' && !field.nullable!true>is<#else>get</#if>${field.name?cap_first}() {
    return ${field.name};
    }

    public void set${field.name?cap_first}(${type} ${field.name}) {
    this.${field.name} = ${field.name};
    }
        </#if>
    </#list>
</#if>
}