package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 大事记
 * Generated 2013-11-22 14:38:08 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_dsj")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Dsj {
    static final MODEL_NAME = Dsj.class.getSimpleName();
    static final ENTITY_NAME = "大事记";
    static final FIELD_ND = "年度";
    static final FIELD_SJSJ = "事件时间";
    static final FIELD_SJNR = "事件内容";
    static final FIELD_BZ = "备注";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 年度 
     */
    @Column(length = 100)
    String nd;

    /**
     * 事件时间 
     */
    Date sjsj;

    /**
     * 事件内容 
     */
    @Column(length = 100)
    String sjnr;

    /**
     * 备注 
     */
    @Column(length = 200)
    String bz;
}