package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 档案库房设备情况
 * Generated 2013-11-22 14:38:07 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_dakfsbqk")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Dakfsbqk {
    static final MODEL_NAME = Dakfsbqk.class.getSimpleName();
    static final ENTITY_NAME = "档案库房设备情况";
    static final FIELD_ND = "年度";
    static final FIELD_JGMC = "机构名称";
    static final FIELD_KFMJ = "库房面积a";
    static final FIELD_BGSMJ = "办公室面积（㎡）";
    static final FIELD_YDSMJ = "阅档室面积（㎡）";
    static final FIELD_MJJ = "密集架（列）";
    static final FIELD_WJG = "五节柜（节）";
    static final FIELD_DTG = "底图柜（节）";
    static final FIELD_FYJ = "复印机（台）";
    static final FIELD_STJ = "嗮图机（台）";
    static final FIELD_ZXJ = "照相机（架）";
    static final FIELD_QSJ = "去湿机（台）";
    static final FIELD_KT = "空调（台）";
    static final FIELD_FRJ = "缝纫机（台）";
    static final FIELD_JSJ = "计算机（台）";
    static final FIELD_SMY = "扫描仪（台）";
    static final FIELD_LXJ = "录像机（台）";
    static final FIELD_SLJ = "收录机（台）";
    static final FIELD_DSJ = "电视机（台）";
    static final FIELD_XCQ = "吸尘器（台）";
    static final FIELD_GPKLJ = "光盘刻录机（台）";
    static final FIELD_WSDJ = "温湿度计（只）";
    static final FIELD_DWDM = "单位代码";
    static final FIELD_BZ = "备注";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 年度 
     */
    @Column(length = 100)
    String nd;

    /**
     * 机构名称 
     */
    @Column(length = 100)
    String jgmc;

    /**
     * 库房面积a 
     */
    @Column(length = 100)
    String kfmj;

    /**
     * 办公室面积（㎡） 
     */
    @Column(length = 100)
    String bgsmj;

    /**
     * 阅档室面积（㎡） 
     */
    @Column(length = 100)
    String ydsmj;

    /**
     * 密集架（列） 
     */
    @Column(length = 100)
    String mjj;

    /**
     * 五节柜（节） 
     */
    @Column(length = 100)
    String wjg;

    /**
     * 底图柜（节） 
     */
    @Column(length = 100)
    String dtg;

    /**
     * 复印机（台） 
     */
    @Column(length = 100)
    String fyj;

    /**
     * 嗮图机（台） 
     */
    @Column(length = 100)
    String stj;

    /**
     * 照相机（架） 
     */
    @Column(length = 100)
    String zxj;

    /**
     * 去湿机（台） 
     */
    @Column(length = 100)
    String qsj;

    /**
     * 空调（台） 
     */
    @Column(length = 100)
    String kt;

    /**
     * 缝纫机（台） 
     */
    @Column(length = 100)
    String frj;

    /**
     * 计算机（台） 
     */
    @Column(length = 100)
    String jsj;

    /**
     * 扫描仪（台） 
     */
    @Column(length = 100)
    String smy;

    /**
     * 录像机（台） 
     */
    @Column(length = 100)
    String lxj;

    /**
     * 收录机（台） 
     */
    @Column(length = 100)
    String slj;

    /**
     * 电视机（台） 
     */
    @Column(length = 100)
    String dsj;

    /**
     * 吸尘器（台） 
     */
    @Column(length = 100)
    String xcq;

    /**
     * 光盘刻录机（台） 
     */
    @Column(length = 100)
    String gpklj;

    /**
     * 温湿度计（只） 
     */
    @Column(length = 100)
    String wsdj;

    /**
     * 单位代码 
     */
    @Column(length = 100)
    String dwdm;

    /**
     * 备注 
     */
    @Column(length = 1000)
    String bz;
}