package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 档案机构信息
 * Generated 2013-11-22 14:38:07 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_dajgxx")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Dajgxx {
    static final MODEL_NAME = Dajgxx.class.getSimpleName();
    static final ENTITY_NAME = "档案机构信息";
    static final FIELD_ND = "年度";
    static final FIELD_QZH = "全宗号";
    static final FIELD_MC = "名称";
    static final FIELD_LSGX = "隶属关系";
    static final FIELD_FGLD = "分管领导";
    static final FIELD_FZR = "负责人";
    static final FIELD_XSGLBM = "下属管理部门";
    static final FIELD_BZ = "备注";
    static final FIELD_DWDM = "单位代码";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 年度 
     */
    @Column(length = 100)
    String nd;

    /**
     * 全宗号 
     */
    @Column(length = 100)
    String qzh;

    /**
     * 名称 
     */
    @Column(length = 100)
    String mc;

    /**
     * 隶属关系 
     */
    @Column(length = 100)
    String lsgx;

    /**
     * 分管领导 
     */
    @Column(length = 100)
    String fgld;

    /**
     * 负责人 
     */
    @Column(length = 100)
    String fzr;

    /**
     * 下属管理部门 
     */
    @Column(length = 100)
    String xsglbm;

    /**
     * 备注 
     */
    @Column(length = 100)
    String bz;

    /**
     * 单位代码 
     */
    @Column(length = 100)
    String dwdm;
}