package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 各机构档案管理人员
 * Generated 2013-11-22 14:38:08 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_daglry")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Daglry {
    static final MODEL_NAME = Daglry.class.getSimpleName();
    static final ENTITY_NAME = "各机构档案管理人员";
    static final FIELD_JGMC = "机构名称";
    static final FIELD_XH = "序号";
    static final FIELD_XM = "姓名";
    static final FIELD_XB = "性别";
    static final FIELD_CSNY = "出生年月";
    static final FIELD_WHCD = "文化程度";
    static final FIELD_DAZY = "档案专业";
    static final FIELD_ZC = "职称";
    static final FIELD_XZ = "性质";
    static final FIELD_DRSJ = "调入时间";
    static final FIELD_DCSJ = "调出时间";
    static final FIELD_BZ = "备注";
    static final FIELD_DWDM = "单位代码";
    static final FIELD_BM = "部门";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 机构名称 
     */
    @Column(length = 100)
    String jgmc;

    /**
     * 序号 
     */
    @Column(length = 100)
    String xh;

    /**
     * 姓名 
     */
    @Column(length = 100)
    String xm;

    /**
     * 性别 
     */
    @Column(length = 100)
    String xb;

    /**
     * 出生年月 
     */
    @Column(length = 100)
    String csny;

    /**
     * 文化程度 
     */
    @Column(length = 100)
    String whcd;

    /**
     * 档案专业 
     */
    @Column(length = 100)
    String dazy;

    /**
     * 职称 
     */
    @Column(length = 100)
    String zc;

    /**
     * 性质 
     */
    @Column(length = 100)
    String xz;

    /**
     * 调入时间 
     */
    @Column(length = 100)
    String drsj;

    /**
     * 调出时间 
     */
    @Column(length = 100)
    String dcsj;

    /**
     * 备注 
     */
    @Column(length = 100)
    String bz;

    /**
     * 单位代码 
     */
    @Column(length = 100)
    String dwdm;

    /**
     * 部门 
     */
    @Column(length = 100)
    String bm;
}