package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 档案保管
 * Generated 2013-11-22 14:38:11 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_dabg")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Dabg {
    static final MODEL_NAME = Dabg.class.getSimpleName();
    static final ENTITY_NAME = "档案保管";
    static final FIELD_HH = "盒号";
    static final FIELD_SXH = "序号";
    static final FIELD_MC = "名称";
    static final FIELD_XCSJ = "形成时间";
    static final FIELD_YS = "页数";
    static final FIELD_BZ = "备注";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 盒号 
     */
    @Column(length = 100)
    String hh;

    /**
     * 序号 
     */
    @Column(length = 100)
    String sxh;

    /**
     * 名称 
     */
    @Column(length = 100)
    String mc;

    /**
     * 形成时间 
     */
    @Column(length = 100)
    String xcsj;

    /**
     * 页数 
     */
    @Column(length = 100)
    String ys;

    /**
     * 备注 
     */
    @Column(length = 100)
    String bz;
}