package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 备考表
 * Generated 2013-11-22 14:38:11 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_bkb")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Bkb {
    static final MODEL_NAME = Bkb.class.getSimpleName();
    static final ENTITY_NAME = "备考表";
    static final FIELD_DWDM = "单位代码";
    static final FIELD_DH = "档号";
    static final FIELD_ZS = "张数";
    static final FIELD_YS = "页数";
    static final FIELD_QKSM = "情况说明";
    static final FIELD_LJR = "立卷人";
    static final FIELD_LJRQ = "立卷日期";
    static final FIELD_JCR = "检查人";
    static final FIELD_JCRQ = "检查日期";
    static final FIELD_BZ = "备注";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 单位代码 
     */
    @Column(length = 100)
    String dwdm;

    /**
     * 档号 
     */
    @Column(length = 100)
    String dh;

    /**
     * 张数 
     */
    @Column(length = 100)
    String zs;

    /**
     * 页数 
     */
    @Column(length = 100)
    String ys;

    /**
     * 情况说明 
     */
    @Column(length = 1000)
    String qksm;

    /**
     * 立卷人 
     */
    @Column(length = 100)
    String ljr;

    /**
     * 立卷日期 
     */
    @Column(length = 100)
    String ljrq;

    /**
     * 检查人 
     */
    @Column(length = 100)
    String jcr;

    /**
     * 检查日期 
     */
    @Column(length = 100)
    String jcrq;

    /**
     * 备注 
     */
    @Column(length = 1000)
    String bz;
}