package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 借阅车
 * Generated 2013-11-22 14:38:06 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_loancart")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class LoanCart {
    static final MODEL_NAME = LoanCart.class.getSimpleName();
    static final ENTITY_NAME = "借阅车";
    static final FIELD_USERID = "用户";
    static final FIELD_ARCHIVETYPE = "档案类型";
    static final FIELD_ARCHIVEID = "档案主键";
    static final FIELD_INDATE = "借阅日期";
    static final FIELD_BUNIT = "借阅单位";
    static final FIELD_BZ = "备注";
    static final FIELD_MLH = "目录号";
    static final FIELD_AJH = "案卷号";
    static final FIELD_TM = "题名";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 用户 
     */
    @Column(length = 32)
    String userId;

    /**
     * 档案类型 
     */
    @Column(length = 100)
    String archiveType;

    /**
     * 档案主键 
     */
    @Column(length = 100)
    String archiveId;

    /**
     * 借阅日期 
     */
    Date inDate;

    /**
     * 借阅单位 
     */
    @Column(length = 100)
    String bUnit;

    /**
     * 备注 
     */
    @Column(length = 100)
    String bz;

    /**
     * 目录号 
     */
    @Column(length = 100)
    String mlh;

    /**
     * 案卷号 
     */
    @Column(length = 100)
    String ajh;

    /**
     * 题名 
     */
    @Column(length = 100)
    String tm;
}