/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.RecordAjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.RecordAjhRangeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.WrongClassException;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;

public class ArchiveEntityAction
extends BaseEntityAction<Archive> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    private String treeId;
    private AjhRange ajhRange;
    public Integer _ajh;
    public boolean gd;
    private String template;
    private List<String> mlhs;
    private String currentMlh;
    private Integer currentAjh;
    private String mlh;
    private String bgqx;
    private boolean add;
    private String state;
    private boolean isMakeUp;

    public String getState() {
        if (StringUtils.isBlank((String)this.state)) {
            return "";
        }
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setGd(boolean gd) {
        this.gd = gd;
    }

    public AjhRange getAjhRange() {
        return this.ajhRange;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public String getBgqx() {
        return this.bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = bgqx;
    }

    public boolean isAdd() {
        return this.add;
    }

    public void setAdd(boolean add) {
        this.add = add;
    }

    public boolean isMakeUp() {
        return this.isMakeUp;
    }

    public void setMakeUp(boolean makeUp) {
        this.isMakeUp = makeUp;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getCurrentMlh() {
        return ((Archive)this.entity).getMlh();
    }

    public Integer getCurrentAjh() {
        return ((Archive)this.entity).getAjh();
    }

    public void prepare() {
        boolean isCreate = StringUtils.isBlank((String)this.id);
        if (isCreate) {
            String flh;
            this.entity = this.archiveService.newArchive(this.modelName);
            String cid = (String)this.session.get("currentAId");
            Archive lastArchive = null;
            if (cid != null) {
                lastArchive = this.archiveService.getArchive(this.modelName, cid);
            }
            if (lastArchive != null && lastArchive.getModelName().equals(this.modelName)) {
                try {
                    if (!this.add) {
                        PropertyUtils.copyProperties((Object)this.entity, (Object)lastArchive);
                    } else if (EnvHolder.isEnable((String)"jiangyin.enable")) {
                        ((Archive)this.entity).setDwdm(this.getDwdm());
                        ((Archive)this.entity).setQzh(this.getQzh());
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                ((Archive)this.entity).setDh(null);
            } else if (EnvHolder.isEnable((String)"jiangyin.enable")) {
                ((Archive)this.entity).setDwdm(this.getDwdm());
                ((Archive)this.entity).setQzh(this.getQzh());
            }
            ((Archive)this.entity).setId(UUIDHexGenerator.generate());
            if (StringUtils.isNotBlank((String)this.treeId) && StringUtils.isNotBlank((String)(flh = this.resourceService.getResource(this.treeId, new String[0]).getFlh()))) {
                ((Archive)this.entity).setFlh(flh);
            }
        } else {
            this.entity = this.archiveService.getArchive(this.modelName, this.id);
            if (this.entity == null) {
                this.entity = this.archiveService.newArchive(this.modelName);
            }
        }
        if (isCreate && EnvHolder.isEnable((String)"increaseAjh.enable")) {
            this.ajhRange = this.getAvailableAjhRange();
            ((Archive)this.entity).setMlh(this.ajhRange.getMlh());
            if (EnvHolder.isEnable((String)"jiangyin.enable")) {
                RecordAjhRange recordAjhRange;
                String dwdm = this.ajhRange.getDwdm();
                if (StringUtils.isBlank((String)dwdm)) {
                    dwdm = this.getDwdm();
                }
                if ((recordAjhRange = this.recordAjhRangeService.getAvailable(this.ajhRange.getMlh(), this.modelName, dwdm)) != null) {
                    ((Archive)this.entity).setAjh(Integer.valueOf(recordAjhRange.getAjh()));
                } else {
                    ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
                }
            } else {
                ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
            }
            if (EnvHolder.isEnable((String)"jiangyin.enable")) {
                ((Archive)this.entity).setBgqx(this.ajhRange.getBgqx());
            }
        }
    }

    protected void preSave() {
        if (this.ajhRange != null && StringUtils.isNotBlank((String)this.ajhRange.getId()) && ((Archive)this.entity).getAjh() != null && ((Archive)this.entity).getAjh().intValue() == this.ajhRange.getNextValue()) {
            this.ajhRange = this.ajhRangeService.getAjhRange(this.ajhRange.getId());
            this._ajh = this.ajhRange.getNextValue();
            ((Archive)this.entity).setAjh(this._ajh);
        } else {
            Page page;
            ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
            criterions.add(Restrictions.eq((String)"qzh", (Object)((Archive)this.entity).getQzh()));
            criterions.add(Restrictions.eq((String)"mlh", (Object)((Archive)this.entity).getMlh()));
            criterions.add(Restrictions.eq((String)"ajh", (Object)((Archive)this.entity).getAjh()));
            try {
                page = this.archiveService.searchArchive(this.modelName, criterions, null, 0, 1);
            }
            catch (WrongClassException wrongClassException) {
                page = this.archiveService.searchArchive("Archive", criterions, null, 0, 1);
            }
            if (!page.isEmpty() && !((Archive)page.getItem(0)).getId().equals(((Archive)this.entity).getId())) {
                if (!EnvHolder.isEnable((String)"bengbu.enable") && !this.isMakeUp) {
                    throw new RuntimeException("\u6b64\u6848\u5377\u53f7\u5df2\u88ab\u4f7f\u7528");
                }
                if (EnvHolder.isEnable((String)"jintan.enable") && this.isMakeUp) {
                    this.logger.debug("\u6863\u6848\u8865\u5f55\uff0c\u63d2\u5165\u6848\u5377\u53f7");
                    this.makeUpArchive();
                }
            }
        }
        if (StringUtils.isNotBlank((String)this.treeId)) {
            ((Archive)this.entity).setResourceId(this.treeId);
        }
        if (((Archive)this.entity).getAjh() != null && ((Archive)this.entity).getMlh() != null) {
            AjhRange preAjhRange;
            if (this.ajhRange != null) {
                preAjhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName, ((Archive)this.entity).getMlh());
            } else {
                this.ajhRange = preAjhRange = this.ajhRangeService.getAjhRangeAvailable(this.modelName, ((Archive)this.entity).getMlh(), StringUtils.isBlank((String)((Archive)this.entity).getDwdm()) ? this.getDwdm() : ((Archive)this.entity).getDwdm());
            }
            if (preAjhRange != null) {
                if (((Archive)this.entity).getAjh() > preAjhRange.getMaxValue()) {
                    throw new RuntimeException("\u6848\u5377\u53f7\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u6700\u5927\u6848\u5377\u53f7");
                }
                if (((Archive)this.entity).getAjh() < preAjhRange.getMinValue()) {
                    throw new RuntimeException("\u6848\u5377\u53f7\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u6700\u5c0f\u6848\u5377\u53f7");
                }
            }
        }
        if (this.gd) {
            this.ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName);
            if (((Archive)this.entity).getAjh() > this.ajhRange.getNextValue()) {
                throw new RuntimeException("\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u6700\u5927\u6848\u5377\u53f7");
            }
            ((Archive)this.entity).setGdsj(new Date());
            ((Archive)this.entity).setState(1);
        }
        ((Archive)this.entity).setDh(null);
    }

    private void makeUpArchive() {
        try {
            ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
            criterions.add(Restrictions.eq((String)"mlh", (Object)((Archive)this.entity).getMlh()));
            criterions.add(Restrictions.ge((String)"ajh", (Object)((Archive)this.entity).getAjh()));
            ArrayList<Order> orders = new ArrayList<Order>();
            orders.add(Order.asc((String)"ajh"));
            List ajhRanges = this.ajhRangeService.getAjhRangeByModelName(this.modelName);
            for (AjhRange range : ajhRanges) {
                if (!range.getMlh().equalsIgnoreCase(((Archive)this.entity).getMlh())) continue;
                this.ajhRange = range;
                break;
            }
            Page pages = this.archiveService.searchArchive(this.modelName, criterions, orders, 0, this.ajhRange.getMaxValue().intValue());
            for (int i = pages.getTotalCount(); i > 0; --i) {
                Archive archive = (Archive)pages.getItem(i - 1);
                archive.setAjh(Integer.valueOf(archive.getAjh() + 1));
                archive.setDh(null);
                if (archive.getAjh() > this.ajhRange.getMaxValue()) {
                    throw new RuntimeException("\u6863\u6848\u79fb\u52a8\u540e\u5c06\u4f1a\u8d85\u51fa\u76ee\u5f55\u6700\u5927\u5bb9\u91cf\uff0c\u8bf7\u5148\u6269\u5145\u76ee\u5f55\u53f7\u3010{" + archive.getMlh() + "}\u3011\u5bb9\u91cf");
                }
                this.archiveService.saveArchive(archive);
            }
        }
        catch (Exception ex) {
            this.logger.error("\u6863\u6848\u8865\u5f55\u5f02\u5e38\u3010{}\u3011,\u786e\u8ba4\u76ee\u5f55\u53f7\u3010{}\u3011\u5df2\u914d\u7f6e", (Object)ex.getLocalizedMessage(), (Object)((Archive)this.entity).getMlh());
            throw new RuntimeException("\u6863\u6848\u8865\u5f55\u5f02\u5e38,\u786e\u8ba4\u76ee\u5f55\u53f7\u3010" + ((Archive)this.entity).getMlh() + "\u3011\u5df2\u914d\u7f6e");
        }
    }

    public String bl() throws Exception {
        return this.renderModelTemplate("bl");
    }

    public String render() throws Exception {
        return this.renderModelTemplate(this.template);
    }

    protected void doSave(Archive entity) {
        this.archiveService.saveArchive(entity);
    }

    protected void afterSave() {
        String id;
        if (this._ajh != null) {
            this.ajhRange.setCurrentValue(this._ajh.intValue());
            this.ajhRangeService.saveAjhRange(this.ajhRange);
        }
        if (EnvHolder.isEnable((String)"jiangyin.enable") && StringUtils.isNotBlank((String)(id = this.recordAjhRangeService.removeHasUsed(((Archive)this.entity).getMlh(), ((Archive)this.entity).getModelName(), ((Archive)this.entity).getDwdm(), ((Archive)this.entity).getBgqx(), ((Archive)this.entity).getAjh().intValue())))) {
            this.recordAjhRangeService.remove(id);
        }
        this.session.put("currentAId", ((Archive)this.entity).getId());
    }

    private AjhRange getAvailableAjhRange() {
        if (((Archive)this.entity).getMlh() != null) {
            try {
                return this.ajhRangeService.getAvailableAjhRange(this.modelName, ((Archive)this.entity).getMlh());
            }
            catch (Exception ex) {
                return this.ajhRangeService.getAvailableAjhRange(this.modelName);
            }
        }
        return this.ajhRangeService.getAvailableAjhRange(this.modelName);
    }

    protected String getSuccessMsg() {
        return this.entity == null ? super.getSuccessMsg() : ((Archive)this.entity).getId();
    }

    protected String getJsCallBack() {
        return "onArchiveComplete";
    }

    private String getQzh() {
        String qzh = "";
        String dwdm = this.getDwdm();
        try {
            List items = this.dictService.getItems("qzhdwdm");
            for (Item item : items) {
                if (!dwdm.equals(item.getName())) continue;
                qzh = item.getValue();
                break;
            }
        }
        catch (Exception ex) {
            this.logger.info("\u672a\u914d\u7f6e[{}]\u5355\u4f4d\u4ee3\u7801\u5168\u5b97\u53f7\u5b57\u5178\u9879", (Object)"qzhdwdm");
        }
        return qzh;
    }

    private String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }

    public String reSetAjh() {
        try {
            this.ajhRange = this.ajhRangeService.getAvailableAjhRange(this.modelName, this.mlh);
            ((Archive)this.entity).setMlh(this.mlh);
            ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
            this.renderJson((Object)(this.ajhRange.getNextValue() + "," + this.ajhRange.getId() + "," + this.ajhRange.getCurrentValue() + "," + this.ajhRange.getBgqx()));
        }
        catch (Exception ex) {
            this.renderJson((Object)"\u8be5\u76ee\u5f55\u6848\u5377\u53f7\u5df2\u7528\u5b8c");
        }
        return null;
    }

    public String reSetMlh() {
        try {
            String dwdm = ((Archive)this.entity).getDwdm();
            if (StringUtils.isBlank((String)dwdm)) {
                dwdm = this.getDwdm();
            }
            this.ajhRange = this.ajhRangeService.getAjhRangesByBgqx(this.modelName, this.bgqx, dwdm);
            RecordAjhRange recordAjhRange = this.recordAjhRangeService.getRecordAjhRange(this.ajhRange.getMlh(), this.modelName, dwdm, this.bgqx);
            ((Archive)this.entity).setMlh(this.ajhRange.getMlh());
            int tempAjh = this.ajhRange.getNextValue();
            if (recordAjhRange != null) {
                ((Archive)this.entity).setAjh(Integer.valueOf(recordAjhRange.getAjh()));
                tempAjh = recordAjhRange.getAjh();
            } else {
                ((Archive)this.entity).setAjh(Integer.valueOf(this.ajhRange.getNextValue()));
            }
            this.renderJson((Object)(tempAjh + "," + this.ajhRange.getId() + "," + this.ajhRange.getCurrentValue() + "," + this.ajhRange.getMlh()));
        }
        catch (Exception ex) {
            this.renderJson((Object)ex.getMessage());
        }
        return null;
    }

    public String getMlh() {
        return this.mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public List<String> getMlhs() {
        if (this.template == null) {
            return this.ajhRangeService.getMlhByModelName(this.modelName);
        }
        return this.ajhRangeService.getMlh(this.modelName, ((Archive)this.entity).getDwdm());
    }
}

