/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.core.ModelChangeEvent;
import com.gtis.archive.core.cache.Cache;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.PermissionService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.support.hibernate.HibernateTemplate;
import com.gtis.web.SessionUtil;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.transaction.annotation.Transactional;

public class PermissionServiceImpl
extends HibernateTemplate<Permission, String>
implements PermissionService,
ApplicationEventPublisherAware {
    private Cache cache;
    private ApplicationEventPublisher publisher;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Transactional
    public void grant(Permission[] permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission perm : permissions) {
            if (this.hasPermission(perm).booleanValue()) continue;
            this.save((Object)perm);
            this.cache.put((Object)perm, (Object)true);
        }
        this.publisher.publishEvent((ApplicationEvent)new ModelChangeEvent((Object)permissions));
    }

    @Transactional
    public void revoke(Permission[] permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission perm : permissions) {
            if (!this.hasPermission(perm).booleanValue()) continue;
            this.delete(this.cache.getKey((Serializable)perm));
            this.cache.put((Object)perm, (Object)false);
        }
        this.publisher.publishEvent((ApplicationEvent)new ModelChangeEvent((Object)permissions));
    }

    public boolean hasPermission(String resourceId, String operation) {
        UserInfo user = SessionUtil.getCurrentUser();
        if (user.isAdmin()) {
            return true;
        }
        String roleIds = user.getRoleIds();
        if (roleIds == null) {
            return false;
        }
        for (String roleId : roleIds.split(",")) {
            if (!this.hasPermission(new Permission(resourceId, roleId = roleId.substring(1, roleId.length() - 1), operation)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<Permission> getPermissions(String resourceId, String roleId) {
        Criteria criteria = this.createCriteria(new Criterion[0]);
        if (StringUtils.isNotBlank((String)resourceId)) {
            criteria.add((Criterion)Restrictions.eq((String)"resourceId", (Object)resourceId));
        }
        if (StringUtils.isNotBlank((String)roleId)) {
            criteria.add((Criterion)Restrictions.eq((String)"roleId", (Object)roleId));
        }
        return criteria.list();
    }

    public Set<String> getReadableRoleIds(String resourceId) {
        HashSet<String> set = new HashSet<String>();
        for (Permission p : this.search(0, -1, new Order[0], new Criterion[]{Restrictions.eq((String)"resourceId", (Object)resourceId), Restrictions.eq((String)"operation", (Object)"view")}).getItems()) {
            set.add(p.getRoleId());
        }
        return set;
    }

    private Boolean hasPermission(Permission perm) {
        Boolean exist = (Boolean)this.cache.get(new Serializable[]{perm});
        if (exist == null) {
            for (Permission item : this.getPermissions(null, perm.getRoleId())) {
                this.cache.put((Object)item, (Object)true);
            }
            exist = (Boolean)this.cache.get(new Serializable[]{perm});
            if (exist == null) {
                exist = false;
                this.cache.put((Object)perm, (Object)exist);
            }
        }
        return exist;
    }
}

