/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.DownloadLog;
import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.OriginalPermission;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalPermissionService;
import com.gtis.archive.service.OriginalService;
import com.gtis.common.Page;
import com.gtis.generic.util.ImageUtils;
import com.gtis.plat.vo.UserInfo;
import com.gtis.support.hibernate.HibernateTemplate;
import com.gtis.web.SessionUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class OriginalServiceImpl
extends HibernateTemplate<Original, String>
implements OriginalService {
    public static final String THUMB_PREFIX = "__thumb.jpg";
    public static final long MAX_SIZE = 0x500000L;
    public static final long TASK_SIZE = 0x100000L;
    public static final int MICRO_IMAGE_WIDTH = 96;
    public static final int MICRO_IMAGE_HEIGHT = 96;
    private static final Logger logger = LoggerFactory.getLogger(OriginalServiceImpl.class);
    private String previewServerUrl;
    @Autowired
    private ModelService modelService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private OriginalPermissionService originalPermissionService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    protected EntityService entityService;

    public void setPreviewServerUrl(String previewServerUrl) {
        this.previewServerUrl = previewServerUrl;
    }

    public Original getOriginal(String id) {
        return (Original)this.get((Serializable)((Object)id));
    }

    @Transactional
    public void removeOriginal(String[] ids) {
        for (String id : ids) {
            Original original = this.getOriginal(id);
            if ("readOnly".equals(original.getStatus())) {
                logger.info("\u8be5\u539f\u6587\u5904\u4e8e\u53ea\u8bfb\u72b6\u6001\uff0c\u65e0\u6cd5\u7f16\u8f91,[original_id=" + original.getId() + ";original_name=" + original.getName() + "]");
                continue;
            }
            if (original != null && !original.getPath().startsWith("${myOriginalPath}")) {
                String path = EnvHolder.getAppEnv().getExpr(original.getPath());
                File file = OriginalServiceImpl.getFile((String)path);
                if (file != null && file.exists() && !file.delete()) {
                    logger.info("delete file [" + file.getAbsolutePath() + "] error");
                }
                if ((file = OriginalServiceImpl.getFile((String)(path + "__thumb.jpg"))) != null && file.exists() && !file.delete()) {
                    logger.info("delete file [" + file.getAbsolutePath() + "] error");
                }
            }
            this.delete((Serializable)((Object)id));
            if (!this.originalPermissionService.isOriginalPermissionEnable()) continue;
            this.batchExecute("delete from DownloadLog d where d.originalId=?", new Object[]{id});
            this.batchExecute("delete from OriginalPermission d where d.originalId=?", new Object[]{id});
        }
    }

    @Transactional
    public void saveOriginal(Original original) {
        UserInfo user;
        original.setUpdateTime(new Date());
        this.save((Object)original);
        if (this.originalPermissionService.isOriginalPermissionEnable() && (user = SessionUtil.getCurrentUser()) != null && !user.isAdmin()) {
            OriginalPermission op = new OriginalPermission();
            op.setUserId(user.getId());
            op.setUserName(user.getUsername());
            op.setOperation("download");
            op.setOriginalId(original.getId());
            this.originalPermissionService.saveOriginalPermission(op);
        }
        if (!original.canMakeThumb()) {
            return;
        }
        String path = EnvHolder.getAppEnv().getExpr(original.getPath()) + "__thumb.jpg";
        File file = OriginalServiceImpl.getFile((String)path);
        if (!(file != null && file.exists() || original.getFileSize() <= 0x100000L)) {
            this.createThumbFile(original);
        }
    }

    @Transactional
    public List<Original> getOriginals(String ownerId) {
        List list = this.syncOriginals(ownerId);
        if (list == null) {
            list = this.getDbOriginals(ownerId);
        }
        return list;
    }

    private List<Original> syncOriginals(String ownerId) {
        if (EnvHolder.isEnable((String)"autoIdentifyOriginal.enable")) {
            List list = this.getDbOriginals(ownerId);
            Map fsOgs = this.getFsOriginals(ownerId);
            if (fsOgs.size() != list.size()) {
                for (Original og : list) {
                    if (!fsOgs.containsKey(og.getName())) continue;
                    fsOgs.remove(og.getName());
                }
                if (!fsOgs.isEmpty()) {
                    for (Original og : fsOgs.values()) {
                        og.setUpdateTime(new Date());
                        this.save((Object)og);
                    }
                    return null;
                }
            }
            return list;
        }
        return null;
    }

    private List<Original> getDbOriginals(String ownerId) {
        return this.createCriteria(new Criterion[]{Restrictions.eq((String)"ownerId", (Object)ownerId)}).addOrder(Order.asc((String)"name")).list();
    }

    private Map<String, Original> getFsOriginals(String ownerId) {
        File[] fs;
        Object owner = this.getOriginalOwner(ownerId);
        if (owner == null) {
            owner = this.getOwner(ownerId);
        }
        Model model = this.modelService.getModel(owner);
        String relativePath = this.getRelativePath(owner, model);
        File storePath = OriginalServiceImpl.getFile((String)(model.getEnv().get((Object)"originalRoot") + "/" + relativePath));
        HashMap<String, Original> map = new HashMap<String, Original>();
        if (storePath.exists() && (fs = storePath.listFiles()) != null) {
            for (File file : fs) {
                String name;
                if (file.isDirectory() || (name = file.getName()).endsWith("__thumb.jpg") || "thumb.db".equals(name)) continue;
                Original og = new Original();
                og.setOwnerId(ownerId);
                og.setName(file.getName());
                og.setFileSize(file.length());
                og.setPath("${originalRoot}/" + relativePath + "/" + og.getName());
                og.setOwnerModelName(model.getName());
                map.put(file.getName(), og);
            }
        }
        return map;
    }

    public Object getOriginalOwner(String id) {
        Archive archive = this.archiveService.getSimpleArchive(id);
        return archive != null ? archive : this.archiveService.getSimpleDocument(id);
    }

    public Object getOriginalOwner(String id, String modelName) {
        if (StringUtils.isBlank((String)modelName)) {
            Archive archive = this.archiveService.getSimpleArchive(id);
            return archive != null ? archive : this.archiveService.getSimpleDocument(id);
        }
        Archive archive = this.archiveService.getArchive(modelName, id);
        return archive != null ? archive : this.archiveService.getDocument(Archive.toDocumentModelName((String)modelName), id);
    }

    public Object getOwner(String ownerId) {
        Object entity = this.entityService.load("ythsw", ownerId);
        if (entity == null) {
            entity = this.entityService.load("ythfw", ownerId);
        }
        if (entity == null) {
            entity = this.entityService.load("ythnw", ownerId);
        }
        return entity;
    }

    @Transactional
    public File getOriginalFile(String id, String action) {
        Original original = this.getOriginal(id);
        String path = EnvHolder.getAppEnv().getExpr(original.getPath());
        if (this.originalPermissionService.isOriginalPermissionEnable()) {
            this.saveDownloadLog(original, action);
        }
        return OriginalServiceImpl.getFile((String)path);
    }

    public File getOriginalThumbFile(String id) {
        Original original = this.getOriginal(id);
        String path = EnvHolder.getAppEnv().getExpr(original.getPath()) + "__thumb.jpg";
        File file = OriginalServiceImpl.getFile((String)path);
        if ((file == null || !file.exists()) && original.isImage() && original.getFileSize() < 0x100000L) {
            this.createThumbFile(original);
        }
        return OriginalServiceImpl.getFile((String)path);
    }

    private Collection getSet(Environment evn) {
        Collection<Object> set = null;
        set = evn.getProps().size() == 0 ? this.getSet(evn.getParent()) : evn.getProps().keySet();
        return set;
    }

    public void saveOriginalFile(Original original, File file, boolean overWrite) {
        Object owner = this.getOriginalOwner(original.getOwnerId());
        if (owner == null) {
            owner = this.getEntity(original);
        }
        if (owner == null) {
            throw new IllegalStateException("Owner for original [" + original + "] is null");
        }
        Model model = this.modelService.getModel(owner);
        try {
            original.setOwnerModelName(PropertyUtils.getProperty((Object)owner, (String)"modelName").toString());
        }
        catch (Exception ex) {
            original.setOwnerModelName(model.getName());
        }
        String relativePath = this.getRelativePath(owner, model);
        Collection set = this.getSet(model.getEnv().getParent());
        ArrayList al = new ArrayList();
        al.addAll(set);
        Iterator i = al.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (s.startsWith("originalRoot_")) continue;
            i.remove();
        }
        File path = null;
        for (int i2 = 0; i2 < al.size(); ++i2) {
            path = OriginalServiceImpl.getFile((String)(model.getEnv().get(al.get(i2)) + "/" + relativePath));
            if (path.getUsableSpace() < original.getFileSize()) continue;
            if (file != null && !path.exists() && !path.mkdirs()) {
                throw new RuntimeException("mkdir [" + relativePath + "] error");
            }
            String fileName = original.getName();
            File f = OriginalServiceImpl.getFile((String)(path + "/" + fileName));
            try {
                if (f != null && f.exists() && !overWrite) {
                    String rename = OriginalServiceImpl.rename((File)f, (String)original.getName());
                    f = OriginalServiceImpl.getFile((String)(path + "/" + rename));
                    original.setName(rename);
                }
                FileCopyUtils.copy((File)file, (File)f);
                original.setPath("${" + (String)al.get(i2) + "}/" + relativePath + "/" + original.getName());
                if (f == null) break;
                original.setFileSize(f.length());
                break;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    public void saveOriginalFile(Original original, File file, boolean overWrite, String modelName) {
        Object owner = this.getOriginalOwner(original.getOwnerId(), modelName);
        if (owner == null) {
            owner = this.getEntity(original);
        }
        if (owner == null) {
            throw new IllegalStateException("Owner for original [" + original + "] is null");
        }
        Model model = this.modelService.getModel(owner);
        try {
            original.setOwnerModelName(PropertyUtils.getProperty((Object)owner, (String)"modelName").toString());
        }
        catch (Exception ex) {
            original.setOwnerModelName(model.getName());
        }
        String relativePath = this.getRelativePath(owner, model);
        Collection set = this.getSet(model.getEnv().getParent());
        ArrayList al = new ArrayList();
        al.addAll(set);
        Iterator i = al.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (s.startsWith("originalRoot_")) continue;
            i.remove();
        }
        File path = null;
        for (int i2 = 0; i2 < al.size(); ++i2) {
            path = OriginalServiceImpl.getFile((String)(model.getEnv().get(al.get(i2)) + "/" + relativePath));
            if (path.getUsableSpace() < original.getFileSize()) continue;
            if (file != null && !path.exists() && !path.mkdirs()) {
                throw new RuntimeException("mkdir [" + relativePath + "] error");
            }
            String fileName = original.getName();
            File f = OriginalServiceImpl.getFile((String)(path + "/" + fileName));
            try {
                if (f != null && f.exists() && !overWrite) {
                    String rename = OriginalServiceImpl.rename((File)f, (String)original.getName());
                    f = OriginalServiceImpl.getFile((String)(path + "/" + rename));
                    original.setName(rename);
                }
                FileCopyUtils.copy((File)file, (File)f);
                original.setPath("${" + (String)al.get(i2) + "}/" + relativePath + "/" + original.getName());
                if (f == null) break;
                original.setFileSize(f.length());
                break;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    public Object getEntity(Original original) {
        Object entity = this.entityService.load("ythsw", original.getOwnerId());
        if (entity == null) {
            entity = this.entityService.load("ythfw", original.getOwnerId());
        }
        if (entity == null) {
            entity = this.entityService.load("ythnw", original.getOwnerId());
        }
        return entity;
    }

    private String getRelativePath(Object owner, Model model) {
        String relativePath;
        if (owner instanceof Archive) {
            Archive archive = (Archive)owner;
            relativePath = new Environment((Object)archive, model.getEnv()).get((Object)"archivePath");
            if (relativePath == null) {
                relativePath = model.getEnv().getExpr("archive/${.now?string('yyyy/MM/dd')}/" + archive.getId());
            }
        } else if (owner instanceof Document) {
            Archive archive;
            Document doc = (Document)owner;
            relativePath = doc.getArchiveId() != null ? ((relativePath = new Environment((Object)(archive = this.archiveService.getSimpleArchive(doc.getArchiveId())), model.getEnv()).get((Object)"archivePath")) == null ? model.getEnv().getExpr("archive/${.now?string('yyyy/MM/dd')}/" + doc.getArchiveId() + "/" + doc.getId()) : relativePath + "/" + (doc.getYh() == null ? doc.getId() : doc.getYh())) : model.getEnv().getExpr("document/${.now?string('yyyy/MM/dd')}/" + doc.getId());
        } else {
            Object entity = owner;
            relativePath = new Environment(entity, model.getEnv()).get((Object)"genericPath");
            if (relativePath == null) {
                try {
                    relativePath = model.getEnv().getExpr("generic/${.now?string('yyyy/MM/dd')}/" + PropertyUtils.getProperty((Object)entity, (String)"id"));
                }
                catch (Exception e) {
                    relativePath = null;
                }
            }
        }
        if (relativePath == null) {
            throw new RuntimeException("Original save path unset,please check");
        }
        return relativePath;
    }

    @Transactional
    public Page<Original> searchOriginal(String ownerId, String name, int start, int limit) {
        UserInfo user;
        if (this.originalPermissionService.isOriginalPermissionEnable() && !(user = SessionUtil.getCurrentUser()).isAdmin()) {
            return this.originalPermissionService.searchOriginal(ownerId, name, start, limit);
        }
        ArrayList<SimpleExpression> list = new ArrayList<SimpleExpression>();
        list.add(Restrictions.eq((String)"ownerId", (Object)ownerId));
        if (StringUtils.isBlank((String)name)) {
            this.syncOriginals(ownerId);
        } else {
            list.add(Restrictions.like((String)"name", (String)name, (MatchMode)MatchMode.ANYWHERE));
        }
        return this.search(list, Collections.singletonList(Order.asc((String)"name")), start, limit);
    }

    public boolean hasOriginal(String ownerId) {
        List list = this.find(new Criterion[]{Restrictions.eq((String)"ownerId", (Object)ownerId)});
        return list.size() > 0;
    }

    public Object[] getIds(String ownerId) {
        List originals = this.createCriteria(new Criterion[]{Restrictions.eq((String)"ownerId", (Object)ownerId)}).addOrder(Order.asc((String)"name")).list();
        ArrayList<String> ids = new ArrayList<String>();
        for (Original original : originals) {
            ids.add(original.getId());
        }
        return ids.toArray();
    }

    private void createThumbFile(Original original) {
        block7: {
            String path = EnvHolder.getAppEnv().getExpr(original.getPath());
            if (!new File(path).exists()) {
                return;
            }
            if (original.isImage() && original.getFileSize() < 0x500000L) {
                String destPath = path + "__thumb.jpg";
                try {
                    if (original.getFileSize() > 0x100000L) {
                        this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                        break block7;
                    }
                    ImageUtils.resizeImage((String)path, (String)destPath, (int)96, (int)96);
                }
                catch (Exception ex) {
                    logger.error("Unable to transform image:[" + path + "] to [" + destPath + "]", (Throwable)ex);
                }
            } else {
                if (this.previewServerUrl == null) {
                    logger.warn("previewServerUrl not config");
                    return;
                }
                this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void saveDownloadLog(Original original, String action) {
        UserInfo user = SessionUtil.getCurrentUser();
        if (user != null) {
            ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
            criterions.add(Restrictions.eq((String)"originalId", (Object)original.getId()));
            criterions.add(Restrictions.eq((String)"userId", (Object)user.getId()));
            criterions.add(Restrictions.eq((String)"action", (Object)action));
            Page page = this.search(DownloadLog.class, criterions, null, 0, 1);
            DownloadLog dl = null;
            if (!page.isEmpty()) {
                dl = (DownloadLog)page.getItem(0);
                if (DateUtils.addMinutes((Date)dl.getDownloadTime(), (int)2).after(new Date())) {
                    dl.setCount(dl.getCount() + 1);
                } else {
                    dl = null;
                }
            }
            if (dl == null) {
                dl = new DownloadLog();
                dl.setOriginalId(original.getId());
                dl.setUserId(user.getId());
                dl.setUserName(user.getUsername());
                dl.setAction(action);
                dl.setCount(1);
            }
            dl.setDownloadTime(new Date());
            this.getSession().save((Object)dl);
        }
    }

    private static File getFile(String path) {
        try {
            return ResourceUtils.getFile((String)path);
        }
        catch (Exception e) {
            logger.error("Get File error,path [" + path + "]", (Throwable)e);
            return null;
        }
    }

    private static String rename(File f, String fileName) {
        int index = fileName.lastIndexOf(46);
        String name = index > -1 ? fileName.substring(0, index) : fileName;
        String ext = index > -1 ? fileName.substring(index) : "";
        String name1 = fileName;
        int i = 1;
        while (new File(f.getParentFile(), name1).exists()) {
            name1 = name + "_" + i + ext;
            ++i;
        }
        return name1;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ String access$100(OriginalServiceImpl x0) {
        return x0.previewServerUrl;
    }
}

