/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.OriginalPermission;
import com.gtis.archive.service.OriginalPermissionService;
import com.gtis.common.Page;
import com.gtis.plat.vo.UserInfo;
import com.gtis.support.hibernate.HibernateTemplate;
import com.gtis.web.SessionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.transaction.annotation.Transactional;

public class OriginalPermissionServiceImpl
extends HibernateTemplate<OriginalPermission, String>
implements OriginalPermissionService {
    private boolean originalPermissionEnable = false;

    public void setOriginalPermissionEnable(boolean originalPermissionEnable) {
        this.originalPermissionEnable = originalPermissionEnable;
    }

    public boolean isOriginalPermissionEnable() {
        return this.originalPermissionEnable;
    }

    public boolean hasOriginalPermission(String originalId) {
        if (!this.originalPermissionEnable) {
            return true;
        }
        UserInfo user = SessionUtil.getCurrentUser();
        return SessionUtil.getCurrentUser().isAdmin() || this.findUnique(new Criterion[]{Restrictions.eq((String)"userId", (Object)user.getId()), Restrictions.eq((String)"originalId", (Object)originalId)}) != null;
    }

    @Transactional
    public OriginalPermission saveOriginalPermission(OriginalPermission originalPermission) {
        if (!this.originalPermissionEnable) {
            return null;
        }
        OriginalPermission op1 = (OriginalPermission)this.findUnique(new Criterion[]{Restrictions.eq((String)"originalId", (Object)originalPermission.getOriginalId()), Restrictions.eq((String)"userId", (Object)originalPermission.getUserId())});
        if (op1 != null) {
            op1.setOperation(originalPermission.getOperation());
            op1.setExpireTime(originalPermission.getExpireTime());
            originalPermission = op1;
        }
        originalPermission.setAuthorizer(SessionUtil.getCurrentUser().getUsername());
        originalPermission.setCreateTime(new Date());
        this.save((Object)originalPermission);
        return originalPermission;
    }

    @Transactional
    public void removeOriginalPermission(String id) {
        this.delete((Serializable)((Object)id));
    }

    public List<OriginalPermission> getOriginalPermissions(String originalId) {
        return this.find(new Criterion[]{Restrictions.eq((String)"originalId", (Object)originalId)});
    }

    public Page<OriginalPermission> searchOriginalPermission(String name, int start, int limit) {
        ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
        if (StringUtils.isNotBlank((String)name)) {
            criterions.add(Restrictions.like((String)"original.name", (Object)("%" + name + "%")));
        }
        return this.search(criterions, Collections.singletonList(Order.desc((String)"id")), start, limit);
    }

    public Page<Original> searchOriginal(String ownerId, String name, int start, int limit) {
        UserInfo user = SessionUtil.getCurrentUser();
        StringBuilder sb = new StringBuilder(" from OriginalPermission as op inner join op.original as o where op.userId=:userId and o.ownerId=:ownerId and (op.expireTime > :now or op.expireTime is null)");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", user.getId());
        map.put("ownerId", ownerId);
        map.put("now", DateUtils.addDays((Date)new Date(), (int)-1));
        if (name != null) {
            map.put("name", "%" + name + "%");
            sb.append(" and o.name like :name");
        }
        sb.append(" order by o.id desc");
        String hql = "select o" + sb;
        String countHql = "select count(o)" + sb;
        Page page = new Page(Page.toIndex((int)start, (int)limit), limit);
        page.setItems(this.createQuery(hql, map).setFirstResult(start).setMaxResults(limit).list());
        page.setTotalCount(((Long)this.findUnique(countHql, map)).intValue());
        return page;
    }
}

