/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.EntityNotFoundException;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.support.hibernate.HibernateTemplate;
import com.gtis.web.SessionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AjhRangeServiceImpl
extends HibernateTemplate<AjhRange, String>
implements AjhRangeService {
    @Autowired
    private SysUserService userService;

    public AjhRange getAjhRange(String id) {
        return (AjhRange)this.get((Serializable)((Object)id));
    }

    public String getModelNameByMlh(String mlh) {
        List list = this.findBy("mlh", (Object)mlh);
        return list.isEmpty() ? null : ((AjhRange)list.get(0)).getModelName();
    }

    public List<AjhRange> getAjhRangeByModelName(String modelName) {
        Criteria criteria = null;
        criteria = EnvHolder.isEnable((String)"individualMlh.enable") && SessionUtil.getCurrentUser() != null && !SessionUtil.getCurrentUser().isAdmin() ? (EnvHolder.isEnable((String)"changzhou.enable") ? this.createCriteria(new Criterion[]{Restrictions.like((String)"modelName", (Object)("%" + modelName + "%")), Restrictions.eq((String)"dwdm", (Object)this.getDwdm())}) : this.createCriteria(new Criterion[]{Restrictions.eq((String)"modelName", (Object)modelName), Restrictions.eq((String)"dwdm", (Object)this.getDwdm())})) : (EnvHolder.isEnable((String)"changzhou.enable") ? this.createCriteria(new Criterion[]{Restrictions.like((String)"modelName", (Object)("%" + modelName + "%"))}) : this.createCriteria(new Criterion[]{Restrictions.eq((String)"modelName", (Object)modelName)}));
        return criteria.addOrder(Order.asc((String)"bgqx")).addOrder(Order.asc((String)"orderNumber")).addOrder(Order.asc((String)"mlh")).list();
    }

    public Map<String, Integer> getAvailableAjhCountMap() {
        List list = this.getAll();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (AjhRange range : list) {
            int i = this.getAvailableAjh(range);
            if (map.containsKey(range.getModelName())) {
                int count = (Integer)map.get(range.getModelName());
                if (count == -1 || i == -1) continue;
                map.put(range.getModelName(), count + i);
                continue;
            }
            map.put(range.getModelName(), i);
        }
        return map;
    }

    public Map<String, Integer> getAvailableAjhCountMapByDwdm(String dwdm) {
        List list = this.getAll();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (AjhRange range : list) {
            if (!dwdm.equals(range.getDwdm())) continue;
            int i = this.getAvailableAjh(range);
            if (map.containsKey(range.getModelName())) {
                int count = (Integer)map.get(range.getModelName());
                if (count == -1 || i == -1) continue;
                map.put(range.getModelName(), count + i);
                continue;
            }
            map.put(range.getModelName(), i);
        }
        return map;
    }

    public AjhRange getAvailableAjhRange(String modelName) {
        List list = this.getAjhRangeByModelName(modelName);
        for (AjhRange ajh : list) {
            if (!EnvHolder.isEnable((String)"jintan.enable") || ajh.getYear() == null || !ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(1))) || ajh.hasExhausted()) continue;
            return ajh;
        }
        for (AjhRange ajh : list) {
            if (ajh.hasExhausted()) continue;
            return ajh;
        }
        if (EnvHolder.isEnable((String)"individualMlh.enable")) {
            throw new EntityNotFoundException("\u6a21\u578b\u3010" + modelName + "\u3011\u672a\u9488\u5bf9\u5355\u4f4d\u4ee3\u7801\u3010" + this.getDwdm() + "\u3011\u5206\u914d\u5bf9\u5e94\u76ee\u5f55\u53f7");
        }
        throw new EntityNotFoundException("\u6a21\u578b" + modelName + "\u6ca1\u6709\u53ef\u7528\u7684\u76ee\u5f55\u53f7");
    }

    public AjhRange getAvailableAjhRangeByDwdm(String modelName, String dwdm) {
        Criteria criteria = this.createCriteria(new Criterion[0]);
        if (EnvHolder.isEnable((String)"individualMlh.enable")) {
            criteria = EnvHolder.isEnable((String)"changzhou.enable") ? this.createCriteria(new Criterion[]{Restrictions.like((String)"modelName", (Object)("%" + modelName + "%")), Restrictions.eq((String)"dwdm", (Object)dwdm)}) : this.createCriteria(new Criterion[]{Restrictions.eq((String)"modelName", (Object)modelName), Restrictions.eq((String)"dwdm", (Object)dwdm)});
        }
        List list = criteria.addOrder(Order.asc((String)"orderNumber")).addOrder(Order.asc((String)"mlh")).list();
        for (AjhRange ajh : list) {
            if (!EnvHolder.isEnable((String)"jintan.enable") || ajh.getYear() == null || !ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(1))) || ajh.hasExhausted()) continue;
            return ajh;
        }
        for (AjhRange ajh : list) {
            if (ajh.hasExhausted()) continue;
            return ajh;
        }
        if (EnvHolder.isEnable((String)"individualMlh.enable")) {
            throw new EntityNotFoundException("\u6a21\u578b\u3010" + modelName + "\u3011\u672a\u9488\u5bf9\u5355\u4f4d\u4ee3\u7801\u3010" + dwdm + "\u3011\u5206\u914d\u5bf9\u5e94\u76ee\u5f55\u53f7");
        }
        throw new EntityNotFoundException("\u6a21\u578b" + modelName + "\u6ca1\u6709\u53ef\u7528\u7684\u76ee\u5f55\u53f7");
    }

    public AjhRange getAvailableAjhRange(String modelName, String mlh) {
        List list = this.getAjhRangeByModelName(modelName);
        for (AjhRange ajh : list) {
            if (!EnvHolder.isEnable((String)"jintan.enable") || ajh.getYear() == null || !ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(1))) || ajh.hasExhausted() || !ajh.getMlh().equalsIgnoreCase(mlh)) continue;
            return ajh;
        }
        for (AjhRange ajh : list) {
            if (ajh.hasExhausted() || !ajh.getMlh().equalsIgnoreCase(mlh)) continue;
            return ajh;
        }
        if (EnvHolder.isEnable((String)"individualMlh.enable")) {
            throw new EntityNotFoundException("\u6a21\u578b\u3010" + modelName + "\u3011\u9488\u5bf9\u5355\u4f4d\u4ee3\u7801\u3010" + this.getDwdm() + "\u3011\u5206\u914d\u7684\u76ee\u5f55\u53f7" + mlh + "\u4e0d\u6b63\u786e");
        }
        throw new EntityNotFoundException("\u6a21\u578b" + modelName + "\u914d\u7f6e\u7684\u76ee\u5f55\u53f7" + mlh + "\u4e0d\u5b58\u5728\uff01");
    }

    public AjhRange getAvailableAjhRange(String modelName, String dwdm, String mlh) {
        Criteria criteria = this.createCriteria(new Criterion[0]);
        criteria = EnvHolder.isEnable((String)"individualMlh.enable") ? (EnvHolder.isEnable((String)"changzhou.enable") ? this.createCriteria(new Criterion[]{Restrictions.like((String)"modelName", (Object)("%" + modelName + "%")), Restrictions.eq((String)"dwdm", (Object)dwdm), Restrictions.eq((String)"mlh", (Object)mlh)}) : this.createCriteria(new Criterion[]{Restrictions.eq((String)"modelName", (Object)modelName), Restrictions.eq((String)"dwdm", (Object)dwdm), Restrictions.eq((String)"mlh", (Object)mlh)})) : (EnvHolder.isEnable((String)"changzhou.enable") ? this.createCriteria(new Criterion[]{Restrictions.like((String)"modelName", (Object)("%" + modelName + "%")), Restrictions.eq((String)"mlh", (Object)mlh)}) : this.createCriteria(new Criterion[]{Restrictions.eq((String)"modelName", (Object)modelName), Restrictions.eq((String)"mlh", (Object)mlh)}));
        List list = criteria.addOrder(Order.asc((String)"orderNumber")).addOrder(Order.asc((String)"mlh")).list();
        for (AjhRange ajh : list) {
            if (!EnvHolder.isEnable((String)"jintan.enable") || ajh.getYear() == null || !ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(1))) || ajh.hasExhausted()) continue;
            return ajh;
        }
        for (AjhRange ajh : list) {
            if (ajh.hasExhausted()) continue;
            return ajh;
        }
        if (EnvHolder.isEnable((String)"individualMlh.enable")) {
            throw new EntityNotFoundException("\u6a21\u578b\u3010" + modelName + "\u3011\u672a\u9488\u5bf9\u5355\u4f4d\u4ee3\u7801\u3010" + dwdm + "\u3011\u5206\u914d\u5bf9\u5e94\u76ee\u5f55\u53f7");
        }
        throw new EntityNotFoundException("\u6a21\u578b" + modelName + "\u6ca1\u6709\u53ef\u7528\u7684\u76ee\u5f55\u53f7");
    }

    @Transactional
    public void removeAjhRange(String id) {
        this.delete((Serializable)((Object)id));
    }

    @Transactional
    public AjhRange saveAjhRange(AjhRange ajhRange) {
        this.merge((Object)ajhRange);
        return ajhRange;
    }

    public Page<AjhRange> getAjhRanges(int start, int limit, Order[] order) {
        return this.search(start, limit, order, new Criterion[0]);
    }

    public Page<AjhRange> getAjhRangesOrderMlh(int start, int limit, String order) {
        String baseSql = "";
        if (!SessionUtil.getCurrentUser().isAdmin() && EnvHolder.isEnable((String)"dwdm.enable")) {
            String dwdm = this.getDwdm();
            baseSql = "select * from t_ajh_range t where t.model_name!='Wdyth' and t.dwdm='" + dwdm + "' order by cast(t.mlh as int) " + order;
        } else {
            baseSql = "select * from t_ajh_range t where t.model_name!='Wdyth' order by cast(t.mlh as int) " + order;
        }
        Page page = new Page(Page.toIndex((int)start, (int)limit), limit);
        SQLQuery query = this.getSession().createSQLQuery(baseSql.toString()).addEntity(AjhRange.class);
        page.setItems(query.list());
        return page;
    }

    public AjhRange getAjhRangesForGeneric(String modelName, String mlh) {
        List list = this.getAjhRangeByModelName(modelName);
        for (AjhRange ajh : list) {
            if (!EnvHolder.isEnable((String)"jintan.enable") || ajh.getYear() == null || !ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(1))) || !ajh.getMlh().equalsIgnoreCase(mlh)) continue;
            return ajh;
        }
        for (AjhRange ajh : list) {
            if (!ajh.getMlh().equalsIgnoreCase(mlh)) continue;
            return ajh;
        }
        if (EnvHolder.isEnable((String)"individualMlh.enable")) {
            throw new EntityNotFoundException("\u6a21\u578b\u3010" + modelName + "\u3011\u9488\u5bf9\u5355\u4f4d\u4ee3\u7801\u3010" + this.getDwdm() + "\u3011\u5206\u914d\u7684\u76ee\u5f55\u53f7" + mlh + "\u4e0d\u6b63\u786e");
        }
        throw new EntityNotFoundException("\u6a21\u578b" + modelName + "\u914d\u7f6e\u7684\u76ee\u5f55\u53f7" + mlh + "\u4e0d\u5b58\u5728\uff01");
    }

    public AjhRange getAjhRangeAvailable(String modelName, String mlh, String dwdm) {
        List list = this.getAjhRangeByModelNameDwdm(modelName, dwdm);
        for (AjhRange ajh : list) {
            if (!EnvHolder.isEnable((String)"jintan.enable") || ajh.getYear() == null || !ajh.getYear().equals(String.valueOf(Calendar.getInstance().get(1))) || !ajh.getMlh().equalsIgnoreCase(mlh)) continue;
            return ajh;
        }
        for (AjhRange ajh : list) {
            if (!ajh.getMlh().equalsIgnoreCase(mlh)) continue;
            return ajh;
        }
        if (SessionUtil.getCurrentUser().isAdmin()) {
            return null;
        }
        if (EnvHolder.isEnable((String)"individualMlh.enable")) {
            throw new EntityNotFoundException("\u6a21\u578b\u3010" + modelName + "\u3011\u9488\u5bf9\u5355\u4f4d\u4ee3\u7801\u3010" + this.getDwdm() + "\u3011\u5206\u914d\u7684\u76ee\u5f55\u53f7" + mlh + "\u4e0d\u6b63\u786e");
        }
        throw new EntityNotFoundException("\u6a21\u578b" + modelName + "\u914d\u7f6e\u7684\u76ee\u5f55\u53f7" + mlh + "\u4e0d\u5b58\u5728\uff01");
    }

    private List<AjhRange> getAjhRangeByModelNameDwdm(String modelName, String dwdm) {
        Criteria criteria = null;
        criteria = EnvHolder.isEnable((String)"individualMlh.enable") && SessionUtil.getCurrentUser() != null && !SessionUtil.getCurrentUser().isAdmin() ? (EnvHolder.isEnable((String)"changzhou.enable") ? this.createCriteria(new Criterion[]{Restrictions.like((String)"modelName", (Object)("%" + modelName + "%")), Restrictions.eq((String)"dwdm", (Object)dwdm)}) : this.createCriteria(new Criterion[]{Restrictions.eq((String)"modelName", (Object)modelName), Restrictions.eq((String)"dwdm", (Object)dwdm)})) : (EnvHolder.isEnable((String)"changzhou.enable") ? this.createCriteria(new Criterion[]{Restrictions.like((String)"modelName", (Object)("%" + modelName + "%"))}) : this.createCriteria(new Criterion[]{Restrictions.eq((String)"modelName", (Object)modelName), Restrictions.eq((String)"dwdm", (Object)dwdm)}));
        return criteria.addOrder(Order.asc((String)"orderNumber")).addOrder(Order.asc((String)"mlh")).list();
    }

    public List getMlhByModelName(String modelName) {
        List ajhList = this.getAjhRangeByModelName(modelName);
        ArrayList<String> mlhList = new ArrayList<String>();
        for (AjhRange ajhRange : ajhList) {
            mlhList.add(ajhRange.getMlh());
        }
        return mlhList;
    }

    public List getMlh(String modelName, String dwdm) {
        List ajhList = this.getAjhRangeByModelNameDwdm(modelName, dwdm);
        ArrayList<String> mlhList = new ArrayList<String>();
        for (AjhRange ajhRange : ajhList) {
            mlhList.add(ajhRange.getMlh());
        }
        return mlhList;
    }

    public AjhRange getAjhRangesByBgqx(String modelName, String bgqx, String dwdm) {
        Criteria criteria = this.createCriteria(new Criterion[0]);
        criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"modelName", (Object)modelName), Restrictions.eq((String)"bgqx", (Object)bgqx), Restrictions.eq((String)"dwdm", (Object)dwdm)});
        List list = criteria.addOrder(Order.asc((String)"orderNumber")).addOrder(Order.asc((String)"mlh")).list();
        for (AjhRange ajh : list) {
            if (ajh.hasExhausted()) continue;
            return ajh;
        }
        if (EnvHolder.isEnable((String)"individualMlh.enable")) {
            throw new EntityNotFoundException("\u6a21\u578b\u3010" + modelName + "\u3011\u672a\u9488\u5bf9\u5355\u4f4d\u4ee3\u7801\u3010" + dwdm + "\u3011\u4fdd\u7ba1\u671f\u9650\u3010" + bgqx + "\u3011\u5206\u914d\u5bf9\u5e94\u76ee\u5f55\u53f7");
        }
        throw new EntityNotFoundException("\u6a21\u578b" + modelName + "\u6ca1\u6709\u53ef\u7528\u7684\u76ee\u5f55\u53f7");
    }

    public boolean exist(String mlh, String dwdm, String id) {
        Criteria criteria = this.createCriteria(new Criterion[0]);
        if (EnvHolder.isEnable((String)"dwdm.enable")) {
            if (StringUtils.isBlank((String)dwdm)) {
                dwdm = this.getDwdm();
            }
            criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"dwdm", (Object)dwdm), Restrictions.eq((String)"mlh", (Object)mlh)});
        } else {
            criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"mlh", (Object)mlh)});
        }
        List list = criteria.list();
        if (list.size() > 1) {
            return true;
        }
        if (list.size() == 1) {
            AjhRange dbAjhRange = (AjhRange)list.get(0);
            return !dbAjhRange.getId().equals(id);
        }
        return false;
    }

    private int getAvailableAjh(AjhRange ajhRange) {
        if (ajhRange.getMaxValue() == null) {
            return -1;
        }
        if (ajhRange.getMaxValue() <= ajhRange.getCurrentValue()) {
            return 0;
        }
        return ajhRange.getMaxValue() - ajhRange.getCurrentValue();
    }

    private String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }
}

