/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="t_permission")
public class Permission
implements Serializable {
    private static final long serialVersionUID = -2545246557701589198L;
    public static final String OPERATION_DICT = "operationPerm";
    public static final String SYS_FUNCTION_DICT = "sysPerm";
    public static final String VIEW_PERMISSION = "view";
    @Id
    @GeneratedValue(generator="sort-uuid")
    @GenericGenerator(name="sort-uuid", strategy="com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length=32)
    private String id;
    @Column(length=100, nullable=false)
    private String resourceId;
    @Column(length=100, nullable=false)
    private String roleId;
    @Column(length=100, nullable=false)
    private String operation;

    public Permission() {
    }

    public Permission(String resourceId, String roleId, String operation) {
        this.resourceId = resourceId;
        this.roleId = roleId;
        this.operation = operation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission p = (Permission)obj;
        return this.resourceId != null && this.resourceId.equals(p.getResourceId()) && this.operation != null && this.operation.equals(p.getOperation()) && this.roleId != null && this.roleId.equals(p.getRoleId());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.resourceId.hashCode();
        hash = hash * 31 + this.operation.hashCode();
        hash = hash * 31 + this.roleId.hashCode();
        return hash;
    }

    public String toString() {
        return "[" + this.resourceId + "," + this.operation + "," + this.roleId + "]";
    }
}

