/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.impl;

import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelManager;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.generater.ModelCodeGenerater;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ModelServiceImpl
implements ModelService {
    private ModelManager modelManager;
    private ClassLoader classLoader;
    private Map<String, Class> loadedclasses = new ConcurrentHashMap();
    private Map<Class, String> namesMap = new ConcurrentHashMap();
    private Resource tempLocation;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setModelManager(ModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public void setTempLocation(Resource tempLocation) {
        this.tempLocation = tempLocation;
    }

    public Class getClass(String modelName) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this.loadedclasses.get(modelName);
        if (clazz == null) {
            clazz = this.classLoader.loadClass("com.gtis.archive.entity." + modelName);
            this.loadedclasses.put(modelName, clazz);
        }
        return clazz;
    }

    public Collection<Class> getClasses() {
        return this.loadedclasses.values();
    }

    public Model getModel(String modelName) {
        return this.modelManager.getModel(modelName);
    }

    public Model getModel(Object entity) {
        return this.getModel(this.getModelName(entity));
    }

    public String getModelName(Object obj) {
        Class<?> clazz = obj.getClass();
        String modelName = (String)this.namesMap.get(clazz);
        if (modelName == null) {
            for (String name : this.loadedclasses.keySet()) {
                if (this.loadedclasses.get(name) != clazz) continue;
                this.namesMap.put(clazz, name);
                modelName = name;
                break;
            }
        }
        return modelName;
    }

    public Collection<Model> getModels() {
        return this.modelManager.getModels();
    }

    public void refresh() {
        this.init();
    }

    public void reload() {
        this.loadedclasses.clear();
        this.namesMap.clear();
        this.refresh();
    }

    public void init() {
        GroovyClassLoader gcl = new GroovyClassLoader();
        try {
            File path = this.tempLocation.getFile();
            if (!path.exists() && !path.mkdirs()) {
                throw new RuntimeException("mkdir" + path.getAbsolutePath() + " error");
            }
            gcl.addURL(path.toURI().toURL());
            gcl.setShouldRecompile(Boolean.valueOf(true));
            this.classLoader = gcl;
        }
        catch (Exception e) {
            this.logger.error("error to init GroovyClassLoader,tempLocation [" + this.tempLocation + "] not exist", (Throwable)e);
        }
        Collection models = this.modelManager.getModels();
        for (Model model : models) {
            if (!model.isConstant()) {
                this.generateModelCode(model);
            }
            try {
                Class clazz = gcl.loadClass(this.toClassName(model), true, false);
                this.loadedclasses.put(model.getName(), clazz);
            }
            catch (ClassNotFoundException e) {
                this.logger.error("load model[" + model + "],error:[{}]", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModelCode(Model model) {
        Writer wf = null;
        try {
            File file = new File(this.tempLocation.getFile(), this.toClassName(model).replace(".", "/") + ".groovy");
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                throw new RuntimeException("mkdir" + dir.getAbsolutePath() + " error");
            }
            if (file.exists()) {
                file.delete();
            }
            wf = new OutputStreamWriter(new FileOutputStream(file));
            ModelCodeGenerater.GROOVY.generate(model, wf);
        }
        catch (IOException e) {
            this.logger.error("generate model [" + model + "] error", (Throwable)e);
        }
        finally {
            try {
                if (wf != null) {
                    wf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String toClassName(Model model) {
        return "com.gtis.archive.entity." + model.getName();
    }
}

