/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.generater;

import com.gtis.archive.core.Model;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCodeGenerater {
    public static final ModelCodeGenerater JAVA = new ModelCodeGenerater("tpl/javaGenerate.ftl");
    public static final ModelCodeGenerater GROOVY = new ModelCodeGenerater("tpl/groovyGenerate.ftl");
    private static Configuration cfg = new Configuration();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Template template;

    public ModelCodeGenerater(String templateLocation) {
        try {
            this.template = new Template(null, (Reader)new InputStreamReader(this.getClass().getResource(templateLocation).openStream()), cfg);
        }
        catch (IOException e) {
            this.logger.error("load modelCodeGenerater template error", (Throwable)e);
        }
    }

    public String generate(Model model) {
        StringWriter result = new StringWriter();
        this.generate(model, (Writer)result);
        return result.toString();
    }

    public void generate(Model model, Writer write) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", model);
        map.put("now", new Date());
        try {
            this.template.process(map, write);
        }
        catch (Exception e) {
            this.logger.error("generate model:[{}] error:[{}]", (Object)model, (Object)e);
        }
    }

    static {
        cfg.setDateFormat("yyyy-MM-dd");
        cfg.setTimeFormat("HH:mm:ss");
        cfg.setNumberFormat("0.######");
    }
}

