package com.gtis.archive.web;

import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.OriginalPermission;
import com.gtis.archive.service.OriginalPermissionService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLDecoder;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-27
 */
@InterceptorRefs({@InterceptorRef(value = "fileUpload", params = {"maximumSize", "5368709120"}), @InterceptorRef(value = "defaultStack")})
public class OgAction extends BaseModelAction<Original> {
    private static final Logger logger = LoggerFactory.getLogger(OgAction.class);

    @Autowired
    private OriginalService originalService;
    @Autowired
    private OriginalPermissionService originalPermissionService;
    @Autowired
    private SysUserService sysUserService;
    /**
     * 所有者id
     */
    private String ownerId;
    /**
     * 是否预览模式
     */
    private boolean preview;
    /**
     * 上传的文件
     */
    private File filedata;
    /**
     * 上传的文件名
     */
    private String filename;
    /**
     * 权限
     */
    private OriginalPermission op;
    /**
     * 下载,查看还是打印
     */
    private String action = "download";

    public void setNid(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setFiledata(File filedata) {
        this.filedata = filedata;
    }

    public void setFile(File filedata) {
        this.filedata = filedata;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setFileFileName(String filename) {
        this.filename = filename;
    }

    public void setOp(OriginalPermission op) {
        this.op = op;
    }

    public OriginalPermission getOp() {
        return op;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String remove() throws Exception {
        originalService.removeOriginal(ids);
        return null;
    }

    /**
     * 上传flash检查重名用
     *
     * @return 重名列表
     */
    public String check() {
        Struts2Utils.renderHtml("{}");
        return null;
    }

    public String get() throws Exception {
        try {
            String id = getId();
            if (!originalPermissionService.hasOriginalPermission(id) && !preview)
                return null;
            HttpServletResponse response = ServletActionContext.getResponse();
            Original original = originalService.getOriginal(id);
            if(original.isImage())
                response.setContentType("image/" + original.getExtension());
            else if(original.isXOffice())
                response.setContentType("application/vnd.openxmlformats");
            else
                response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", (preview ? "inline" : "attachment") + "; filename=\"" + new String(original.getName().getBytes("gbk"), "iso8859-1") + "\"");
            sendFile(originalService.getOriginalFile(id, action));
        } catch (Throwable e) {
            logger.error("Get error", e);
        }
        return null;
    }

    /**
     * 多文件打包下载
     * @return
     */
    public String getBatch() throws Exception{
        byte[] buffer = new byte[1024];
        String fileName=System.currentTimeMillis()+".zip";
        String zipPath=EnvHolder.getAppEnv().getExpr(EnvHolder.getAppEnv().getProps().get("originalRoot").toString())
                +"/tempZip/"+fileName;
        String zipRootPath=EnvHolder.getAppEnv().getExpr(EnvHolder.getAppEnv().getProps().get("originalRoot").toString())
                +"/tempZip/";
        File tempFile=new File(zipRootPath);
        if(!tempFile.exists()){
            tempFile.mkdirs();
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipPath));
        for(String id:ids[0].split(",")){
            File file=originalService.getOriginalFile(id, action);
            FileInputStream fis = new FileInputStream(file);
            zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
            int len;
            while((len = fis.read(buffer))>0) {
                zipOutputStream.write(buffer,0,len);
            }
            zipOutputStream.closeEntry();
            fis.close();
        }
        zipOutputStream.close();
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", (preview ? "inline" : "attachment") + "; filename=\"" + new String(fileName.getBytes("gbk"), "iso8859-1") + "\"");
        sendFile(new File(zipPath));
        File file=new File(zipPath);
        if(file.exists()){
            file.delete();
        }
        return null;
    }

    public String preview() throws Exception {
        List<Original> ogs = getEntities();
        Document doc = DocumentHelper.createDocument();
        Element files = doc.addElement("files");
        String id = getId();
        String baseUrl = "${.vars['archive.url']}/og!get.action;jsessionid=" + ServletActionContext.getRequest().getSession().getId() + "?preview=true&id=";
        for (Original og : ogs) {
            String url = EnvHolder.getAppEnv().getExpr(baseUrl + og.getId());
            Element file = files.addElement("file").addAttribute("name", og.getName()).addAttribute("url", url);
            if (og.getId().equals(id))
                file.addAttribute("iscurrent", "true");
        }
        Struts2Utils.renderXml(doc.asXML());
        return null;
    }

    public String upload() {
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            if(filename!=null){
                Original original = new Original();
                original.setOwnerId(ownerId);
                original.setName(URLDecoder.decode(filename,"UTF-8"));
                originalService.saveOriginalFile(original, filedata, false);
                originalService.saveOriginal(original);
                map.put("type", 0);
            }else{
                throw  new RuntimeException("获取上传文件名异常，请稍后再试");
            }
        } catch (Exception e) {
            map.put("type", 5);
            logger.error("upload error", e);
        }
        if (filedata != null)
            filedata.delete();
        renderJson(map);
        return null;
    }

    public String thumb() throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        Original original = originalService.getOriginal(getId());
        response.setContentType("image/" + original.getExtension());
        File file = originalService.getOriginalThumbFile(original.getId());
        if (file!=null && file.exists()) {
            sendFile(file);
        } else {
            response.sendRedirect("img/no-thumb.gif");
        }
        return null;
    }

    public String print() throws Exception {
        return "print";
    }

    public String listPermission() {
        List<OriginalPermission> ops = originalPermissionService.getOriginalPermissions(getId());
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("items", ops);
        Struts2Utils.renderJson(map);
        return null;
    }

    public String listUsers() {
        List<PfUserVo> list = sysUserService.getAllUsers();
        List<Map<String, Object>> users = new ArrayList<Map<String, Object>>(list.size());
        for (PfUserVo user : list) {
            if (StringUtils.isNotBlank(query) && !user.getUserName().contains(query))
                continue;
            Map<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("userId", user.getUserId());
            map.put("userName", user.getUserName());
            users.add(map);
        }
        Struts2Utils.renderJson(users);
        return null;
    }

    public String addPermission() {
        originalPermissionService.saveOriginalPermission(op);
        return renderSuccess();
    }

    public String removePermission() {
        for (String id : ids) {
            originalPermissionService.removeOriginalPermission(id);
        }
        return renderSuccess();
    }

    public String link() {
        String id = getId();
        List<Map<Object, Serializable>> list = new ArrayList<Map<Object, Serializable>>();
        try {
            File root = ResourceUtils.getFile(EnvHolder.getAppEnv().get("myOriginalPath"));
            File path = ResourceUtils.getFile(root.getAbsolutePath() + "/" + ("root".equals(id) ? "" : id));
            for (File f : path.listFiles()) {
                Map<Object, Serializable> map = new HashMap<Object, Serializable>();
                map.put("id", f.getAbsolutePath().substring(root.getAbsolutePath().length() + 1));
                map.put("text", f.getName());
                map.put("leaf", !f.isDirectory());
                map.put("checked", false);
                list.add(map);
            }
        } catch (FileNotFoundException e) {
            logger.error("错误,linkOriginalPath没有设置,无法关联文件", e.getMessage());
        }
        Struts2Utils.renderJson(list);
        return null;
    }

    public String saveLink() {
        List<Original> originals = originalService.getOriginals(ownerId);
        Set<String> ogNames = new HashSet<String>();
        for (Original og : originalService.getOriginals(ownerId)) {
            ogNames.add(og.getPath());
        }
        try {
            File root = ResourceUtils.getFile(EnvHolder.getAppEnv().get("myOriginalPath"));
            for (String id : ids) {
                File file = new File(root, id);
                if (file.isDirectory())
                    continue;
                String path = "${myOriginalPath}/" + file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1);
                if (ogNames.contains(path))
                    continue;
                Original original = new Original();
                original.setName(file.getName());
                original.setPath(path);
                original.setFileSize(file.length());
                original.setOwnerId(ownerId);
                originalService.saveOriginal(original);
            }
        } catch (FileNotFoundException ignored) {
        }
        return null;
    }

    @Override
    protected Page<Original> searchEntity(List<Criterion> criterions, List<Order> orders) {
        return originalService.searchOriginal(ownerId, query, start, limit);
    }

    /**
     * 获取所有的原文id
     * @return
     */
    public String allIds(){
        if(StringUtils.isBlank(ownerId))return null;
        Struts2Utils.renderJson(originalService.getIds(ownerId));
        return null;
    }


}
