/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core;

import java.util.HashSet;
import java.util.Set;

public class ExtendedStringBuilder {
    private static final String INDENTATION = "  ";
    private static final char SPACE = ' ';
    private static final Set<Character> SEPARATORS = new HashSet<Character>();
    private StringBuilder builder = new StringBuilder();
    private int indentationLevel;
    private boolean onNewLine = true;

    public ExtendedStringBuilder() {
        this("");
    }

    public ExtendedStringBuilder(String string) {
        this.builder = new StringBuilder(string);
    }

    public ExtendedStringBuilder(ExtendedStringBuilder otherBuilder) {
        this.configureFrom(otherBuilder);
    }

    public void configureFrom(ExtendedStringBuilder otherBuilder) {
        this.indentationLevel = otherBuilder.indentationLevel;
        this.onNewLine = otherBuilder.onNewLine;
    }

    public ExtendedStringBuilder appendAsIs(String string) {
        this.builder.append(string);
        return this;
    }

    public ExtendedStringBuilder append(boolean arg0) {
        this.handleIndentation();
        this.builder.append(arg0);
        return this;
    }

    public ExtendedStringBuilder append(char c) {
        this.handleIndentation();
        this.builder.append(c);
        return this;
    }

    public ExtendedStringBuilder append(char[] str, int offset, int len) {
        this.handleIndentation();
        this.builder.append(str, offset, len);
        return this;
    }

    public ExtendedStringBuilder append(char[] str) {
        this.handleIndentation();
        this.builder.append(str);
        return this;
    }

    public ExtendedStringBuilder append(CharSequence s, int start, int end) {
        this.handleIndentation();
        this.builder.append(s, start, end);
        return this;
    }

    public ExtendedStringBuilder append(CharSequence s) {
        this.handleIndentation();
        this.builder.append(s);
        return this;
    }

    public ExtendedStringBuilder append(double d) {
        this.handleIndentation();
        this.builder.append(d);
        return this;
    }

    public ExtendedStringBuilder append(float f) {
        this.handleIndentation();
        this.builder.append(f);
        return this;
    }

    public ExtendedStringBuilder append(int i) {
        this.handleIndentation();
        this.builder.append(i);
        return this;
    }

    public ExtendedStringBuilder append(long lng) {
        this.handleIndentation();
        this.builder.append(lng);
        return this;
    }

    public ExtendedStringBuilder append(Object obj) {
        this.handleIndentation();
        this.builder.append(obj);
        return this;
    }

    public ExtendedStringBuilder append(String str) {
        this.handleIndentation();
        this.builder.append(str);
        return this;
    }

    public ExtendedStringBuilder append(StringBuffer sb) {
        this.handleIndentation();
        this.builder.append(sb);
        return this;
    }

    public ExtendedStringBuilder appendIgnoreNull(CharSequence s) {
        if (s != null) {
            this.handleIndentation();
            this.builder.append(s);
        }
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    public ExtendedStringBuilder ensureNewLine() {
        if (!this.onNewLine) {
            this.newLine();
        }
        return this;
    }

    public ExtendedStringBuilder newLine() {
        this.builder.append("\n");
        this.onNewLine = true;
        return this;
    }

    public void increaseIndentationLevel() {
        ++this.indentationLevel;
    }

    public void decreaseIndentationLevel() {
        --this.indentationLevel;
        if (this.indentationLevel < 0) {
            this.indentationLevel = 0;
        }
    }

    private void handleIndentation() {
        if (this.onNewLine()) {
            this.onNewLine = false;
            for (int i = 0; i < this.indentationLevel; ++i) {
                this.builder.append(INDENTATION);
            }
        }
    }

    private boolean onNewLine() {
        return this.onNewLine;
    }

    public ExtendedStringBuilder ensureSeparator() {
        if (this.onNewLine() || this.endsWithSeparator()) {
            return this;
        }
        this.builder.append(' ');
        return this;
    }

    public boolean endsWithSeparator() {
        int length = this.builder.length() - 1;
        if (length < 0) {
            return false;
        }
        return SEPARATORS.contains(Character.valueOf(this.builder.charAt(length)));
    }

    static {
        SEPARATORS.add(Character.valueOf(' '));
        SEPARATORS.add(Character.valueOf(';'));
        SEPARATORS.add(Character.valueOf('('));
    }
}

