/*
 * Decompiled with CFR 0.152.
 */
package apijson.column;

import apijson.RequestMethod;
import apijson.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ColumnUtil {
    public static final Map<Integer, Map<String, List<String>>> VERSIONED_TABLE_COLUMN_MAP = new HashMap<Integer, Map<String, List<String>>>();
    public static final Map<Integer, Map<String, Map<String, String>>> VERSIONED_KEY_COLUMN_MAP = new HashMap<Integer, Map<String, Map<String, String>>>();
    private static Map<Integer, Map<String, Map<String, String>>> VERSIONED_COLUMN_KEY_MAP = new HashMap<Integer, Map<String, Map<String, String>>>();

    public static void init() {
        VERSIONED_COLUMN_KEY_MAP.clear();
        Set<Map.Entry<Integer, Map<String, Map<String, String>>>> set = VERSIONED_KEY_COLUMN_MAP.entrySet();
        if (set != null && !set.isEmpty()) {
            HashMap<Integer, Map<String, Map<String, String>>> map = new HashMap<Integer, Map<String, Map<String, String>>>();
            for (Map.Entry<Integer, Map<String, Map<String, String>>> entry : set) {
                Map<String, Map<String, String>> tableKeyColumnMap = entry == null ? null : entry.getValue();
                Set<Map.Entry<String, Map<String, String>>> tableKeyColumnSet = tableKeyColumnMap == null ? null : tableKeyColumnMap.entrySet();
                if (tableKeyColumnSet == null || tableKeyColumnSet.isEmpty()) continue;
                HashMap tableColumnKeyMap = new HashMap();
                for (Map.Entry<String, Map<String, String>> tableKeyColumnEntry : tableKeyColumnSet) {
                    Map<String, String> keyColumnMap = tableKeyColumnEntry == null ? null : tableKeyColumnEntry.getValue();
                    Set<Map.Entry<String, String>> keyColumnSet = keyColumnMap == null ? null : keyColumnMap.entrySet();
                    if (keyColumnSet == null || keyColumnSet.isEmpty()) continue;
                    HashMap<String, String> columnKeyMap = new HashMap<String, String>();
                    for (Map.Entry<String, String> keyColumnEntry : keyColumnSet) {
                        if (keyColumnEntry == null) continue;
                        columnKeyMap.put(keyColumnEntry.getValue(), keyColumnEntry.getKey());
                    }
                    tableColumnKeyMap.put(tableKeyColumnEntry.getKey(), columnKeyMap);
                }
                map.put(entry.getKey(), tableColumnKeyMap);
            }
            VERSIONED_COLUMN_KEY_MAP = map;
        }
    }

    public static List<String> compatInputColumn(List<String> columns, String table, RequestMethod method) {
        return ColumnUtil.compatInputColumn(columns, table, method, null);
    }

    public static List<String> compatInputColumn(List<String> columns, String table, RequestMethod method, Integer version) {
        List<String> allColumns;
        String[] keys;
        String[] stringArray = keys = columns == null ? null : columns.toArray(new String[0]);
        if (keys == null || keys.length <= 0) {
            return columns;
        }
        ArrayList<String> exceptColumns = new ArrayList<String>();
        ArrayList<String> newColumns = new ArrayList<String>();
        Map<String, Map<String, String>> tableKeyColumnMap = VERSIONED_KEY_COLUMN_MAP == null || VERSIONED_KEY_COLUMN_MAP.isEmpty() ? null : VERSIONED_KEY_COLUMN_MAP.get(version);
        Map<String, String> keyColumnMap = tableKeyColumnMap == null || tableKeyColumnMap.isEmpty() ? null : tableKeyColumnMap.get(table);
        for (int i = 0; i < keys.length; ++i) {
            String expression = keys[i];
            if (expression.contains("(") || expression.contains(")")) {
                newColumns.add(expression);
                continue;
            }
            String[] ckeys = StringUtil.split((String)expression);
            if (ckeys == null || ckeys.length <= 0) continue;
            for (int j = 0; j < ckeys.length; ++j) {
                String ck = ckeys[j];
                if (ck.startsWith("!")) {
                    if (ck.length() <= 1) {
                        throw new IllegalArgumentException("@column:value \u7684 value \u4e2d " + ck + " \u4e0d\u5408\u6cd5\uff01 !column \u4e0d\u5141\u8bb8 column \u4e3a\u7a7a\u5b57\u7b26\u4e32\uff01column,!column2,!column3,column4:alias4 \u4e2d\u6240\u6709 column \u5fc5\u987b\u7b26\u5408\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
                    }
                    String c = ck.substring(1);
                    if (!StringUtil.isName((String)c)) {
                        throw new IllegalArgumentException("@column:value \u7684 value \u4e2d " + c + " \u4e0d\u5408\u6cd5\uff01 column,!column2,!column3,column4:alias4 \u4e2d\u6240\u6709 column \u5fc5\u987b\u7b26\u5408\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
                    }
                    String rc = keyColumnMap == null || keyColumnMap.isEmpty() ? null : keyColumnMap.get(c);
                    exceptColumns.add(rc == null ? c : rc);
                    continue;
                }
                String rc = keyColumnMap == null || keyColumnMap.isEmpty() ? null : keyColumnMap.get(ck);
                newColumns.add(rc == null ? ck : rc);
            }
        }
        boolean isEmpty = exceptColumns == null || exceptColumns.isEmpty();
        Map<String, List<String>> map = isEmpty || VERSIONED_TABLE_COLUMN_MAP == null || VERSIONED_TABLE_COLUMN_MAP.isEmpty() ? null : VERSIONED_TABLE_COLUMN_MAP.get(version);
        List<String> list = allColumns = map == null || map.isEmpty() ? null : map.get(table);
        if (allColumns != null && !allColumns.isEmpty()) {
            for (String c : allColumns) {
                if (c == null || exceptColumns.contains(c)) continue;
                newColumns.add(c);
            }
        }
        return newColumns;
    }

    public static String compatInputKey(String key, String table, RequestMethod method) {
        return ColumnUtil.compatInputKey(key, table, method, null);
    }

    public static String compatInputKey(String key, String table, RequestMethod method, Integer version) {
        Map<String, Map<String, String>> tableKeyColumnMap = VERSIONED_KEY_COLUMN_MAP == null || VERSIONED_KEY_COLUMN_MAP.isEmpty() ? null : VERSIONED_KEY_COLUMN_MAP.get(version);
        Map<String, String> keyColumnMap = tableKeyColumnMap == null || tableKeyColumnMap.isEmpty() ? null : tableKeyColumnMap.get(table);
        String alias = keyColumnMap == null || keyColumnMap.isEmpty() ? null : keyColumnMap.get(key);
        return alias == null ? key : alias;
    }

    public static String compatOutputKey(String key, String table, RequestMethod method) {
        return ColumnUtil.compatOutputKey(key, table, method, null);
    }

    public static String compatOutputKey(String key, String table, RequestMethod method, Integer version) {
        Map<String, Map<String, String>> tableColumnKeyMap = VERSIONED_COLUMN_KEY_MAP == null || VERSIONED_COLUMN_KEY_MAP.isEmpty() ? null : VERSIONED_COLUMN_KEY_MAP.get(version);
        Map<String, String> columnKeyMap = tableColumnKeyMap == null || tableColumnKeyMap.isEmpty() ? null : tableColumnKeyMap.get(table);
        String alias = columnKeyMap == null || columnKeyMap.isEmpty() ? null : columnKeyMap.get(key);
        return alias == null ? key : alias;
    }

    public static String concat(String database, String schema, String datasource, String table) {
        return database + "-" + schema + "-" + datasource + "-" + table;
    }
}

