/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.entity;

import com.github.abel533.entity.BaseProvider;
import com.github.abel533.mapperhelper.EntityHelper;
import com.github.abel533.mapperhelper.MapperTemplate;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.reflection.MetaObject;

public class CommonProvider
extends BaseProvider {
    public String selectOne(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                if (entity != null) {
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        if (value == null) continue;
                        if (column.getJavaType().equals(String.class)) {
                            if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                            this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                            continue;
                        }
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String select(final Map<String, Object> params) {
        return new SQL(){
            {
                StringBuilder orderByClause;
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                if (entity != null) {
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        if (value == null) continue;
                        if (column.getJavaType().equals(String.class)) {
                            if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                            this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                            continue;
                        }
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
                if ((orderByClause = EntityHelper.getOrderByClause(entityClass)).length() > 0) {
                    this.ORDER_BY(orderByClause.toString());
                }
            }
        }.toString();
    }

    public String count(final Map<String, Object> params) {
        return new SQL(){
            {
                Class<?> entityClass;
                Object entity = CommonProvider.this.getEntity(params);
                if (entity instanceof Class) {
                    entityClass = (Class<?>)entity;
                    entity = null;
                } else {
                    entityClass = CommonProvider.this.getEntityClass(params);
                }
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT("count(*)");
                this.FROM(entityTable.getName());
                if (entity != null) {
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        if (value == null) continue;
                        if (column.getJavaType().equals(String.class)) {
                            if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                            this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                            continue;
                        }
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String selectByPrimaryKey(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                if (entityTable.getEntityClassPKColumns().size() == 1) {
                    EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(column.getProperty(), entity);
                    this.WHERE(column.getColumn() + "=#{key}");
                } else {
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String insert(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.INSERT_INTO(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    this.VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
                }
            }
        }.toString();
    }

    public String insertSelective(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.INSERT_INTO(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (!column.isId() && value == null) continue;
                    this.VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
                }
            }
        }.toString();
    }

    public String delete(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.DELETE_FROM(entityTable.getName());
                boolean hasValue = false;
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null) continue;
                    if (column.getJavaType().equals(String.class)) {
                        if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                        hasValue = true;
                        continue;
                    }
                    this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    hasValue = true;
                }
                if (!hasValue) {
                    throw new UnsupportedOperationException("delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u5168\u8868\u7684\u64cd\u4f5c!");
                }
            }
        }.toString();
    }

    public String deleteByPrimaryKey(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.DELETE_FROM(entityTable.getName());
                if (entityTable.getEntityClassPKColumns().size() == 1) {
                    EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(column.getProperty(), entity);
                    this.WHERE(column.getColumn() + "=#{key}");
                } else {
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String updateByPrimaryKey(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    if (column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                if (entityTable.getEntityClassPKColumns().size() == 1) {
                    EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                    this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                } else {
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String updateByPrimaryKeySelective(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null || column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                if (entityTable.getEntityClassPKColumns().size() == 1) {
                    EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                    this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                } else {
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String countByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT("count(*)");
                this.FROM(entityTable.getName());
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }

    public String deleteByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.DELETE_FROM(entityTable.getName());
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }

    public String selectByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                CommonProvider.this.applyWhere(this, example);
                CommonProvider.this.applyOrderBy(this, example, EntityHelper.getOrderByClause(entityClass).toString());
            }
        }.toString();
    }

    public String updateByExampleSelective(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }

    public String updateByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    if (column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }
}

