/*
 * Decompiled with CFR 0.152.
 */
package unitauto;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import unitauto.JSON;
import unitauto.Log;
import unitauto.NotNull;
import unitauto.StringUtil;

public class MethodUtil {
    public static final String TAG = "MethodUtil";
    public static String KEY_CODE = "code";
    public static String KEY_MSG = "msg";
    public static int CODE_SUCCESS = 200;
    public static int CODE_SERVER_ERROR = 500;
    public static String MSG_SUCCESS = "success";
    public static String KEY_REUSE = "reuse";
    public static String KEY_UI = "ui";
    public static String KEY_TIME = "time";
    public static String KEY_TIMEOUT = "timeout";
    public static String KEY_PACKAGE = "package";
    public static String KEY_THIS = "this";
    public static String KEY_CLASS = "class";
    public static String KEY_CONSTRUCTOR = "constructor";
    public static String KEY_TYPE = "type";
    public static String KEY_VALUE = "value";
    public static String KEY_WARN = "warn";
    public static String KEY_STATIC = "static";
    public static String KEY_NAME = "name";
    public static String KEY_METHOD = "method";
    public static String KEY_MOCK = "mock";
    public static String KEY_QUERY = "query";
    public static String KEY_RETURN = "return";
    public static String KEY_TIME_DETAIL = "time:start|duration|end";
    public static String KEY_CLASS_ARGS = "classArgs";
    public static String KEY_METHOD_ARGS = "methodArgs";
    public static String KEY_CALLBACK = "callback";
    public static String KEY_GLOBAL = "global";
    public static String KEY_CALL_LIST = "call()[]";
    public static String KEY_CALL_MAP = "call(){}";
    public static String KEY_PACKAGE_TOTAL = "packageTotal";
    public static String KEY_CLASS_TOTAL = "classTotal";
    public static String KEY_METHOD_TOTAL = "methodTotal";
    public static String KEY_PACKAGE_LIST = "packageList";
    public static String KEY_CLASS_LIST = "classList";
    public static String KEY_METHOD_LIST = "methodList";
    @NotNull
    public static InstanceGetter INSTANCE_GETTER = new InstanceGetter(){

        @Override
        public Object getInstance(@NotNull Class<?> clazz, List<Argument> classArgs, Boolean reuse) throws Exception {
            return MethodUtil.getInvokeInstance(clazz, classArgs, reuse);
        }
    };
    @NotNull
    public static ClassLoaderCallback CLASS_LOADER_CALLBACK = new ClassLoaderCallback(){

        @Override
        public Class<?> loadClass(String packageOrFileName, String className, boolean ignoreError) throws ClassNotFoundException, IOException {
            return MethodUtil.findClass(packageOrFileName, className, ignoreError);
        }

        @Override
        public List<Class<?>> loadClassList(String packageOrFileName, String className, boolean ignoreError, int limit, int offset) throws ClassNotFoundException, IOException {
            return MethodUtil.findClassList(packageOrFileName, className, ignoreError, limit, offset);
        }
    };
    @NotNull
    public static JSONCallback JSON_CALLBACK = new JSONCallback(){

        @Override
        public JSONObject newSuccessResult() {
            return MethodUtil.newSuccessResult();
        }

        @Override
        public JSONObject newErrorResult(Throwable e) {
            return MethodUtil.newErrorResult(e);
        }

        @Override
        public JSONObject parseJSON(String type, Object value) {
            return MethodUtil.parseJSON(type, value);
        }
    };
    @NotNull
    public static Map<Class<?>, InterfaceProxy> GLOBAL_CALLBACK_MAP = new HashMap();
    public static final Map<Class<?>, Map<Object, Object>> INSTANCE_MAP = new HashMap();
    public static final Map<String, Class<?>> PRIMITIVE_CLASS_MAP = new HashMap();
    public static final Map<String, Class<?>> BASE_CLASS_MAP = new HashMap();
    public static final Map<String, Class<?>> CLASS_MAP = new HashMap();
    public static final Map<Class<?>, Object> DEFAULT_TYPE_VALUE_MAP;

    public static JSONObject listMethod(String request) {
        JSONObject result;
        try {
            JSONObject req = MethodUtil.parseObject(request);
            if (req == null) {
                req = new JSONObject(true);
            }
            int query = req.getIntValue(KEY_QUERY);
            boolean mock = req.getBooleanValue(KEY_MOCK);
            String pkgName = req.getString(KEY_PACKAGE);
            String clsName = req.getString(KEY_CLASS);
            String methodName = req.getString(KEY_METHOD);
            JSONArray methodArgTypes = null;
            boolean allMethod = MethodUtil.isEmpty(methodName, true);
            Class[] argTypes = null;
            if (!allMethod && (methodArgTypes = req.getJSONArray("types")) != null && !methodArgTypes.isEmpty()) {
                argTypes = new Class[methodArgTypes.size()];
                for (int i = 0; i < methodArgTypes.size(); ++i) {
                    argTypes[i] = MethodUtil.getType(methodArgTypes.getString(i), null, true);
                }
            }
            JSONObject obj = MethodUtil.getMethodListGroupByClass(pkgName, clsName, methodName, argTypes, query, mock);
            result = JSON_CALLBACK.newSuccessResult();
            result.putAll((Map)obj);
        }
        catch (Throwable e) {
            e.printStackTrace();
            result = JSON_CALLBACK.newErrorResult(e);
        }
        return result;
    }

    public static void invokeMethod(String request, Object instance, Listener<JSONObject> listener) throws Exception {
        MethodUtil.invokeMethod(MethodUtil.parseObject(request), instance, listener);
    }

    public static void invokeMethod(JSONObject req, Object instance, final Listener<JSONObject> listener) throws Exception {
        if (req == null) {
            req = new JSONObject(true);
        }
        final String pkgName = req.getString(KEY_PACKAGE);
        final String clsName = req.getString(KEY_CLASS);
        String cttName = req.getString(KEY_CONSTRUCTOR);
        final String methodName = req.getString(KEY_METHOD);
        final long startTime = System.currentTimeMillis();
        try {
            InterfaceProxy globalInterfaceProxy;
            boolean static_ = req.getBooleanValue(KEY_STATIC);
            final long timeout = req.getLongValue(KEY_TIMEOUT);
            Object this_ = req.get((Object)KEY_THIS);
            List<Argument> clsArgs = MethodUtil.getArgList(req, KEY_CLASS_ARGS);
            List<Argument> methodArgs = MethodUtil.getArgList(req, KEY_METHOD_ARGS);
            Class<?> clazz = MethodUtil.getInvokeClass(pkgName, clsName);
            if (clazz == null) {
                throw new ClassNotFoundException("\u627e\u4e0d\u5230 " + pkgName + "." + clsName + " \u5bf9\u5e94\u7684\u7c7b\uff01");
            }
            if (this_ != null) {
                if (StringUtil.isNotEmpty(cttName, true) || clsArgs != null) {
                    throw new IllegalArgumentException(KEY_THIS + " \u4e0e " + KEY_CONSTRUCTOR + ", " + KEY_CLASS_ARGS + " \u4e24\u4e2a\u90fd\u4e0d\u80fd\u540c\u65f6\u4f20\uff01");
                }
                JSONObject obj = new JSONObject();
                obj.put(KEY_METHOD_ARGS, Arrays.asList(this_));
                List<Argument> mArgs = MethodUtil.getArgList(obj, KEY_METHOD_ARGS);
                Class[] types = new Class[1];
                Object[] args = new Object[1];
                MethodUtil.initTypesAndValues(mArgs, types, args, true, true);
                instance = args[0];
            }
            if (instance == null && !static_) {
                instance = StringUtil.isEmpty(cttName, true) ? INSTANCE_GETTER.getInstance(clazz, clsArgs, req.getBoolean(KEY_REUSE)) : MethodUtil.getInvokeResult(clazz, null, cttName, clsArgs, null, null);
            }
            if (timeout < 0L || timeout > 60000L) {
                throw new IllegalArgumentException("\u53c2\u6570 " + KEY_TIMEOUT + " \u7684\u503c\u4e0d\u5408\u6cd5\uff01\u53ea\u80fd\u5728 [0, 60000] \u8303\u56f4\u5185\uff01");
            }
            if (timeout > 0L) {
                final Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            timer.cancel();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        MethodUtil.completeWithError(pkgName, clsName, methodName, startTime, new TimeoutException("\u5904\u7406\u8d85\u65f6\uff0c\u5e94\u8be5\u5728\u671f\u671b\u65f6\u95f4 " + timeout + "ms \u5185\uff01"), listener);
                    }
                }, timeout, Long.MAX_VALUE);
            }
            boolean hasGlobalCallback = (globalInterfaceProxy = GLOBAL_CALLBACK_MAP.get(clazz)) != null;
            Set set = req.entrySet();
            for (Map.Entry e : set) {
                String key = e == null ? null : (String)e.getKey();
                JSONObject val = key != null && e.getValue() instanceof JSONObject ? (JSONObject)e.getValue() : null;
                int index = val == null || !key.endsWith(")") ? -1 : key.indexOf("(");
                if (index <= 0 || !StringUtil.isName(key.substring(0, index))) continue;
                final boolean isCb = val.getBooleanValue(KEY_CALLBACK);
                if (isCb) {
                    hasGlobalCallback = true;
                }
                if (globalInterfaceProxy == null) {
                    globalInterfaceProxy = new InterfaceProxy();
                }
                final JSONObject finalReq = req;
                final InterfaceProxy globalProxy = globalInterfaceProxy;
                globalInterfaceProxy.$_putCallback(key, new Listener<Object>(){

                    @Override
                    public void complete(Object data, Method method, InterfaceProxy proxy, Object ... extras) throws Exception {
                        Log.d(MethodUtil.TAG, "invokeMethod  LISTENER_QUEUE.poll " + method);
                        if (isCb && listener != null) {
                            finalReq.putAll((Map)((Object)globalProxy));
                            listener.complete(finalReq, method, proxy, extras);
                        }
                    }
                });
            }
            if (globalInterfaceProxy != null && !GLOBAL_CALLBACK_MAP.containsValue((Object)globalInterfaceProxy)) {
                GLOBAL_CALLBACK_MAP.put(clazz, globalInterfaceProxy);
            }
            MethodUtil.invokeMethod(clazz, instance, pkgName, clsName, methodName, methodArgs, listener, hasGlobalCallback ? globalInterfaceProxy : null);
        }
        catch (Throwable e) {
            MethodUtil.completeWithError(pkgName, clsName, methodName, startTime, e, listener);
        }
    }

    public static void invokeMethod(Class<?> clazz, final Object instance, String pkgName, String clsName, String methodName, List<Argument> methodArgs, final Listener<JSONObject> listener, InterfaceProxy globalInterfaceProxy) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            MethodUtil.getInvokeResult(clazz, instance, methodName, methodArgs, new Listener<JSONObject>(){

                @Override
                public void complete(JSONObject data, Method method, InterfaceProxy proxy, Object ... extras) throws Exception {
                    JSONObject result = JSON_CALLBACK.newSuccessResult();
                    if (data != null) {
                        result.putAll((Map)data);
                    }
                    if (instance != null) {
                        result.put(KEY_THIS, (Object)MethodUtil.parseJSON(instance.getClass(), instance));
                    }
                    if (listener != null) {
                        listener.complete(result);
                    }
                }
            }, globalInterfaceProxy);
        }
        catch (Throwable e) {
            MethodUtil.completeWithError(pkgName, clsName, methodName, startTime, e, listener);
        }
    }

    private static void completeWithError(String pkgName, String clsName, String methodName, long startTime, Throwable e, Listener<JSONObject> listener) {
        long endTime = System.currentTimeMillis();
        e.printStackTrace();
        if (e instanceof NoSuchMethodException) {
            e = new IllegalArgumentException("\u5b57\u7b26 " + methodName + " \u5bf9\u5e94\u7684\u65b9\u6cd5\u4e0d\u5728 " + pkgName + "." + clsName + " \u5185\uff01\n\u8bf7\u68c0\u67e5\u51fd\u6570\u540d\u548c\u53c2\u6570\u6570\u91cf\u662f\u5426\u4e0e\u5df2\u5b9a\u4e49\u7684\u51fd\u6570\u4e00\u81f4\uff01\n" + e.getMessage());
        }
        if (e instanceof InvocationTargetException) {
            Throwable te = ((InvocationTargetException)e).getTargetException();
            if (!MethodUtil.isEmpty(te.getMessage(), true)) {
                e = te instanceof Exception ? (Exception)te : new Exception(te.getMessage());
            }
            e = new IllegalArgumentException("\u5b57\u7b26 " + methodName + " \u5bf9\u5e94\u7684\u65b9\u6cd5\u4f20\u53c2\u7c7b\u578b\u9519\u8bef\uff01\n\u8bf7\u68c0\u67e5 key:value \u4e2dvalue\u7684\u7c7b\u578b\u662f\u5426\u6ee1\u8db3\u5df2\u5b9a\u4e49\u7684\u51fd\u6570\u7684\u8981\u6c42\uff01\n" + e.getMessage());
        }
        long duration = endTime - startTime;
        String throwName = e.getClass().getTypeName();
        Log.d(TAG, "getInvokeResult  " + pkgName + "." + clsName + "." + methodName + " throw " + throwName + "! endTime = " + endTime + ";  duration = " + duration + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n\n");
        JSONObject result = JSON_CALLBACK.newErrorResult(e);
        result.put(KEY_TIME_DETAIL, (Object)(startTime + "|" + duration + "|" + endTime));
        result.put("throw", (Object)throwName);
        result.put("cause", (Object)e.getCause());
        result.put("trace", (Object)e.getStackTrace());
        if (listener != null) {
            try {
                listener.complete(result);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static List<Argument> getArgList(JSONObject req, String arrKey) {
        JSONArray arr = req == null ? null : com.alibaba.fastjson.JSON.parseArray((String)req.getString(arrKey));
        ArrayList<Argument> list = null;
        if (arr != null && !arr.isEmpty()) {
            list = new ArrayList<Argument>();
            for (Object item : arr) {
                if (item instanceof Boolean || item instanceof Number || item instanceof Collection) {
                    list.add(new Argument(null, item));
                    continue;
                }
                if (item instanceof String) {
                    String str = (String)item;
                    int index = str.indexOf(":");
                    String type = index < 0 ? null : str.substring(0, index);
                    String value = index < 0 ? str : str.substring(index + 1);
                    list.add(new Argument(type, value));
                    continue;
                }
                list.add(item == null ? null : (Argument)com.alibaba.fastjson.JSON.parseObject((String)com.alibaba.fastjson.JSON.toJSONString(item), Argument.class));
            }
        }
        return list;
    }

    public static Class<?> getInvokeClass(String pkgName, String clsName) throws Exception {
        return CLASS_LOADER_CALLBACK.loadClass(pkgName, clsName, false);
    }

    public static Object getInvokeInstance(@NotNull Class<?> clazz, List<Argument> classArgs, Boolean reuse) throws Exception {
        Object instance;
        Objects.requireNonNull(clazz);
        Map<Object, Object> clsMap = INSTANCE_MAP.get(clazz);
        if (clsMap == null) {
            clsMap = new HashMap<Object, Object>();
            INSTANCE_MAP.put(clazz, clsMap);
        }
        String key = classArgs == null || classArgs.isEmpty() ? "" : com.alibaba.fastjson.JSON.toJSONString(classArgs);
        Object object = instance = reuse != null && reuse != false ? clsMap.get(key) : null;
        if (instance == null) {
            if (classArgs == null || classArgs.isEmpty()) {
                if (clazz.isAnnotation()) {
                    return clazz;
                }
                instance = clazz.isEnum() ? MethodUtil.getEnumInstance(clazz, null) : clazz.newInstance();
            } else {
                if (clazz.isEnum()) {
                    Object v;
                    Argument arg = classArgs.get(0);
                    String t = arg == null ? null : arg.getType();
                    Object object2 = v = arg == null ? null : arg.getValue();
                    if (classArgs.size() != 1 || v != null && !(v instanceof CharSequence) || t != null && !CharSequence.class.isAssignableFrom(MethodUtil.getType(t, v, true))) {
                        throw new IllegalArgumentException("enum " + clazz.getName() + " \u5bf9\u5e94\u7684 classArgs \u6570\u91cf\u53ea\u80fd\u662f 0 \u6216 1 \uff01\u4e14\u9009\u9879\u7c7b\u578b\u5fc5\u987b\u4e3a String\uff01");
                    }
                    return MethodUtil.getEnumInstance(clazz, v == null ? null : v.toString());
                }
                if (clazz.isAnnotation()) {
                    throw new IllegalArgumentException("@interface " + clazz.getName() + " \u6ca1\u6709\u6784\u9020\u53c2\u6570\uff0c\u5bf9\u5e94\u7684 classArgs \u6570\u91cf\u53ea\u80fd\u662f 0\uff01");
                }
                boolean exactContructor = false;
                for (int i = 0; i < classArgs.size(); ++i) {
                    Argument obj = classArgs.get(i);
                    if (obj == null || MethodUtil.isEmpty(obj.getType(), true)) continue;
                    exactContructor = true;
                    break;
                }
                Class[] classArgTypes = new Class[classArgs.size()];
                Object[] classArgValues = new Object[classArgs.size()];
                MethodUtil.initTypesAndValues(classArgs, classArgTypes, classArgValues, exactContructor);
                if (exactContructor) {
                    Constructor<?> constructor = clazz.getConstructor(classArgTypes);
                    instance = constructor.newInstance(classArgValues);
                } else {
                    Constructor<?>[] constructors = clazz.getConstructors();
                    if (constructors != null) {
                        for (int i = 0; i < constructors.length; ++i) {
                            if (constructors[i] == null || constructors[i].getParameterCount() != classArgValues.length) continue;
                            try {
                                constructors[i].setAccessible(true);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                            try {
                                instance = constructors[i].newInstance(classArgValues);
                                break;
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            if (instance == null) {
                throw new NullPointerException("\u627e\u4e0d\u5230 " + clazz.getName() + " \u4ee5\u53ca classArgs \u5bf9\u5e94\u7684\u6784\u9020\u65b9\u6cd5\uff01");
            }
            clsMap.put(key, instance);
        }
        return instance;
    }

    public static Object getEnumInstance(Enum em, String name) throws NoSuchFieldException {
        return MethodUtil.getEnumInstance(em == null ? null : em.getDeclaringClass(), name);
    }

    public static Object getEnumInstance(Class clazz, String name) throws NoSuchFieldException {
        T[] constants;
        T[] TArray = constants = clazz == null ? null : clazz.getEnumConstants();
        if (constants == null || constants.length < 0) {
            return null;
        }
        if (StringUtil.isEmpty(name, false)) {
            return constants[0];
        }
        for (int i = 0; i < constants.length; ++i) {
            if (!name.equals(constants[i].toString())) continue;
            return constants[i];
        }
        throw new NoSuchFieldException("enum " + clazz.getName() + " \u4e0d\u5b58\u5728 " + name + " \u8fd9\u4e2a\u503c\uff01");
    }

    public static LinkedHashMap<Integer, String> mapEnumConstants(Enum em) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return MethodUtil.mapEnumConstants(em.getDeclaringClass());
    }

    public static LinkedHashMap<Integer, String> mapEnumConstants(Class clazz) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        T[] objs;
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        Method toName = clazz.getMethod("toName", new Class[0]);
        Method toCode = clazz.getMethod("toCode", new Class[0]);
        for (Object obj : objs = clazz.getEnumConstants()) {
            map.put((Integer)toCode.invoke(obj, new Object[0]), (String)toName.invoke(obj, new Object[0]));
        }
        return map;
    }

    public static Method getInvokeMethod(@NotNull Class<?> clazz, @NotNull String methodName, List<Argument> methodArgs) throws Exception {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(methodName);
        Class[] types = null;
        Object[] args = null;
        if (methodArgs != null && !methodArgs.isEmpty()) {
            types = new Class[methodArgs.size()];
            args = new Object[methodArgs.size()];
            MethodUtil.initTypesAndValues(methodArgs, types, args, true);
        }
        return clazz.getMethod(methodName, types);
    }

    public static Object getInvokeResult(@NotNull Class<?> clazz, Object instance, @NotNull String methodName, List<Argument> methodArgs, final Listener<JSONObject> listener, InterfaceProxy globalInterfaceProxy) throws Exception {
        boolean isSync;
        Object[] args;
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(methodName);
        int size = methodArgs == null ? 0 : methodArgs.size();
        boolean isEmpty = size <= 0;
        final Class[] types = isEmpty ? null : new Class[size];
        Object[] objectArray = args = isEmpty ? null : new Object[size];
        if (!isEmpty) {
            MethodUtil.initTypesAndValues(methodArgs, types, args, true, false);
        }
        final Method method = clazz.getMethod(methodName, types);
        final long[] startTime = new long[]{System.currentTimeMillis()};
        Listener<Object> itemListener = new Listener<Object>(){

            @Override
            public void complete(Object data, Method m, InterfaceProxy proxy, Object ... extra) throws Exception {
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime[0];
                Log.d(MethodUtil.TAG, "getInvokeResult  " + method.toGenericString() + "; endTime = " + endTime + ";  duration = " + duration + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n\n");
                if (listener == null) {
                    return;
                }
                JSONObject result = new JSONObject(true);
                result.put(KEY_TYPE, (Object)MethodUtil.trimType(method.getReturnType()));
                result.put(KEY_RETURN, data);
                ArrayList<JSONObject> finalMethodArgs = null;
                if (types != null) {
                    finalMethodArgs = new ArrayList<JSONObject>();
                    for (int i = 0; i < types.length; ++i) {
                        Class t = types[i];
                        Object v = args[i];
                        try {
                            if (t.isArray() || Collection.class.isAssignableFrom(t) || GenericArrayType.class.isAssignableFrom(t)) {
                                if (t.getComponentType() != null && t.getComponentType().isInterface()) {
                                    v = com.alibaba.fastjson.JSON.parseArray((String)v.toString());
                                }
                            } else if (t.isInterface()) {
                                v = MethodUtil.parseObject(v.toString());
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finalMethodArgs.add(MethodUtil.parseJSON(t, v));
                    }
                }
                result.put(KEY_METHOD_ARGS, finalMethodArgs);
                result.put(KEY_TIME_DETAIL, (Object)(startTime[0] + "|" + duration + "|" + endTime));
                if (listener != null) {
                    listener.complete(result);
                }
            }
        };
        boolean bl = isSync = globalInterfaceProxy == null;
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                Class type = types[i];
                Object value = args[i];
                if (value instanceof InterfaceProxy || type != null && type.isInterface()) {
                    try {
                        Argument arg;
                        InterfaceProxy proxy = value instanceof InterfaceProxy ? (InterfaceProxy)((Object)value) : MethodUtil.cast(value, InterfaceProxy.class, ParserConfig.getGlobalInstance());
                        Set set = proxy.entrySet();
                        if (set != null) {
                            for (Map.Entry e : set) {
                                String key = e == null ? null : (String)e.getKey();
                                JSONObject val = key != null && e.getValue() instanceof JSONObject ? (JSONObject)e.getValue() : null;
                                int index = val == null || !key.endsWith(")") ? -1 : key.indexOf("(");
                                if (index <= 0 || !StringUtil.isName(key.substring(0, index)) || !val.getBooleanValue(KEY_CALLBACK)) continue;
                                proxy.$_putCallback(key, itemListener);
                            }
                        }
                        if ((arg = methodArgs.get(i)) != null && arg.getGlobal() != null && arg.getGlobal().booleanValue()) {
                            GLOBAL_CALLBACK_MAP.put(clazz, proxy);
                        }
                        args[i] = MethodUtil.cast((Object)proxy, type, ParserConfig.getGlobalInstance());
                        if (isSync) {
                            isSync = proxy.$_getCallbackMap().isEmpty();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                try {
                    args[i] = MethodUtil.cast(value, type, ParserConfig.getGlobalInstance());
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        startTime[0] = System.currentTimeMillis();
        Log.d(TAG, "getInvokeResult  " + method.toGenericString() + "; startTime = " + startTime[0] + "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n\n\n ");
        Object val = method.invoke(instance, args);
        if (isSync) {
            if (listener != null) {
                itemListener.complete(val);
            }
            return val;
        }
        return null;
    }

    public static JSONObject getMethodListGroupByClass(String pkgName, String clsName, String methodName, Class<?>[] argTypes, int query, boolean mock) throws Exception {
        JSONObject countObj;
        HashMap<String, JSONObject> packageMap;
        int methodTotal;
        int classTotal;
        int packageTotal;
        block17: {
            if (query != 0 && query != 1 && query != 2) {
                throw new IllegalArgumentException("query \u53d6\u503c\u53ea\u80fd\u662f [0, 1, 2] \u4e2d\u7684\u4e00\u4e2a\uff01 0-\u6570\u636e\uff0c1-\u603b\u6570\uff0c2-\u5168\u90e8");
            }
            boolean queryData = query != 1;
            boolean queryTotal = query != 0;
            pkgName = StringUtil.isEmpty(pkgName, true) ? null : StringUtil.getTrimedString(pkgName);
            clsName = StringUtil.isEmpty(clsName, true) ? null : StringUtil.getTrimedString(clsName);
            boolean allMethod = MethodUtil.isEmpty(methodName, true);
            List<Class<?>> allClassList = CLASS_LOADER_CALLBACK.loadClassList(pkgName, clsName, true);
            packageTotal = 0;
            classTotal = 0;
            methodTotal = 0;
            packageMap = new HashMap<String, JSONObject>();
            JSONArray packageList = null;
            countObj = new JSONObject(true);
            if (queryTotal) {
                countObj.put(KEY_PACKAGE_TOTAL, (Object)packageTotal);
                countObj.put(KEY_CLASS_TOTAL, (Object)classTotal);
                countObj.put(KEY_METHOD_TOTAL, (Object)methodTotal);
            }
            if (allClassList == null || allClassList.isEmpty()) break block17;
            packageList = new JSONArray(Math.max(10, allClassList.size() / 5));
            for (Class<?> cls : allClassList) {
                if (cls == null) continue;
                ++classTotal;
                int methodCount = 0;
                try {
                    JSONArray methodList;
                    JSONObject clsObj;
                    JSONArray classList;
                    boolean pkgNotExist;
                    JSONObject pkgObj;
                    block19: {
                        block18: {
                            String pkg = cls.getPackage().getName();
                            pkgObj = (JSONObject)packageMap.get(pkg);
                            boolean bl = pkgNotExist = pkgObj == null;
                            if (pkgNotExist) {
                                pkgObj = new JSONObject(true);
                                packageMap.put(pkg, pkgObj);
                            }
                            if (queryTotal) {
                                int clsCount = pkgObj.getIntValue(KEY_CLASS_TOTAL);
                                pkgObj.put(KEY_CLASS_TOTAL, (Object)(clsCount + 1));
                            }
                            pkgObj.put(KEY_PACKAGE, (Object)pkg);
                            classList = pkgObj.getJSONArray(KEY_CLASS_LIST);
                            if (classList == null) {
                                classList = new JSONArray();
                            }
                            clsObj = new JSONObject(true);
                            clsObj.put(KEY_CLASS, (Object)cls.getSimpleName());
                            clsObj.put(KEY_TYPE, (Object)MethodUtil.trimType(cls.getGenericSuperclass()));
                            methodList = null;
                            if (allMethod || argTypes == null) break block18;
                            methodList = queryData ? new JSONArray(1) : null;
                            JSONObject mObj = MethodUtil.parseMethodObject(cls.getMethod(methodName, argTypes), mock);
                            if (mObj == null || mObj.isEmpty()) break block19;
                            methodCount = 1;
                            if (methodList == null) break block19;
                            methodList.add((Object)mObj);
                            break block19;
                        }
                        Method[] methods = cls.getDeclaredMethods();
                        if (methods != null && methods.length > 0) {
                            methodList = queryData ? new JSONArray(methods.length) : null;
                            for (Method m : methods) {
                                JSONObject mObj;
                                String name;
                                String string = name = m == null ? null : m.getName();
                                if (MethodUtil.isEmpty(name, true) || name.contains("$") || name.length() < 2 || !allMethod && !methodName.equals(name) || (mObj = MethodUtil.parseMethodObject(m, mock)) == null || mObj.isEmpty()) continue;
                                ++methodCount;
                                if (methodList == null) continue;
                                methodList.add((Object)mObj);
                            }
                        }
                    }
                    if (queryTotal) {
                        clsObj.put(KEY_METHOD_TOTAL, (Object)methodCount);
                    }
                    if (methodList != null && !methodList.isEmpty()) {
                        clsObj.put(KEY_METHOD_LIST, (Object)methodList);
                    }
                    if (clsObj != null && !clsObj.isEmpty()) {
                        classList.add((Object)clsObj);
                    }
                    if (classList != null && !classList.isEmpty()) {
                        pkgObj.put(KEY_CLASS_LIST, (Object)classList);
                    }
                    if (pkgNotExist && pkgObj != null && !pkgObj.isEmpty()) {
                        packageList.add((Object)pkgObj);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                methodTotal += methodCount;
            }
            if (packageList != null && !packageList.isEmpty()) {
                countObj.put(KEY_PACKAGE_LIST, (Object)packageList);
            }
        }
        packageTotal = packageMap.size();
        if (query != 0) {
            countObj.put(KEY_PACKAGE_TOTAL, (Object)packageTotal);
            countObj.put(KEY_CLASS_TOTAL, (Object)classTotal);
            countObj.put(KEY_METHOD_TOTAL, (Object)methodTotal);
        }
        return countObj;
    }

    public static String dot2Separator(String name) {
        return name == null ? null : name.replaceAll("\\.", "\\".equals(File.separator) ? "\\\\" : File.separator);
    }

    public static String separator2dot(String name) {
        return name == null ? null : name.replaceAll("\\".equals(File.separator) ? "\\\\" : File.separator, ".");
    }

    public static void initTypesAndValues(List<Argument> methodArgs, Class<?>[] types, Object[] args, boolean defaultType) throws IllegalArgumentException, ClassNotFoundException, IOException {
        MethodUtil.initTypesAndValues(methodArgs, types, args, defaultType, true);
    }

    public static void initTypesAndValues(List<Argument> methodArgs, Class<?>[] types, Object[] args, boolean defaultType, boolean castValue2Type) throws IllegalArgumentException, ClassNotFoundException, IOException {
        MethodUtil.initTypesAndValues(methodArgs, types, args, defaultType, castValue2Type, null);
    }

    public static void initTypesAndValues(List<Argument> methodArgs, Class<?>[] types, Object[] args, boolean defaultType, boolean castValue2Type, Listener<Object> listener) throws IllegalArgumentException, ClassNotFoundException, IOException {
        if (methodArgs == null || methodArgs.isEmpty()) {
            return;
        }
        if (types == null || args == null) {
            throw new IllegalArgumentException("types == null || args == null !");
        }
        if (types.length != methodArgs.size() || args.length != methodArgs.size()) {
            throw new IllegalArgumentException("methodArgs.isEmpty() || types.length != methodArgs.size() || args.length != methodArgs.size() !");
        }
        for (int i = 0; i < methodArgs.size(); ++i) {
            Argument argObj = methodArgs.get(i);
            String typeName = argObj == null ? null : argObj.getType();
            Object value = argObj == null ? null : argObj.getValue();
            Class<?> type = MethodUtil.getType(typeName, value, defaultType);
            if (value == null) {
                try {
                    value = INSTANCE_GETTER.getInstance(type, null, argObj.getReuse());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (value != null && type != null && !value.getClass().equals(type)) {
                try {
                    if (type.isArray() || Collection.class.isAssignableFrom(type) || GenericArrayType.class.isAssignableFrom(type)) {
                        if (type.getComponentType() != null && type.getComponentType().isInterface()) {
                            List implList = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString((Object)value), InterfaceProxy.class);
                            value = implList;
                        }
                    } else if (type.isInterface()) {
                        InterfaceProxy proxy = (InterfaceProxy)((Object)com.alibaba.fastjson.JSON.parseObject((String)com.alibaba.fastjson.JSON.toJSONString((Object)value), InterfaceProxy.class));
                        proxy.$_setType(type);
                        value = proxy;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (castValue2Type) {
                    try {
                        value = MethodUtil.cast(value, type, ParserConfig.getGlobalInstance());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            types[i] = type;
            args[i] = value;
        }
    }

    public static JSONObject parseMethodObject(Method m, boolean mock) {
        if (m == null) {
            return null;
        }
        int mod = m.getModifiers();
        if (Modifier.isPrivate(mod) || Modifier.isProtected(mod)) {
            return null;
        }
        Type[] genericTypes = m.getGenericParameterTypes();
        Type[] types = m.getParameterTypes();
        JSONObject obj = new JSONObject(true);
        obj.put("name", (Object)m.getName());
        obj.put("parameterTypeList", (Object)MethodUtil.trimTypes(types));
        obj.put("genericParameterTypeList", (Object)MethodUtil.trimTypes(genericTypes));
        obj.put("returnType", (Object)MethodUtil.trimType(m.getReturnType()));
        obj.put("genericReturnType", (Object)MethodUtil.trimType(m.getGenericReturnType()));
        obj.put("static", (Object)Modifier.isStatic(m.getModifiers()));
        obj.put("exceptionTypeList", (Object)MethodUtil.trimTypes(m.getExceptionTypes()));
        obj.put("genericExceptionTypeList", (Object)MethodUtil.trimTypes(m.getGenericExceptionTypes()));
        if (mock && genericTypes != null && genericTypes.length > 0) {
            Object[] vs = new Object[genericTypes.length];
            for (int i = 0; i < genericTypes.length; ++i) {
                try {
                    vs[i] = MethodUtil.mockValue((Class)types[i], genericTypes[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            obj.put("parameterDefaultValueList", (Object)vs);
        }
        return obj;
    }

    public static Object mockValue(Class type) {
        return MethodUtil.mockValue(type, type);
    }

    public static Object mockValue(Class type, Type genericType) {
        int sign;
        if (type == null || type == Object.class || type == Void.TYPE || type == Void.class) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return Math.random() >= 0.5;
        }
        if (type == Boolean.class) {
            if (Math.random() < 0.4) {
                return false;
            }
            if (Math.random() > 0.6) {
                return true;
            }
            return null;
        }
        double r = Math.random();
        int n = sign = r > 0.1 ? 1 : -1;
        if (type == Character.TYPE || type == Character.class) {
            return Math.round(65535.0 * Math.random());
        }
        if (type == Byte.TYPE || type == Byte.class || type == Character.TYPE || type == Character.class) {
            return Math.round(127.0 * Math.random());
        }
        if (type == Short.TYPE || type == Short.class) {
            return Math.round(32767.0 * Math.random());
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (long)sign * Math.round((double)(sign < 0 ? 2 : 10) * Math.random());
        }
        if (type == Long.TYPE || type == Long.class) {
            return (long)sign * Math.round((double)(sign < 0 ? 10 : 100) * Math.random());
        }
        if (type == Float.TYPE || type == Float.class || type == Number.class) {
            return (double)(sign * (sign < 0 ? 10 : 100)) * Math.random();
        }
        if (type == Double.TYPE || type == Double.class) {
            return (double)(sign * (sign < 0 ? 10 : 100)) * Math.random();
        }
        try {
            if (CharSequence.class.isAssignableFrom(type)) {
                int size = (int)(r * 5.0);
                char[] cs = new char[size];
                for (int i = 0; i < size; ++i) {
                    cs[i] = (char)(65.0 + 57.0 * Math.random());
                }
                return String.valueOf(cs);
            }
            if (java.util.Date.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type)) {
                return new java.util.Date((long)((double)System.currentTimeMillis() * r));
            }
            if (Timestamp.class.isAssignableFrom(type) || java.security.Timestamp.class.isAssignableFrom(type)) {
                return new Timestamp((long)((double)System.currentTimeMillis() * r));
            }
            if (Map.class.isAssignableFrom(type)) {
                JSONObject obj = new JSONObject(true);
                Type[] ts = MethodUtil.getTypeArguments(type, genericType);
                Class mt = ts == null || ts.length < 2 || !(ts[1] instanceof Class) ? Integer.TYPE : (Class)ts[1];
                int i = 0;
                while ((double)i < r * 3.0) {
                    Object v = MethodUtil.mockValue(mt, ts[1]);
                    if (v != null) {
                        obj.put((String)MethodUtil.mockValue(String.class, String.class), v);
                    }
                    ++i;
                }
                return obj;
            }
            if (Collection.class.isAssignableFrom(type) || Array.class.isAssignableFrom(type) || type.isArray()) {
                JSONArray arr = new JSONArray();
                Type[] ts = MethodUtil.getTypeArguments(type, genericType);
                Class mt = ts == null || ts.length < 1 || !(ts[0] instanceof Class) ? Integer.TYPE : (Class)ts[0];
                int i = 0;
                while ((double)i < r * 5.0) {
                    Object v = MethodUtil.mockValue(mt, ts[0]);
                    if (v != null) {
                        arr.add(v);
                    }
                    ++i;
                }
                return arr;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (type.isInterface()) {
                Method[] ms = type.getMethods();
                if (ms != null) {
                    JSONObject mo = new JSONObject(true);
                    for (int j = 0; j < ms.length; ++j) {
                        String name = ms[j].getName();
                        if (StringUtil.isEmpty(name, true) || "toString".equals(name) || "equals".equals(name) || "hashCode".equals(name) || "clone".equals(name) || "getClass".equals(name) || "wait".equals(name) || "notify".equals(name) || "notifyAll".equals(name)) continue;
                        String key = name + "(" + StringUtil.getString(MethodUtil.trimTypes(ms[j].getGenericParameterTypes())) + ")";
                        JSONObject val = new JSONObject(true);
                        Class<?> rt = ms[j].getReturnType();
                        if (rt == null || rt == Void.TYPE || rt == Void.class) {
                            if (!(name.startsWith("get") || name.startsWith("set") || name.startsWith("add") || name.startsWith("put") || name.startsWith("remove"))) {
                                val.put(KEY_CALLBACK, (Object)true);
                            }
                        } else {
                            val.put(KEY_TYPE, (Object)MethodUtil.trimType(rt));
                            val.put(KEY_RETURN, rt.isInterface() ? new JSONObject() : MethodUtil.mockValue(rt, ms[j].getGenericReturnType()));
                        }
                        mo.put(key, (Object)val);
                    }
                    return mo;
                }
                return null;
            }
            Object v = com.alibaba.fastjson.JSON.parse((String)com.alibaba.fastjson.JSON.toJSONString((Object)INSTANCE_GETTER.getInstance(type, null)));
            return v;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Type[] getTypeArguments(Class clazz, Type genericType) {
        Type rt;
        Class<?> cp;
        if (clazz == null) {
            Class clazz2 = clazz = genericType instanceof Class ? (Class)genericType : null;
        }
        if (clazz == null) {
            return null;
        }
        if (genericType == null) {
            genericType = clazz;
        }
        Type[] ts = null;
        String tn = genericType.getTypeName();
        int index = tn.indexOf("<");
        if (index > 0) {
            if ((index = (tn = tn.substring(index + 1)).lastIndexOf(">")) <= 0) {
                return null;
            }
            String[] tns = StringUtil.split(tn = tn.substring(0, index), true);
            if (tns != null && tns.length > 0) {
                ts = new Type[tns.length];
                for (int i = 0; i < tns.length; ++i) {
                    try {
                        ts[i] = MethodUtil.getType(tns[i], null, false);
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return ts;
            }
        }
        if ((cp = clazz.getComponentType()) != null && cp instanceof Class) {
            return new Type[]{cp};
        }
        Type[] tps = clazz.getTypeParameters();
        if (tps != null && tps.length > 0) {
            return tps;
        }
        ParameterizedType pType = null;
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType && (rt = (pType = (ParameterizedType)type).getRawType()) != null && rt != Object.class && rt != Void.TYPE && rt != Void.class) {
            return new Type[]{rt};
        }
        Type[] typeArray = ts = pType == null ? null : pType.getActualTypeArguments();
        if (ts != null && ts.length > 0) {
            return ts;
        }
        return null;
    }

    public static JSONObject parseJSON(Class<?> type, Object value) {
        return JSON_CALLBACK.parseJSON(type == null ? (value == null ? "Object" : value.getClass().toGenericString()) : type.toGenericString(), value);
    }

    public static JSONObject parseJSON(String type, Object value) {
        JSONObject o = new JSONObject(true);
        o.put(KEY_TYPE, (Object)type);
        if (value == null || JSON.isBooleanOrNumberOrString(value) || value instanceof Enum) {
            o.put(KEY_VALUE, value);
        } else {
            try {
                o.put(KEY_VALUE, com.alibaba.fastjson.JSON.parse((String)com.alibaba.fastjson.JSON.toJSONString((Object)value)));
            }
            catch (Throwable e) {
                e.printStackTrace();
                o.put(KEY_VALUE, (Object)value.toString());
                o.put(KEY_WARN, (Object)e.getMessage());
            }
        }
        return o;
    }

    public static JSONObject newSuccessResult() {
        JSONObject result = new JSONObject(true);
        result.put(KEY_CODE, (Object)CODE_SUCCESS);
        result.put(KEY_MSG, (Object)MSG_SUCCESS);
        return result;
    }

    public static JSONObject newErrorResult(Throwable e) {
        JSONObject result = new JSONObject(true);
        result.put(KEY_CODE, (Object)CODE_SERVER_ERROR);
        result.put(KEY_MSG, (Object)e.getMessage());
        return result;
    }

    public static String[] trimTypes(Type[] types) {
        if (types != null && types.length > 0) {
            String[] names = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                names[i] = MethodUtil.trimType(types[i]);
            }
            return names;
        }
        return null;
    }

    public static String trimType(Type type) {
        return MethodUtil.trimType(type == null ? null : type.getTypeName());
    }

    public static String trimType(String name) {
        int n;
        if (name == null || "void".equals(name)) {
            return null;
        }
        Set<Map.Entry<String, Class<?>>> set = CLASS_MAP.entrySet();
        for (Map.Entry entry : set) {
            if (!name.equals(((Class)entry.getValue()).getTypeName())) continue;
            return (String)entry.getKey();
        }
        String child = "";
        while ((n = name.indexOf("<")) >= 0) {
            child = child + "<" + MethodUtil.trimType(name.substring(n + 1, name.lastIndexOf(">"))) + ">";
            name = name.substring(0, n);
            if (n >= 0) continue;
        }
        if (name.startsWith("java.lang.")) {
            name = name.substring("java.lang.".length());
        }
        if (name.startsWith("java.util.")) {
            name = name.substring("java.util.".length());
        }
        if (name.startsWith("com.alibaba.fastjson.")) {
            name = name.substring("com.alibaba.fastjson.".length());
        }
        return name + child;
    }

    public static Class<?> getType(String name, Object value, boolean defaultType) throws ClassNotFoundException, IOException {
        Class<Object> type = null;
        if (MethodUtil.isEmpty(name, true)) {
            if (value != null && defaultType) {
                type = value.getClass();
            }
        } else {
            int index = name.indexOf("<");
            String child = null;
            if (index >= 0) {
                child = name.substring(index + 1, name.lastIndexOf(">"));
                name = name.substring(0, index);
            }
            if ((type = CLASS_MAP.get(name)) == null) {
                index = name.lastIndexOf(".");
                type = CLASS_LOADER_CALLBACK.loadClass(index < 0 ? "" : name.substring(0, index), index < 0 ? name : name.substring(index + 1), defaultType);
                if (type != null) {
                    CLASS_MAP.put(name, type);
                }
            } else if (value != null && !StringUtil.isEmpty(child, true) && !"?".equals(child) && !"Object".equals(child) && Collection.class.isAssignableFrom(type)) {
                try {
                    Collection c = (Collection)value;
                    if (c != null && !c.isEmpty()) {
                        AbstractCollection nc = Queue.class.isAssignableFrom(type) || AbstractSequentialList.class.isAssignableFrom(type) ? new LinkedList() : (Vector.class.isAssignableFrom(type) ? new Stack() : (List.class.isAssignableFrom(type) ? new ArrayList(c.size()) : (SortedSet.class.isAssignableFrom(type) ? new TreeSet() : (Set.class.isAssignableFrom(type) ? new LinkedHashSet(c.size()) : new ArrayList(c.size())))));
                        for (Object o : c) {
                            if (o != null) {
                                Class<?> ct = MethodUtil.getType(child, o, true);
                                o = MethodUtil.cast(o, ct, ParserConfig.getGlobalInstance());
                            }
                            nc.add(o);
                        }
                        c.clear();
                        c.addAll(nc);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        if (type == null && defaultType) {
            type = Object.class;
        }
        return type;
    }

    public static <T> T cast(Object obj, Class<T> type, ParserConfig config) {
        if (type == null || obj == null || type.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (Collection.class.isAssignableFrom(type)) {
            Collection c = (Collection)obj;
            AbstractCollection nc = Queue.class.isAssignableFrom(type) || AbstractSequentialList.class.isAssignableFrom(type) ? new LinkedList() : (Vector.class.isAssignableFrom(type) ? new Stack() : (List.class.isAssignableFrom(type) ? new ArrayList(c.size()) : (SortedSet.class.isAssignableFrom(type) ? new TreeSet() : (Set.class.isAssignableFrom(type) ? new LinkedHashSet(c.size()) : new ArrayList(c.size())))));
            for (Object o : c) {
                nc.add(o);
            }
            return (T)nc;
        }
        return (T)TypeUtils.cast((Object)obj, type, (ParserConfig)config);
    }

    public static Class<?> findClass(String packageOrFileName, String className, boolean ignoreError) throws ClassNotFoundException, IOException {
        Class<?> clazz;
        Objects.requireNonNull(className);
        int index = className.indexOf("<");
        if (index >= 0) {
            className = className.substring(0, index);
        }
        if ((clazz = Class.forName(MethodUtil.isEmpty(packageOrFileName, true) ? className : packageOrFileName.replaceAll("/", ".") + "." + className)) != null) {
            return clazz;
        }
        List<Class<?>> list = CLASS_LOADER_CALLBACK.loadClassList(packageOrFileName, className, ignoreError, 1, 0);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    public static List<Class<?>> findClassList(String packageOrFileName, String className, boolean ignoreError, int limit, int offset) throws ClassNotFoundException, IOException {
        File file;
        int index;
        ArrayList list = new ArrayList();
        int n = index = className == null ? -1 : className.indexOf("<");
        if (index >= 0) {
            className = className.substring(0, index);
        }
        boolean allPackage = MethodUtil.isEmpty(packageOrFileName, true);
        boolean allName = MethodUtil.isEmpty(className, true);
        String fileName = allPackage ? File.separator : MethodUtil.dot2Separator(packageOrFileName);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            file = new File(loader.getResource(fileName).getFile());
        }
        catch (Throwable e) {
            if (ignoreError) {
                return null;
            }
            throw e;
        }
        File[] files = file.listFiles();
        if (files != null) {
            int count = 0;
            for (File f : files) {
                if (f.isDirectory()) {
                    List<Class<?>> childList;
                    if (!allPackage || (childList = MethodUtil.findClassList(f.getAbsolutePath(), className, ignoreError, limit, offset)) == null || childList.isEmpty()) continue;
                    list.addAll(childList);
                    continue;
                }
                String name = MethodUtil.trim(f.getName());
                if (name == null || !name.endsWith(".class") || (name = name.substring(0, name.length() - ".class".length())).isEmpty() || name.equals("package-info") || name.contains("$") || !allName && !className.equals(name)) continue;
                try {
                    Class<?> clazz = loader.loadClass(packageOrFileName.replaceAll("\\".equals(File.separator) ? "\\\\" : File.separator, "\\.") + "." + name);
                    list.add(clazz);
                    if (allName && (limit <= 0 || ++count < limit)) continue;
                    break;
                }
                catch (Throwable e) {
                    if (!ignoreError) {
                        throw e;
                    }
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public static boolean isEmpty(String s, boolean trim) {
        if (s == null) {
            return true;
        }
        if (trim) {
            s = s.trim();
        }
        return s.isEmpty();
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static JSONObject parseObject(Object obj) {
        return MethodUtil.parseObject(obj instanceof String ? (String)obj : com.alibaba.fastjson.JSON.toJSONString((Object)obj));
    }

    public static JSONObject parseObject(String json) {
        return (JSONObject)com.alibaba.fastjson.JSON.parseObject((String)json, JSONObject.class, (int)(com.alibaba.fastjson.JSON.DEFAULT_PARSER_FEATURE | Feature.OrderedField.getMask()), (Feature[])new Feature[0]);
    }

    static {
        PRIMITIVE_CLASS_MAP.put(Boolean.TYPE.getSimpleName(), Boolean.TYPE);
        PRIMITIVE_CLASS_MAP.put(Integer.TYPE.getSimpleName(), Integer.TYPE);
        PRIMITIVE_CLASS_MAP.put(Long.TYPE.getSimpleName(), Long.TYPE);
        PRIMITIVE_CLASS_MAP.put(Float.TYPE.getSimpleName(), Float.TYPE);
        PRIMITIVE_CLASS_MAP.put(Double.TYPE.getSimpleName(), Double.TYPE);
        BASE_CLASS_MAP.putAll(PRIMITIVE_CLASS_MAP);
        BASE_CLASS_MAP.put(Boolean.class.getSimpleName(), Boolean.class);
        BASE_CLASS_MAP.put(Integer.class.getSimpleName(), Integer.class);
        BASE_CLASS_MAP.put(Long.class.getSimpleName(), Long.class);
        BASE_CLASS_MAP.put(Float.class.getSimpleName(), Float.class);
        BASE_CLASS_MAP.put(Double.class.getSimpleName(), Double.class);
        BASE_CLASS_MAP.put(Number.class.getSimpleName(), Number.class);
        BASE_CLASS_MAP.put(String.class.getSimpleName(), String.class);
        BASE_CLASS_MAP.put(Object.class.getSimpleName(), Object.class);
        CLASS_MAP.putAll(BASE_CLASS_MAP);
        CLASS_MAP.put(boolean[].class.getSimpleName(), boolean[].class);
        CLASS_MAP.put(int[].class.getSimpleName(), int[].class);
        CLASS_MAP.put(long[].class.getSimpleName(), long[].class);
        CLASS_MAP.put(float[].class.getSimpleName(), float[].class);
        CLASS_MAP.put(double[].class.getSimpleName(), double[].class);
        CLASS_MAP.put(Array.class.getSimpleName(), Array.class);
        CLASS_MAP.put(Boolean[].class.getSimpleName(), Boolean[].class);
        CLASS_MAP.put(Integer[].class.getSimpleName(), Integer[].class);
        CLASS_MAP.put(Long[].class.getSimpleName(), Long[].class);
        CLASS_MAP.put(Float[].class.getSimpleName(), Float[].class);
        CLASS_MAP.put(Double[].class.getSimpleName(), Double[].class);
        CLASS_MAP.put(Number[].class.getSimpleName(), Number[].class);
        CLASS_MAP.put(String[].class.getSimpleName(), String[].class);
        CLASS_MAP.put(Object[].class.getSimpleName(), Object[].class);
        CLASS_MAP.put(Array[].class.getSimpleName(), Array[].class);
        CLASS_MAP.put(Collection.class.getSimpleName(), Collection.class);
        CLASS_MAP.put(AbstractCollection.class.getSimpleName(), AbstractCollection.class);
        CLASS_MAP.put(List.class.getSimpleName(), List.class);
        CLASS_MAP.put(AbstractList.class.getSimpleName(), AbstractList.class);
        CLASS_MAP.put(ArrayList.class.getSimpleName(), ArrayList.class);
        CLASS_MAP.put(AbstractSequentialList.class.getSimpleName(), AbstractSequentialList.class);
        CLASS_MAP.put(LinkedList.class.getSimpleName(), LinkedList.class);
        CLASS_MAP.put(Vector.class.getSimpleName(), Vector.class);
        CLASS_MAP.put(Stack.class.getSimpleName(), Stack.class);
        CLASS_MAP.put(Map.class.getSimpleName(), Map.class);
        CLASS_MAP.put(AbstractMap.class.getSimpleName(), AbstractMap.class);
        CLASS_MAP.put(HashMap.class.getSimpleName(), HashMap.class);
        CLASS_MAP.put(LinkedHashMap.class.getSimpleName(), LinkedHashMap.class);
        CLASS_MAP.put(SortedMap.class.getSimpleName(), SortedMap.class);
        CLASS_MAP.put(NavigableMap.class.getSimpleName(), NavigableMap.class);
        CLASS_MAP.put(TreeMap.class.getSimpleName(), TreeMap.class);
        CLASS_MAP.put(Set.class.getSimpleName(), Set.class);
        CLASS_MAP.put(AbstractSet.class.getSimpleName(), AbstractSet.class);
        CLASS_MAP.put(HashSet.class.getSimpleName(), HashSet.class);
        CLASS_MAP.put(LinkedHashSet.class.getSimpleName(), LinkedHashSet.class);
        CLASS_MAP.put(SortedSet.class.getSimpleName(), SortedSet.class);
        CLASS_MAP.put(NavigableSet.class.getSimpleName(), NavigableSet.class);
        CLASS_MAP.put(TreeSet.class.getSimpleName(), TreeSet.class);
        CLASS_MAP.put(com.alibaba.fastjson.JSON.class.getSimpleName(), com.alibaba.fastjson.JSON.class);
        CLASS_MAP.put(JSONObject.class.getSimpleName(), JSONObject.class);
        CLASS_MAP.put(JSONArray.class.getSimpleName(), JSONArray.class);
        DEFAULT_TYPE_VALUE_MAP = new HashMap();
    }

    public static class InterfaceProxy
    extends JSONObject {
        private static final long serialVersionUID = 1L;
        private Class<?> type;
        private Map<String, Listener<?>> callbackMap = new HashMap();

        public InterfaceProxy() {
            super(true);
        }

        public InterfaceProxy(int initialCapacity) {
            super(initialCapacity, true);
        }

        @JSONField(serialize=false, deserialize=false)
        public Class<?> $_getType() {
            return this.type;
        }

        @JSONField(serialize=false, deserialize=false)
        public InterfaceProxy $_setType(Class<?> type) {
            this.type = type;
            return this;
        }

        @NotNull
        @JSONField(serialize=false, deserialize=false)
        public Map<String, Listener<?>> $_getCallbackMap() {
            return this.callbackMap;
        }

        @JSONField(serialize=false, deserialize=false)
        public InterfaceProxy $_setCallbackMap(Map<String, Listener<?>> callbackMap) {
            this.callbackMap = callbackMap != null ? callbackMap : new HashMap();
            return this;
        }

        @JSONField(serialize=false, deserialize=false)
        public Listener<?> $_getCallback(String method) {
            return this.callbackMap.get(method);
        }

        @JSONField(serialize=false, deserialize=false)
        public InterfaceProxy $_putCallback(String method, Listener<?> callback) {
            this.callbackMap.put(method, callback);
            return this;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1) {
                Class<?> returnType = method.getReturnType();
                if (returnType != Void.TYPE) {
                    return this.onInvoke(proxy, method, args);
                }
                String name = null;
                JSONField annotation = method.getAnnotation(JSONField.class);
                if (annotation != null && annotation.name().length() != 0) {
                    name = annotation.name();
                }
                if (name == null) {
                    name = method.getName();
                    if (!name.startsWith("set")) {
                        return this.onInvoke(proxy, method, args);
                    }
                    if ((name = name.substring(3)).length() == 0) {
                        return this.onInvoke(proxy, method, args);
                    }
                }
                return this.onInvoke(proxy, method, args, true);
            }
            if (parameterTypes.length == 0) {
                Class<?> returnType = method.getReturnType();
                if (returnType == Void.TYPE) {
                    return this.onInvoke(proxy, method, args);
                }
                String name = null;
                JSONField annotation = method.getAnnotation(JSONField.class);
                if (annotation != null && annotation.name().length() != 0) {
                    name = annotation.name();
                }
                if (name == null) {
                    name = method.getName();
                    if (name.startsWith("get")) {
                        if ((name = name.substring(3)).length() == 0) {
                            return this.onInvoke(proxy, method, args);
                        }
                    } else if (name.startsWith("is")) {
                        if ((name = name.substring(2)).length() == 0) {
                            return this.onInvoke(proxy, method, args);
                        }
                    } else if (!name.startsWith("hashCode") && !name.startsWith("toString")) {
                        return this.onInvoke(proxy, method, args);
                    }
                }
                return this.onInvoke(proxy, method, args, true);
            }
            return this.onInvoke(proxy, method, args);
        }

        private Object onInvoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.onInvoke(proxy, method, args, false);
        }

        private Object onInvoke(Object proxy, Method method, Object[] args, boolean callSuper) throws Throwable {
            JSONArray cList;
            Object value;
            String name;
            String string = name = method == null ? null : method.getName();
            if (name == null) {
                return null;
            }
            String key = name + "(" + StringUtil.getString(MethodUtil.trimTypes(method.getGenericParameterTypes())) + ")";
            Object handlerValue = this.get(key);
            String type = null;
            Object object = value = callSuper ? super.invoke(proxy, method, args) : null;
            if (!callSuper) {
                if (Modifier.isStatic(method.getModifiers())) {
                    value = method.invoke(null, args);
                } else if (handlerValue instanceof JSONObject) {
                    JSONObject handler = (JSONObject)handlerValue;
                    value = handler.get((Object)KEY_RETURN);
                    type = handler.getString(KEY_TYPE);
                } else {
                    value = handlerValue;
                }
            }
            JSONObject methodObj = new JSONObject(true);
            methodObj.put(KEY_TIME, (Object)System.currentTimeMillis());
            methodObj.put(KEY_RETURN, value);
            ArrayList<JSONObject> finalMethodArgs = null;
            if (args != null) {
                finalMethodArgs = new ArrayList<JSONObject>();
                for (int i = 0; i < args.length; ++i) {
                    Object v = args[i];
                    String t = v == null ? "Object" : v.getClass().toGenericString();
                    finalMethodArgs.add(JSON_CALLBACK.parseJSON(t, v));
                }
            }
            methodObj.put(KEY_METHOD_ARGS, finalMethodArgs);
            JSONObject map = this.getJSONObject(KEY_CALL_MAP);
            if (map == null) {
                map = new JSONObject(true);
            }
            if ((cList = map.getJSONArray(key)) == null) {
                cList = new JSONArray();
            }
            cList.add(0, (Object)methodObj);
            map.put(key, (Object)cList);
            this.put(KEY_CALL_MAP, map);
            JSONObject methodObj2 = new JSONObject(true);
            methodObj2.put(KEY_METHOD, (Object)key);
            methodObj2.putAll((Map)methodObj);
            JSONArray list = this.getJSONArray(KEY_CALL_LIST);
            if (list == null) {
                list = new JSONArray();
            }
            list.add((Object)methodObj2);
            this.put(KEY_CALL_LIST, list);
            Listener<?> listener = this.$_getCallback(key);
            if (listener != null) {
                listener.complete(null);
            }
            try {
                value = MethodUtil.cast(value, MethodUtil.getType(type, value, true), ParserConfig.getGlobalInstance());
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (type == null) {
                    type = value == null ? "Object" : value.getClass().getName();
                }
                throw new IllegalArgumentException(key + " \u4e2d " + KEY_RETURN + " \u503c\u65e0\u6cd5\u8f6c\u4e3a " + type + "! " + e.getMessage());
            }
            return value;
        }
    }

    public static class Argument {
        private Boolean reuse;
        private String type;
        private Object value;
        private Boolean global;

        public Argument() {
        }

        public Argument(String type, Object value) {
            this.setType(type);
            this.setValue(value);
        }

        public Boolean getReuse() {
            return this.reuse;
        }

        public void setReuse(Boolean reuse) {
            this.reuse = reuse;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Boolean getGlobal() {
            return this.global;
        }

        public void setGlobal(Boolean global) {
            this.global = global;
        }
    }

    public static interface ClassLoaderCallback {
        public Class<?> loadClass(String var1, String var2, boolean var3) throws ClassNotFoundException, IOException;

        public List<Class<?>> loadClassList(String var1, String var2, boolean var3, int var4, int var5) throws ClassNotFoundException, IOException;

        default public List<Class<?>> loadClassList(String packageOrFileName, String className, boolean ignoreError) throws ClassNotFoundException, IOException {
            return this.loadClassList(packageOrFileName, className, ignoreError, 0, 0);
        }
    }

    public static interface JSONCallback {
        public JSONObject newSuccessResult();

        public JSONObject newErrorResult(Throwable var1);

        public JSONObject parseJSON(String var1, Object var2);
    }

    public static interface InstanceGetter {
        public Object getInstance(@NotNull Class<?> var1, List<Argument> var2, Boolean var3) throws Exception;

        default public Object getInstance(@NotNull Class<?> clazz, List<Argument> classArgs) throws Exception {
            return this.getInstance(clazz, classArgs, null);
        }
    }

    public static interface Listener<T> {
        public void complete(T var1, Method var2, InterfaceProxy var3, Object ... var4) throws Exception;

        default public void complete(T data) throws Exception {
            this.complete(data, null, null, new Object[0]);
        }
    }
}

