/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphicsio.ImageParamConverter;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.ByteOrderInputStream;
import org.freehep.util.io.FlateOutputStream;

public class DefineBitsLossless
extends DefinitionTag {
    protected int character;
    protected RenderedImage image;
    protected Color bkg;
    private byte[] imageBytes;
    public static final String rootKey = "org.freehep.graphicsio";
    public static final String COMPRESS_QUALITY = ".CompressQuality";
    public static final String PROGRESSIVE = ".Progressive";
    public static final String COMPRESS = ".Compress";
    public static final String COMPRESS_MODE = ".CompressMode";
    private static final String[] alwaysCompressedFormats = new String[]{"JPG".toLowerCase(), "JPEG".toLowerCase(), "GIF".toLowerCase()};

    public DefineBitsLossless(int id, Image image, Color bkg, ImageObserver observer) {
        this(id, ImageUtilities.createRenderedImage(image, observer, bkg), bkg);
    }

    public DefineBitsLossless(int id, RenderedImage image, Color bkg) {
        this();
        this.character = id;
        this.image = image;
        this.bkg = bkg;
    }

    public DefineBitsLossless() {
        super(20, 2);
    }

    protected DefineBitsLossless(int tagID, int version) {
        super(tagID, version);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineBitsLossless tag = new DefineBitsLossless();
        tag.read(tagID, swf, len, false);
        return tag;
    }

    protected void read(int tagID, SWFInputStream swf, int len, boolean hasAlpha) throws IOException {
        this.character = swf.readUnsignedShort();
        swf.getDictionary().put(this.character, this);
        int format = swf.readUnsignedByte();
        int width = swf.readUnsignedShort();
        int height = swf.readUnsignedShort();
        int colorTableSize = format == 3 ? swf.readUnsignedByte() + 1 : 0;
        InflaterInputStream zip = new InflaterInputStream(swf);
        ByteOrderInputStream bois = new ByteOrderInputStream(zip, true);
        int[][] colors = new int[colorTableSize][hasAlpha ? 4 : 3];
        int i = 0;
        while (i < colorTableSize) {
            colors[i][0] = zip.read();
            colors[i][1] = zip.read();
            colors[i][2] = zip.read();
            if (hasAlpha) {
                colors[i][3] = zip.read();
            }
            ++i;
        }
        BufferedImage bi = new BufferedImage(width, height, hasAlpha ? 2 : 1);
        WritableRaster raster = bi.getRaster();
        int[] rgba = new int[hasAlpha ? 4 : 3];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                switch (format) {
                    default: {
                        System.out.println("ERROR: unknown format in LossLess image: " + format);
                        return;
                    }
                    case 3: {
                        raster.setPixel(x, y, colors[bois.readUnsignedByte()]);
                        break;
                    }
                    case 4: {
                        if (hasAlpha) {
                            System.out.println("ERROR: unknown format in LossLess2 image: 4");
                            return;
                        }
                        bois.readUBits(1);
                        rgba[0] = (int)bois.readUBits(5);
                        rgba[1] = (int)bois.readUBits(5);
                        rgba[2] = (int)bois.readUBits(5);
                        raster.setPixel(x, y, rgba);
                        break;
                    }
                    case 5: {
                        if (hasAlpha) {
                            rgba[3] = bois.readUnsignedByte();
                        } else {
                            bois.readUnsignedByte();
                        }
                        rgba[0] = bois.readUnsignedByte();
                        rgba[1] = bois.readUnsignedByte();
                        rgba[2] = bois.readUnsignedByte();
                        raster.setPixel(x, y, rgba);
                    }
                }
                ++x;
            }
            ++y;
        }
        this.image = bi;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        this.write(tagID, swf, false);
    }

    protected void write(int tagID, SWFOutputStream swf, boolean hasAlpha) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.writeUnsignedByte(5);
        swf.writeUnsignedShort(this.image.getWidth());
        swf.writeUnsignedShort(this.image.getHeight());
        swf.write(this.getImageBytes());
    }

    public int getLength() throws IOException {
        return this.getImageBytes().length + 7;
    }

    private byte[] getImageBytes() throws IOException {
        if (this.imageBytes == null) {
            this.imageBytes = DefineBitsLossless.toByteArray(this.image, "RAW", "Flate", DefineBitsLossless.getRAWProperties(this.bkg, "*ARGB"));
        }
        return this.imageBytes;
    }

    public static UserProperties getRAWProperties(Color bkg, String code) {
        UserProperties result = new UserProperties();
        result.setProperty(RawImageWriteParam.BACKGROUND, bkg);
        result.setProperty(RawImageWriteParam.CODE, code);
        result.setProperty(RawImageWriteParam.PAD, 1);
        return result;
    }

    public static byte[] toByteArray(RenderedImage image, String format, String encoding, Properties props) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream os = bos;
        if ("ASCII85".equals(encoding) || "Flate-ASCII85".equals(encoding)) {
            os = new ASCII85OutputStream(os);
        }
        if ("Flate".equals(encoding) || "Flate-ASCII85".equals(encoding)) {
            os = new FlateOutputStream(os);
        }
        if (props == null) {
            props = new Properties();
        }
        DefineBitsLossless.writeImage(image, format.toLowerCase(), props, os);
        os.close();
        return bos.toByteArray();
    }

    public static void writeImage(RenderedImage image, String format, Properties properties, OutputStream os) throws IOException {
        ImageWriter writer = DefineBitsLossless.getPreferredImageWriter(format);
        if (writer == null) {
            throw new IOException(": No writer for format '" + format + "'.");
        }
        UserProperties user = new UserProperties(properties);
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (param instanceof ImageParamConverter) {
            param = ((ImageParamConverter)((Object)param)).getWriteParam(user);
        }
        String formatKey = "org.freehep.graphicsio." + format;
        if (param.canWriteCompressed()) {
            if (user.isProperty(String.valueOf(formatKey) + COMPRESS)) {
                if (user.getProperty(String.valueOf(formatKey) + COMPRESS_MODE).equals("")) {
                    param.setCompressionMode(1);
                } else {
                    param.setCompressionMode(2);
                    param.setCompressionType(user.getProperty(String.valueOf(formatKey) + COMPRESS_MODE));
                    param.setCompressionQuality(user.getPropertyFloat(String.valueOf(formatKey) + COMPRESS_QUALITY));
                }
            } else if (DefineBitsLossless.canWriteUncompressed(format)) {
                param.setCompressionMode(0);
            }
        }
        if (param.canWriteProgressive()) {
            if (user.isProperty(String.valueOf(formatKey) + PROGRESSIVE)) {
                param.setProgressiveMode(1);
            } else {
                param.setProgressiveMode(0);
            }
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(image, null, null), param);
        writer.dispose();
        ios.close();
    }

    public static boolean canWriteUncompressed(String format) {
        return !Arrays.asList(alwaysCompressedFormats).contains(format.toLowerCase());
    }

    public static ImageWriter getPreferredImageWriter(String format) {
        return (ImageWriter)DefineBitsLossless.getImageWriters(ImageIO.getImageWritersByFormatName(format)).first();
    }

    public static SortedSet getImageWriters(Iterator iterator) {
        TreeSet imageWriters = new TreeSet(new Comparator(){

            private int order(Object o) {
                String className = o.getClass().getName();
                if (className.startsWith("org.freehep.")) {
                    return 0;
                }
                if (className.startsWith("com.sun.imageio.")) {
                    return 1;
                }
                if (className.startsWith("com.sun.media.")) {
                    return 2;
                }
                return 3;
            }

            public int compare(Object arg0, Object arg1) {
                int order1;
                int order0 = this.order(arg0);
                return order0 < (order1 = this.order(arg1)) ? -1 : (order0 > order1 ? 1 : 0);
            }
        });
        while (iterator.hasNext()) {
            imageWriters.add(iterator.next());
        }
        return imageWriters;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(String.valueOf(super.toString()) + "\n");
        s.append("  character:  " + this.character);
        s.append("  image: " + this.image);
        return s.toString();
    }
}

