/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphicsio.ImageParamConverter;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.graphicsio.swf.DefineBitsJPEG2;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.FlateOutputStream;

public class DefineBitsJPEG3
extends DefineBitsJPEG2 {
    private byte[] imageBytes;
    private int imageLength;
    public static final String rootKey = "org.freehep.graphicsio";
    public static final String COMPRESS_QUALITY = ".CompressQuality";
    public static final String PROGRESSIVE = ".Progressive";
    public static final String COMPRESS = ".Compress";
    public static final String COMPRESS_MODE = ".CompressMode";
    private static final String[] alwaysCompressedFormats = new String[]{"JPG".toLowerCase(), "JPEG".toLowerCase(), "GIF".toLowerCase()};

    public DefineBitsJPEG3(int id, Image image, Properties options, Color bkg, ImageObserver observer) {
        this(id, ImageUtilities.createRenderedImage(image, observer, bkg), bkg, options);
    }

    public DefineBitsJPEG3(int id, RenderedImage image, Color bkg, Properties options) {
        this();
        this.character = id;
        this.image = image;
        this.options = options;
    }

    public DefineBitsJPEG3() {
        super(35, 3);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineBitsJPEG3 tag = new DefineBitsJPEG3();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        int jpegLen = (int)swf.readUnsignedInt();
        byte[] data = swf.readByte(jpegLen);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedImage bi = DefineBitsJPEG3.readImage("JPG".toLowerCase(), bais);
        if (bais.available() > 0) {
            System.err.println("DefineBitsJPEG3: not all bytes read: " + bais.available());
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        InflaterInputStream zip = new InflaterInputStream(swf);
        byte[] alpha = new byte[width * height];
        zip.read(alpha);
        WritableRaster raster = bi.getAlphaRaster();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                raster.setPixel(x, y, new int[]{alpha[y * width + x]});
                ++x;
            }
            ++y;
        }
        tag.image = bi;
        return tag;
    }

    public static BufferedImage readImage(String format, InputStream is) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(format.toLowerCase());
        if (!iterator.hasNext()) {
            throw new IOException(": No reader for format '" + format + "'.");
        }
        ImageReader reader = iterator.next();
        ImageInputStream iis = ImageIO.createImageInputStream(is);
        reader.setInput(iis, true);
        BufferedImage image = reader.read(0);
        reader.dispose();
        iis.close();
        return image;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.writeUnsignedInt(this.imageLength);
        swf.write(this.getImageBytes());
    }

    public int getLength() throws IOException {
        return this.getImageBytes().length + 2;
    }

    private byte[] getImageBytes() throws IOException {
        if (this.imageBytes == null) {
            byte[] jpgBytes = DefineBitsJPEG3.toByteArray(this.image, "JPG", null, null);
            this.imageLength = jpgBytes.length;
            byte[] rawBytes = DefineBitsJPEG3.toByteArray(this.image, "RAW", "Flate", DefineBitsJPEG3.getRAWProperties(Color.black, "A"));
            this.imageBytes = new byte[jpgBytes.length + rawBytes.length];
            System.arraycopy(jpgBytes, 0, this.imageBytes, 0, jpgBytes.length);
            System.arraycopy(rawBytes, 0, this.imageBytes, jpgBytes.length, rawBytes.length);
        }
        return this.imageBytes;
    }

    public static UserProperties getRAWProperties(Color bkg, String code) {
        UserProperties result = new UserProperties();
        result.setProperty(RawImageWriteParam.BACKGROUND, bkg);
        result.setProperty(RawImageWriteParam.CODE, code);
        result.setProperty(RawImageWriteParam.PAD, 1);
        return result;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(String.valueOf(super.toString()) + "\n");
        s.append("  character:   " + this.character + "\n");
        s.append("  image:      " + this.image + "\n");
        return s.toString();
    }

    public static byte[] toByteArray(RenderedImage image, String format, String encoding, Properties props) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream os = bos;
        if ("ASCII85".equals(encoding) || "Flate-ASCII85".equals(encoding)) {
            os = new ASCII85OutputStream(os);
        }
        if ("Flate".equals(encoding) || "Flate-ASCII85".equals(encoding)) {
            os = new FlateOutputStream(os);
        }
        if (props == null) {
            props = new Properties();
        }
        DefineBitsJPEG3.writeImage(image, format.toLowerCase(), props, os);
        os.close();
        return bos.toByteArray();
    }

    public static void writeImage(RenderedImage image, String format, Properties properties, OutputStream os) throws IOException {
        ImageWriter writer = DefineBitsJPEG3.getPreferredImageWriter(format);
        if (writer == null) {
            throw new IOException(": No writer for format '" + format + "'.");
        }
        UserProperties user = new UserProperties(properties);
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (param instanceof ImageParamConverter) {
            param = ((ImageParamConverter)((Object)param)).getWriteParam(user);
        }
        String formatKey = "org.freehep.graphicsio." + format;
        if (param.canWriteCompressed()) {
            if (user.isProperty(String.valueOf(formatKey) + COMPRESS)) {
                if (user.getProperty(String.valueOf(formatKey) + COMPRESS_MODE).equals("")) {
                    param.setCompressionMode(1);
                } else {
                    param.setCompressionMode(2);
                    param.setCompressionType(user.getProperty(String.valueOf(formatKey) + COMPRESS_MODE));
                    param.setCompressionQuality(user.getPropertyFloat(String.valueOf(formatKey) + COMPRESS_QUALITY));
                }
            } else if (DefineBitsJPEG3.canWriteUncompressed(format)) {
                param.setCompressionMode(0);
            }
        }
        if (param.canWriteProgressive()) {
            if (user.isProperty(String.valueOf(formatKey) + PROGRESSIVE)) {
                param.setProgressiveMode(1);
            } else {
                param.setProgressiveMode(0);
            }
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(image, null, null), param);
        writer.dispose();
        ios.close();
    }

    public static boolean canWriteUncompressed(String format) {
        return !Arrays.asList(alwaysCompressedFormats).contains(format.toLowerCase());
    }

    public static ImageWriter getPreferredImageWriter(String format) {
        return (ImageWriter)DefineBitsJPEG3.getImageWriters(ImageIO.getImageWritersByFormatName(format)).first();
    }

    public static SortedSet getImageWriters(Iterator iterator) {
        TreeSet imageWriters = new TreeSet(new Comparator(){

            private int order(Object o) {
                String className = o.getClass().getName();
                if (className.startsWith("org.freehep.")) {
                    return 0;
                }
                if (className.startsWith("com.sun.imageio.")) {
                    return 1;
                }
                if (className.startsWith("com.sun.media.")) {
                    return 2;
                }
                return 3;
            }

            public int compare(Object arg0, Object arg1) {
                int order1;
                int order0 = this.order(arg0);
                return order0 < (order1 = this.order(arg1)) ? -1 : (order0 > order1 ? 1 : 0);
            }
        });
        while (iterator.hasNext()) {
            imageWriters.add(iterator.next());
        }
        return imageWriters;
    }
}

