/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;
import org.bouncycastle.util.Store;
import org.bouncycastle.x509.X509Store;

public class SMIMESignedGenerator
extends SMIMEGenerator {
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String DIGEST_RIPEMD128 = TeleTrusTObjectIdentifiers.ripemd128.getId();
    public static final String DIGEST_RIPEMD160 = TeleTrusTObjectIdentifiers.ripemd160.getId();
    public static final String DIGEST_RIPEMD256 = TeleTrusTObjectIdentifiers.ripemd256.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1.getId();
    public static final String ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    public static final String ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS.getId();
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();
    private static final String CERTIFICATE_MANAGEMENT_CONTENT = "application/pkcs7-mime; name=smime.p7c; smime-type=certs-only";
    private static final String DETACHED_SIGNATURE_TYPE = "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data";
    private static final String ENCAPSULATED_SIGNED_CONTENT_TYPE = "application/pkcs7-mime; name=smime.p7m; smime-type=signed-data";
    private final String _defaultContentTransferEncoding;
    private List _certStores = new ArrayList();
    private List certStores = new ArrayList();
    private List crlStores = new ArrayList();
    private List attrCertStores = new ArrayList();
    private List signerInfoGens = new ArrayList();
    private List _signers = new ArrayList();
    private List _oldSigners = new ArrayList();
    private List _attributeCerts = new ArrayList();
    private Map _digests = new HashMap();

    private static MailcapCommandMap addCommands(CommandMap cm) {
        MailcapCommandMap mc = (MailcapCommandMap)cm;
        mc.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mc.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mc.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mc.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mc.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        return mc;
    }

    public SMIMESignedGenerator() {
        this._defaultContentTransferEncoding = "7bit";
    }

    public SMIMESignedGenerator(String defaultContentTransferEncoding) {
        this._defaultContentTransferEncoding = defaultContentTransferEncoding;
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException {
        this._signers.add(new Signer(key, cert, digestOID, null, null));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID) throws IllegalArgumentException {
        this._signers.add(new Signer(key, cert, encryptionOID, digestOID, null, null));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this._signers.add(new Signer(key, cert, digestOID, signedAttr, unsignedAttr));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this._signers.add(new Signer(key, cert, encryptionOID, digestOID, signedAttr, unsignedAttr));
    }

    public void addSigners(SignerInformationStore signerStore) {
        Iterator it = signerStore.getSigners().iterator();
        while (it.hasNext()) {
            this._oldSigners.add(it.next());
        }
    }

    public void addSignerInfoGenerator(SignerInfoGenerator sigInfoGen) {
        this.signerInfoGens.add(sigInfoGen);
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, SMIMEException {
        this._certStores.add(certStore);
    }

    public void addCertificates(Store certStore) {
        this.certStores.add(certStore);
    }

    public void addCRLs(Store crlStore) {
        this.crlStores.add(crlStore);
    }

    public void addAttributeCertificates(Store certStore) {
        this.attrCertStores.add(certStore);
    }

    public void addAttributeCertificates(X509Store store) throws CMSException {
        this._attributeCerts.add(store);
    }

    private void addHashHeader(StringBuffer header, List signers) {
        int count = 0;
        Iterator it = signers.iterator();
        HashSet<String> micAlgs = new HashSet<String>();
        while (it.hasNext()) {
            Object signer = it.next();
            String digestOID = signer instanceof Signer ? ((Signer)signer).getDigestOID() : (signer instanceof SignerInformation ? ((SignerInformation)signer).getDigestAlgOID() : ((SignerInfoGenerator)signer).getDigestAlgorithm().getAlgorithm().getId());
            if (digestOID.equals(DIGEST_SHA1)) {
                micAlgs.add("sha1");
                continue;
            }
            if (digestOID.equals(DIGEST_MD5)) {
                micAlgs.add("md5");
                continue;
            }
            if (digestOID.equals(DIGEST_SHA224)) {
                micAlgs.add("sha224");
                continue;
            }
            if (digestOID.equals(DIGEST_SHA256)) {
                micAlgs.add("sha256");
                continue;
            }
            if (digestOID.equals(DIGEST_SHA384)) {
                micAlgs.add("sha384");
                continue;
            }
            if (digestOID.equals(DIGEST_SHA512)) {
                micAlgs.add("sha512");
                continue;
            }
            if (digestOID.equals(DIGEST_GOST3411)) {
                micAlgs.add("gostr3411-94");
                continue;
            }
            micAlgs.add("unknown");
        }
        it = micAlgs.iterator();
        while (it.hasNext()) {
            String alg = (String)it.next();
            if (count == 0) {
                if (micAlgs.size() != 1) {
                    header.append("; micalg=\"");
                } else {
                    header.append("; micalg=");
                }
            } else {
                header.append(',');
            }
            header.append(alg);
            ++count;
        }
        if (count != 0 && micAlgs.size() != 1) {
            header.append('\"');
        }
    }

    private MimeMultipart make(MimeBodyPart content, Provider sigProvider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            MimeBodyPart sig = new MimeBodyPart();
            sig.setContent(new ContentSigner(content, false, sigProvider), DETACHED_SIGNATURE_TYPE);
            sig.addHeader("Content-Type", DETACHED_SIGNATURE_TYPE);
            sig.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            sig.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            sig.addHeader("Content-Transfer-Encoding", this.encoding);
            StringBuffer header = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"");
            ArrayList allSigners = new ArrayList(this._signers);
            allSigners.addAll(this._oldSigners);
            allSigners.addAll(this.signerInfoGens);
            this.addHashHeader(header, allSigners);
            MimeMultipart mm = new MimeMultipart(header.toString());
            mm.addBodyPart(content);
            mm.addBodyPart(sig);
            return mm;
        }
        catch (MessagingException e) {
            throw new SMIMEException("exception putting multi-part together.", e);
        }
    }

    private MimeMultipart make(MimeBodyPart content) throws SMIMEException {
        try {
            MimeBodyPart sig = new MimeBodyPart();
            sig.setContent(new ContentSigner(content, false), DETACHED_SIGNATURE_TYPE);
            sig.addHeader("Content-Type", DETACHED_SIGNATURE_TYPE);
            sig.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            sig.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            sig.addHeader("Content-Transfer-Encoding", this.encoding);
            StringBuffer header = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"");
            ArrayList allSigners = new ArrayList(this._signers);
            allSigners.addAll(this._oldSigners);
            allSigners.addAll(this.signerInfoGens);
            this.addHashHeader(header, allSigners);
            MimeMultipart mm = new MimeMultipart(header.toString());
            mm.addBodyPart(content);
            mm.addBodyPart(sig);
            return mm;
        }
        catch (MessagingException e) {
            throw new SMIMEException("exception putting multi-part together.", e);
        }
    }

    private MimeBodyPart makeEncapsulated(MimeBodyPart content, Provider sigProvider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            MimeBodyPart sig = new MimeBodyPart();
            sig.setContent(new ContentSigner(content, true, sigProvider), ENCAPSULATED_SIGNED_CONTENT_TYPE);
            sig.addHeader("Content-Type", ENCAPSULATED_SIGNED_CONTENT_TYPE);
            sig.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            sig.addHeader("Content-Description", "S/MIME Cryptographic Signed Data");
            sig.addHeader("Content-Transfer-Encoding", this.encoding);
            return sig;
        }
        catch (MessagingException e) {
            throw new SMIMEException("exception putting body part together.", e);
        }
    }

    private MimeBodyPart makeEncapsulated(MimeBodyPart content) throws SMIMEException {
        try {
            MimeBodyPart sig = new MimeBodyPart();
            sig.setContent(new ContentSigner(content, true), ENCAPSULATED_SIGNED_CONTENT_TYPE);
            sig.addHeader("Content-Type", ENCAPSULATED_SIGNED_CONTENT_TYPE);
            sig.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            sig.addHeader("Content-Description", "S/MIME Cryptographic Signed Data");
            sig.addHeader("Content-Transfer-Encoding", this.encoding);
            return sig;
        }
        catch (MessagingException e) {
            throw new SMIMEException("exception putting body part together.", e);
        }
    }

    public Map getGeneratedDigests() {
        return new HashMap(this._digests);
    }

    public MimeMultipart generate(MimeBodyPart content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(content), SMIMEUtil.getProvider(sigProvider));
    }

    public MimeMultipart generate(MimeBodyPart content, Provider sigProvider) throws NoSuchAlgorithmException, SMIMEException {
        return this.make(this.makeContentBodyPart(content), sigProvider);
    }

    public MimeMultipart generate(MimeMessage message, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generate(message, SMIMEUtil.getProvider(sigProvider));
    }

    public MimeMultipart generate(MimeMessage message, Provider sigProvider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            message.saveChanges();
        }
        catch (MessagingException e) {
            throw new SMIMEException("unable to save message", e);
        }
        return this.make(this.makeContentBodyPart(message), sigProvider);
    }

    public MimeMultipart generate(MimeBodyPart content) throws SMIMEException {
        return this.make(this.makeContentBodyPart(content));
    }

    public MimeBodyPart generateEncapsulated(MimeBodyPart content) throws SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(content));
    }

    public MimeBodyPart generateEncapsulated(MimeBodyPart content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(content), SMIMEUtil.getProvider(sigProvider));
    }

    public MimeBodyPart generateEncapsulated(MimeBodyPart content, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(content), sigProvider);
    }

    public MimeBodyPart generateEncapsulated(MimeMessage message, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generateEncapsulated(message, SMIMEUtil.getProvider(sigProvider));
    }

    public MimeBodyPart generateEncapsulated(MimeMessage message, Provider sigProvider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            message.saveChanges();
        }
        catch (MessagingException e) {
            throw new SMIMEException("unable to save message", e);
        }
        return this.makeEncapsulated(this.makeContentBodyPart(message), sigProvider);
    }

    public MimeBodyPart generateCertificateManagement(String provider) throws SMIMEException, NoSuchProviderException {
        return this.generateCertificateManagement(SMIMEUtil.getProvider(provider));
    }

    public MimeBodyPart generateCertificateManagement(Provider provider) throws SMIMEException {
        try {
            MimeBodyPart sig = new MimeBodyPart();
            sig.setContent(new ContentSigner(null, true, provider), CERTIFICATE_MANAGEMENT_CONTENT);
            sig.addHeader("Content-Type", CERTIFICATE_MANAGEMENT_CONTENT);
            sig.addHeader("Content-Disposition", "attachment; filename=\"smime.p7c\"");
            sig.addHeader("Content-Description", "S/MIME Certificate Management Message");
            sig.addHeader("Content-Transfer-Encoding", this.encoding);
            return sig;
        }
        catch (MessagingException e) {
            throw new SMIMEException("exception putting body part together.", e);
        }
    }

    static {
        CommandMap.setDefaultCommandMap(SMIMESignedGenerator.addCommands(CommandMap.getDefaultCommandMap()));
    }

    private class ContentSigner
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart content;
        private final boolean encapsulate;
        private final Provider provider;
        private final boolean noProvider;

        ContentSigner(MimeBodyPart content, boolean encapsulate, Provider provider) {
            this.content = content;
            this.encapsulate = encapsulate;
            this.provider = provider;
            this.noProvider = false;
        }

        ContentSigner(MimeBodyPart content, boolean encapsulate) {
            this.content = content;
            this.encapsulate = encapsulate;
            this.provider = null;
            this.noProvider = true;
        }

        protected CMSSignedDataStreamGenerator getGenerator() throws CMSException, CertStoreException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
            Iterator it = SMIMESignedGenerator.this._certStores.iterator();
            while (it.hasNext()) {
                gen.addCertificatesAndCRLs((CertStore)it.next());
            }
            it = SMIMESignedGenerator.this.certStores.iterator();
            while (it.hasNext()) {
                gen.addCertificates((Store)it.next());
            }
            it = SMIMESignedGenerator.this.crlStores.iterator();
            while (it.hasNext()) {
                gen.addCRLs((Store)it.next());
            }
            it = SMIMESignedGenerator.this.attrCertStores.iterator();
            while (it.hasNext()) {
                gen.addAttributeCertificates((Store)it.next());
            }
            it = SMIMESignedGenerator.this._attributeCerts.iterator();
            while (it.hasNext()) {
                gen.addAttributeCertificates((X509Store)it.next());
            }
            it = SMIMESignedGenerator.this._signers.iterator();
            while (it.hasNext()) {
                Signer signer = (Signer)it.next();
                if (signer.getEncryptionOID() != null) {
                    gen.addSigner(signer.getKey(), signer.getCert(), signer.getEncryptionOID(), signer.getDigestOID(), signer.getSignedAttr(), signer.getUnsignedAttr(), this.provider);
                    continue;
                }
                gen.addSigner(signer.getKey(), signer.getCert(), signer.getDigestOID(), signer.getSignedAttr(), signer.getUnsignedAttr(), this.provider);
            }
            it = SMIMESignedGenerator.this.signerInfoGens.iterator();
            while (it.hasNext()) {
                gen.addSignerInfoGenerator((SignerInfoGenerator)it.next());
            }
            gen.addSigners(new SignerInformationStore(SMIMESignedGenerator.this._oldSigners));
            return gen;
        }

        private void writeBodyPart(OutputStream out, MimeBodyPart bodyPart) throws IOException, MessagingException {
            if (bodyPart.getContent() instanceof Multipart) {
                Multipart mp = (Multipart)bodyPart.getContent();
                ContentType contentType = new ContentType(mp.getContentType());
                String boundary = "--" + contentType.getParameter("boundary");
                SMIMEUtil.LineOutputStream lOut = new SMIMEUtil.LineOutputStream(out);
                Enumeration headers = bodyPart.getAllHeaderLines();
                while (headers.hasMoreElements()) {
                    lOut.writeln((String)headers.nextElement());
                }
                lOut.writeln();
                SMIMEUtil.outputPreamble(lOut, bodyPart, boundary);
                for (int i = 0; i < mp.getCount(); ++i) {
                    lOut.writeln(boundary);
                    this.writeBodyPart(out, (MimeBodyPart)mp.getBodyPart(i));
                    lOut.writeln();
                }
                lOut.writeln(boundary + "--");
            } else {
                if (SMIMEUtil.isCanonicalisationRequired(bodyPart, SMIMESignedGenerator.this._defaultContentTransferEncoding)) {
                    out = new CRLFOutputStream(out);
                }
                bodyPart.writeTo(out);
            }
        }

        public void write(OutputStream out) throws IOException {
            try {
                CMSSignedDataStreamGenerator gen = this.getGenerator();
                OutputStream signingStream = gen.open(out, this.encapsulate);
                if (this.content != null) {
                    if (!this.encapsulate) {
                        this.writeBodyPart(signingStream, this.content);
                    } else {
                        this.content.getDataHandler().setCommandMap(SMIMESignedGenerator.addCommands(CommandMap.getDefaultCommandMap()));
                        this.content.writeTo(signingStream);
                    }
                }
                signingStream.close();
                SMIMESignedGenerator.this._digests = gen.getGeneratedDigests();
            }
            catch (MessagingException e) {
                throw new IOException(e.toString());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.toString());
            }
            catch (NoSuchProviderException e) {
                throw new IOException(e.toString());
            }
            catch (CMSException e) {
                throw new IOException(e.toString());
            }
            catch (InvalidKeyException e) {
                throw new IOException(e.toString());
            }
            catch (CertStoreException e) {
                throw new IOException(e.toString());
            }
        }
    }

    private class Signer {
        final PrivateKey key;
        final X509Certificate cert;
        final String encryptionOID;
        final String digestOID;
        final AttributeTable signedAttr;
        final AttributeTable unsignedAttr;

        Signer(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) {
            this(key, cert, null, digestOID, signedAttr, unsignedAttr);
        }

        Signer(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) {
            this.key = key;
            this.cert = cert;
            this.encryptionOID = encryptionOID;
            this.digestOID = digestOID;
            this.signedAttr = signedAttr;
            this.unsignedAttr = unsignedAttr;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public String getEncryptionOID() {
            return this.encryptionOID;
        }

        public String getDigestOID() {
            return this.digestOID;
        }

        public PrivateKey getKey() {
            return this.key;
        }

        public AttributeTable getSignedAttr() {
            return this.signedAttr;
        }

        public AttributeTable getUnsignedAttr() {
            return this.unsignedAttr;
        }
    }
}

