/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.jce.interfaces.BCKeyStore;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEPBEKey;
import org.bouncycastle.jce.provider.JDKKeyFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class JDKPKCS12KeyStore
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 1024;
    private static final Provider bcProvider = new BouncyCastleProvider();
    private IgnoresCaseHashtable keys = new IgnoresCaseHashtable();
    private Hashtable localIds = new Hashtable();
    private IgnoresCaseHashtable certs = new IgnoresCaseHashtable();
    private Hashtable chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact;
    private DERObjectIdentifier keyAlgorithm;
    private DERObjectIdentifier certAlgorithm;

    public JDKPKCS12KeyStore(Provider provider, DERObjectIdentifier keyAlgorithm, DERObjectIdentifier certAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        this.certAlgorithm = certAlgorithm;
        try {
            this.certFact = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't create cert factory - " + e.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey pubKey) {
        try {
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(pubKey.getEncoded()));
            return new SubjectKeyIdentifier(info);
        }
        catch (Exception e) {
            throw new RuntimeException("error creating key");
        }
    }

    public void setRandom(SecureRandom rand) {
        this.random = rand;
    }

    public Enumeration engineAliases() {
        Hashtable<Object, String> tab = new Hashtable<Object, String>();
        Enumeration e = this.certs.keys();
        while (e.hasMoreElements()) {
            tab.put(e.nextElement(), "cert");
        }
        e = this.keys.keys();
        while (e.hasMoreElements()) {
            String a = (String)e.nextElement();
            if (tab.get(a) != null) continue;
            tab.put(a, "key");
        }
        return tab.keys();
    }

    public boolean engineContainsAlias(String alias) {
        return this.certs.get(alias) != null || this.keys.get(alias) != null;
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Key k = (Key)this.keys.remove(alias);
        Certificate c = (Certificate)this.certs.remove(alias);
        if (c != null) {
            this.chainCerts.remove(new CertId(c.getPublicKey()));
        }
        if (k != null) {
            String id = (String)this.localIds.remove(alias);
            if (id != null) {
                c = (Certificate)this.keyCerts.remove(id);
            }
            if (c != null) {
                this.chainCerts.remove(new CertId(c.getPublicKey()));
            }
        }
        if (c == null && k == null) {
            throw new KeyStoreException("no such entry as " + alias);
        }
    }

    public Certificate engineGetCertificate(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getCertificate.");
        }
        Certificate c = (Certificate)this.certs.get(alias);
        if (c == null) {
            String id = (String)this.localIds.get(alias);
            c = id != null ? (Certificate)this.keyCerts.get(id) : (Certificate)this.keyCerts.get(alias);
        }
        return c;
    }

    public String engineGetCertificateAlias(Certificate cert) {
        String ta;
        Certificate tc;
        Enumeration c = this.certs.elements();
        Enumeration k = this.certs.keys();
        while (c.hasMoreElements()) {
            tc = (Certificate)c.nextElement();
            ta = (String)k.nextElement();
            if (!tc.equals(cert)) continue;
            return ta;
        }
        c = this.keyCerts.elements();
        k = this.keyCerts.keys();
        while (c.hasMoreElements()) {
            tc = (Certificate)c.nextElement();
            ta = (String)k.nextElement();
            if (!tc.equals(cert)) continue;
            return ta;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(alias)) {
            return null;
        }
        Certificate c = this.engineGetCertificate(alias);
        if (c != null) {
            Vector<Certificate> cs = new Vector<Certificate>();
            while (c != null) {
                Principal s;
                Principal i;
                X509Certificate x509c = (X509Certificate)c;
                Certificate nextC = null;
                byte[] bytes = x509c.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (bytes != null) {
                    try {
                        ASN1InputStream aIn = new ASN1InputStream(bytes);
                        byte[] authBytes = ((ASN1OctetString)aIn.readObject()).getOctets();
                        aIn = new ASN1InputStream(authBytes);
                        AuthorityKeyIdentifier id = new AuthorityKeyIdentifier((ASN1Sequence)aIn.readObject());
                        if (id.getKeyIdentifier() != null) {
                            nextC = (Certificate)this.chainCerts.get(new CertId(id.getKeyIdentifier()));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
                if (nextC == null && !((Object)(i = x509c.getIssuerDN())).equals(s = x509c.getSubjectDN())) {
                    Enumeration e = this.chainCerts.keys();
                    while (e.hasMoreElements()) {
                        X509Certificate crt = (X509Certificate)this.chainCerts.get(e.nextElement());
                        Principal sub = crt.getSubjectDN();
                        if (!((Object)sub).equals(i)) continue;
                        try {
                            x509c.verify(crt.getPublicKey());
                            nextC = crt;
                            break;
                        }
                        catch (Exception ex) {
                        }
                    }
                }
                cs.addElement(c);
                if (nextC != c) {
                    c = nextC;
                    continue;
                }
                c = null;
            }
            Certificate[] certChain = new Certificate[cs.size()];
            for (int i = 0; i != certChain.length; ++i) {
                certChain[i] = (Certificate)cs.elementAt(i);
            }
            return certChain;
        }
        return null;
    }

    public Date engineGetCreationDate(String alias) {
        return new Date();
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.keys.get(alias);
    }

    public boolean engineIsCertificateEntry(String alias) {
        return this.certs.get(alias) != null && this.keys.get(alias) == null;
    }

    public boolean engineIsKeyEntry(String alias) {
        return this.keys.get(alias) != null;
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (this.keys.get(alias) != null) {
            throw new KeyStoreException("There is a key entry with the name " + alias + ".");
        }
        this.certs.put(alias, cert);
        this.chainCerts.put(new CertId(cert.getPublicKey()), cert);
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (key instanceof PrivateKey && chain == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(alias) != null) {
            this.engineDeleteEntry(alias);
        }
        this.keys.put(alias, key);
        this.certs.put(alias, chain[0]);
        for (int i = 0; i != chain.length; ++i) {
            this.chainCerts.put(new CertId(chain[i].getPublicKey()), chain[i]);
        }
    }

    public int engineSize() {
        Hashtable<Object, String> tab = new Hashtable<Object, String>();
        Enumeration e = this.certs.keys();
        while (e.hasMoreElements()) {
            tab.put(e.nextElement(), "cert");
        }
        e = this.keys.keys();
        while (e.hasMoreElements()) {
            String a = (String)e.nextElement();
            if (tab.get(a) != null) continue;
            tab.put(a, "key");
        }
        return tab.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algId, byte[] data, char[] password, boolean wrongPKCS12Zero) throws IOException {
        PrivateKey out;
        String algorithm = algId.getObjectId().getId();
        PKCS12PBEParams pbeParams = new PKCS12PBEParams((ASN1Sequence)algId.getParameters());
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, bcProvider);
            PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
            SecretKey k = keyFact.generateSecret(pbeSpec);
            ((JCEPBEKey)k).setTryWrongPKCS12Zero(wrongPKCS12Zero);
            Cipher cipher = Cipher.getInstance(algorithm, bcProvider);
            cipher.init(4, (Key)k, defParams);
            out = (PrivateKey)cipher.unwrap(data, "", 2);
        }
        catch (Exception e) {
            throw new IOException("exception unwrapping private key - " + e.toString());
        }
        return out;
    }

    protected byte[] wrapKey(String algorithm, Key key, PKCS12PBEParams pbeParams, char[] password) throws IOException {
        byte[] out;
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, bcProvider);
            PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(algorithm, bcProvider);
            cipher.init(3, (Key)keyFact.generateSecret(pbeSpec), defParams);
            out = cipher.wrap(key);
        }
        catch (Exception e) {
            throw new IOException("exception encrypting data - " + e.toString());
        }
        return out;
    }

    protected byte[] cryptData(boolean forEncryption, AlgorithmIdentifier algId, char[] password, boolean wrongPKCS12Zero, byte[] data) throws IOException {
        String algorithm = algId.getObjectId().getId();
        PKCS12PBEParams pbeParams = new PKCS12PBEParams((ASN1Sequence)algId.getParameters());
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, bcProvider);
            PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
            JCEPBEKey key = (JCEPBEKey)keyFact.generateSecret(pbeSpec);
            key.setTryWrongPKCS12Zero(wrongPKCS12Zero);
            Cipher cipher = Cipher.getInstance(algorithm, bcProvider);
            int mode = forEncryption ? 1 : 2;
            cipher.init(mode, (Key)key, defParams);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IOException("exception decrypting data - " + e.toString());
        }
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException {
        PKCS12BagAttributeCarrier bagAttr;
        if (stream == null) {
            return;
        }
        if (password == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufIn = new BufferedInputStream(stream);
        bufIn.mark(10);
        int head = bufIn.read();
        if (head != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufIn.reset();
        ASN1InputStream bIn = new ASN1InputStream(bufIn);
        ASN1Sequence obj = (ASN1Sequence)bIn.readObject();
        Pfx bag = new Pfx(obj);
        ContentInfo info = bag.getAuthSafe();
        Vector<SafeBag> chain = new Vector<SafeBag>();
        boolean unmarkedKey = false;
        boolean wrongPKCS12Zero = false;
        if (bag.getMacData() != null) {
            MacData mData = bag.getMacData();
            DigestInfo dInfo = mData.getMac();
            AlgorithmIdentifier algId = dInfo.getAlgorithmId();
            byte[] salt = mData.getSalt();
            int itCount = mData.getIterationCount().intValue();
            byte[] data = ((ASN1OctetString)info.getContent()).getOctets();
            try {
                byte[] res = JDKPKCS12KeyStore.calculatePbeMac(algId.getObjectId(), salt, itCount, password, false, data);
                byte[] dig = dInfo.getDigest();
                if (!Arrays.constantTimeAreEqual(res, dig)) {
                    if (password.length > 0) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    res = JDKPKCS12KeyStore.calculatePbeMac(algId.getObjectId(), salt, itCount, password, true, data);
                    if (!Arrays.constantTimeAreEqual(res, dig)) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    wrongPKCS12Zero = true;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("error constructing MAC: " + e.toString());
            }
        }
        this.keys = new IgnoresCaseHashtable();
        this.localIds = new Hashtable();
        if (info.getContentType().equals(data)) {
            bIn = new ASN1InputStream(((ASN1OctetString)info.getContent()).getOctets());
            AuthenticatedSafe authSafe = new AuthenticatedSafe((ASN1Sequence)bIn.readObject());
            ContentInfo[] c = authSafe.getContentInfo();
            for (int i = 0; i != c.length; ++i) {
                if (c[i].getContentType().equals(data)) {
                    ASN1InputStream dIn = new ASN1InputStream(((ASN1OctetString)c[i].getContent()).getOctets());
                    ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                    for (int j = 0; j != seq.size(); ++j) {
                        SafeBag b = new SafeBag((ASN1Sequence)seq.getObjectAt(j));
                        if (b.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            EncryptedPrivateKeyInfo eIn = new EncryptedPrivateKeyInfo((ASN1Sequence)b.getBagValue());
                            PrivateKey privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password, wrongPKCS12Zero);
                            PKCS12BagAttributeCarrier bagAttr2 = (PKCS12BagAttributeCarrier)((Object)privKey);
                            String alias = null;
                            ASN1OctetString localId = null;
                            if (b.getBagAttributes() != null) {
                                Enumeration e = b.getBagAttributes().getObjects();
                                while (e.hasMoreElements()) {
                                    ASN1Sequence sq = (ASN1Sequence)e.nextElement();
                                    DERObjectIdentifier aOid = (DERObjectIdentifier)sq.getObjectAt(0);
                                    ASN1Set attrSet = (ASN1Set)sq.getObjectAt(1);
                                    DERObject attr = null;
                                    if (attrSet.size() > 0) {
                                        attr = (DERObject)attrSet.getObjectAt(0);
                                        DEREncodable existing = bagAttr2.getBagAttribute(aOid);
                                        if (existing != null) {
                                            if (!existing.getDERObject().equals(attr)) {
                                                throw new IOException("attempt to add existing attribute with different value");
                                            }
                                        } else {
                                            bagAttr2.setBagAttribute(aOid, attr);
                                        }
                                    }
                                    if (aOid.equals(pkcs_9_at_friendlyName)) {
                                        alias = ((DERBMPString)attr).getString();
                                        this.keys.put(alias, privKey);
                                        continue;
                                    }
                                    if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                    localId = (ASN1OctetString)attr;
                                }
                            }
                            if (localId != null) {
                                String name = new String(Hex.encode(localId.getOctets()));
                                if (alias == null) {
                                    this.keys.put(name, privKey);
                                    continue;
                                }
                                this.localIds.put(alias, name);
                                continue;
                            }
                            unmarkedKey = true;
                            this.keys.put("unmarked", privKey);
                            continue;
                        }
                        if (b.getBagId().equals(certBag)) {
                            chain.addElement(b);
                            continue;
                        }
                        System.out.println("extra in data " + b.getBagId());
                        System.out.println(ASN1Dump.dumpAsString(b));
                    }
                    continue;
                }
                if (c[i].getContentType().equals(encryptedData)) {
                    EncryptedData d = new EncryptedData((ASN1Sequence)c[i].getContent());
                    byte[] octets = this.cryptData(false, d.getEncryptionAlgorithm(), password, wrongPKCS12Zero, d.getContent().getOctets());
                    ASN1Sequence seq = (ASN1Sequence)ASN1Object.fromByteArray(octets);
                    for (int j = 0; j != seq.size(); ++j) {
                        String name;
                        DEREncodable existing;
                        DERObject attr;
                        ASN1Set attrSet;
                        DERObjectIdentifier aOid;
                        ASN1Sequence sq;
                        Enumeration e;
                        ASN1OctetString localId;
                        String alias;
                        PrivateKey privKey;
                        SafeBag b = new SafeBag((ASN1Sequence)seq.getObjectAt(j));
                        if (b.getBagId().equals(certBag)) {
                            chain.addElement(b);
                            continue;
                        }
                        if (b.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            EncryptedPrivateKeyInfo eIn = new EncryptedPrivateKeyInfo((ASN1Sequence)b.getBagValue());
                            privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password, wrongPKCS12Zero);
                            bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
                            alias = null;
                            localId = null;
                            e = b.getBagAttributes().getObjects();
                            while (e.hasMoreElements()) {
                                sq = (ASN1Sequence)e.nextElement();
                                aOid = (DERObjectIdentifier)sq.getObjectAt(0);
                                attrSet = (ASN1Set)sq.getObjectAt(1);
                                attr = null;
                                if (attrSet.size() > 0) {
                                    attr = (DERObject)attrSet.getObjectAt(0);
                                    existing = bagAttr.getBagAttribute(aOid);
                                    if (existing != null) {
                                        if (!existing.getDERObject().equals(attr)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                    } else {
                                        bagAttr.setBagAttribute(aOid, attr);
                                    }
                                }
                                if (aOid.equals(pkcs_9_at_friendlyName)) {
                                    alias = ((DERBMPString)attr).getString();
                                    this.keys.put(alias, privKey);
                                    continue;
                                }
                                if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                localId = (ASN1OctetString)attr;
                            }
                            name = new String(Hex.encode(localId.getOctets()));
                            if (alias == null) {
                                this.keys.put(name, privKey);
                                continue;
                            }
                            this.localIds.put(alias, name);
                            continue;
                        }
                        if (b.getBagId().equals(keyBag)) {
                            PrivateKeyInfo pIn = new PrivateKeyInfo((ASN1Sequence)b.getBagValue());
                            privKey = JDKKeyFactory.createPrivateKeyFromPrivateKeyInfo(pIn);
                            bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
                            alias = null;
                            localId = null;
                            e = b.getBagAttributes().getObjects();
                            while (e.hasMoreElements()) {
                                sq = (ASN1Sequence)e.nextElement();
                                aOid = (DERObjectIdentifier)sq.getObjectAt(0);
                                attrSet = (ASN1Set)sq.getObjectAt(1);
                                attr = null;
                                if (attrSet.size() > 0) {
                                    attr = (DERObject)attrSet.getObjectAt(0);
                                    existing = bagAttr.getBagAttribute(aOid);
                                    if (existing != null) {
                                        if (!existing.getDERObject().equals(attr)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                    } else {
                                        bagAttr.setBagAttribute(aOid, attr);
                                    }
                                }
                                if (aOid.equals(pkcs_9_at_friendlyName)) {
                                    alias = ((DERBMPString)attr).getString();
                                    this.keys.put(alias, privKey);
                                    continue;
                                }
                                if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                localId = (ASN1OctetString)attr;
                            }
                            name = new String(Hex.encode(localId.getOctets()));
                            if (alias == null) {
                                this.keys.put(name, privKey);
                                continue;
                            }
                            this.localIds.put(alias, name);
                            continue;
                        }
                        System.out.println("extra in encryptedData " + b.getBagId());
                        System.out.println(ASN1Dump.dumpAsString(b));
                    }
                    continue;
                }
                System.out.println("extra " + c[i].getContentType().getId());
                System.out.println("extra " + ASN1Dump.dumpAsString(c[i].getContent()));
            }
        }
        this.certs = new IgnoresCaseHashtable();
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        for (int i = 0; i != chain.size(); ++i) {
            String name;
            Certificate cert;
            SafeBag b = (SafeBag)chain.elementAt(i);
            CertBag cb = new CertBag((ASN1Sequence)b.getBagValue());
            if (!cb.getCertId().equals(x509Certificate)) {
                throw new RuntimeException("Unsupported certificate type: " + cb.getCertId());
            }
            try {
                ByteArrayInputStream cIn = new ByteArrayInputStream(((ASN1OctetString)cb.getCertValue()).getOctets());
                cert = this.certFact.generateCertificate(cIn);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            ASN1OctetString localId = null;
            String alias = null;
            if (b.getBagAttributes() != null) {
                Enumeration e = b.getBagAttributes().getObjects();
                while (e.hasMoreElements()) {
                    ASN1Sequence sq = (ASN1Sequence)e.nextElement();
                    DERObjectIdentifier oid = (DERObjectIdentifier)sq.getObjectAt(0);
                    DERObject attr = (DERObject)((ASN1Set)sq.getObjectAt(1)).getObjectAt(0);
                    bagAttr = null;
                    if (cert instanceof PKCS12BagAttributeCarrier) {
                        bagAttr = (PKCS12BagAttributeCarrier)((Object)cert);
                        DEREncodable existing = bagAttr.getBagAttribute(oid);
                        if (existing != null) {
                            if (!existing.getDERObject().equals(attr)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            bagAttr.setBagAttribute(oid, attr);
                        }
                    }
                    if (oid.equals(pkcs_9_at_friendlyName)) {
                        alias = ((DERBMPString)attr).getString();
                        continue;
                    }
                    if (!oid.equals(pkcs_9_at_localKeyId)) continue;
                    localId = (ASN1OctetString)attr;
                }
            }
            this.chainCerts.put(new CertId(cert.getPublicKey()), cert);
            if (unmarkedKey) {
                if (!this.keyCerts.isEmpty()) continue;
                name = new String(Hex.encode(this.createSubjectKeyId(cert.getPublicKey()).getKeyIdentifier()));
                this.keyCerts.put(name, cert);
                this.keys.put(name, this.keys.remove("unmarked"));
                continue;
            }
            if (localId != null) {
                name = new String(Hex.encode(localId.getOctets()));
                this.keyCerts.put(name, cert);
            }
            if (alias == null) continue;
            this.certs.put(alias, cert);
        }
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException {
        MacData mData;
        Object certId;
        SafeBag sBag;
        ASN1EncodableVector fSeq;
        ASN1EncodableVector fSeq2;
        DERObjectIdentifier oid;
        Enumeration e;
        DERBMPString nm;
        PKCS12BagAttributeCarrier bagAttrs;
        ASN1EncodableVector fName;
        CertBag cBag;
        Certificate cert;
        if (password == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        ASN1EncodableVector keyS = new ASN1EncodableVector();
        Enumeration ks = this.keys.keys();
        while (ks.hasMoreElements()) {
            byte[] kSalt = new byte[20];
            this.random.nextBytes(kSalt);
            String name = (String)ks.nextElement();
            PrivateKey privKey = (PrivateKey)this.keys.get(name);
            PKCS12PBEParams kParams = new PKCS12PBEParams(kSalt, 1024);
            byte[] kBytes = this.wrapKey(this.keyAlgorithm.getId(), privKey, kParams, password);
            AlgorithmIdentifier kAlgId = new AlgorithmIdentifier(this.keyAlgorithm, kParams.getDERObject());
            EncryptedPrivateKeyInfo kInfo = new EncryptedPrivateKeyInfo(kAlgId, kBytes);
            boolean attrSet = false;
            ASN1EncodableVector kName = new ASN1EncodableVector();
            if (privKey instanceof PKCS12BagAttributeCarrier) {
                PKCS12BagAttributeCarrier bagAttrs2 = (PKCS12BagAttributeCarrier)((Object)privKey);
                DERBMPString nm2 = (DERBMPString)bagAttrs2.getBagAttribute(pkcs_9_at_friendlyName);
                if (nm2 == null || !nm2.getString().equals(name)) {
                    bagAttrs2.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString(name));
                }
                if (bagAttrs2.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                    Certificate ct = this.engineGetCertificate(name);
                    bagAttrs2.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(ct.getPublicKey()));
                }
                Enumeration e2 = bagAttrs2.getBagAttributeKeys();
                while (e2.hasMoreElements()) {
                    DERObjectIdentifier oid2 = (DERObjectIdentifier)e2.nextElement();
                    ASN1EncodableVector kSeq = new ASN1EncodableVector();
                    kSeq.add(oid2);
                    kSeq.add(new DERSet(bagAttrs2.getBagAttribute(oid2)));
                    attrSet = true;
                    kName.add(new DERSequence(kSeq));
                }
            }
            if (!attrSet) {
                ASN1EncodableVector kSeq = new ASN1EncodableVector();
                Certificate ct = this.engineGetCertificate(name);
                kSeq.add(pkcs_9_at_localKeyId);
                kSeq.add(new DERSet(this.createSubjectKeyId(ct.getPublicKey())));
                kName.add(new DERSequence(kSeq));
                kSeq = new ASN1EncodableVector();
                kSeq.add(pkcs_9_at_friendlyName);
                kSeq.add(new DERSet(new DERBMPString(name)));
                kName.add(new DERSequence(kSeq));
            }
            SafeBag kBag = new SafeBag(pkcs8ShroudedKeyBag, kInfo.getDERObject(), new DERSet(kName));
            keyS.add(kBag);
        }
        byte[] keySEncoded = new DERSequence(keyS).getDEREncoded();
        BERConstructedOctetString keyString = new BERConstructedOctetString(keySEncoded);
        byte[] cSalt = new byte[20];
        this.random.nextBytes(cSalt);
        ASN1EncodableVector certSeq = new ASN1EncodableVector();
        PKCS12PBEParams cParams = new PKCS12PBEParams(cSalt, 1024);
        AlgorithmIdentifier cAlgId = new AlgorithmIdentifier(this.certAlgorithm, cParams.getDERObject());
        Hashtable<Certificate, Certificate> doneCerts = new Hashtable<Certificate, Certificate>();
        Enumeration cs = this.keys.keys();
        while (cs.hasMoreElements()) {
            try {
                String name = (String)cs.nextElement();
                cert = this.engineGetCertificate(name);
                boolean cAttrSet = false;
                cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                fName = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert);
                    nm = (DERBMPString)bagAttrs.getBagAttribute(pkcs_9_at_friendlyName);
                    if (nm == null || !nm.getString().equals(name)) {
                        bagAttrs.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString(name));
                    }
                    if (bagAttrs.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                        bagAttrs.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(cert.getPublicKey()));
                    }
                    e = bagAttrs.getBagAttributeKeys();
                    while (e.hasMoreElements()) {
                        oid = (DERObjectIdentifier)e.nextElement();
                        fSeq2 = new ASN1EncodableVector();
                        fSeq2.add(oid);
                        fSeq2.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                        fName.add(new DERSequence(fSeq2));
                        cAttrSet = true;
                    }
                }
                if (!cAttrSet) {
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_localKeyId);
                    fSeq.add(new DERSet(this.createSubjectKeyId(cert.getPublicKey())));
                    fName.add(new DERSequence(fSeq));
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString(name)));
                    fName.add(new DERSequence(fSeq));
                }
                sBag = new SafeBag(certBag, cBag.getDERObject(), new DERSet(fName));
                certSeq.add(sBag);
                doneCerts.put(cert, cert);
            }
            catch (CertificateEncodingException e3) {
                throw new IOException("Error encoding certificate: " + e3.toString());
            }
        }
        cs = this.certs.keys();
        while (cs.hasMoreElements()) {
            try {
                certId = (String)cs.nextElement();
                cert = (Certificate)this.certs.get((String)certId);
                boolean cAttrSet = false;
                if (this.keys.get((String)certId) != null) continue;
                cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                fName = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert);
                    nm = (DERBMPString)bagAttrs.getBagAttribute(pkcs_9_at_friendlyName);
                    if (nm == null || !nm.getString().equals(certId)) {
                        bagAttrs.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)certId));
                    }
                    e = bagAttrs.getBagAttributeKeys();
                    while (e.hasMoreElements()) {
                        oid = (DERObjectIdentifier)e.nextElement();
                        if (oid.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        fSeq2 = new ASN1EncodableVector();
                        fSeq2.add(oid);
                        fSeq2.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                        fName.add(new DERSequence(fSeq2));
                        cAttrSet = true;
                    }
                }
                if (!cAttrSet) {
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString((String)certId)));
                    fName.add(new DERSequence(fSeq));
                }
                sBag = new SafeBag(certBag, cBag.getDERObject(), new DERSet(fName));
                certSeq.add(sBag);
                doneCerts.put(cert, cert);
            }
            catch (CertificateEncodingException e4) {
                throw new IOException("Error encoding certificate: " + e4.toString());
            }
        }
        cs = this.chainCerts.keys();
        while (cs.hasMoreElements()) {
            try {
                certId = (CertId)cs.nextElement();
                cert = (Certificate)this.chainCerts.get(certId);
                if (doneCerts.get(cert) != null) continue;
                CertBag cBag2 = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                ASN1EncodableVector fName2 = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    PKCS12BagAttributeCarrier bagAttrs3 = (PKCS12BagAttributeCarrier)((Object)cert);
                    Enumeration e5 = bagAttrs3.getBagAttributeKeys();
                    while (e5.hasMoreElements()) {
                        DERObjectIdentifier oid3 = (DERObjectIdentifier)e5.nextElement();
                        if (oid3.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        ASN1EncodableVector fSeq3 = new ASN1EncodableVector();
                        fSeq3.add(oid3);
                        fSeq3.add(new DERSet(bagAttrs3.getBagAttribute(oid3)));
                        fName2.add(new DERSequence(fSeq3));
                    }
                }
                SafeBag sBag2 = new SafeBag(certBag, cBag2.getDERObject(), new DERSet(fName2));
                certSeq.add(sBag2);
            }
            catch (CertificateEncodingException e6) {
                throw new IOException("Error encoding certificate: " + e6.toString());
            }
        }
        byte[] certSeqEncoded = new DERSequence(certSeq).getDEREncoded();
        byte[] certBytes = this.cryptData(true, cAlgId, password, false, certSeqEncoded);
        EncryptedData cInfo = new EncryptedData(data, cAlgId, new BERConstructedOctetString(certBytes));
        ContentInfo[] info = new ContentInfo[]{new ContentInfo(data, keyString), new ContentInfo(encryptedData, cInfo.getDERObject())};
        AuthenticatedSafe auth = new AuthenticatedSafe(info);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BEROutputStream berOut = new BEROutputStream(bOut);
        berOut.writeObject(auth);
        byte[] pkg = bOut.toByteArray();
        ContentInfo mainInfo = new ContentInfo(data, new BERConstructedOctetString(pkg));
        byte[] mSalt = new byte[20];
        int itCount = 1024;
        this.random.nextBytes(mSalt);
        byte[] data = ((ASN1OctetString)mainInfo.getContent()).getOctets();
        try {
            byte[] res = JDKPKCS12KeyStore.calculatePbeMac(id_SHA1, mSalt, itCount, password, false, data);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(id_SHA1, new DERNull());
            DigestInfo dInfo = new DigestInfo(algId, res);
            mData = new MacData(dInfo, mSalt, itCount);
        }
        catch (Exception e7) {
            throw new IOException("error constructing MAC: " + e7.toString());
        }
        Pfx pfx = new Pfx(mainInfo, mData);
        berOut = new BEROutputStream(stream);
        berOut.writeObject(pfx);
    }

    private static byte[] calculatePbeMac(DERObjectIdentifier oid, byte[] salt, int itCount, char[] password, boolean wrongPkcs12Zero, byte[] data) throws Exception {
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(oid.getId(), bcProvider);
        PBEParameterSpec defParams = new PBEParameterSpec(salt, itCount);
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        JCEPBEKey key = (JCEPBEKey)keyFact.generateSecret(pbeSpec);
        key.setTryWrongPKCS12Zero(wrongPkcs12Zero);
        Mac mac = Mac.getInstance(oid.getId(), bcProvider);
        mac.init(key, defParams);
        mac.update(data);
        return mac.doFinal();
    }

    private static class IgnoresCaseHashtable {
        private Hashtable orig = new Hashtable();
        private Hashtable keys = new Hashtable();

        private IgnoresCaseHashtable() {
        }

        public void put(String key, Object value) {
            String lower = Strings.toLowerCase(key);
            String k = (String)this.keys.get(lower);
            if (k != null) {
                this.orig.remove(k);
            }
            this.keys.put(lower, key);
            this.orig.put(key, value);
        }

        public Enumeration keys() {
            return this.orig.keys();
        }

        public Object remove(String alias) {
            String k = (String)this.keys.remove(Strings.toLowerCase(alias));
            if (k == null) {
                return null;
            }
            return this.orig.remove(k);
        }

        public Object get(String alias) {
            String k = (String)this.keys.get(Strings.toLowerCase(alias));
            if (k == null) {
                return null;
            }
            return this.orig.get(k);
        }

        public Enumeration elements() {
            return this.orig.elements();
        }
    }

    public static class DefPKCS12KeyStore3DES
    extends JDKPKCS12KeyStore {
        public DefPKCS12KeyStore3DES() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    public static class DefPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public DefPKCS12KeyStore() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbewithSHAAnd40BitRC2_CBC);
        }
    }

    public static class BCPKCS12KeyStore3DES
    extends JDKPKCS12KeyStore {
        public BCPKCS12KeyStore3DES() {
            super(bcProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    public static class BCPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public BCPKCS12KeyStore() {
            super(bcProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbewithSHAAnd40BitRC2_CBC);
        }
    }

    private class CertId {
        byte[] id;

        CertId(PublicKey key) {
            this.id = JDKPKCS12KeyStore.this.createSubjectKeyId(key).getKeyIdentifier();
        }

        CertId(byte[] id) {
            this.id = id;
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertId)) {
                return false;
            }
            CertId cId = (CertId)o;
            return Arrays.areEqual(this.id, cId.id);
        }
    }
}

