/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class BasicGCMExponentiator
implements GCMExponentiator {
    private byte[] x;

    public void init(byte[] x) {
        this.x = Arrays.clone(x);
    }

    public void exponentiateX(long pow, byte[] output) {
        byte[] y = GCMUtil.oneAsBytes();
        if (pow > 0L) {
            byte[] powX = Arrays.clone(this.x);
            do {
                if ((pow & 1L) != 0L) {
                    GCMUtil.multiply(y, powX);
                }
                GCMUtil.multiply(powX, powX);
            } while ((pow >>>= 1) > 0L);
        }
        System.arraycopy(y, 0, output, 0, 16);
    }
}

