/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERBoolean
extends ASN1Object {
    byte value;
    public static final DERBoolean FALSE = new DERBoolean(false);
    public static final DERBoolean TRUE = new DERBoolean(true);

    public static DERBoolean getInstance(Object obj) {
        if (obj == null || obj instanceof DERBoolean) {
            return (DERBoolean)obj;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBoolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static DERBoolean getInstance(ASN1TaggedObject obj, boolean explicit) {
        DERObject o = obj.getObject();
        if (explicit || o instanceof DERBoolean) {
            return DERBoolean.getInstance(o);
        }
        return new DERBoolean(((ASN1OctetString)o).getOctets());
    }

    public DERBoolean(byte[] value) {
        if (value.length != 1) {
            throw new IllegalArgumentException("byte value should have 1 byte in it");
        }
        this.value = value[0];
    }

    public DERBoolean(boolean value) {
        this.value = (byte)(value ? -1 : 0);
    }

    public boolean isTrue() {
        return this.value != 0;
    }

    void encode(DEROutputStream out) throws IOException {
        byte[] bytes = new byte[]{this.value};
        out.writeEncoded(1, bytes);
    }

    protected boolean asn1Equals(DERObject o) {
        if (o == null || !(o instanceof DERBoolean)) {
            return false;
        }
        return this.value == ((DERBoolean)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.value != 0 ? "TRUE" : "FALSE";
    }
}

