/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.CSSImportNode;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.ImportRule;
import org.apache.batik.css.engine.MediaRule;
import org.apache.batik.css.engine.Messages;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StringIntMap;
import org.apache.batik.css.engine.StyleDeclaration;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.css.engine.sac.CSSConditionFactory;
import org.apache.batik.css.engine.sac.CSSSelectorFactory;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.InheritValue;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class CSSEngine {
    protected CSSContext cssContext;
    protected Document document;
    protected URL documentURI;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected ExtendedParser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    protected SACMediaList media;
    protected List styleSheetNodes;
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected URL cssBaseURI;
    protected String alternateStyleSheet;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Set selectorAttributes;
    protected final int[] ALL_PROPERTIES;
    protected CSSConditionFactory cssConditionFactory;
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public static CSSStylableElement getParentCSSStylableElement(Element elt) {
        Element e = CSSEngine.getParentElement(elt);
        while (e != null) {
            if (e instanceof CSSStylableElement) {
                return (CSSStylableElement)e;
            }
            e = CSSEngine.getParentElement(e);
        }
        return null;
    }

    public static Element getParentElement(Element elt) {
        Node n = elt.getParentNode();
        while (n != null) {
            if ((n = CSSEngine.getLogicalParentNode(n)).getNodeType() == 1) {
                return (Element)n;
            }
            n = n.getParentNode();
        }
        return null;
    }

    public static Node getLogicalParentNode(Node parent) {
        Node node = parent;
        if (node != null) {
            if (node instanceof CSSImportedElementRoot) {
                return ((CSSImportedElementRoot)node).getCSSParentElement();
            }
            return node;
        }
        return null;
    }

    public static Node getImportedChild(Node node) {
        if (node instanceof CSSImportNode) {
            CSSImportNode inode = (CSSImportNode)node;
            CSSImportedElementRoot r = inode.getCSSImportedElementRoot();
            if (r == null) {
                return null;
            }
            return r.getFirstChild();
        }
        return null;
    }

    protected CSSEngine(Document doc, URL uri, ExtendedParser p, ValueManager[] vm, ShorthandManager[] sm, String[] pe, String sns, String sln, String cns, String cln, boolean hints, String hintsNS, CSSContext ctx) {
        this.document = doc;
        this.documentURI = uri;
        this.parser = p;
        this.pseudoElementNames = pe;
        this.styleNamespaceURI = sns;
        this.styleLocalName = sln;
        this.classNamespaceURI = cns;
        this.classLocalName = cln;
        this.cssContext = ctx;
        this.cssConditionFactory = new CSSConditionFactory(cns, cln, null, "id");
        int len = vm.length;
        this.indexes = new StringIntMap(len);
        this.valueManagers = vm;
        int i = len - 1;
        while (i >= 0) {
            String pn = vm[i].getPropertyName();
            this.indexes.put(pn, i);
            if (this.fontSizeIndex == -1 && pn.equals("font-size")) {
                this.fontSizeIndex = i;
            }
            if (this.lineHeightIndex == -1 && pn.equals("line-height")) {
                this.lineHeightIndex = i;
            }
            if (this.colorIndex == -1 && pn.equals("color")) {
                this.colorIndex = i;
            }
            --i;
        }
        len = sm.length;
        this.shorthandIndexes = new StringIntMap(len);
        this.shorthandManagers = sm;
        int i2 = len - 1;
        while (i2 >= 0) {
            this.shorthandIndexes.put(sm[i2].getPropertyName(), i2);
            --i2;
        }
        if (hints) {
            len = vm.length;
            this.nonCSSPresentationalHints = new HashSet();
            this.nonCSSPresentationalHintsNamespaceURI = hintsNS;
            int i3 = len - 1;
            while (i3 >= 0) {
                String pn = vm[i3].getPropertyName();
                this.nonCSSPresentationalHints.add(pn);
                --i3;
            }
        }
        if (this.document instanceof EventTarget) {
            EventTarget et = (EventTarget)((Object)this.document);
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            et.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            et.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            et.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            et.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            et.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        int i4 = this.getNumberOfProperties() - 1;
        while (i4 >= 0) {
            this.ALL_PROPERTIES[i4] = i4;
            --i4;
        }
    }

    public void dispose() {
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            EventTarget et = (EventTarget)((Object)this.document);
            et.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            et.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            et.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            et.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            et.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    private void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        Node n = node.getFirstChild();
        while (n != null) {
            Node c;
            if (n.getNodeType() == 1) {
                this.disposeStyleMaps(n);
            }
            if ((c = CSSEngine.getImportedChild(n)) != null) {
                this.disposeStyleMaps(c);
            }
            n = n.getNextSibling();
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String name) {
        return this.indexes.get(name);
    }

    public int getShorthandIndex(String name) {
        return this.shorthandIndexes.get(name);
    }

    public String getPropertyName(int idx) {
        return this.valueManagers[idx].getPropertyName();
    }

    public void setUserAgentStyleSheet(StyleSheet ss) {
        this.userAgentStyleSheet = ss;
    }

    public void setUserStyleSheet(StyleSheet ss) {
        this.userStyleSheet = ss;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public void setMedia(String str) {
        try {
            this.media = this.parser.parseMedia(str);
        }
        catch (Exception e) {
            String m = e.getMessage();
            String s = Messages.formatMessage("media.error", new Object[]{str, m == null ? "" : m});
            throw new DOMException(12, s);
        }
    }

    public void setAlternateStyleSheet(String str) {
        this.alternateStyleSheet = str;
    }

    public void importCascadedStyleMaps(Element src, CSSEngine srceng, Element dest) {
        if (src instanceof CSSStylableElement) {
            CSSStylableElement csrc = (CSSStylableElement)src;
            CSSStylableElement cdest = (CSSStylableElement)dest;
            StyleMap sm = srceng.getCascadedStyleMap(csrc, null);
            sm.setFixedCascadedStyle(true);
            cdest.setComputedStyleMap(null, sm);
            if (this.pseudoElementNames != null) {
                int len = this.pseudoElementNames.length;
                int i = 0;
                while (i < len) {
                    String pe = this.pseudoElementNames[i];
                    sm = srceng.getCascadedStyleMap(csrc, pe);
                    cdest.setComputedStyleMap(pe, sm);
                    ++i;
                }
            }
        }
        Node dn = dest.getFirstChild();
        Node sn = src.getFirstChild();
        while (dn != null) {
            if (sn.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)sn, srceng, (Element)dn);
            }
            dn = dn.getNextSibling();
            sn = sn.getNextSibling();
        }
    }

    public URL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            this.cssBaseURI = this.element.getCSSBase();
        }
        return this.cssBaseURI;
    }

    public StyleMap getCascadedStyleMap(CSSStylableElement elt, String pseudo) {
        String style;
        List snodes;
        int slen;
        ArrayList rules;
        int props = this.getNumberOfProperties();
        StyleMap result = new StyleMap(props);
        if (this.userAgentStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userAgentStyleSheet, elt, pseudo);
            this.addRules(elt, pseudo, result, rules, (short)0);
        }
        if (this.userStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userStyleSheet, elt, pseudo);
            this.addRules(elt, pseudo, result, rules, (short)8192);
        }
        this.element = elt;
        if (this.nonCSSPresentationalHints != null) {
            NamedNodeMap attrs = elt.getAttributes();
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                Node attr = attrs.item(i);
                String an = attr.getNodeName();
                if (this.nonCSSPresentationalHints.contains(an)) {
                    try {
                        int idx = this.getPropertyIndex(an);
                        LexicalUnit lu = this.parser.parsePropertyValue(attr.getNodeValue());
                        ValueManager vm = this.valueManagers[idx];
                        Value v = vm.createValue(lu, this);
                        this.putAuthorProperty(result, idx, v, false, (short)16384);
                    }
                    catch (Exception e) {
                        String m = e.getMessage();
                        String s = Messages.formatMessage("property.syntax.error.at", new Object[]{this.documentURI.toString(), an, attr.getNodeValue(), m == null ? "" : m});
                        throw new DOMException(12, s);
                    }
                }
                ++i;
            }
        }
        if ((slen = (snodes = this.getStyleSheetNodes()).size()) > 0) {
            ArrayList rules2 = new ArrayList();
            int i = 0;
            while (i < slen) {
                CSSStyleSheetNode ssn = (CSSStyleSheetNode)snodes.get(i);
                StyleSheet ss = ssn.getCSSStyleSheet();
                if (ss != null && (!ss.isAlternate() || ss.getTitle() == null || ss.getTitle().equals(this.alternateStyleSheet)) && this.mediaMatch(ss.getMedia())) {
                    this.addMatchingRules(rules2, ss, elt, pseudo);
                }
                ++i;
            }
            this.addRules(elt, pseudo, result, rules2, (short)24576);
        }
        if (this.styleLocalName != null && (style = elt.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
            try {
                this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                this.parser.setConditionFactory(this.cssConditionFactory);
                this.styleDeclarationDocumentHandler.styleMap = result;
                this.parser.setDocumentHandler(this.styleDeclarationDocumentHandler);
                this.parser.parseStyleDeclaration(style);
                this.styleDeclarationDocumentHandler.styleMap = null;
            }
            catch (Exception e) {
                String m = e.getMessage();
                String s = Messages.formatMessage("style.syntax.error.at", new Object[]{this.documentURI.toString(), this.styleLocalName, style, m == null ? "" : m});
                throw new DOMException(12, s);
            }
        }
        this.element = null;
        this.cssBaseURI = null;
        return result;
    }

    public Value getComputedStyle(CSSStylableElement elt, String pseudo, int propidx) {
        StyleMap sm = elt.getComputedStyleMap(pseudo);
        if (sm == null) {
            sm = this.getCascadedStyleMap(elt, pseudo);
            elt.setComputedStyleMap(pseudo, sm);
        }
        Value value = sm.getValue(propidx);
        if (!sm.isComputed(propidx)) {
            Value result = value;
            ValueManager vm = this.valueManagers[propidx];
            CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
            if (!(value != null || vm.isInheritedProperty() && p != null)) {
                result = vm.getDefaultValue();
            } else if (value != null && value == InheritValue.INSTANCE && p != null) {
                result = null;
            }
            if (result == null) {
                result = this.getComputedStyle(p, null, propidx);
                sm.putParentRelative(propidx, true);
            } else {
                result = vm.computeValue(elt, pseudo, this, propidx, sm, result);
            }
            if (value == null) {
                sm.putValue(propidx, result);
                sm.putNullCascaded(propidx, true);
            } else if (result != value) {
                ComputedValue cv = new ComputedValue(value);
                cv.setComputedValue(result);
                sm.putValue(propidx, cv);
                result = cv;
            }
            sm.putComputed(propidx, true);
            value = result;
        }
        return value;
    }

    public List getStyleSheetNodes() {
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList();
            this.selectorAttributes = new HashSet();
            this.findStyleSheetNodes(this.document);
            int len = this.styleSheetNodes.size();
            int i = 0;
            while (i < len) {
                CSSStyleSheetNode ssn = (CSSStyleSheetNode)this.styleSheetNodes.get(i);
                StyleSheet ss = ssn.getCSSStyleSheet();
                if (ss != null) {
                    this.findSelectorAttributes(this.selectorAttributes, ss);
                }
                ++i;
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes(Node n) {
        if (n instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(n);
        }
        Node nd = n.getFirstChild();
        while (nd != null) {
            this.findStyleSheetNodes(nd);
            nd = nd.getNextSibling();
        }
    }

    protected void findSelectorAttributes(Set attrs, StyleSheet ss) {
        int len = ss.getSize();
        int i = 0;
        while (i < len) {
            Rule r = ss.getRule(i);
            switch (r.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)r;
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    int j = 0;
                    while (j < slen) {
                        ExtendedSelector s = (ExtendedSelector)sl.item(j);
                        s.fillAttributeSet(attrs);
                        ++j;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    MediaRule mr = (MediaRule)r;
                    if (!this.mediaMatch(mr.getMediaList())) break;
                    this.findSelectorAttributes(attrs, mr);
                }
            }
            ++i;
        }
    }

    public Value parsePropertyValue(String prop, String value) {
        try {
            int idx = this.getPropertyIndex(prop);
            LexicalUnit lu = this.parser.parsePropertyValue(value);
            ValueManager vm = this.valueManagers[idx];
            return vm.createValue(lu, this);
        }
        catch (Exception e) {
            String m = e.getMessage();
            String s = Messages.formatMessage("property.syntax.error.at", new Object[]{this.documentURI.toString(), prop, value, m == null ? "" : m});
            throw new DOMException(12, s);
        }
    }

    public StyleDeclaration parseStyleDeclaration(String value) {
        try {
            this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
            this.parser.setConditionFactory(this.cssConditionFactory);
            this.cssBaseURI = this.documentURI;
            this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
            this.parser.setDocumentHandler(this.styleDeclarationBuilder);
            this.parser.parseStyleDeclaration(value);
            this.cssBaseURI = null;
            return this.styleDeclarationBuilder.styleDeclaration;
        }
        catch (Exception e) {
            String m = e.getMessage();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{this.documentURI.toString(), m == null ? "" : m});
            throw new DOMException(12, s);
        }
    }

    public StyleSheet parseStyleSheet(URL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
        }
        catch (Exception e) {
            String m = e.getMessage();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{this.documentURI.toString(), m == null ? "" : m});
            throw new DOMException(12, s);
        }
        this.parseStyleSheet(ss, uri);
        return ss;
    }

    public StyleSheet parseStyleSheet(InputSource is, URL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
            this.parseStyleSheet(ss, is, uri);
        }
        catch (Exception e) {
            String m = e.getMessage();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{this.documentURI.toString(), m == null ? "" : m});
            throw new DOMException(12, s);
        }
        return ss;
    }

    public void parseStyleSheet(StyleSheet ss, URL uri) throws DOMException {
        try {
            ParsedURL pDocURL = null;
            if (this.documentURI != null) {
                pDocURL = new ParsedURL(this.documentURI);
            }
            ParsedURL pURL = new ParsedURL(uri);
            this.cssContext.checkLoadExternalResource(pURL, pDocURL);
            this.parseStyleSheet(ss, new InputSource(uri.toString()), uri);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            String m = e.getMessage();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{uri.toString(), m == null ? "" : m});
            throw new DOMException(12, s);
        }
    }

    public StyleSheet parseStyleSheet(String rules, URL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
        }
        catch (Exception e) {
            String m = e.getMessage();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{this.documentURI.toString(), m == null ? "" : m});
            throw new DOMException(12, s);
        }
        this.parseStyleSheet(ss, rules, uri);
        return ss;
    }

    public void parseStyleSheet(StyleSheet ss, String rules, URL uri) throws DOMException {
        try {
            this.parseStyleSheet(ss, new InputSource((Reader)new StringReader(rules)), uri);
        }
        catch (Exception e) {
            String m = e.getMessage();
            String s = Messages.formatMessage("stylesheet.syntax.error", new Object[]{uri.toString(), rules, m == null ? "" : m});
            throw new DOMException(12, s);
        }
    }

    protected void parseStyleSheet(StyleSheet ss, InputSource is, URL uri) throws IOException {
        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        this.parser.setConditionFactory(this.cssConditionFactory);
        this.cssBaseURI = uri;
        this.styleSheetDocumentHandler.styleSheet = ss;
        this.parser.setDocumentHandler(this.styleSheetDocumentHandler);
        this.parser.parseStyleSheet(is);
        this.cssBaseURI = null;
        int len = ss.getSize();
        int i = 0;
        while (i < len) {
            Rule r = ss.getRule(i);
            if (r.getType() != 2) break;
            ImportRule ir = (ImportRule)r;
            this.parseStyleSheet(ir, ir.getURI());
            ++i;
        }
    }

    protected void putAuthorProperty(StyleMap dest, int idx, Value sval, boolean imp, short origin) {
        boolean cond;
        Value dval = dest.getValue(idx);
        short dorg = dest.getOrigin(idx);
        boolean dimp = dest.isImportant(idx);
        boolean bl = cond = dval == null;
        if (!cond) {
            switch (dorg) {
                case 8192: {
                    cond = !dimp;
                    break;
                }
                case 24576: {
                    cond = !dimp || imp;
                    break;
                }
                default: {
                    cond = true;
                }
            }
        }
        if (cond) {
            dest.putValue(idx, sval);
            dest.putImportant(idx, imp);
            dest.putOrigin(idx, origin);
        }
    }

    protected void addMatchingRules(List rules, StyleSheet ss, Element elt, String pseudo) {
        int len = ss.getSize();
        int i = 0;
        while (i < len) {
            Rule r = ss.getRule(i);
            switch (r.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)r;
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    int j = 0;
                    while (j < slen) {
                        ExtendedSelector s = (ExtendedSelector)sl.item(j);
                        if (s.match(elt, pseudo)) {
                            rules.add(style);
                        }
                        ++j;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    MediaRule mr = (MediaRule)r;
                    if (!this.mediaMatch(mr.getMediaList())) break;
                    this.addMatchingRules(rules, mr, elt, pseudo);
                }
            }
            ++i;
        }
    }

    protected void addRules(Element elt, String pseudo, StyleMap sm, List rules, short origin) {
        this.sortRules(rules, elt, pseudo);
        int rlen = rules.size();
        int props = this.getNumberOfProperties();
        if (origin == 24576) {
            int r = 0;
            while (r < rlen) {
                StyleRule sr = (StyleRule)rules.get(r);
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                int i = 0;
                while (i < len) {
                    this.putAuthorProperty(sm, sd.getIndex(i), sd.getValue(i), sd.getPriority(i), origin);
                    ++i;
                }
                ++r;
            }
        } else {
            int r = 0;
            while (r < rlen) {
                StyleRule sr = (StyleRule)rules.get(r);
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                int i = 0;
                while (i < len) {
                    int idx = sd.getIndex(i);
                    sm.putValue(idx, sd.getValue(i));
                    sm.putImportant(idx, sd.getPriority(i));
                    sm.putOrigin(idx, origin);
                    ++i;
                }
                ++r;
            }
        }
    }

    protected void sortRules(List rules, Element elt, String pseudo) {
        int len = rules.size();
        int i = 0;
        while (i < len - 1) {
            int idx = i;
            int min = Integer.MAX_VALUE;
            int j = i;
            while (j < len) {
                StyleRule r = (StyleRule)rules.get(j);
                SelectorList sl = r.getSelectorList();
                int spec = 0;
                int slen = sl.getLength();
                int k = 0;
                while (k < slen) {
                    int sp;
                    ExtendedSelector s = (ExtendedSelector)sl.item(k);
                    if (s.match(elt, pseudo) && (sp = s.getSpecificity()) > spec) {
                        spec = sp;
                    }
                    ++k;
                }
                if (spec < min) {
                    min = spec;
                    idx = j;
                }
                ++j;
            }
            if (i != idx) {
                Object tmp = rules.get(i);
                rules.set(i, rules.get(idx));
                rules.set(idx, tmp);
            }
            ++i;
        }
    }

    protected boolean mediaMatch(SACMediaList ml) {
        if (this.media == null || ml == null || this.media.getLength() == 0 || ml.getLength() == 0) {
            return true;
        }
        int i = 0;
        while (i < ml.getLength()) {
            int j = 0;
            while (j < this.media.getLength()) {
                if (this.media.item(j).equalsIgnoreCase("all") || ml.item(i).equalsIgnoreCase(this.media.item(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void addCSSEngineListener(CSSEngineListener l) {
        this.listeners.add(l);
    }

    public void removeCSSEngineListener(CSSEngineListener l) {
        this.listeners.remove(l);
    }

    protected void firePropertiesChangedEvent(Element target, int[] props) {
        CSSEngineListener[] ll = this.listeners.toArray(LISTENER_ARRAY);
        int len = ll.length;
        if (len > 0) {
            CSSEngineEvent evt = new CSSEngineEvent(this, target, props);
            int i = 0;
            while (i < len) {
                ll[i].propertiesChanged(evt);
                ++i;
            }
        }
    }

    protected void inlineStyleAttributeUpdated(CSSStylableElement elt, StyleMap style, MutationEvent evt) {
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        int i = this.getNumberOfProperties() - 1;
        while (i >= 0) {
            updated[i] = false;
            --i;
        }
        switch (evt.getAttrChange()) {
            case 1: 
            case 2: {
                String decl = evt.getNewValue();
                if (decl.length() > 0) {
                    this.element = elt;
                    try {
                        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                        this.parser.setConditionFactory(this.cssConditionFactory);
                        this.styleDeclarationUpdateHandler.styleMap = style;
                        this.parser.setDocumentHandler(this.styleDeclarationUpdateHandler);
                        this.parser.parseStyleDeclaration(decl);
                        this.styleDeclarationUpdateHandler.styleMap = null;
                    }
                    catch (Exception e) {
                        String m = e.getMessage();
                        String s = Messages.formatMessage("style.syntax.error.at", new Object[]{this.documentURI.toString(), this.styleLocalName, decl, m == null ? "" : m});
                        throw new DOMException(12, s);
                    }
                    this.element = null;
                    this.cssBaseURI = null;
                }
            }
            case 3: {
                boolean removed = false;
                if (evt.getPrevValue() != null && evt.getPrevValue().length() > 0) {
                    int i2 = this.getNumberOfProperties() - 1;
                    while (i2 >= 0) {
                        if (style.isComputed(i2) && style.getOrigin(i2) == Short.MIN_VALUE && !updated[i2]) {
                            removed = true;
                            updated[i2] = true;
                        }
                        --i2;
                    }
                }
                if (removed) {
                    elt.setComputedStyleMap(null, null);
                    this.firePropertiesChangedEvent(elt, this.ALL_PROPERTIES);
                    Node c = CSSEngine.getImportedChild(elt);
                    if (c != null) {
                        this.propagateChanges(c, this.ALL_PROPERTIES);
                    }
                    Node n = elt.getFirstChild();
                    while (n != null) {
                        this.propagateChanges(n, this.ALL_PROPERTIES);
                        n = n.getNextSibling();
                    }
                } else {
                    int count = 0;
                    boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
                    boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
                    boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
                    int i3 = this.getNumberOfProperties() - 1;
                    while (i3 >= 0) {
                        if (!updated[i3]) {
                            if (style.isComputed(i3)) {
                                if (fs && style.isFontSizeRelative(i3)) {
                                    updated[i3] = true;
                                    ++count;
                                    CSSEngine.clearComputedValue(style, i3);
                                }
                                if (lh && style.isLineHeightRelative(i3)) {
                                    updated[i3] = true;
                                    ++count;
                                    CSSEngine.clearComputedValue(style, i3);
                                }
                                if (cl && style.isColorRelative(i3)) {
                                    updated[i3] = true;
                                    ++count;
                                    CSSEngine.clearComputedValue(style, i3);
                                }
                            }
                        } else {
                            ++count;
                        }
                        --i3;
                    }
                    if (count <= 0) break;
                    int[] props = new int[count];
                    count = 0;
                    int i4 = this.getNumberOfProperties() - 1;
                    while (i4 >= 0) {
                        if (updated[i4]) {
                            props[count++] = i4;
                        }
                        --i4;
                    }
                    this.firePropertiesChangedEvent(elt, props);
                    Node c = CSSEngine.getImportedChild(elt);
                    if (c != null) {
                        this.propagateChanges(c, props);
                    }
                    Node n = elt.getFirstChild();
                    while (n != null) {
                        this.propagateChanges(n, props);
                        n = n.getNextSibling();
                    }
                }
                break;
            }
            default: {
                throw new InternalError("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap style, int n) {
        if (style.isNullCascaded(n)) {
            style.putValue(n, null);
        } else {
            Value v = style.getValue(n);
            if (v instanceof ComputedValue) {
                ComputedValue cv = (ComputedValue)v;
                v = cv.getCascadedValue();
                style.putValue(n, v);
            }
        }
        style.putComputed(n, false);
    }

    protected void invalidateTreeProperties(Node node) {
        Node c;
        CSSStylableElement elt;
        StyleMap style;
        if (node instanceof CSSStylableElement && (style = (elt = (CSSStylableElement)node).getComputedStyleMap(null)) != null) {
            elt.setComputedStyleMap(null, null);
            this.firePropertiesChangedEvent(elt, this.ALL_PROPERTIES);
        }
        if ((c = CSSEngine.getImportedChild(node)) != null) {
            this.propagateChanges(c, this.ALL_PROPERTIES);
        }
        Node n = node.getFirstChild();
        while (n != null) {
            this.invalidateTreeProperties(n);
            n = n.getNextSibling();
        }
    }

    protected void invalidateProperties(Node node) {
        Node c;
        CSSStylableElement elt;
        StyleMap style;
        if (node instanceof CSSStylableElement && (style = (elt = (CSSStylableElement)node).getComputedStyleMap(null)) != null) {
            elt.setComputedStyleMap(null, null);
            this.firePropertiesChangedEvent(elt, this.ALL_PROPERTIES);
        }
        if ((c = CSSEngine.getImportedChild(node)) != null) {
            this.propagateChanges(c, this.ALL_PROPERTIES);
        }
        Node n = node.getFirstChild();
        while (n != null) {
            this.propagateChanges(n, this.ALL_PROPERTIES);
            n = n.getNextSibling();
        }
    }

    protected void propagateChanges(Node node, int[] props) {
        CSSStylableElement elt;
        StyleMap style;
        if (node instanceof CSSStylableElement && (style = (elt = (CSSStylableElement)node).getComputedStyleMap(null)) != null) {
            boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
            int i = this.getNumberOfProperties() - 1;
            while (i >= 0) {
                updated[i] = false;
                --i;
            }
            int i2 = props.length - 1;
            while (i2 >= 0) {
                int idx = props[i2];
                if (style.isComputed(idx) && style.isParentRelative(idx)) {
                    updated[idx] = true;
                    CSSEngine.clearComputedValue(style, idx);
                }
                --i2;
            }
            boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
            boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
            boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
            int count = 0;
            int i3 = this.getNumberOfProperties() - 1;
            while (i3 >= 0) {
                if (!updated[i3]) {
                    if (style.isComputed(i3)) {
                        if (fs && style.isFontSizeRelative(i3)) {
                            updated[i3] = true;
                            ++count;
                            CSSEngine.clearComputedValue(style, i3);
                        }
                        if (lh && style.isLineHeightRelative(i3)) {
                            updated[i3] = true;
                            ++count;
                            CSSEngine.clearComputedValue(style, i3);
                        }
                        if (cl && style.isColorRelative(i3)) {
                            updated[i3] = true;
                            ++count;
                            CSSEngine.clearComputedValue(style, i3);
                        }
                    }
                } else {
                    ++count;
                }
                --i3;
            }
            if (count > 0) {
                props = new int[count];
                count = 0;
                int i4 = this.getNumberOfProperties() - 1;
                while (i4 >= 0) {
                    if (updated[i4]) {
                        props[count++] = i4;
                    }
                    --i4;
                }
                this.firePropertiesChangedEvent(elt, props);
            } else {
                props = null;
            }
        }
        if (props != null) {
            Node c = CSSEngine.getImportedChild(node);
            if (c != null) {
                this.propagateChanges(c, props);
            }
            Node n = node.getFirstChild();
            while (n != null) {
                this.propagateChanges(n, props);
                n = n.getNextSibling();
            }
        }
    }

    protected void nonCSSPresentationalHintUpdated(CSSStylableElement elt, StyleMap style, String property, MutationEvent evt) {
        int idx = this.getPropertyIndex(property);
        if (style.isImportant(idx)) {
            return;
        }
        switch (style.getOrigin(idx)) {
            case -32768: 
            case 24576: {
                return;
            }
        }
        boolean comp = style.isComputed(idx);
        switch (evt.getAttrChange()) {
            case 1: 
            case 2: {
                this.element = elt;
                try {
                    LexicalUnit lu = this.parser.parsePropertyValue(evt.getNewValue());
                    ValueManager vm = this.valueManagers[idx];
                    Value v = vm.createValue(lu, this);
                    style.putMask(idx, (short)0);
                    style.putValue(idx, v);
                    style.putOrigin(idx, (short)16384);
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    String s = Messages.formatMessage("property.syntax.error.at", new Object[]{this.documentURI.toString(), property, evt.getNewValue(), m == null ? "" : m});
                    throw new DOMException(12, s);
                }
                this.element = null;
                this.cssBaseURI = null;
                break;
            }
            case 3: {
                elt.setComputedStyleMap(null, null);
                this.firePropertiesChangedEvent(elt, this.ALL_PROPERTIES);
                Node c = CSSEngine.getImportedChild(elt);
                if (c != null) {
                    this.propagateChanges(c, this.ALL_PROPERTIES);
                }
                Node n = elt.getFirstChild();
                while (n != null) {
                    this.propagateChanges(n, this.ALL_PROPERTIES);
                    n = n.getNextSibling();
                }
                return;
            }
        }
        if (!comp) {
            return;
        }
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        int i = this.getNumberOfProperties() - 1;
        while (i >= 0) {
            updated[i] = false;
            --i;
        }
        updated[idx] = true;
        boolean fs = idx == this.fontSizeIndex;
        boolean lh = idx == this.lineHeightIndex;
        boolean cl = idx == this.colorIndex;
        int count = 0;
        int i2 = this.getNumberOfProperties() - 1;
        while (i2 >= 0) {
            if (!updated[i2]) {
                if (style.isComputed(i2)) {
                    if (fs && style.isFontSizeRelative(i2)) {
                        updated[i2] = true;
                        ++count;
                        CSSEngine.clearComputedValue(style, i2);
                    }
                    if (lh && style.isLineHeightRelative(i2)) {
                        updated[i2] = true;
                        ++count;
                        CSSEngine.clearComputedValue(style, i2);
                    }
                    if (cl && style.isColorRelative(i2)) {
                        updated[i2] = true;
                        ++count;
                        CSSEngine.clearComputedValue(style, i2);
                    }
                }
            } else {
                ++count;
            }
            --i2;
        }
        int[] props = new int[count];
        count = 0;
        int i3 = this.getNumberOfProperties() - 1;
        while (i3 >= 0) {
            if (updated[i3]) {
                props[count++] = i3;
            }
            --i3;
        }
        this.firePropertiesChangedEvent(elt, props);
        Node c = CSSEngine.getImportedChild(elt);
        if (c != null) {
            this.propagateChanges(c, props);
        }
        Node n = elt.getFirstChild();
        while (n != null) {
            this.propagateChanges(n, props);
            n = n.getNextSibling();
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event evt) {
            String name;
            EventTarget et = evt.getTarget();
            if (!(et instanceof CSSStylableElement)) {
                return;
            }
            CSSStylableElement elt = (CSSStylableElement)((Object)et);
            StyleMap style = elt.getComputedStyleMap(null);
            if (style == null) {
                return;
            }
            MutationEvent mevt = (MutationEvent)evt;
            Node attr = mevt.getRelatedNode();
            String attrNS = attr.getNamespaceURI();
            if (attrNS == null && CSSEngine.this.styleNamespaceURI == null || attrNS != null && attrNS.equals(CSSEngine.this.styleNamespaceURI)) {
                String string = name = attrNS == null ? attr.getNodeName() : attr.getLocalName();
                if (name.equals(CSSEngine.this.styleLocalName)) {
                    CSSEngine.this.inlineStyleAttributeUpdated(elt, style, mevt);
                    return;
                }
            }
            String string = name = attrNS == null ? attr.getNodeName() : attr.getLocalName();
            if (CSSEngine.this.nonCSSPresentationalHints != null && (attrNS == null && CSSEngine.this.nonCSSPresentationalHintsNamespaceURI == null || attrNS != null && attrNS.equals(CSSEngine.this.nonCSSPresentationalHintsNamespaceURI)) && CSSEngine.this.nonCSSPresentationalHints.contains(name)) {
                CSSEngine.this.nonCSSPresentationalHintUpdated(elt, style, name, mevt);
                return;
            }
            if (CSSEngine.this.selectorAttributes != null && CSSEngine.this.selectorAttributes.contains(name)) {
                elt.setComputedStyleMap(null, null);
                CSSEngine.this.firePropertiesChangedEvent(elt, CSSEngine.this.ALL_PROPERTIES);
                Node c = CSSEngine.getImportedChild(elt);
                if (c != null) {
                    CSSEngine.this.propagateChanges(c, CSSEngine.this.ALL_PROPERTIES);
                }
                Node n = elt.getFirstChild();
                while (n != null) {
                    CSSEngine.this.propagateChanges(n, CSSEngine.this.ALL_PROPERTIES);
                    n = n.getNextSibling();
                }
            }
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event evt) {
            Node n = (Node)((Object)evt.getTarget());
            if (n.getParentNode() instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateTreeProperties(CSSEngine.this.document.getDocumentElement());
            }
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        public void handleEvent(Event evt) {
            if (CSSEngine.this.styleSheetRemoved) {
                CSSEngine.this.styleSheetRemoved = false;
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateTreeProperties(CSSEngine.this.document.getDocumentElement());
            } else if (CSSEngine.this.removedStylableElementSibling != null) {
                Node n = CSSEngine.this.removedStylableElementSibling;
                while (n != null) {
                    CSSEngine.this.invalidateProperties(n);
                    n = n.getNextSibling();
                }
                CSSEngine.this.removedStylableElementSibling = null;
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event evt) {
            EventTarget et = evt.getTarget();
            if (et instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetRemoved = true;
            } else if (et instanceof CSSStylableElement) {
                CSSEngine.this.removedStylableElementSibling = ((Node)((Object)et)).getNextSibling();
            }
            CSSEngine.this.disposeStyleMaps((Node)((Object)et));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event evt) {
            EventTarget et = evt.getTarget();
            if (et instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateTreeProperties(CSSEngine.this.document.getDocumentElement());
                return;
            }
            if (et instanceof CSSStylableElement) {
                Node n = ((Node)((Object)evt.getTarget())).getNextSibling();
                while (n != null) {
                    CSSEngine.this.invalidateProperties(n);
                    n = n.getNextSibling();
                }
            }
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                if (this.styleMap.isImportant(i)) {
                    return;
                }
                if (this.styleMap.isComputed(i)) {
                    this.updatedProperties[i] = true;
                }
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                this.styleMap.putMask(i, (short)0);
                this.styleMap.putValue(i, v);
                this.styleMap.putOrigin(i, (short)Short.MIN_VALUE);
            }
        }
    }

    protected static class DocumentAdapter
    implements DocumentHandler {
        protected DocumentAdapter() {
        }

        public void startDocument(InputSource source) throws CSSException {
            throw new InternalError();
        }

        public void endDocument(InputSource source) throws CSSException {
            throw new InternalError();
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            throw new InternalError();
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            throw new InternalError();
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            throw new InternalError();
        }

        public void startMedia(SACMediaList media) throws CSSException {
            throw new InternalError();
        }

        public void endMedia(SACMediaList media) throws CSSException {
            throw new InternalError();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            throw new InternalError();
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            throw new InternalError();
        }

        public void startFontFace() throws CSSException {
            throw new InternalError();
        }

        public void endFontFace() throws CSSException {
            throw new InternalError();
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            throw new InternalError();
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            throw new InternalError();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            throw new InternalError();
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleSheet styleSheet;
        protected StyleRule styleRule;
        protected StyleDeclaration styleDeclaration;

        protected StyleSheetDocumentHandler() {
        }

        public void startDocument(InputSource source) throws CSSException {
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            ImportRule ir = new ImportRule();
            ir.setMediaList(media);
            ir.setParent(this.styleSheet);
            try {
                ir.setURI(new URL(CSSEngine.this.getCSSBaseURI(), uri));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            this.styleSheet.append(ir);
        }

        public void startMedia(SACMediaList media) throws CSSException {
            MediaRule mr = new MediaRule();
            mr.setMediaList(media);
            mr.setParent(this.styleSheet);
            this.styleSheet.append(mr);
            this.styleSheet = mr;
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.styleSheet = this.styleSheet.getParent();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
        }

        public void startFontFace() throws CSSException {
        }

        public void endFontFace() throws CSSException {
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.styleRule = new StyleRule();
            this.styleRule.setSelectorList(selectors);
            this.styleDeclaration = new StyleDeclaration();
            this.styleRule.setStyleDeclaration(this.styleDeclaration);
            this.styleSheet.append(this.styleRule);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this.styleRule = null;
            this.styleDeclaration = null;
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                this.styleDeclaration.append(v, i, important);
            }
        }
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                this.styleDeclaration.append(v, i, important);
            }
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;

        protected StyleDeclarationDocumentHandler() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                CSSEngine.this.putAuthorProperty(this.styleMap, i, v, important, (short)Short.MIN_VALUE);
            }
        }
    }
}

