/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import ij.util.Tools;

public class StringSorter {
    public static void sort(String[] a) {
        if (!StringSorter.alreadySorted(a)) {
            StringSorter.sort(a, 0, a.length - 1);
        }
    }

    static void sort(String[] a, int from, int to) {
        int i = from;
        int j = to;
        String center = a[(from + to) / 2];
        while (true) {
            if (i < to && center.compareTo(a[i]) > 0) {
                ++i;
                continue;
            }
            while (j > from && center.compareTo(a[j]) < 0) {
                --j;
            }
            if (i < j) {
                String temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
            if (i <= j) {
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (from < j) {
            StringSorter.sort(a, from, j);
        }
        if (i < to) {
            StringSorter.sort(a, i, to);
        }
    }

    static boolean alreadySorted(String[] a) {
        int i = 1;
        while (i < a.length) {
            if (a[i].compareTo(a[i - 1]) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] sortNumerically(String[] list) {
        int n = list.length;
        String[] paddedList = StringSorter.getPaddedNames(list);
        String[] sortedList = new String[n];
        int[] indexes = Tools.rank(paddedList);
        int i = 0;
        while (i < n) {
            sortedList[i] = list[indexes[i]];
            ++i;
        }
        return sortedList;
    }

    private static String[] getPaddedNames(String[] names) {
        int nNames = names.length;
        String[] paddedNames = new String[nNames];
        int maxLen = 0;
        int jj = 0;
        while (jj < nNames) {
            if (names[jj].length() > maxLen) {
                maxLen = names[jj].length();
            }
            ++jj;
        }
        int maxNums = maxLen / 2 + 1;
        int[][] numberStarts = new int[names.length][maxNums];
        int[][] numberLengths = new int[names.length][maxNums];
        int[] maxDigits = new int[maxNums];
        int jj2 = 0;
        while (jj2 < names.length) {
            String name = names[jj2];
            boolean inNumber = false;
            int nNumbers = 0;
            int nDigits = 0;
            int pos = 0;
            while (pos < name.length()) {
                boolean isDigit;
                boolean bl = isDigit = name.charAt(pos) >= '0' && name.charAt(pos) <= '9';
                if (isDigit) {
                    ++nDigits;
                    if (!inNumber) {
                        numberStarts[jj2][nNumbers] = pos;
                        inNumber = true;
                    }
                }
                if (inNumber && (!isDigit || pos == name.length() - 1)) {
                    inNumber = false;
                    if (maxDigits[nNumbers] < nDigits) {
                        maxDigits[nNumbers] = nDigits;
                    }
                    numberLengths[jj2][nNumbers] = nDigits;
                    ++nNumbers;
                    nDigits = 0;
                }
                ++pos;
            }
            ++jj2;
        }
        jj2 = 0;
        while (jj2 < names.length) {
            String string = names[jj2];
            ++jj2;
        }
        return paddedNames;
    }
}

