/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ColorStatistics
extends ImageStatistics {
    public ColorStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    public ColorStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        ColorProcessor cp = (ColorProcessor)ip;
        this.histogram = cp.getHistogram();
        this.setup(ip, cal);
        this.getRawStatistics(0, 255);
        if ((mOptions & 0x10) != 0) {
            this.getRawMinAndMax(0, 255);
        }
        if ((mOptions & 0x800) != 0 || (mOptions & 0x2000) != 0) {
            this.fitEllipse(ip, mOptions);
        } else if ((mOptions & 0x20) != 0) {
            this.getCentroid(ip);
        }
        if ((mOptions & 0x60040) != 0) {
            this.calculateMoments(ip);
        }
        if ((mOptions & 0x10000) != 0) {
            this.calculateMedian(this.histogram, 0, 255, cal);
        }
    }

    void calculateMoments(ImageProcessor ip) {
        byte[] mask = ip.getMaskArray();
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                if (mask == null || mask[mi++] != 0) {
                    double v = ip.getPixelValue(x, y);
                    double v2 = v * v;
                    sum1 += v;
                    sum2 += v2;
                    sum3 += v * v2;
                    sum4 += v2 * v2;
                    xsum += (double)x * v;
                    ysum += (double)y * v;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        double mean2 = this.mean * this.mean;
        double variance = sum2 / (double)this.pixelCount - mean2;
        double sDeviation = Math.sqrt(variance);
        this.skewness = ((sum3 - 3.0 * this.mean * sum2) / (double)this.pixelCount + 2.0 * this.mean * mean2) / (variance * sDeviation);
        this.kurtosis = ((sum4 - 4.0 * this.mean * sum3 + 6.0 * mean2 * sum2) / (double)this.pixelCount - 3.0 * mean2 * mean2) / (variance * variance) - 3.0;
        this.xCenterOfMass = xsum / sum1 + 0.5;
        this.yCenterOfMass = ysum / sum1 + 0.5;
        if (this.cal != null) {
            this.xCenterOfMass = this.cal.getX(this.xCenterOfMass);
            this.yCenterOfMass = this.cal.getY(this.yCenterOfMass, this.height);
        }
    }
}

