/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.TextRoi;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Fonts
extends PlugInFrame
implements PlugIn,
ItemListener {
    public static final String LOC_KEY = "fonts.loc";
    private static String[] sizes = new String[]{"8", "9", "10", "12", "14", "18", "24", "28", "36", "48", "60", "72", "100", "150", "225", "350"};
    private static int[] isizes = new int[]{8, 9, 10, 12, 14, 18, 24, 28, 36, 48, 60, 72, 100, 150, 225, 350};
    private Panel panel;
    private Choice font;
    private Choice size;
    private Choice style;
    private Checkbox checkbox;
    private static Frame instance;
    static /* synthetic */ Class class$0;

    public Fonts() {
        super("Fonts");
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        this.setLayout(new FlowLayout(1, 10, 5));
        this.font = new Choice();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        this.font.add("SansSerif");
        this.font.add("Serif");
        this.font.add("Monospaced");
        int i = 0;
        while (i < fonts.length) {
            String f = fonts[i];
            if (!(f.equals("SansSerif") || f.equals("Serif") || f.equals("Monospaced"))) {
                this.font.add(f);
            }
            ++i;
        }
        this.font.select(TextRoi.getFont());
        this.font.addItemListener(this);
        this.add(this.font);
        this.size = new Choice();
        i = 0;
        while (i < sizes.length) {
            this.size.add(sizes[i]);
            ++i;
        }
        this.size.select(this.getSizeIndex());
        this.size.addItemListener(this);
        this.add(this.size);
        this.style = new Choice();
        this.style.add("Plain");
        this.style.add("Bold");
        this.style.add("Italic");
        this.style.add("Bold+Italic");
        this.style.add("Center");
        this.style.add("Right");
        this.style.add("Center+Bold");
        this.style.add("Right+Bold");
        i = TextRoi.getStyle();
        int justificaton = TextRoi.getGlobalJustification();
        String s = "Plain";
        if (i == 1) {
            s = justificaton == 1 ? "Center+Bold" : (justificaton == 2 ? "Right+Bold" : "Bold");
        } else if (i == 2) {
            s = "Italic";
        } else if (i == 3) {
            s = "Bold+Italic";
        } else if (i == 0) {
            if (justificaton == 1) {
                s = "Center";
            } else if (justificaton == 2) {
                s = "Right";
            }
        }
        this.style.select(s);
        this.style.addItemListener(this);
        this.add(this.style);
        this.checkbox = new Checkbox("Smooth", TextRoi.isAntialiased());
        this.add(this.checkbox);
        this.checkbox.addItemListener(this);
        this.pack();
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.center(this);
        }
        this.show();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ij.plugin.frame.Fonts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJ.register(clazz);
    }

    int getSizeIndex() {
        int size = TextRoi.getSize();
        int index = 0;
        int i = 0;
        while (i < isizes.length) {
            if (size >= isizes[i]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void itemStateChanged(ItemEvent e) {
        String fontName = this.font.getSelectedItem();
        int fontSize = Integer.parseInt(this.size.getSelectedItem());
        String styleName = this.style.getSelectedItem();
        int fontStyle = 0;
        int justification = 0;
        if (styleName.endsWith("Bold")) {
            fontStyle = 1;
        } else if (styleName.equals("Italic")) {
            fontStyle = 2;
        } else if (styleName.equals("Bold+Italic")) {
            fontStyle = 3;
        }
        if (styleName.startsWith("Center")) {
            justification = 1;
        } else if (styleName.startsWith("Right")) {
            justification = 2;
        }
        TextRoi.setFont(fontName, fontSize, fontStyle, this.checkbox.getState());
        TextRoi.setGlobalJustification(justification);
        IJ.showStatus(String.valueOf(fontSize) + " point " + fontName + " " + styleName);
    }

    public void close() {
        super.close();
        instance = null;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
    }
}

