/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.EllipseRoi;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Rectangle;
import java.lang.reflect.Method;

public class Info
implements PlugInFilter {
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        String info = this.getImageInfo(this.imp, ip);
        if (info.indexOf("----") > 0) {
            this.showInfo(info, 450, 500);
        } else {
            this.showInfo(info, 300, 300);
        }
    }

    public String getImageInfo(ImagePlus imp, ImageProcessor ip) {
        ImageStack stack;
        String label;
        String infoProperty = null;
        if (imp.getStackSize() > 1 && (label = (stack = imp.getStack()).getSliceLabel(imp.getCurrentSlice())) != null && label.indexOf(10) > 0) {
            infoProperty = label;
        }
        if (infoProperty == null && (infoProperty = (String)imp.getProperty("Info")) == null) {
            infoProperty = this.getExifData(imp);
        }
        String info = this.getInfo(imp, ip);
        if (infoProperty != null) {
            return String.valueOf(infoProperty) + "\n------------------------\n" + info;
        }
        return info;
    }

    private String getExifData(ImagePlus imp) {
        Class<?> c;
        String metadata;
        String path;
        block8: {
            FileInfo fi = imp.getOriginalFileInfo();
            if (fi == null) {
                return null;
            }
            String directory = fi.directory;
            String name = fi.fileName;
            if (directory == null) {
                return null;
            }
            if ((name == null || name.equals("")) && imp.getStack().isVirtual()) {
                name = imp.getStack().getSliceLabel(imp.getCurrentSlice());
            }
            if (name == null || !name.endsWith("jpg") && !name.endsWith("JPG")) {
                return null;
            }
            path = String.valueOf(directory) + name;
            metadata = null;
            try {
                c = IJ.getClassLoader().loadClass("Exif_Reader");
                if (c != null) break block8;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        String methodName = "getMetadata";
        Class[] argClasses = new Class[]{methodName.getClass()};
        Method m = c.getMethod("getMetadata", argClasses);
        Object[] args = new Object[]{path};
        Object obj = m.invoke(null, args);
        metadata = obj != null ? obj.toString() : null;
        if (metadata != null && !metadata.startsWith("Error:")) {
            return metadata;
        }
        return null;
    }

    String getInfo(ImagePlus imp, ImageProcessor ip) {
        Roi roi;
        double mag;
        int digits;
        String s = new String("\n");
        s = String.valueOf(s) + "Title: " + imp.getTitle() + "\n";
        Calibration cal = imp.getCalibration();
        int stackSize = imp.getStackSize();
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int n = digits = imp.getBitDepth() == 32 ? 4 : 0;
        if (cal.scaled()) {
            String unit = cal.getUnit();
            String units = cal.getUnits();
            s = String.valueOf(s) + "Width:  " + IJ.d2s((double)imp.getWidth() * cal.pixelWidth, 2) + " " + units + " (" + imp.getWidth() + ")\n";
            s = String.valueOf(s) + "Height:  " + IJ.d2s((double)imp.getHeight() * cal.pixelHeight, 2) + " " + units + " (" + imp.getHeight() + ")\n";
            if (slices > 1) {
                s = String.valueOf(s) + "Depth:  " + IJ.d2s((double)slices * cal.pixelDepth, 2) + " " + units + " (" + slices + ")\n";
            }
            double xResolution = 1.0 / cal.pixelWidth;
            double yResolution = 1.0 / cal.pixelHeight;
            int places = Tools.getDecimalPlaces(xResolution, yResolution);
            if (xResolution == yResolution) {
                s = String.valueOf(s) + "Resolution:  " + IJ.d2s(xResolution, places) + " pixels per " + unit + "\n";
            } else {
                s = String.valueOf(s) + "X Resolution:  " + IJ.d2s(xResolution, places) + " pixels per " + unit + "\n";
                s = String.valueOf(s) + "Y Resolution:  " + IJ.d2s(yResolution, places) + " pixels per " + unit + "\n";
            }
        } else {
            s = String.valueOf(s) + "Width:  " + imp.getWidth() + " pixels\n";
            s = String.valueOf(s) + "Height:  " + imp.getHeight() + " pixels\n";
            if (stackSize > 1) {
                s = String.valueOf(s) + "Depth:  " + slices + " pixels\n";
            }
        }
        s = stackSize > 1 ? String.valueOf(s) + "Voxel size: " + this.d2s(cal.pixelWidth) + "x" + this.d2s(cal.pixelHeight) + "x" + this.d2s(cal.pixelDepth) + " " + cal.getUnit() + "\n" : String.valueOf(s) + "Pixel size: " + this.d2s(cal.pixelWidth) + "x" + this.d2s(cal.pixelHeight) + " " + cal.getUnit() + "\n";
        s = String.valueOf(s) + "ID: " + imp.getID() + "\n";
        String zOrigin = stackSize > 1 || cal.zOrigin != 0.0 ? "," + this.d2s(cal.zOrigin) : "";
        s = String.valueOf(s) + "Coordinate origin:  " + this.d2s(cal.xOrigin) + "," + this.d2s(cal.yOrigin) + zOrigin + "\n";
        int type = imp.getType();
        switch (type) {
            case 0: {
                s = String.valueOf(s) + "Bits per pixel: 8 ";
                String lut = "LUT";
                lut = imp.getProcessor().isColorLut() ? "color " + lut : "grayscale " + lut;
                if (imp.isInvertedLut()) {
                    lut = "inverting " + lut;
                }
                s = String.valueOf(s) + "(" + lut + ")\n";
                s = String.valueOf(s) + "Display range: " + (int)ip.getMin() + "-" + (int)ip.getMax() + "\n";
                break;
            }
            case 1: 
            case 2: {
                if (type == 1) {
                    String sign = cal.isSigned16Bit() ? "signed" : "unsigned";
                    s = String.valueOf(s) + "Bits per pixel: 16 (" + sign + ")\n";
                } else {
                    s = String.valueOf(s) + "Bits per pixel: 32 (float)\n";
                }
                s = String.valueOf(s) + "Display range: ";
                double min = ip.getMin();
                double max = ip.getMax();
                if (cal.calibrated()) {
                    min = cal.getCValue((int)min);
                    max = cal.getCValue((int)max);
                }
                s = String.valueOf(s) + IJ.d2s(min, digits) + " - " + IJ.d2s(max, digits) + "\n";
                break;
            }
            case 3: {
                s = String.valueOf(s) + "Bits per pixel: 8 (color LUT)\n";
                break;
            }
            case 4: {
                s = String.valueOf(s) + "Bits per pixel: 32 (RGB)\n";
            }
        }
        double interval = cal.frameInterval;
        double fps = cal.fps;
        if (stackSize > 1) {
            ImageStack stack = imp.getStack();
            int slice = imp.getCurrentSlice();
            String number = String.valueOf(slice) + "/" + stackSize;
            String label = stack.getShortSliceLabel(slice);
            label = label != null && label.length() > 0 ? " (" + label + ")" : "";
            if (interval > 0.0 || fps != 0.0) {
                s = String.valueOf(s) + "Frame: " + number + label + "\n";
                if (fps != 0.0) {
                    String sRate = Math.abs(fps - (double)Math.round(fps)) < 1.0E-5 ? IJ.d2s(fps, 0) : IJ.d2s(fps, 5);
                    s = String.valueOf(s) + "Frame rate: " + sRate + " fps\n";
                }
                if (interval != 0.0) {
                    s = String.valueOf(s) + "Frame interval: " + ((double)((int)interval) == interval ? IJ.d2s(interval, 0) : IJ.d2s(interval, 5)) + " " + cal.getTimeUnit() + "\n";
                }
            } else {
                s = String.valueOf(s) + "Image: " + number + label + "\n";
            }
            if (imp.isHyperStack()) {
                if (channels > 1) {
                    s = String.valueOf(s) + "  Channel: " + imp.getChannel() + "/" + channels + "\n";
                }
                if (slices > 1) {
                    s = String.valueOf(s) + "  Slice: " + imp.getSlice() + "/" + slices + "\n";
                }
                if (frames > 1) {
                    s = String.valueOf(s) + "  Frame: " + imp.getFrame() + "/" + frames + "\n";
                }
            }
            if (imp.isComposite()) {
                if (!imp.isHyperStack() && channels > 1) {
                    s = String.valueOf(s) + "  Channels: " + channels + "\n";
                }
                String mode = ((CompositeImage)imp).getModeAsString();
                s = String.valueOf(s) + "  Composite mode: \"" + mode + "\"\n";
            }
        }
        if (ip.getMinThreshold() == -808080.0) {
            s = String.valueOf(s) + "No Threshold\n";
        } else {
            double lower = ip.getMinThreshold();
            double upper = ip.getMaxThreshold();
            int dp = digits;
            if (cal.calibrated()) {
                lower = cal.getCValue((int)lower);
                upper = cal.getCValue((int)upper);
                dp = cal.isSigned16Bit() ? 0 : 4;
            }
            s = String.valueOf(s) + "Threshold: " + IJ.d2s(lower, dp) + "-" + IJ.d2s(upper, dp) + "\n";
        }
        ImageCanvas ic = imp.getCanvas();
        double d = mag = ic != null ? ic.getMagnification() : 1.0;
        if (mag != 1.0) {
            s = String.valueOf(s) + "Magnification: " + IJ.d2s(mag, 2) + "\n";
        }
        if (cal.calibrated()) {
            s = String.valueOf(s) + " \n";
            int curveFit = cal.getFunction();
            s = String.valueOf(s) + "Calibration Function: ";
            s = curveFit == 21 ? String.valueOf(s) + "Uncalibrated OD\n" : (curveFit == 22 ? String.valueOf(s) + "Custom lookup table\n" : String.valueOf(s) + CurveFitter.fList[curveFit] + "\n");
            double[] c = cal.getCoefficients();
            if (c != null) {
                s = String.valueOf(s) + "  a: " + IJ.d2s(c[0], 6) + "\n";
                s = String.valueOf(s) + "  b: " + IJ.d2s(c[1], 6) + "\n";
                if (c.length >= 3) {
                    s = String.valueOf(s) + "  c: " + IJ.d2s(c[2], 6) + "\n";
                }
                if (c.length >= 4) {
                    s = String.valueOf(s) + "  c: " + IJ.d2s(c[3], 6) + "\n";
                }
                if (c.length >= 5) {
                    s = String.valueOf(s) + "  c: " + IJ.d2s(c[4], 6) + "\n";
                }
            }
            s = String.valueOf(s) + "  Unit: \"" + cal.getValueUnit() + "\"\n";
        } else {
            s = String.valueOf(s) + "Uncalibrated\n";
        }
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            if (fi.url != null && !fi.url.equals("")) {
                s = String.valueOf(s) + "URL: " + fi.url + "\n";
            } else if (fi.directory != null && fi.fileName != null) {
                s = String.valueOf(s) + "Path: " + fi.directory + fi.fileName + "\n";
            }
        }
        if ((roi = imp.getRoi()) == null) {
            if (cal.calibrated()) {
                s = String.valueOf(s) + " \n";
            }
            s = String.valueOf(s) + "No Selection\n";
        } else if (roi instanceof EllipseRoi) {
            s = String.valueOf(s) + "\nElliptical Selection\n";
            double[] p = ((EllipseRoi)roi).getParams();
            double dx = p[2] - p[0];
            double dy = p[3] - p[1];
            double major = Math.sqrt(dx * dx + dy * dy);
            s = String.valueOf(s) + "  Major: " + IJ.d2s(major, 2) + "\n";
            s = String.valueOf(s) + "  Minor: " + IJ.d2s(major * p[4], 2) + "\n";
            s = String.valueOf(s) + "  X1: " + IJ.d2s(p[0], 2) + "\n";
            s = String.valueOf(s) + "  Y1: " + IJ.d2s(p[1], 2) + "\n";
            s = String.valueOf(s) + "  X2: " + IJ.d2s(p[2], 2) + "\n";
            s = String.valueOf(s) + "  Y2: " + IJ.d2s(p[3], 2) + "\n";
            s = String.valueOf(s) + "  Aspect ratio: " + IJ.d2s(p[4], 2) + "\n";
        } else {
            String name;
            s = String.valueOf(s) + " \n";
            s = String.valueOf(s) + roi.getTypeAsString() + " Selection";
            String points = null;
            if (roi instanceof PointRoi) {
                int npoints = ((PolygonRoi)roi).getNCoordinates();
                String suffix = npoints > 1 ? "s)" : ")";
                points = " (" + npoints + " point" + suffix;
            }
            if ((name = roi.getName()) != null) {
                s = String.valueOf(s) + " (\"" + name + "\")";
                if (points != null) {
                    s = String.valueOf(s) + "\n " + points;
                }
            } else if (points != null) {
                s = String.valueOf(s) + points;
            }
            s = String.valueOf(s) + "\n";
            Rectangle r = roi.getBounds();
            if (roi instanceof Line) {
                Line line = (Line)roi;
                s = String.valueOf(s) + "  X1: " + IJ.d2s(line.x1d * cal.pixelWidth) + "\n";
                s = String.valueOf(s) + "  Y1: " + IJ.d2s(this.yy(line.y1d, imp) * cal.pixelHeight) + "\n";
                s = String.valueOf(s) + "  X2: " + IJ.d2s(line.x2d * cal.pixelWidth) + "\n";
                s = String.valueOf(s) + "  Y2: " + IJ.d2s(this.yy(line.y2d, imp) * cal.pixelHeight) + "\n";
            } else if (cal.scaled()) {
                s = String.valueOf(s) + "  X: " + IJ.d2s(cal.getX(r.x)) + " (" + r.x + ")\n";
                s = String.valueOf(s) + "  Y: " + IJ.d2s(cal.getY(r.y, imp.getHeight())) + " (" + r.y + ")\n";
                s = String.valueOf(s) + "  Width: " + IJ.d2s((double)r.width * cal.pixelWidth) + " (" + r.width + ")\n";
                s = String.valueOf(s) + "  Height: " + IJ.d2s((double)r.height * cal.pixelHeight) + " (" + r.height + ")\n";
            } else {
                s = String.valueOf(s) + "  X: " + r.x + "\n";
                s = String.valueOf(s) + "  Y: " + this.yy(r.y, imp) + "\n";
                s = String.valueOf(s) + "  Width: " + r.width + "\n";
                s = String.valueOf(s) + "  Height: " + r.height + "\n";
            }
        }
        return s;
    }

    String d2s(double n) {
        return n == (double)((int)n) ? Integer.toString((int)n) : IJ.d2s(n);
    }

    int yy(int y, ImagePlus imp) {
        return Analyzer.updateY(y, imp.getHeight());
    }

    double yy(double y, ImagePlus imp) {
        return Analyzer.updateY(y, imp.getHeight());
    }

    void showInfo(String info, int width, int height) {
        new TextWindow("Info for " + this.imp.getTitle(), info, width, height);
    }
}

