/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class GaussianBlur
implements ExtendedPlugInFilter,
DialogListener {
    private static double sigma = 2.0;
    private static boolean sigmaScaled = false;
    private int flags = 16777311;
    private ImagePlus imp;
    private boolean hasScale = false;
    private int nPasses = 1;
    private int nChannels = 1;
    private int pass;
    private boolean noProgress;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (imp != null && imp.getRoi() != null) {
            Rectangle roiRect = imp.getRoi().getBoundingRect();
            if (roiRect.y > 0 || roiRect.y + roiRect.height < imp.getDimensions()[1]) {
                this.flags |= 0x4000;
            }
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        String options = Macro.getOptions();
        boolean oldMacro = false;
        this.nChannels = imp.getProcessor().getNChannels();
        if (options != null && options.indexOf("radius=") >= 0) {
            oldMacro = true;
            Macro.setOptions(options.replaceAll("radius=", "sigma="));
        }
        GenericDialog gd = new GenericDialog(command);
        sigma = Math.abs(sigma);
        gd.addNumericField("Sigma (Radius):", sigma, 2);
        if (imp.getCalibration() != null && !imp.getCalibration().getUnits().equals("pixels")) {
            this.hasScale = true;
            gd.addCheckbox("Scaled Units (" + imp.getCalibration().getUnits() + ")", sigmaScaled);
        } else {
            sigmaScaled = false;
        }
        gd.addPreviewCheckbox(pfr);
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        if (oldMacro) {
            sigma /= 2.5;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog(imp, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        sigma = gd.getNextNumber();
        if (sigma < 0.0 || gd.invalidNumber()) {
            return false;
        }
        if (this.hasScale) {
            sigmaScaled = gd.getNextBoolean();
        }
        return true;
    }

    public void setNPasses(int nPasses) {
        this.nPasses = 2 * this.nChannels * nPasses;
        this.pass = 0;
    }

    public void run(ImageProcessor ip) {
        double sigmaX = sigmaScaled ? sigma / this.imp.getCalibration().pixelWidth : sigma;
        double sigmaY = sigmaScaled ? sigma / this.imp.getCalibration().pixelHeight : sigma;
        double accuracy = ip instanceof ByteProcessor || ip instanceof ColorProcessor ? 0.002 : 2.0E-4;
        Rectangle roi = ip.getRoi();
        this.blurGaussian(ip, sigmaX, sigmaY, accuracy);
    }

    public boolean blur(ImageProcessor ip, double radius) {
        Rectangle roi = ip.getRoi();
        if (roi.height != ip.getHeight() && ip.getMask() == null) {
            ip.snapshot();
        }
        this.blurGaussian(ip, 0.4 * radius, 0.4 * radius, 0.01);
        return true;
    }

    public void blurGaussian(ImageProcessor ip, double sigmaX, double sigmaY, double accuracy) {
        if (this.nPasses <= 1) {
            this.nPasses = ip.getNChannels() * (sigmaX > 0.0 && sigmaY > 0.0 ? 2 : 1);
        }
        FloatProcessor fp = null;
        int i = 0;
        while (i < ip.getNChannels()) {
            fp = ip.toFloat(i, fp);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.blurFloat(fp, sigmaX, sigmaY, accuracy);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ip.setPixels(i, fp);
            ++i;
        }
        if (ip.getRoi().height != ip.getHeight() && sigmaX > 0.0 && sigmaY > 0.0) {
            GaussianBlur.resetOutOfRoi(ip, (int)Math.ceil(5.0 * sigmaY));
        }
    }

    public void blurFloat(FloatProcessor ip, double sigmaX, double sigmaY, double accuracy) {
        if (sigmaX > 0.0) {
            this.blur1Direction(ip, sigmaX, accuracy, true, (int)Math.ceil(5.0 * sigmaY));
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (sigmaY > 0.0) {
            this.blur1Direction(ip, sigmaY, accuracy, false, 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void blur1Direction(FloatProcessor ip, double sigma, double accuracy, boolean xDirection, int extraLines) {
        block10: {
            UPSCALE_K_RADIUS = 2;
            MIN_DOWNSCALED_SIGMA = 4.0;
            pixels = (float[])ip.getPixels();
            width = ip.getWidth();
            height = ip.getHeight();
            roi = ip.getRoi();
            length = xDirection != false ? width : height;
            pointInc = xDirection != false ? 1 : width;
            lineInc = xDirection != false ? width : 1;
            lineFromA = (xDirection != false ? roi.y : roi.x) - extraLines;
            lineFrom = lineFromA < 0 ? 0 : lineFromA;
            lineToA = (xDirection != false ? roi.y + roi.height : roi.x + roi.width) + extraLines;
            lineTo = lineToA > (xDirection != false ? height : width) ? (xDirection != false ? height : width) : lineToA;
            writeFrom = xDirection != false ? roi.x : roi.y;
            writeTo = xDirection != false ? roi.x + roi.width : roi.y + roi.height;
            ++this.pass;
            if (this.pass > this.nPasses) {
                this.pass = 1;
            }
            numThreads = Math.min(Prefs.getThreads(), lineTo - lineFrom);
            lineThreads = new Thread[numThreads];
            doDownscaling = sigma > 8.5;
            reduceBy = doDownscaling != false ? Math.min((int)Math.floor(sigma / 4.0), length) : 1;
            sigmaGauss = doDownscaling != false ? Math.sqrt(sigma * sigma / (double)(reduceBy * reduceBy) - 0.3333333333333333 - 0.25) : sigma;
            maxLength = doDownscaling != false ? (length + reduceBy - 1) / reduceBy + 6 : length;
            gaussKernel = this.makeGaussianKernel(sigmaGauss, accuracy, maxLength);
            kRadius = gaussKernel[0].length * reduceBy;
            readFrom = writeFrom - kRadius < 0 ? 0 : writeFrom - kRadius;
            readTo = writeTo + kRadius > length ? length : writeTo + kRadius;
            newLength = doDownscaling != false ? (readTo - readFrom + reduceBy - 1) / reduceBy + 6 : length;
            unscaled0 = readFrom - 3 * reduceBy;
            downscaleKernel = doDownscaling != false ? GaussianBlur.makeDownscaleKernel(reduceBy) : null;
            upscaleKernel = doDownscaling != false ? GaussianBlur.makeUpscaleKernel(reduceBy) : null;
            t = 0;
            while (t < numThreads) {
                ti = t;
                cache1 = new float[newLength];
                cache2 = doDownscaling != false ? new float[newLength] : null;
                thread = new Thread(new Runnable(){

                    public final void run() {
                        long lastTime = System.currentTimeMillis();
                        boolean canShowProgress = Thread.currentThread() == lineThreads[0];
                        int pixel0 = (lineFrom + ti) * lineInc;
                        int line = lineFrom + ti;
                        while (line < lineTo) {
                            long time = System.currentTimeMillis();
                            if (time - lastTime > 110L) {
                                if (canShowProgress) {
                                    GaussianBlur.this.showProgress((double)(line - lineFrom) / (double)(lineTo - lineFrom));
                                }
                                if (Thread.currentThread().isInterrupted()) {
                                    return;
                                }
                                lastTime = time;
                            }
                            if (doDownscaling) {
                                GaussianBlur.downscaleLine(pixels, cache1, downscaleKernel, reduceBy, pixel0, unscaled0, length, pointInc, newLength);
                                GaussianBlur.convolveLine(cache1, cache2, gaussKernel, 0, newLength, 1, newLength - 1, 0, 1);
                                GaussianBlur.upscaleLine(cache2, pixels, upscaleKernel, reduceBy, pixel0, unscaled0, writeFrom, writeTo, pointInc);
                            } else {
                                int p = pixel0 + readFrom * pointInc;
                                int i = readFrom;
                                while (i < readTo) {
                                    cache1[i] = pixels[p];
                                    ++i;
                                    p += pointInc;
                                }
                                GaussianBlur.convolveLine(cache1, pixels, gaussKernel, readFrom, readTo, writeFrom, writeTo, pixel0, pointInc);
                            }
                            line += numThreads;
                            pixel0 += numThreads * lineInc;
                        }
                    }
                }, "GaussianBlur-" + t);
                thread.setPriority(Thread.currentThread().getPriority());
                lineThreads[ti] = thread;
                thread.start();
                ++t;
            }
            try {
                i = 0;
                while (i < lineThreads.length) {
                    thread = lineThreads[i];
                    if (thread != null) {
                        thread.join();
                    }
                    ++i;
                }
                break block10;
            }
            catch (InterruptedException e) {
                i = 0;
                ** while (i < lineThreads.length)
            }
lbl-1000:
            // 1 sources

            {
                thread = lineThreads[i];
                thread.interrupt();
                ++i;
                continue;
            }
lbl60:
            // 1 sources

            try {
                i = 0;
                while (i < lineThreads.length) {
                    thread = lineThreads[i];
                    thread.join();
                    ++i;
                }
            }
            catch (InterruptedException var40_39) {
                // empty catch block
            }
            Thread.currentThread().interrupt();
        }
        this.showProgress(1.0);
    }

    private static final void downscaleLine(float[] pixels, float[] cache, float[] kernel, int reduceBy, int pixel0, int unscaled0, int length, int pointInc, int newLength) {
        int p = pixel0 + pointInc * (unscaled0 - reduceBy * 3 / 2);
        int pLast = pixel0 + pointInc * (length - 1);
        int xout = -1;
        while (xout <= newLength) {
            float sum0 = 0.0f;
            float sum1 = 0.0f;
            float sum2 = 0.0f;
            int x = 0;
            while (x < reduceBy) {
                float v = pixels[p < pixel0 ? pixel0 : (p > pLast ? pLast : p)];
                sum0 += v * kernel[x + 2 * reduceBy];
                sum1 += v * kernel[x + reduceBy];
                sum2 += v * kernel[x];
                ++x;
                p += pointInc;
            }
            if (xout > 0) {
                int n = xout - 1;
                cache[n] = cache[n] + sum0;
            }
            if (xout >= 0 && xout < newLength) {
                int n = xout;
                cache[n] = cache[n] + sum1;
            }
            if (xout + 1 < newLength) {
                cache[xout + 1] = sum2;
            }
            ++xout;
        }
    }

    private static final float[] makeDownscaleKernel(int unitLength) {
        float v;
        double x;
        int mid = unitLength * 3 / 2;
        float[] kernel = new float[3 * unitLength];
        int i = 0;
        while (i <= unitLength / 2) {
            x = (double)i / (double)unitLength;
            kernel[mid - i] = v = (float)((0.75 - x * x) / (double)unitLength);
            kernel[mid + i] = v;
            ++i;
        }
        i = unitLength / 2 + 1;
        while (i < (unitLength * 3 + 1) / 2) {
            x = (double)i / (double)unitLength;
            kernel[mid - i] = v = (float)((0.125 + 0.5 * (x - 1.0) * (x - 2.0)) / (double)unitLength);
            kernel[mid + i] = v;
            ++i;
        }
        return kernel;
    }

    private static final void upscaleLine(float[] cache, float[] pixels, float[] kernel, int reduceBy, int pixel0, int unscaled0, int writeFrom, int writeTo, int pointInc) {
        int p = pixel0 + pointInc * writeFrom;
        int xout = writeFrom;
        while (xout < writeTo) {
            int xin = (xout - unscaled0 + reduceBy - 1) / reduceBy;
            int x = reduceBy - 1 - (xout - unscaled0 + reduceBy - 1) % reduceBy;
            pixels[p] = cache[xin - 2] * kernel[x] + cache[xin - 1] * kernel[x + reduceBy] + cache[xin] * kernel[x + 2 * reduceBy] + cache[xin + 1] * kernel[x + 3 * reduceBy];
            ++xout;
            p += pointInc;
        }
    }

    private static final float[] makeUpscaleKernel(int unitLength) {
        float v;
        double x;
        float[] kernel = new float[4 * unitLength];
        int mid = 2 * unitLength;
        kernel[0] = 0.0f;
        int i = 0;
        while (i < unitLength) {
            x = (double)i / (double)unitLength;
            kernel[mid + i] = v = (float)(0.6666666666666666 - x * x * (1.0 - 0.5 * x));
            kernel[mid - i] = v;
            ++i;
        }
        i = unitLength;
        while (i < 2 * unitLength) {
            x = (double)i / (double)unitLength;
            kernel[mid + i] = v = (float)((2.0 - x) * (2.0 - x) * (2.0 - x) / 6.0);
            kernel[mid - i] = v;
            ++i;
        }
        return kernel;
    }

    private static final void convolveLine(float[] input, float[] pixels, float[][] kernel, int readFrom, int readTo, int writeFrom, int writeTo, int point0, int pointInc) {
        int length = input.length;
        float first = input[0];
        float last = input[length - 1];
        float[] kern = kernel[0];
        float kern0 = kern[0];
        float[] kernSum = kernel[1];
        int kRadius = kern.length;
        int firstPart = kRadius < length ? kRadius : length;
        int p = point0 + writeFrom * pointInc;
        int i = writeFrom;
        while (i < firstPart) {
            float result = input[i] * kern0;
            result += kernSum[i] * first;
            if (i + kRadius > length) {
                result += kernSum[length - i - 1] * last;
            }
            int k = 1;
            while (k < kRadius) {
                float v = 0.0f;
                if (i - k >= 0) {
                    v += input[i - k];
                }
                if (i + k < length) {
                    v += input[i + k];
                }
                result += kern[k] * v;
                ++k;
            }
            pixels[p] = result;
            ++i;
            p += pointInc;
        }
        int iEndInside = length - kRadius < writeTo ? length - kRadius : writeTo;
        while (i < iEndInside) {
            float result = input[i] * kern0;
            int k = 1;
            while (k < kRadius) {
                result += kern[k] * (input[i - k] + input[i + k]);
                ++k;
            }
            pixels[p] = result;
            ++i;
            p += pointInc;
        }
        while (i < writeTo) {
            float result = input[i] * kern0;
            if (i < kRadius) {
                result += kernSum[i] * first;
            }
            if (i + kRadius >= length) {
                result += kernSum[length - i - 1] * last;
            }
            int k = 1;
            while (k < kRadius) {
                float v = 0.0f;
                if (i - k >= 0) {
                    v += input[i - k];
                }
                if (i + k < length) {
                    v += input[i + k];
                }
                result += kern[k] * v;
                ++k;
            }
            pixels[p] = result;
            ++i;
            p += pointInc;
        }
    }

    public float[][] makeGaussianKernel(double sigma, double accuracy, int maxRadius) {
        double sum;
        int kRadius = (int)Math.ceil(sigma * Math.sqrt(-2.0 * Math.log(accuracy))) + 1;
        if (maxRadius < 50) {
            maxRadius = 50;
        }
        if (kRadius > maxRadius) {
            kRadius = maxRadius;
        }
        float[][] kernel = new float[2][kRadius];
        int i = 0;
        while (i < kRadius) {
            kernel[0][i] = (float)Math.exp(-0.5 * (double)i * (double)i / sigma / sigma);
            ++i;
        }
        if (kRadius < maxRadius && kRadius > 3) {
            double sqrtSlope = Double.MAX_VALUE;
            int r = kRadius;
            while (r > kRadius / 2) {
                double a;
                if (!((a = Math.sqrt(kernel[0][--r]) / (double)(kRadius - r)) < sqrtSlope)) break;
                sqrtSlope = a;
            }
            int r1 = r + 2;
            while (r1 < kRadius) {
                kernel[0][r1] = (float)((double)((kRadius - r1) * (kRadius - r1)) * sqrtSlope * sqrtSlope);
                ++r1;
            }
        }
        if (kRadius < maxRadius) {
            sum = kernel[0][0];
            int i2 = 1;
            while (i2 < kRadius) {
                sum += (double)(2.0f * kernel[0][i2]);
                ++i2;
            }
        } else {
            sum = sigma * Math.sqrt(Math.PI * 2);
        }
        double rsum = 0.5 + 0.5 * (double)kernel[0][0] / sum;
        int i3 = 0;
        while (i3 < kRadius) {
            double v = (double)kernel[0][i3] / sum;
            kernel[0][i3] = (float)v;
            kernel[1][i3] = (float)(rsum -= v);
            ++i3;
        }
        return kernel;
    }

    public static void resetOutOfRoi(ImageProcessor ip, int radius) {
        Rectangle roi = ip.getRoi();
        int width = ip.getWidth();
        int height = ip.getHeight();
        Object pixels = ip.getPixels();
        Object snapshot = ip.getSnapshotPixels();
        int y0 = roi.y - radius;
        if (y0 < 0) {
            y0 = 0;
        }
        int y = y0;
        int p = width * y + roi.x;
        while (y < roi.y) {
            System.arraycopy(snapshot, p, pixels, p, roi.width);
            ++y;
            p += width;
        }
        int yEnd = roi.y + roi.height + radius;
        if (yEnd > height) {
            yEnd = height;
        }
        int y2 = roi.y + roi.height;
        int p2 = width * y2 + roi.x;
        while (y2 < yEnd) {
            System.arraycopy(snapshot, p2, pixels, p2, roi.width);
            ++y2;
            p2 += width;
        }
    }

    private void showProgress(double percent) {
        if (this.noProgress) {
            return;
        }
        percent = (double)(this.pass - 1) / (double)this.nPasses + percent / (double)this.nPasses;
        IJ.showProgress(percent);
    }

    public void showProgress(boolean showProgressBar) {
        this.noProgress = !showProgressBar;
    }
}

