/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.MaximumFinder;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class EDM
implements ExtendedPlugInFilter {
    public static final int BYTE_OVERWRITE = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int FLOAT = 3;
    public static final int ONE = 41;
    public static final int SQRT2 = 58;
    public static final int SQRT5 = 92;
    private ImagePlus imp;
    private ImagePlus outImp;
    private PlugInFilterRunner pfr;
    private String command;
    private int outImageType;
    private ImageStack outStack;
    private int processType;
    private MaximumFinder maxFinder = new MaximumFinder();
    private double progressDone;
    private int nPasses;
    private boolean interrupted;
    private boolean background255;
    private int flags = 98305;
    private static final int EDM = 0;
    private static final int WATERSHED = 1;
    private static final int UEP = 2;
    private static final int VORONOI = 3;
    private static final boolean[] USES_MAX_FINDER;
    private static final boolean[] USES_WATERSHED;
    private static final String[] TITLE_PREFIX;
    private static final int NO_POINT = -1;
    private static final double MAXFINDER_TOLERANCE = 0.5;
    private static int outputType;

    static {
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        USES_MAX_FINDER = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[1] = true;
        blArray2[3] = true;
        USES_WATERSHED = blArray2;
        String[] stringArray = new String[4];
        stringArray[0] = "EDM of ";
        stringArray[2] = "UEPs of ";
        stringArray[3] = "Voronoi of ";
        TITLE_PREFIX = stringArray;
        outputType = 0;
    }

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("final")) {
            this.showOutput();
            return 4096;
        }
        this.imp = imp;
        if (arg.equals("watershed")) {
            this.processType = 1;
            this.flags += 131072;
        } else if (arg.equals("points")) {
            this.processType = 2;
        } else if (arg.equals("voronoi")) {
            this.processType = 3;
        }
        if (this.processType != 1) {
            this.outImageType = outputType;
        }
        if (this.outImageType != 0) {
            this.flags |= 0x80;
        }
        if (imp != null) {
            ImageProcessor ip = imp.getProcessor();
            if (!ip.isBinary()) {
                IJ.error("8-bit binary image (0 and 255) required.");
                return 4096;
            }
            ip.resetRoi();
            boolean invertedLut = imp.isInvertedLut();
            this.background255 = invertedLut && Prefs.blackBackground || !invertedLut && !Prefs.blackBackground;
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.pfr = pfr;
        int width = imp.getWidth();
        int height = imp.getHeight();
        this.flags = IJ.setupDialog(imp, this.flags);
        if ((this.flags & 0x20) != 0 && this.outImageType != 0) {
            this.outStack = new ImageStack(width, height, imp.getStackSize());
            this.maxFinder.setNPasses(imp.getStackSize());
        }
        return this.flags;
    }

    public void run(ImageProcessor ip) {
        int backgroundValue;
        if (this.interrupted) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        int n = this.processType == 3 ? (this.background255 ? 0 : -1) : (backgroundValue = this.background255 ? -1 : 0);
        if (USES_WATERSHED[this.processType]) {
            this.nPasses = 0;
        }
        FloatProcessor floatEdm = this.makeFloatEDM(ip, backgroundValue, false);
        ImageProcessor maxIp = null;
        if (USES_MAX_FINDER[this.processType]) {
            boolean isEDM;
            int maxOutputType;
            if (this.processType == 3) {
                floatEdm.multiply(-1.0);
            }
            if ((maxIp = this.maxFinder.findMaxima(floatEdm, 0.5, -808080.0, maxOutputType = USES_WATERSHED[this.processType] ? 2 : 0, false, isEDM = this.processType != 3)) == null) {
                this.interrupted = true;
                return;
            }
            if (this.processType != 1) {
                if (this.processType == 3) {
                    floatEdm.multiply(-1.0);
                }
                this.resetMasked(floatEdm, maxIp, this.processType == 3 ? -1 : 0);
            }
        }
        ImageProcessor outIp = null;
        if (this.processType == 1) {
            if (this.background255) {
                maxIp.invert();
            }
            ip.copyBits(maxIp, 0, 0, 0);
            ip.setBinaryThreshold();
        } else {
            switch (this.outImageType) {
                case 3: {
                    outIp = floatEdm;
                    break;
                }
                case 2: {
                    floatEdm.setMinAndMax(0.0, 65535.0);
                    outIp = floatEdm.convertToShort(true);
                    break;
                }
                case 1: {
                    floatEdm.setMinAndMax(0.0, 255.0);
                    outIp = floatEdm.convertToByte(true);
                    break;
                }
                case 0: {
                    ip.setPixels(0, floatEdm);
                    if (!(floatEdm.getMax() > 255.0)) break;
                    ip.resetMinAndMax();
                }
            }
        }
        if (this.outImageType != 0) {
            if (this.outStack == null) {
                this.outImp = new ImagePlus(String.valueOf(TITLE_PREFIX[this.processType]) + this.imp.getShortTitle(), outIp);
            } else {
                this.outStack.setPixels(outIp.getPixels(), this.pfr.getSliceNumber());
            }
        }
    }

    public void setNPasses(int nPasses) {
        this.nPasses = nPasses;
        this.progressDone = 0.0;
        if (USES_MAX_FINDER[this.processType]) {
            this.maxFinder.setNPasses(nPasses);
        }
    }

    public void toEDM(ImageProcessor ip) {
        ip.setPixels(0, this.makeFloatEDM(ip, 0, false));
        ip.resetMinAndMax();
    }

    public void toWatershed(ImageProcessor ip) {
        FloatProcessor floatEdm = this.makeFloatEDM(ip, 0, false);
        ByteProcessor maxIp = this.maxFinder.findMaxima(floatEdm, 0.5, -808080.0, 2, false, true);
        if (maxIp != null) {
            ip.copyBits(maxIp, 0, 0, 9);
        }
    }

    public ShortProcessor make16bitEDM(ImageProcessor ip) {
        FloatProcessor floatEdm = this.makeFloatEDM(ip, 0, false);
        floatEdm.setMinAndMax(0.0, 1598.4146341463415);
        return (ShortProcessor)floatEdm.convertToShort(true);
    }

    public FloatProcessor makeFloatEDM(ImageProcessor ip, int backgroundValue, boolean edgesAreBackground) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        FloatProcessor fp = new FloatProcessor(width, height);
        byte[] bPixels = (byte[])ip.getPixels();
        float[] fPixels = (float[])fp.getPixels();
        int progressInterval = 100;
        int nProgressUpdates = height / 100;
        double progressAddendum = nProgressUpdates > 0 ? 0.5 / (double)nProgressUpdates : 0.0;
        int i = 0;
        while (i < width * height) {
            if (bPixels[i] != backgroundValue) {
                fPixels[i] = Float.MAX_VALUE;
            }
            ++i;
        }
        int[][] pointBufs = new int[2][width];
        int yDist = Integer.MAX_VALUE;
        int x = 0;
        while (x < width) {
            pointBufs[0][x] = -1;
            pointBufs[1][x] = -1;
            ++x;
        }
        int y = 0;
        while (y < height) {
            if (edgesAreBackground) {
                yDist = y + 1;
            }
            this.edmLine(bPixels, fPixels, pointBufs, width, y * width, y, backgroundValue, yDist);
            if (y % 100 == 0) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                this.addProgress(progressAddendum);
            }
            ++y;
        }
        x = 0;
        while (x < width) {
            pointBufs[0][x] = -1;
            pointBufs[1][x] = -1;
            ++x;
        }
        y = height - 1;
        while (y >= 0) {
            if (edgesAreBackground) {
                yDist = height - y;
            }
            this.edmLine(bPixels, fPixels, pointBufs, width, y * width, y, backgroundValue, yDist);
            if (y % 100 == 0) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                this.addProgress(progressAddendum);
            }
            --y;
        }
        fp.sqrt();
        return fp;
    }

    private void edmLine(byte[] bPixels, float[] fPixels, int[][] pointBufs, int width, int offset, int y, int backgroundValue, int yDist) {
        float dist2;
        int pNextDiag;
        int[] points = pointBufs[0];
        int pPrev = -1;
        int pDiag = -1;
        boolean edgesAreBackground = yDist != Integer.MAX_VALUE;
        int distSqr = Integer.MAX_VALUE;
        int x = 0;
        while (x < width) {
            pNextDiag = points[x];
            if (bPixels[offset] == backgroundValue) {
                points[x] = x | y << 16;
            } else {
                if (edgesAreBackground) {
                    int n = distSqr = x + 1 < yDist ? (x + 1) * (x + 1) : yDist * yDist;
                }
                if (fPixels[offset] > (dist2 = this.minDist2(points, pPrev, pDiag, x, y, distSqr))) {
                    fPixels[offset] = dist2;
                }
            }
            pPrev = points[x];
            pDiag = pNextDiag;
            ++x;
            ++offset;
        }
        --offset;
        points = pointBufs[1];
        pPrev = -1;
        pDiag = -1;
        x = width - 1;
        while (x >= 0) {
            pNextDiag = points[x];
            if (bPixels[offset] == backgroundValue) {
                points[x] = x | y << 16;
            } else {
                if (edgesAreBackground) {
                    int n = distSqr = width - x < yDist ? (width - x) * (width - x) : yDist * yDist;
                }
                if (fPixels[offset] > (dist2 = this.minDist2(points, pPrev, pDiag, x, y, distSqr))) {
                    fPixels[offset] = dist2;
                }
            }
            pPrev = points[x];
            pDiag = pNextDiag;
            --x;
            --offset;
        }
    }

    private float minDist2(int[] points, int pPrev, int pDiag, int x, int y, int distSqr) {
        int y1;
        int x1;
        int y0;
        int x0;
        int dist1Sqr;
        int p0;
        int nearestPoint = p0 = points[x];
        if (p0 != -1 && (dist1Sqr = (x - (x0 = p0 & 0xFFFF)) * (x - x0) + (y - (y0 = p0 >> 16 & 0xFFFF)) * (y - y0)) < distSqr) {
            distSqr = dist1Sqr;
        }
        if (pDiag != p0 && pDiag != -1 && (dist1Sqr = (x - (x1 = pDiag & 0xFFFF)) * (x - x1) + (y - (y1 = pDiag >> 16 & 0xFFFF)) * (y - y1)) < distSqr) {
            nearestPoint = pDiag;
            distSqr = dist1Sqr;
        }
        if (pPrev != pDiag && pPrev != -1 && (dist1Sqr = (x - (x1 = pPrev & 0xFFFF)) * (x - x1) + (y - (y1 = pPrev >> 16 & 0xFFFF)) * (y - y1)) < distSqr) {
            nearestPoint = pPrev;
            distSqr = dist1Sqr;
        }
        points[x] = nearestPoint;
        return distSqr;
    }

    private void byteFromFloat(ImageProcessor ip, FloatProcessor floatEdm) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] bPixels = (byte[])ip.getPixels();
        float[] fPixels = (float[])floatEdm.getPixels();
        int i = 0;
        while (i < width * height) {
            float v = fPixels[i];
            bPixels[i] = v < 255.0f ? (int)((int)((double)v + 0.5)) : -1;
            ++i;
        }
    }

    private void resetMasked(FloatProcessor floatEdm, ImageProcessor mask, int resetOnThis) {
        int width = mask.getWidth();
        int height = mask.getHeight();
        byte[] mPixels = (byte[])mask.getPixels();
        float[] fPixels = (float[])floatEdm.getPixels();
        int i = 0;
        while (i < width * height) {
            if (mPixels[i] == resetOnThis) {
                fPixels[i] = 0.0f;
            }
            ++i;
        }
    }

    private void showOutput() {
        if (this.interrupted) {
            return;
        }
        if (this.outStack != null) {
            this.outImp = new ImagePlus(String.valueOf(TITLE_PREFIX[this.processType]) + this.imp.getShortTitle(), this.outStack);
            int[] d = this.imp.getDimensions();
            this.outImp.setDimensions(d[2], d[3], d[4]);
            int i = 1;
            while (i <= this.imp.getStackSize()) {
                this.outStack.setSliceLabel(this.imp.getStack().getSliceLabel(i), i);
                ++i;
            }
        }
        if (this.outImageType != 0) {
            ImageProcessor ip = this.outImp.getProcessor();
            if (!Prefs.blackBackground) {
                ip.invertLut();
            }
            ip.resetMinAndMax();
            this.outImp.show();
        }
    }

    private void addProgress(double deltaProgress) {
        if (this.nPasses == 0) {
            return;
        }
        this.progressDone += deltaProgress;
        IJ.showProgress(this.progressDone / (double)this.nPasses);
    }

    public static void setOutputType(int type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        outputType = type;
    }

    public static int getOutputType() {
        return outputType;
    }
}

