/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class CalibrationBar
implements PlugInFilter {
    static final int BAR_LENGTH = 128;
    static final int BAR_THICKNESS = 12;
    static final int XMARGIN = 10;
    static final int YMARGIN = 10;
    static final int WIN_HEIGHT = 128;
    static final int BOX_PAD = 0;
    static final int LINE_WIDTH = 1;
    static int nBins = 256;
    static final String[] colors = new String[]{"White", "Light Gray", "Dark Gray", "Black", "Red", "Green", "Blue", "Yellow", "None"};
    static final String[] locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "At Selection"};
    static final int UPPER_RIGHT = 0;
    static final int LOWER_RIGHT = 1;
    static final int LOWER_LEFT = 2;
    static final int UPPER_LEFT = 3;
    static final int AT_SELECTION = 4;
    static String fillColor = colors[0];
    static String textColor = colors[3];
    static String location = locations[0];
    static double zoom = 1.0;
    static int numLabels = 5;
    static int fontSize = 12;
    static int decimalPlaces = 0;
    ImagePlus imp;
    ImagePlus impOriginal;
    LiveDialog gd;
    ImageStatistics stats;
    Calibration cal;
    int[] histogram;
    LookUpTable lut;
    Image img;
    Button setup;
    Button redraw;
    Button insert;
    Button unInsert;
    Checkbox ne;
    Checkbox nw;
    Checkbox se;
    Checkbox sw;
    CheckboxGroup locGroup;
    Label value;
    Label note;
    int newMaxCount;
    boolean logScale;
    int win_width;
    int userPadding = 0;
    int fontHeight = 0;
    boolean boldText = false;
    Object backupPixels;
    byte[] byteStorage;
    int[] intStorage;
    short[] shortStorage;
    float[] floatStorage;
    String boxOutlineColor = colors[8];
    String barOutlineColor = colors[3];
    ImagePlus impData;
    ImageProcessor ip;
    String[] fieldNames = null;
    int insetPad;
    boolean decimalPlacesChanged;

    public int setup(String arg, ImagePlus imp) {
        if (imp != null) {
            this.imp = imp;
            this.impData = imp;
            if (imp.getRoi() != null) {
                location = locations[4];
            }
        }
        return 143;
    }

    public void run(ImageProcessor ipPassed) {
        double mag;
        ImageCanvas ic = this.imp.getCanvas();
        double d = mag = ic != null ? ic.getMagnification() : 1.0;
        if (zoom <= 1.0 && mag < 1.0) {
            zoom = 1.0 / mag;
        }
        this.ip = ipPassed.duplicate().convertToRGB();
        this.impOriginal = this.imp;
        this.imp = new ImagePlus(String.valueOf(this.imp.getTitle()) + " with bar", this.ip);
        this.imp.setCalibration(this.impData.getCalibration());
        if (this.impOriginal.getRoi() != null) {
            this.imp.setRoi(this.impOriginal.getRoi());
        }
        this.imp.show();
        this.ip.snapshot();
        this.insetPad = this.imp.getWidth() / 50;
        if (this.insetPad < 4) {
            this.insetPad = 4;
        }
        this.updateColorBar();
        if (!this.showDialog()) {
            this.imp.hide();
            this.ip.reset();
            this.imp.updateAndDraw();
            return;
        }
        this.updateColorBar();
    }

    private void updateColorBar() {
        this.ip.reset();
        Roi roi = this.imp.getRoi();
        if (roi != null && location.equals(locations[4])) {
            Rectangle r = roi.getBounds();
            this.drawColorBar(this.imp, r.x, r.y);
        } else if (location.equals(locations[3])) {
            this.drawColorBar(this.imp, this.insetPad, this.insetPad);
        } else if (location.equals(locations[0])) {
            this.calculateWidth();
            this.drawColorBar(this.imp, this.imp.getWidth() - this.insetPad - this.win_width, this.insetPad);
        } else if (location.equals(locations[2])) {
            this.drawColorBar(this.imp, this.insetPad, this.imp.getHeight() - (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - (int)((double)this.insetPad * zoom));
        } else if (location.equals(locations[1])) {
            this.calculateWidth();
            this.drawColorBar(this.imp, this.imp.getWidth() - this.win_width - this.insetPad, this.imp.getHeight() - (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - this.insetPad);
        }
        this.imp.updateAndDraw();
    }

    private boolean showDialog() {
        this.gd = new LiveDialog("Calibration Bar");
        this.gd.addChoice("Location:", locations, location);
        this.gd.addChoice("Fill Color: ", colors, fillColor);
        this.gd.addChoice("Label Color: ", colors, textColor);
        this.gd.addNumericField("Number of Labels:", numLabels, 0);
        this.gd.addNumericField("Decimal Places:", decimalPlaces, 0);
        this.gd.addNumericField("Font Size:", fontSize, 0);
        this.gd.addNumericField("Zoom Factor:", zoom, 1);
        this.gd.addCheckbox("Bold Text", this.boldText);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return false;
        }
        location = this.gd.getNextChoice();
        fillColor = this.gd.getNextChoice();
        textColor = this.gd.getNextChoice();
        numLabels = (int)this.gd.getNextNumber();
        decimalPlaces = (int)this.gd.getNextNumber();
        fontSize = (int)this.gd.getNextNumber();
        zoom = this.gd.getNextNumber();
        this.boldText = this.gd.getNextBoolean();
        return true;
    }

    public void verticalColorBar(ImageProcessor ip, int x, int y, int thickness, int length) {
        byte[] bLUT;
        byte[] gLUT;
        byte[] rLUT;
        int width = thickness;
        int height = length;
        int mapSize = 0;
        ColorModel cm = this.lut.getColorModel();
        if (cm instanceof IndexColorModel) {
            IndexColorModel m = (IndexColorModel)cm;
            mapSize = m.getMapSize();
            rLUT = new byte[mapSize];
            gLUT = new byte[mapSize];
            bLUT = new byte[mapSize];
            m.getReds(rLUT);
            m.getGreens(gLUT);
            m.getBlues(bLUT);
        } else {
            mapSize = 256;
            rLUT = new byte[mapSize];
            gLUT = new byte[mapSize];
            bLUT = new byte[mapSize];
            int i = 0;
            while (i < mapSize) {
                rLUT[i] = (byte)i;
                gLUT[i] = (byte)i;
                bLUT[i] = (byte)i;
                ++i;
            }
        }
        double colors = mapSize;
        int start = 0;
        ImageProcessor ipOrig = this.impOriginal.getProcessor();
        if (ipOrig instanceof ByteProcessor) {
            int max;
            int min = (int)ipOrig.getMin();
            if (min < 0) {
                min = 0;
            }
            if ((max = (int)ipOrig.getMax()) > 255) {
                max = 255;
            }
            colors = max - min + 1;
            start = min;
        }
        int i = 0;
        while (i < (int)(128.0 * zoom)) {
            int iMap = start + (int)Math.round((double)i * colors / (128.0 * zoom));
            if (iMap >= mapSize) {
                iMap = mapSize - 1;
            }
            ip.setColor(new Color(rLUT[iMap] & 0xFF, gLUT[iMap] & 0xFF, bLUT[iMap] & 0xFF));
            int j = (int)(128.0 * zoom) - i - 1;
            ip.drawLine(x, j + y, thickness + x, j + y);
            ++i;
        }
        Color c = this.getColor(this.barOutlineColor);
        if (c != null) {
            ip.setColor(c);
            ip.moveTo(x, y);
            ip.lineTo(x + width, y);
            ip.lineTo(x + width, y + height);
            ip.lineTo(x, y + height);
            ip.lineTo(x, y);
        }
    }

    protected void drawColorBar(ImageProcessor ip, int xOffset, int yOffset) {
        ip.setColor(Color.black);
        if (decimalPlaces == -1) {
            decimalPlaces = Analyzer.getPrecision();
        }
        int x = (int)(10.0 * zoom) + xOffset;
        int y = (int)(10.0 * zoom) + yOffset;
        this.verticalColorBar(ip, x, y, (int)(12.0 * zoom), (int)(128.0 * zoom));
        this.drawText(ip, x + (int)(12.0 * zoom), y, true);
        Color c = this.getColor(this.boxOutlineColor);
        if (c != null && !fillColor.equals("None")) {
            ip.setColor(c);
            ip.setLineWidth(1);
            ip.moveTo(xOffset + 0, yOffset + 0);
            ip.lineTo(xOffset + this.win_width - 0, yOffset + 0);
            ip.lineTo(xOffset + this.win_width - 0, yOffset + (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - 0);
            ip.lineTo(xOffset + 0, yOffset + (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - 0);
            ip.lineTo(xOffset + 0, yOffset + 0);
        }
    }

    int drawText(ImageProcessor ip, int x, int y, boolean active) {
        Color c = this.getColor(textColor);
        if (c == null) {
            return 0;
        }
        ip.setColor(c);
        double hmin = this.cal.getCValue(this.stats.histMin);
        double hmax = this.cal.getCValue(this.stats.histMax);
        double barStep = 128.0 * zoom;
        if (numLabels > 2) {
            barStep /= (double)(numLabels - 1);
        }
        int fontType = this.boldText ? 1 : 0;
        Font font = null;
        font = fontSize < 9 ? new Font("SansSerif", fontType, 9) : new Font("SansSerif", fontType, (int)((double)fontSize * zoom));
        ip.setFont(font);
        ip.setAntialiasedText(true);
        int maxLength = 0;
        Image img = GUI.createBlankImage(128, 64);
        Graphics g = img.getGraphics();
        FontMetrics metrics = g.getFontMetrics(font);
        this.fontHeight = metrics.getHeight();
        int i = 0;
        while (i < numLabels) {
            int iLength;
            double yLabelD = (int)(10.0 * zoom + 128.0 * zoom - (double)i * barStep - 1.0);
            int yLabel = (int)Math.round((double)y + 128.0 * zoom - (double)i * barStep - 1.0);
            Calibration cal = this.impOriginal.getCalibration();
            ImageProcessor ipOrig = this.impOriginal.getProcessor();
            double min = ipOrig.getMin();
            double max = ipOrig.getMax();
            if (ipOrig instanceof ByteProcessor) {
                if (min < 0.0) {
                    min = 0.0;
                }
                if (max > 255.0) {
                    max = 255.0;
                }
            }
            double grayLabel = min + (max - min) / (double)(numLabels - 1) * (double)i;
            if (cal.calibrated()) {
                grayLabel = cal.getCValue(grayLabel);
                double cmin = cal.getCValue(min);
                double cmax = cal.getCValue(max);
                if (!(this.decimalPlacesChanged || decimalPlaces != 0 || (double)((int)cmax) == cmax && (double)((int)cmin) == cmin)) {
                    decimalPlaces = 2;
                }
            }
            if (active) {
                ip.drawString(this.d2s(grayLabel), x + 5, yLabel + this.fontHeight / 2);
            }
            if ((iLength = metrics.stringWidth(this.d2s(grayLabel))) > maxLength) {
                maxLength = iLength;
            }
            ++i;
        }
        return maxLength;
    }

    String d2s(double d) {
        return IJ.d2s(d, decimalPlaces);
    }

    int getFontHeight() {
        Image img = GUI.createBlankImage(64, 64);
        Graphics g = img.getGraphics();
        int fontType = this.boldText ? 1 : 0;
        Font font = new Font("SansSerif", fontType, (int)((double)fontSize * zoom));
        FontMetrics metrics = g.getFontMetrics(font);
        return metrics.getHeight();
    }

    Color getColor(String color) {
        Color c = Color.white;
        if (color.equals(colors[1])) {
            c = Color.lightGray;
        } else if (color.equals(colors[2])) {
            c = Color.darkGray;
        } else if (color.equals(colors[3])) {
            c = Color.black;
        } else if (color.equals(colors[4])) {
            c = Color.red;
        } else if (color.equals(colors[5])) {
            c = Color.green;
        } else if (color.equals(colors[6])) {
            c = Color.blue;
        } else if (color.equals(colors[7])) {
            c = Color.yellow;
        } else if (color.equals(colors[8])) {
            c = null;
        }
        return c;
    }

    void calculateWidth() {
        this.drawColorBar(this.imp, -1, -1);
    }

    public void drawColorBar(ImagePlus imp, int x, int y) {
        Roi roi = this.impOriginal.getRoi();
        if (roi != null) {
            this.impOriginal.deleteRoi();
        }
        this.stats = this.impOriginal.getStatistics(16, nBins);
        if (roi != null) {
            this.impOriginal.setRoi(roi);
        }
        this.histogram = this.stats.histogram;
        this.lut = this.impOriginal.createLut();
        this.cal = this.impOriginal.getCalibration();
        int maxTextWidth = this.drawText(this.ip, 0, 0, false);
        this.win_width = (int)(10.0 * zoom) + 5 + (int)(12.0 * zoom) + maxTextWidth + (int)(5.0 * zoom);
        if (x == -1 && y == -1) {
            return;
        }
        Color c = this.getColor(fillColor);
        if (c != null) {
            this.ip.setColor(c);
            this.ip.setRoi(x, y, this.win_width, (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))));
            this.ip.fill();
        }
        this.ip.resetRoi();
        this.drawColorBar(this.ip, x, y);
        imp.updateAndDraw();
        this.ip.setColor(Color.black);
    }

    class LiveDialog
    extends GenericDialog {
        LiveDialog(String title) {
            super(title);
        }

        public void textValueChanged(TextEvent e) {
            if (CalibrationBar.this.fieldNames == null) {
                CalibrationBar.this.fieldNames = new String[4];
                int i = 0;
                while (i < 4) {
                    CalibrationBar.this.fieldNames[i] = ((TextField)this.numberField.elementAt(i)).getName();
                    ++i;
                }
            }
            TextField tf = (TextField)e.getSource();
            String name = tf.getName();
            String value = tf.getText();
            if (value.equals("")) {
                return;
            }
            int i = 0;
            boolean needsRefresh = false;
            if (name.equals(CalibrationBar.this.fieldNames[0])) {
                i = this.getValue(value).intValue();
                if (i < 1) {
                    return;
                }
                needsRefresh = true;
                numLabels = i;
            } else if (name.equals(CalibrationBar.this.fieldNames[1])) {
                i = this.getValue(value).intValue();
                if (i < 0) {
                    return;
                }
                needsRefresh = true;
                decimalPlaces = i;
                CalibrationBar.this.decimalPlacesChanged = true;
            } else if (name.equals(CalibrationBar.this.fieldNames[2])) {
                i = this.getValue(value).intValue();
                if (i < 1) {
                    return;
                }
                needsRefresh = true;
                fontSize = i;
            } else if (name.equals(CalibrationBar.this.fieldNames[3])) {
                double d = 0.0;
                d = this.getValue("0" + value);
                if (d <= 0.0) {
                    return;
                }
                needsRefresh = true;
                zoom = d;
            }
            if (needsRefresh) {
                CalibrationBar.this.updateColorBar();
            }
        }

        public void itemStateChanged(ItemEvent e) {
            location = ((Choice)this.choice.elementAt(0)).getSelectedItem();
            fillColor = ((Choice)this.choice.elementAt(1)).getSelectedItem();
            textColor = ((Choice)this.choice.elementAt(2)).getSelectedItem();
            CalibrationBar.this.boldText = ((Checkbox)this.checkbox.elementAt(0)).getState();
            CalibrationBar.this.updateColorBar();
        }
    }
}

